/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.collection.correlation;

import java.util.Comparator;
import org.eclipse.hyades.collection.correlation.BaseCorrelatorDataImpl;
import org.eclipse.hyades.collection.correlation.CorrelatorAssociation;
import org.eclipse.hyades.collection.correlation.CorrelatorStack;
import org.eclipse.hyades.collection.correlation.IApplication;
import org.eclipse.hyades.collection.correlation.IContextHandler;
import org.eclipse.hyades.collection.correlation.ICorrelatorData;
import org.eclipse.hyades.collection.correlation.Stack;

public abstract class BaseApplicationImpl
implements IApplication {
    private static final int CORRELATOR_POOL_SIZE = 20;
    private static final int CORRELATOR_POOL_INCREMENT = 10;
    private static final int CORRELATOR_STACK_SIZE = 10;
    private static final int CORRELATOR_STACK_INCREMENT = 10;
    private static final int CORRELATOR_STACKS_SIZE = 10;
    private static final int CORRELATOR_STACKS_INCREMENT = 10;
    private static final int CORRELATOR_ASSOCIATION_POOL_SIZE = 20;
    private static final int CORRELATOR_ASSOCIATION_POOL_INCREMENT = 10;
    private long applicationCounter;
    private Stack correlatorPool;
    private Stack correlatorStacks;
    private IContextHandler handler;
    private Stack correlatorAssocationPool;

    public abstract BaseCorrelatorDataImpl instantiateCorrelator();

    public void initialize() {
        this.applicationCounter = 0L;
        this.correlatorPool = new Stack(20, 10);
        this.correlatorStacks = new Stack(10, 10);
        this.correlatorAssocationPool = new Stack(20, 10);
        this.handler = null;
    }

    public ICorrelatorData createCorrelatorData() {
        BaseCorrelatorDataImpl baseCorrelatorDataImpl = (BaseCorrelatorDataImpl)this.correlatorPool.pop();
        if (baseCorrelatorDataImpl == null) {
            baseCorrelatorDataImpl = this.instantiateCorrelator();
        } else {
            baseCorrelatorDataImpl.invalidate();
        }
        baseCorrelatorDataImpl.setApplication(this);
        return baseCorrelatorDataImpl;
    }

    public void returnCorrelatorData(ICorrelatorData iCorrelatorData) {
        this.correlatorPool.push(iCorrelatorData);
    }

    protected CorrelatorAssociation createCorrelatorAssociation() {
        CorrelatorAssociation correlatorAssociation = (CorrelatorAssociation)this.correlatorAssocationPool.pop();
        return correlatorAssociation == null ? new CorrelatorAssociation() : correlatorAssociation;
    }

    public CorrelatorAssociation handleCall(Comparator comparator) {
        this.incrementCounter();
        CorrelatorStack correlatorStack = this.findCorrelatorStack(comparator);
        if (correlatorStack == null) {
            correlatorStack = this.createCorrelatorStack(comparator);
        }
        CorrelatorAssociation correlatorAssociation = this.createCorrelatorAssociation();
        correlatorAssociation.setParent((ICorrelatorData)correlatorStack.peek());
        correlatorAssociation.setChild(null);
        if (this.handler != null) {
            this.handler.handleSend(correlatorAssociation);
        }
        return correlatorAssociation;
    }

    public CorrelatorAssociation handleReturn(Comparator comparator, ICorrelatorData iCorrelatorData) {
        CorrelatorStack correlatorStack = this.findCorrelatorStack(comparator);
        this.incrementCounter();
        CorrelatorAssociation correlatorAssociation = this.createCorrelatorAssociation();
        correlatorAssociation.setParent(iCorrelatorData);
        correlatorAssociation.setChild(null);
        if (this.handler != null) {
            this.handler.handleReturn(correlatorAssociation);
        }
        return correlatorAssociation;
    }

    public CorrelatorAssociation pushChild(Comparator comparator, ICorrelatorData iCorrelatorData) {
        CorrelatorStack correlatorStack = this.findCorrelatorStack(comparator);
        if (correlatorStack == null) {
            correlatorStack = this.createCorrelatorStack(comparator);
        }
        ICorrelatorData iCorrelatorData2 = (ICorrelatorData)correlatorStack.peek();
        ((BaseCorrelatorDataImpl)iCorrelatorData).setApplicationCounter(this.incrementCounter());
        ((BaseCorrelatorDataImpl)iCorrelatorData).setOperationCounter(correlatorStack.incrementOperationCounter());
        correlatorStack.push(iCorrelatorData);
        CorrelatorAssociation correlatorAssociation = this.createCorrelatorAssociation();
        correlatorAssociation.setParent(iCorrelatorData2);
        correlatorAssociation.setChild(iCorrelatorData);
        if (this.handler != null) {
            this.handler.handleEntry(correlatorAssociation);
        }
        return correlatorAssociation;
    }

    public CorrelatorAssociation popChild(Comparator comparator) {
        CorrelatorStack correlatorStack = this.findCorrelatorStack(comparator);
        BaseCorrelatorDataImpl baseCorrelatorDataImpl = (BaseCorrelatorDataImpl)correlatorStack.pop();
        baseCorrelatorDataImpl.setApplicationCounter(this.incrementCounter());
        CorrelatorAssociation correlatorAssociation = this.createCorrelatorAssociation();
        correlatorAssociation.setParent((ICorrelatorData)correlatorStack.peek());
        correlatorAssociation.setChild(baseCorrelatorDataImpl);
        if (this.handler != null) {
            this.handler.handleExit(correlatorAssociation);
        }
        return correlatorAssociation;
    }

    public CorrelatorAssociation pushParent(Comparator comparator, ICorrelatorData iCorrelatorData) {
        CorrelatorStack correlatorStack = this.findCorrelatorStack(comparator);
        if (correlatorStack == null) {
            correlatorStack = this.createCorrelatorStack(comparator);
        }
        this.incrementCounter();
        correlatorStack.incrementOperationCounter();
        correlatorStack.push(iCorrelatorData);
        CorrelatorAssociation correlatorAssociation = this.createCorrelatorAssociation();
        correlatorAssociation.setParent(iCorrelatorData);
        correlatorAssociation.setChild(null);
        if (this.handler != null) {
            this.handler.handleReceive(correlatorAssociation);
        }
        return correlatorAssociation;
    }

    public CorrelatorAssociation popParent(Comparator comparator) {
        CorrelatorStack correlatorStack = this.findCorrelatorStack(comparator);
        this.incrementCounter();
        CorrelatorAssociation correlatorAssociation = this.createCorrelatorAssociation();
        correlatorAssociation.setParent((ICorrelatorData)correlatorStack.pop());
        correlatorAssociation.setChild(null);
        if (this.handler != null) {
            this.handler.handleReply(correlatorAssociation);
        }
        return correlatorAssociation;
    }

    protected synchronized long incrementCounter() {
        return ++this.applicationCounter;
    }

    public ICorrelatorData getActiveCorrelatorByKey(Comparator comparator) {
        CorrelatorStack correlatorStack = this.findCorrelatorStack(comparator);
        return correlatorStack == null ? null : (ICorrelatorData)correlatorStack.peek();
    }

    protected CorrelatorStack createCorrelatorStack(Comparator comparator) {
        CorrelatorStack correlatorStack = new CorrelatorStack(comparator, 10, 10);
        this.correlatorStacks.push(correlatorStack);
        return correlatorStack;
    }

    protected synchronized void destroyCorrelatorStack(Comparator comparator) {
        int n = 0;
        while (n <= this.correlatorStacks.top) {
            if (((CorrelatorStack)this.correlatorStacks.stack[n]).getKey().equals(comparator)) {
                this.correlatorStacks.stack[n] = this.correlatorStacks.stack[this.correlatorStacks.top];
                this.correlatorStacks.stack[this.correlatorStacks.top--] = null;
                return;
            }
            ++n;
        }
    }

    protected synchronized CorrelatorStack findCorrelatorStack(Comparator comparator) {
        int n = 0;
        while (n <= this.correlatorStacks.top) {
            if (((CorrelatorStack)this.correlatorStacks.stack[n]).getKey().equals(comparator)) {
                return (CorrelatorStack)this.correlatorStacks.stack[n];
            }
            ++n;
        }
        return null;
    }

    public void releaseAssociation(CorrelatorAssociation correlatorAssociation) {
        this.correlatorAssocationPool.push(correlatorAssociation);
    }

    public void registerHandler(IContextHandler iContextHandler) {
        this.handler = iContextHandler;
    }

    public void deregisterHandler() {
        this.handler = null;
    }

    public abstract int getVersion();

    public abstract int getId();
}

