/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.collection.correlation;

import java.util.Comparator;
import org.eclipse.hyades.collection.correlation.BaseApplicationImpl;
import org.eclipse.hyades.collection.correlation.CorrelatorAssociation;
import org.eclipse.hyades.collection.correlation.IApplication;
import org.eclipse.hyades.collection.correlation.ICorrelatorData;
import org.eclipse.hyades.collection.correlation.ITransport;
import org.eclipse.hyades.collection.correlation.ServiceRegistry;
import org.eclipse.hyades.collection.correlation.exceptions.InsufficientBufferLengthException;
import org.eclipse.hyades.collection.correlation.exceptions.InvalidDataException;
import org.eclipse.hyades.collection.correlation.exceptions.MoreDataRequiredException;

public class TransportMediator {
    public static byte[] writeMessage(ICorrelatorData iCorrelatorData, int n) {
        byte[] byArray = new byte[1024];
        int n2 = 0;
        try {
            n2 = iCorrelatorData.writeBinary(byArray, 7, byArray.length);
        }
        catch (InsufficientBufferLengthException insufficientBufferLengthException) {
            byte[] byArray2 = new byte[insufficientBufferLengthException.getRequiredLength()];
            byArray = byArray2;
            try {
                n2 = iCorrelatorData.writeBinary(byArray, 7, byArray.length);
            }
            catch (InsufficientBufferLengthException insufficientBufferLengthException2) {
                // empty catch block
            }
        }
        byArray[0] = (byte)(n2 >> 8);
        byArray[1] = (byte)n2;
        byArray[2] = 0;
        byArray[3] = 0;
        byArray[4] = 0;
        byArray[5] = (byte)(n >> 8);
        byArray[6] = (byte)n;
        byte[] byArray3 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        return byArray3;
    }

    public static void getDataStream(int n, Comparator comparator, ITransport iTransport) {
        IApplication iApplication = ServiceRegistry.getRegistry().getApplicationById(n);
        CorrelatorAssociation correlatorAssociation = iApplication.handleCall(comparator);
        byte[] byArray = TransportMediator.writeMessage(correlatorAssociation.getParent(), n);
        ((BaseApplicationImpl)iApplication).releaseAssociation(correlatorAssociation);
        iTransport.sendRequest(byArray, 0, byArray.length);
    }

    public static int setRemoteDataStream(Comparator comparator, byte[] byArray, int n, int n2) throws MoreDataRequiredException, InvalidDataException {
        int n3 = (byArray[n + 5] & 0xFF) << 8 | byArray[n + 6] & 0xFF;
        BaseApplicationImpl baseApplicationImpl = (BaseApplicationImpl)ServiceRegistry.getRegistry().getApplicationById(n3);
        if (baseApplicationImpl == null) {
            throw new InvalidDataException();
        }
        try {
            ICorrelatorData iCorrelatorData = baseApplicationImpl.createCorrelatorData();
            n = iCorrelatorData.readBinary(byArray, n + 7, n2);
            CorrelatorAssociation correlatorAssociation = baseApplicationImpl.pushParent(comparator, iCorrelatorData);
            baseApplicationImpl.releaseAssociation(correlatorAssociation);
            return n;
        }
        catch (InsufficientBufferLengthException insufficientBufferLengthException) {
            throw new MoreDataRequiredException();
        }
    }

    public static void getRemoteDataStream(int n, Comparator comparator, ITransport iTransport) {
        IApplication iApplication = ServiceRegistry.getRegistry().getApplicationById(n);
        CorrelatorAssociation correlatorAssociation = iApplication.popParent(comparator);
        byte[] byArray = TransportMediator.writeMessage(correlatorAssociation.getParent(), n);
        ((BaseApplicationImpl)iApplication).returnCorrelatorData(correlatorAssociation.getParent());
        ((BaseApplicationImpl)iApplication).releaseAssociation(correlatorAssociation);
        iTransport.sendReply(byArray, 0, byArray.length);
    }

    public static int setDataStream(Comparator comparator, byte[] byArray, int n, int n2) throws MoreDataRequiredException, InvalidDataException {
        int n3 = (byArray[n + 5] & 0xFF) << 8 | byArray[n + 6] & 0xFF;
        BaseApplicationImpl baseApplicationImpl = (BaseApplicationImpl)ServiceRegistry.getRegistry().getApplicationById(n3);
        if (baseApplicationImpl == null) {
            throw new InvalidDataException();
        }
        try {
            ICorrelatorData iCorrelatorData = baseApplicationImpl.createCorrelatorData();
            n = iCorrelatorData.readBinary(byArray, n + 7, n2);
            CorrelatorAssociation correlatorAssociation = baseApplicationImpl.handleReturn(comparator, iCorrelatorData);
            baseApplicationImpl.returnCorrelatorData(iCorrelatorData);
            baseApplicationImpl.releaseAssociation(correlatorAssociation);
            return n;
        }
        catch (InsufficientBufferLengthException insufficientBufferLengthException) {
            throw new MoreDataRequiredException();
        }
    }
}

