/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.preferences;

import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.util.CBESortUI;
import org.eclipse.hyades.log.ui.internal.util.ContextIds;
import org.eclipse.hyades.log.ui.internal.util.RecordChangeEvent;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.help.WorkbenchHelp;

public class LogAnalyzerSortPrefPage
implements SelectionListener {
    private CBESortUI _options;
    private IPreferenceStore _preferenceStore;
    private boolean sortHasChanged = false;

    public LogAnalyzerSortPrefPage(IPreferenceStore iPreferenceStore) {
        this._preferenceStore = iPreferenceStore;
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 5;
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = GridUtil.createFill();
        composite2.setLayoutData((Object)gridData);
        this._options = new CBESortUI();
        this._options.createControl(composite2);
        this._options.addListener(this);
        this.initializeValues();
        WorkbenchHelp.setHelp((Control)composite2, (String)ContextIds.ACTLOG_PREF_SORT_RECORDS);
        return composite2;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return LogUIPlugin.getDefault().getPreferenceStore();
    }

    public void init(IWorkbench iWorkbench) {
    }

    private void initializeDefaults() {
        this._options.initializeValues(true);
    }

    private void initializeValues() {
        this._options.initializeValues(false);
    }

    protected void performDefaults() {
        this.initializeDefaults();
    }

    public boolean performOk() {
        this.storeValues();
        this._options.removeListener(this);
        LogUIPlugin.getDefault().savePluginPreferences();
        if (this.sortHasChanged) {
            LogUIPlugin.getDefault().fireRecordChangeNotification(new RecordChangeEvent(4, this));
        }
        this.sortHasChanged = false;
        return true;
    }

    public void performApply() {
        this._options.applyValues(this._preferenceStore);
        LogUIPlugin.getDefault().savePluginPreferences();
        if (this.sortHasChanged) {
            LogUIPlugin.getDefault().fireRecordChangeNotification(new RecordChangeEvent(4, this));
        }
        this.sortHasChanged = false;
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.data != null && selectionEvent.data instanceof Integer && (Integer)selectionEvent.data == 4) {
            this.sortHasChanged = true;
        }
    }

    private void storeValues() {
        this._options.storeValues(this._preferenceStore);
    }
}

