/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.views;

import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.loaders.cbe.CBEUtils;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.util.ColumnData;
import org.eclipse.hyades.log.ui.internal.util.LogUIConstants;
import org.eclipse.hyades.log.ui.internal.util.RecordTableElement;
import org.eclipse.hyades.log.ui.internal.util.TerminalNode;
import org.eclipse.hyades.models.cbe.CBEAssociationEngine;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.cbe.CBEExtendedDataElement;
import org.eclipse.hyades.models.cbe.CBEPackage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class RecordPaneContentProvider
implements IStructuredContentProvider {
    private HashMap _methods = new HashMap();
    static /* synthetic */ Class class$java$lang$String;

    public void dispose() {
        this._methods.clear();
    }

    public Object getElementAt(Object object, int n) {
        if (object instanceof CBEExtendedDataElement) {
            switch (n) {
                case 0: {
                    return ((CBEExtendedDataElement)object).getName();
                }
                case 1: {
                    if (((CBEExtendedDataElement)object).getValues().size() <= 0) break;
                    return ((CBEExtendedDataElement)object).getValues().get(0).toString();
                }
            }
        }
        return "unknown row element";
    }

    public Object[] getElements(Object object) {
        ArrayList arrayList = new ArrayList();
        if (object instanceof EObject && ((EObject)object).eClass().getEPackage() == CBEPackage.eINSTANCE) {
            arrayList.addAll(this.getEObjectAttributes((EObject)object));
        } else if (object instanceof TerminalNode && ((TerminalNode)object).getParent() instanceof CBEAssociationEngine) {
            arrayList.addAll(this.getEObjectAttributes(((TerminalNode)object).getParent()));
        }
        return arrayList.toArray();
    }

    private List getEObjectAttributes(EObject eObject) {
        ArrayList<RecordTableElement> arrayList = new ArrayList<RecordTableElement>();
        EClass eClass = eObject.eClass();
        IPreferenceStore iPreferenceStore = LogUIPlugin.getDefault().getPreferenceStore();
        ArrayList arrayList2 = ColumnData.createColumnDataFromString(iPreferenceStore.getString("pd_filter_options"));
        ArrayList arrayList3 = new ArrayList();
        String string = "";
        EList eList = eClass.getEAllAttributes();
        int n = 0;
        while (n < arrayList2.size()) {
            EAttribute eAttribute;
            ColumnData columnData = (ColumnData)arrayList2.get(n);
            if (columnData.visible() && (eAttribute = this.findAttributeInList(string = columnData.name().toLowerCase(), eList)) != null) {
                try {
                    Object object = eObject.eGet((EStructuralFeature)eAttribute);
                    if (eAttribute.getName().equals("creationTime")) {
                        object = this.formatCreationTime(object, eObject.getClass(), eObject);
                    }
                    if (eAttribute.isMany() && eAttribute.getEType().getInstanceClass() == (class$java$lang$String == null ? RecordPaneContentProvider.class$("java.lang.String") : class$java$lang$String)) {
                        int n2 = 0;
                        Iterator iterator = ((EList)eObject.eGet((EStructuralFeature)eAttribute)).iterator();
                        while (iterator.hasNext()) {
                            RecordTableElement recordTableElement = new RecordTableElement(eAttribute.getName() + "[" + n2++ + "]", (String)iterator.next());
                            arrayList.add(recordTableElement);
                        }
                    } else {
                        RecordTableElement recordTableElement = new RecordTableElement(eAttribute.getName(), object != null ? object.toString() : "");
                        arrayList.add(recordTableElement);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++n;
        }
        return arrayList;
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
    }

    public boolean isDeleted(Object object) {
        return false;
    }

    private String getFirstLine(String string) {
        String string2 = "";
        char[] cArray = string.toCharArray();
        int n = -1;
        int n2 = 0;
        while (n2 < cArray.length) {
            if (cArray[n2] == '\r' || cArray[n2] == '\n' || cArray[n2] == '\f') {
                n = n2;
                break;
            }
            ++n2;
        }
        string2 = n > -1 && n != 0 ? string.substring(0, n) : string;
        return string2;
    }

    private SimpleDateFormat getDateTimeFormat() {
        IPreferenceStore iPreferenceStore = LogUIPlugin.getDefault().getPreferenceStore();
        String string = iPreferenceStore.getString("LogAnalyzer.DateFormat");
        boolean bl = false;
        int n = 0;
        while (n < LogUIConstants.LOG_ANALYZER_FORMAT_DATE_LIST.length) {
            if (string.equals(LogUIConstants.LOG_ANALYZER_FORMAT_DATE_LIST[n])) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            string = LogUIConstants.LOG_ANALYZER_FORMAT_DATE_DEFAULT;
        }
        String string2 = iPreferenceStore.getString("LogAnalyzer.TimeFormat");
        bl = false;
        int n2 = 0;
        while (n2 < LogUIConstants.LOG_ANALYZER_FORMAT_TIME_LIST.length) {
            if (string2.equals(LogUIConstants.LOG_ANALYZER_FORMAT_TIME_LIST[n2])) {
                bl = true;
                break;
            }
            ++n2;
        }
        if (!bl) {
            string2 = LogUIConstants.LOG_ANALYZER_FORMAT_TIME_DEFAULT;
        }
        if (string2.startsWith("h")) {
            string2 = string2 + " a";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string + " " + string2);
        return simpleDateFormat;
    }

    private Object formatCreationTime(Object object, Class clazz, Object object2) {
        String string = "0";
        try {
            short s = 0;
            try {
                Method method = this.getMethod(clazz, "getTimeZone");
                if (method != null) {
                    s = (Short)method.invoke(object2, null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            double d = CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)((CBECommonBaseEvent)object2));
            Double d2 = new Double(d);
            SimpleDateFormat simpleDateFormat = this.getDateTimeFormat();
            string = simpleDateFormat.format(new Date(d2.longValue() / 1000L + (long)(s * 60 * 1000)));
            String string2 = "" + d2.longValue() % 1000000L;
            string = string + "." + "000000".substring(0, 6 - string2.length()) + string2;
            string = string + (s > 0 ? "+00" : "-00").substring(0, 3 - ("" + Math.abs(s / 60)).length()) + Math.abs(s / 60);
            string = string + ":00".substring(0, 3 - ("" + Math.abs(s % 60)).length()) + Math.abs(s % 60);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    private Method getMethod(Class clazz, String string) throws Exception {
        Method method = (Method)this._methods.get(clazz.getName() + string);
        if (method == null) {
            method = clazz.getMethod(string, null);
            this._methods.put(clazz.getName() + string, method);
        }
        return method;
    }

    private EAttribute findAttributeInList(String string, EList eList) {
        int n = 0;
        while (n < eList.size()) {
            EAttribute eAttribute = (EAttribute)eList.get(n);
            if (eAttribute.getName().toLowerCase().equals(string)) {
                return eAttribute;
            }
            ++n;
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

