/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.wizards;

import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.wizards.ImportLogWizard;
import org.eclipse.hyades.log.ui.internal.wizards.LogParserItem;
import org.eclipse.hyades.log.ui.internal.wizards.LogParsersPage;
import org.eclipse.hyades.log.ui.internal.wizards.ParserField;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class LogParserUI
implements SelectionListener {
    private Table _list;
    private Label _description;
    private ArrayList _images;
    private ArrayList _parserTable = new ArrayList();
    private LogParserItem _parser;
    private int _max = 1;
    private LogParsersPage page;

    public LogParserUI(LogParsersPage logParsersPage) {
        this.page = logParsersPage;
        this._images = new ArrayList();
    }

    public Composite createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)GridUtil.createFill());
        composite2.setLayout((Layout)new GridLayout());
        Label label = new Label(composite2, 0);
        label.setLayoutData((Object)GridUtil.createHorizontalFill());
        label.setText(LogUIPlugin.getResourceString("STR_LOG_PDESC"));
        this._list = new Table(composite2, 68356);
        this._list.setLayoutData((Object)GridUtil.createFill());
        this._description = new Label(composite2, 64);
        this._description.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._list.addSelectionListener((SelectionListener)this);
        this.initializeValues();
        return composite2;
    }

    private void initializeValues() {
        IPluginRegistry iPluginRegistry = Platform.getPluginRegistry();
        IConfigurationElement[] iConfigurationElementArray = iPluginRegistry.getConfigurationElementsFor("com.ibm.etools.pd.util", "logParser");
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            block6: {
                IConfigurationElement iConfigurationElement;
                Object object;
                IConfigurationElement iConfigurationElement2 = iConfigurationElementArray[n];
                LogParserItem logParserItem = new LogParserItem(iConfigurationElement2.getAttribute("id"), iConfigurationElement2.getAttribute("name"), iConfigurationElement2.getAttribute("ui_name"), iConfigurationElement2.getAttribute("description"));
                logParserItem.setConfigurationElement(iConfigurationElement2);
                logParserItem.setClass(iConfigurationElement2.getAttribute("class"));
                logParserItem.setUIType(iConfigurationElement2.getAttribute("ui_type"));
                String string = iConfigurationElement2.getAttribute("icon");
                if (string != null && !string.equals("")) {
                    object = iConfigurationElement2.getDeclaringExtension().getDeclaringPluginDescriptor().getInstallURL();
                    try {
                        URL uRL = new URL((URL)object, string);
                        iConfigurationElement = ImageDescriptor.createFromURL((URL)uRL);
                        logParserItem.setImageDescriptor((ImageDescriptor)iConfigurationElement);
                    }
                    catch (Exception exception) {
                        iConfigurationElement = new Status(4, LogUIPlugin.getPluginId(), 2, "exception.malformedURL", (Throwable)exception);
                        LogUIPlugin.getDefault().getLog().log((IStatus)iConfigurationElement);
                        break block6;
                    }
                }
                object = iConfigurationElement2.getChildren("field");
                int n2 = 0;
                while (n2 < ((IConfigurationElement[])object).length) {
                    iConfigurationElement = object[n2];
                    ParserField parserField = new ParserField(iConfigurationElement.getAttribute("id"), iConfigurationElement.getAttribute("name"));
                    parserField.setDefaultValue(iConfigurationElement.getAttribute("defaultValue"));
                    parserField.setContextId(iConfigurationElement.getAttribute("helpContextId"));
                    parserField.setTooltip(iConfigurationElement.getAttribute("tooltip"));
                    parserField.setFilters(iConfigurationElement.getAttribute("browseType"));
                    parserField.useBrowse(iConfigurationElement.getAttribute("useBrowse").equals("true"));
                    parserField.setUiType(iConfigurationElement.getAttribute("ui_type"));
                    logParserItem.addEntry(parserField);
                    ++n2;
                }
                if (this._max < ((IConfigurationElement[])object).length) {
                    this._max = ((IConfigurationElement[])object).length;
                }
                this._parserTable.add(logParserItem);
            }
            ++n;
        }
        this.initializeUI();
    }

    private void initializeUI() {
        int n = 0;
        while (n < this._parserTable.size()) {
            LogParserItem logParserItem = (LogParserItem)this._parserTable.get(n);
            TableItem tableItem = new TableItem(this._list, 0);
            tableItem.setText(logParserItem.getUIName());
            tableItem.setData((Object)logParserItem);
            if (logParserItem.getImageDescriptor() != null) {
                Image image = logParserItem.getImageDescriptor().createImage();
                tableItem.setImage(image);
                this._images.add(image);
            }
            ++n;
        }
        if (this._parserTable.size() > 0) {
            this._parser = (LogParserItem)this._parserTable.get(0);
            this._list.setSelection(0);
            this._description.setText(this._parser.getDescription());
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this._list) {
            TableItem[] tableItemArray = this._list.getSelection();
            if (tableItemArray.length > 0) {
                this._parser = (LogParserItem)tableItemArray[0].getData();
                this._description.setText(this._parser.getDescription());
                this.setParser(this._parser);
            } else {
                this._description.setText("");
            }
        }
    }

    public LogParserItem getParser() {
        return this._parser;
    }

    public void setParser(LogParserItem logParserItem) {
        ((ImportLogWizard)this.page.getWizard()).setCurrentSelectedParser(logParserItem);
    }

    public int getMaximumFields() {
        return this._max;
    }

    public void dispose() {
        int n = 0;
        while (n < this._images.size()) {
            Image image = (Image)this._images.get(n);
            if (image != null && !image.isDisposed()) {
                image.dispose();
            }
            ++n;
        }
        this._images.clear();
    }
}

