/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.classloader;

import java.io.File;
import java.util.AbstractList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.hyades.ui.internal.classloader.FileClassLoader;
import org.eclipse.hyades.ui.internal.util.FileUtil;
import org.eclipse.hyades.ui.internal.util.StringUtil;

public class PathEntriesClassLoader
extends FileClassLoader {
    private Hashtable entryDataByPathEntry;
    private Vector directories;

    public PathEntriesClassLoader(String string) {
        super(string);
        this.initialize(string);
    }

    public PathEntriesClassLoader(ClassLoader classLoader, String string) {
        super(classLoader, string);
        this.initialize(string);
    }

    private void initialize(String string) {
        this.entryDataByPathEntry = new Hashtable();
        this.directories = new Vector();
        if (string != null) {
            String[] stringArray = StringUtil.tokenizer(string, File.pathSeparator, false);
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                String string2 = stringArray[n].trim();
                File file = new File(string2);
                if (file.exists() && file.isDirectory()) {
                    this.directories.add(string2);
                } else {
                    this.entryDataByPathEntry.putAll(FileUtil.getZipEntryDataByZipEntryName(string2));
                }
                ++n;
            }
        }
    }

    protected byte[] loadClassBytes(String string) {
        byte[] byArray = (byte[])this.entryDataByPathEntry.get(this.formatClassName(string));
        if (byArray != null) {
            return byArray;
        }
        Iterator iterator = ((AbstractList)this.directories).iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            byArray = super.loadClassBytes(string, string2);
            if (byArray == null) continue;
            return byArray;
        }
        return null;
    }
}

