/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.navigator;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.hyades.ui.internal.logicalfolder.LogicalFolder;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.ui.internal.util.HyadesViewerSorter;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.hyades.ui.util.INamedElement;
import org.eclipse.jface.viewers.Viewer;

public class NavigatorViewerSorter
extends HyadesViewerSorter
implements IDisposable {
    public static final int SORTER_TYPE = (class$org$eclipse$hyades$ui$internal$navigator$NavigatorViewerSorter == null ? (class$org$eclipse$hyades$ui$internal$navigator$NavigatorViewerSorter = NavigatorViewerSorter.class$("org.eclipse.hyades.ui.internal.navigator.NavigatorViewerSorter")) : class$org$eclipse$hyades$ui$internal$navigator$NavigatorViewerSorter).hashCode();
    public static final int NAME = 1;
    public static final int TYPE = 2;
    private INavigator navigator;
    private int criteria;
    static /* synthetic */ Class class$org$eclipse$hyades$ui$internal$navigator$NavigatorViewerSorter;
    static /* synthetic */ Class class$org$eclipse$core$resources$IResource;

    public NavigatorViewerSorter(INavigator iNavigator, int n) {
        this.navigator = iNavigator;
        this.criteria = n != 1 && n != 2 ? 1 : n;
    }

    public void dispose() {
        this.navigator = null;
    }

    public INavigator getNavigator() {
        return this.navigator;
    }

    public void setCriteria(int n) {
        if (this.criteria == n) {
            return;
        }
        if (n != 1 && n != 2) {
            return;
        }
        this.criteria = n;
        if (this.navigator.getViewer() != null) {
            this.navigator.getViewer().refresh();
        }
        this.navigator.handleChange(SORTER_TYPE);
    }

    public int getCriteria() {
        return this.criteria;
    }

    public int category(Object object) {
        if (object instanceof IProject) {
            return 1000;
        }
        if (object instanceof IFolder) {
            return 400;
        }
        if (object instanceof LogicalFolder) {
            return 200;
        }
        return 600;
    }

    protected String getValue(Viewer viewer, Object object) {
        String string = null;
        if (object instanceof LogicalFolder && (string = this.getLogicalFolderValue(viewer, (LogicalFolder)object)) != null) {
            return string;
        }
        if (object instanceof IResource && (string = this.getResourceValue(viewer, (IResource)object)) != null) {
            return string;
        }
        if (object instanceof IAdaptable && (string = this.getAdaptableValue(viewer, (IAdaptable)object)) != null) {
            return string;
        }
        if (object instanceof INamedElement && (string = this.getNamedElementValue(viewer, (INamedElement)object)) != null) {
            return string;
        }
        return super.getValue(viewer, object);
    }

    protected String getLogicalFolderValue(Viewer viewer, LogicalFolder logicalFolder) {
        return "0";
    }

    protected String getResourceValue(Viewer viewer, IResource iResource) {
        if (iResource.getFileExtension() == null) {
            return iResource.getName();
        }
        if (1 == this.getCriteria()) {
            return iResource.getName() + "_+_" + iResource.getFileExtension();
        }
        return iResource.getFileExtension() + "_+_" + iResource.getName();
    }

    protected String getAdaptableValue(Viewer viewer, IAdaptable iAdaptable) {
        IResource iResource = (IResource)iAdaptable.getAdapter(class$org$eclipse$core$resources$IResource == null ? (class$org$eclipse$core$resources$IResource = NavigatorViewerSorter.class$("org.eclipse.core.resources.IResource")) : class$org$eclipse$core$resources$IResource);
        if (iResource == null) {
            return null;
        }
        return this.getResourceValue(viewer, iResource);
    }

    protected String getNamedElementValue(Viewer viewer, INamedElement iNamedElement) {
        return iNamedElement.getName();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

