/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.wizard.exampleproject;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.util.JavaUtil;
import org.eclipse.hyades.ui.internal.util.ResourceUtil;
import org.eclipse.hyades.ui.internal.util.StringUtil;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.hyades.ui.internal.wizard.exampleproject.CreationOperation;
import org.eclipse.hyades.ui.internal.wizard.exampleproject.CreationWizardPage;
import org.eclipse.hyades.ui.internal.wizard.exampleproject.IProjectAdjuster;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class CreationWizard
extends BasicNewResourceWizard
implements INewWizard,
IExecutableExtension {
    private CreationWizardPage[] pages;
    private IConfigurationElement configurationElement;
    private CreationOperation runnable;
    private IProjectAdjuster adjuster;

    public CreationWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        IConfigurationElement[] iConfigurationElementArray;
        super.addPages();
        if ((this.getWindowTitle() == null || this.getWindowTitle().trim().length() == 0) && (iConfigurationElementArray = this.configurationElement.getAttribute("windowTitle")) != null) {
            this.setWindowTitle((String)iConfigurationElementArray);
        }
        if ((iConfigurationElementArray = this.configurationElement.getChildren("projectsetup")) == null || iConfigurationElementArray.length == 0) {
            HyadesUIPlugin.logError(HyadesUIPlugin.getString("_ERROR_DUP_PROJECT_NAME"));
            return;
        }
        this.pages = new CreationWizardPage[iConfigurationElementArray.length];
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            CreationWizardPage creationWizardPage = this.createWizardPage("newProject" + n, iConfigurationElementArray[n]);
            if (creationWizardPage != null) {
                this.pages[n] = creationWizardPage;
                this.addPage((IWizardPage)this.pages[n]);
            }
            ++n;
        }
    }

    protected CreationWizardPage createWizardPage(String string, IConfigurationElement iConfigurationElement) {
        return new CreationWizardPage(this, string, iConfigurationElement);
    }

    protected CreationWizardPage[] getCreationWizardPages() {
        return this.pages;
    }

    public void createPageControls(Composite composite) {
        super.createPageControls(composite);
        int n = 0;
        while (n < this.pages.length) {
            this.pages[n].setHelpId();
            ++n;
        }
    }

    public IProjectAdjuster getAdjuster() {
        return this.adjuster;
    }

    public void setAdjuster(IProjectAdjuster iProjectAdjuster) {
        this.adjuster = iProjectAdjuster;
        if (this.runnable != null) {
            this.runnable.setAdjuster(iProjectAdjuster);
        }
    }

    private void adjustClasspathVariable() {
        IConfigurationElement[] iConfigurationElementArray = this.configurationElement.getChildren("classpathVariable");
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            String string = iConfigurationElementArray[n].getAttribute("name");
            String string2 = iConfigurationElementArray[n].getAttribute("value");
            boolean bl = Boolean.valueOf(iConfigurationElementArray[n].getAttribute("overwrite"));
            if (string != null && string2 != null && (bl || JavaUtil.getVariableValue(string) == null) && (string2 = this.replaceClasspathVariables(string2)) != null) {
                try {
                    JavaUtil.setVariableValue(string, string2, null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++n;
        }
    }

    protected String replaceClasspathVariables(String string) {
        string = this.replaceVariableByPluginDirectory(string, "${plugins}", this.configurationElement.getDeclaringExtension().getDeclaringPluginDescriptor().getUniqueIdentifier(), true);
        string = this.replaceVariableByPluginDirectory(string, "${base.plugins}", "org.eclipse.core.boot", true);
        String[] stringArray = this.getPluginIdsToResolve(string);
        int n = 0;
        while (n < stringArray.length) {
            string = this.replaceVariableByPluginDirectory(string, "${pluginId=\"" + stringArray[n] + "\"}", stringArray[n], false);
            ++n;
        }
        return string;
    }

    protected String replaceVariableByPluginDirectory(String string, String string2, String string3, boolean bl) {
        File file;
        if (string.indexOf(string2) >= 0 && (file = ResourceUtil.getPluginDirectory(string3)) != null) {
            if (bl) {
                file = file.getAbsoluteFile().getParentFile();
            }
            if (file != null) {
                string = StringUtil.replace(string, string2, file.getAbsolutePath());
            }
        }
        return string;
    }

    protected String[] getPluginIdsToResolve(String string) {
        String[] stringArray = StringUtil.tokenizer(string, "${pluginId=\"", false);
        if (stringArray.length <= 1) {
            return new String[0];
        }
        HashSet<String> hashSet = new HashSet<String>(stringArray.length - 1);
        int n = 1;
        while (n < stringArray.length) {
            int n2 = stringArray[n].indexOf("\"}");
            if (n2 >= 0) {
                hashSet.add(stringArray[n].substring(0, n2));
            }
            ++n;
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public boolean performFinish() {
        this.adjustClasspathVariable();
        this.runnable = new CreationOperation(this, new ImportOverwriteQuery());
        this.runnable.setAdjuster(this.adjuster);
        WorkspaceModifyDelegatingOperation workspaceModifyDelegatingOperation = new WorkspaceModifyDelegatingOperation((IRunnableWithProgress)this.runnable);
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)workspaceModifyDelegatingOperation);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.handleException(invocationTargetException.getTargetException());
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        if (this.adjuster != null) {
            this.adjuster.beforeWorspaceRefresh(this.pages);
        }
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.configurationElement);
        if (this.adjuster != null) {
            this.adjuster.afterWorspaceRefresh(this.pages);
        }
        IResource[] iResourceArray = this.runnable.getResourcesToOpen();
        int n = 0;
        while (n < iResourceArray.length) {
            if (iResourceArray[n] instanceof IFile) {
                String string = this.runnable.getEditorId(iResourceArray[n]);
                boolean bl = false;
                try {
                    bl = UIUtil.openEditor((IFile)iResourceArray[n], string, false) != null;
                }
                catch (Throwable throwable) {
                    HyadesUIPlugin.logError(throwable);
                }
                if (!bl) {
                    try {
                        UIUtil.openEditor((IFile)iResourceArray[n], null, false);
                    }
                    catch (Throwable throwable) {
                        HyadesUIPlugin.logError(throwable);
                    }
                }
            }
            ++n;
        }
        if (iResourceArray.length > 0) {
            this.selectAndReveal(iResourceArray[iResourceArray.length - 1]);
        }
        this.runnable.dispose();
        return true;
    }

    private void handleException(Throwable throwable) {
        HyadesUIPlugin.logError(throwable);
        String[] stringArray = new String[]{IDialogConstants.OK_LABEL};
        new MessageDialog(this.getShell(), HyadesUIPlugin.getString("W_ERROR"), null, HyadesUIPlugin.getString("_ERROR_UNABLE_CREATE"), 1, stringArray, 0);
    }

    public void setInitializationData(IConfigurationElement iConfigurationElement, String string, Object object) {
        this.configurationElement = iConfigurationElement;
    }

    protected String getPluginId() {
        if (this.configurationElement == null) {
            return null;
        }
        return this.configurationElement.getDeclaringExtension().getDeclaringPluginDescriptor().getUniqueIdentifier();
    }

    protected void initializeDefaultPageImageDescriptor() {
        ImageDescriptor imageDescriptor;
        String string = this.configurationElement.getAttribute("banner");
        if (string != null && (imageDescriptor = UIUtil.getImageDescriptorFromPlugin(this.configurationElement.getDeclaringExtension().getDeclaringPluginDescriptor(), string)) != null) {
            this.setDefaultPageImageDescriptor(imageDescriptor);
            return;
        }
        super.initializeDefaultPageImageDescriptor();
    }

    private class ImportOverwriteQuery
    implements IOverwriteQuery {
        private ImportOverwriteQuery() {
        }

        public String queryOverwrite(String string) {
            String[] stringArray = new String[]{"YES", "NO", "ALL", "CANCEL"};
            int n = this.openDialog(string);
            return n < 0 ? "CANCEL" : stringArray[n];
        }

        private int openDialog(final String string) {
            final int[] nArray = new int[]{1};
            CreationWizard.this.getShell().getDisplay().syncExec(new Runnable(){

                public void run() {
                    String string3 = HyadesUIPlugin.getString("Q_OVERWRITE", string);
                    String string2 = HyadesUIPlugin.getString("W_QUESTION");
                    String[] stringArray = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.CANCEL_LABEL};
                    MessageDialog messageDialog = new MessageDialog(CreationWizard.this.getShell(), string2, null, string3, 3, stringArray, 0);
                    nArray[0] = messageDialog.open();
                }
            });
            return nArray[0];
        }
    }
}

