/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.parsers;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Hashtable;
import org.eclipse.hyades.logging.core.ILogger;
import org.eclipse.hyades.logging.events.ICommonBaseEvent;
import org.eclipse.hyades.logging.events.IExtendedDataElement;
import org.eclipse.hyades.logging.events.ISimpleEventFactory;
import org.eclipse.hyades.logging.events.SimpleEventFactoryImpl;
import org.eclipse.hyades.logging.parsers.LogParserException;
import org.eclipse.hyades.logging.parsers.ParserUtilities;

public abstract class Parser {
    protected static final String UNKNOWN_HOST = "Unknown Host";
    public static final int defaultArraySize = 1;
    protected int MessageArraySize = 1;
    protected ICommonBaseEvent[] messages;
    protected int arrayIndex;
    protected String originLocale;
    protected String localHostId;
    protected String localHostIdFormat;
    protected String localHostName;
    protected String file_path;
    protected BufferedReader logFile;
    protected String curLine = "";
    protected static ISimpleEventFactory eventFactory = SimpleEventFactoryImpl.getInstance();
    protected ILogger logger;

    public void parse(ILogger iLogger) throws LogParserException {
        try {
            this.logger = iLogger;
            this.curLine = this.readLine();
            this.getLocalHostId();
            this.originLocale = this.getLocale();
            this.arrayIndex = 0;
        }
        catch (Throwable throwable) {
            LogParserException logParserException = new LogParserException(throwable);
            logParserException.fillInStackTrace();
            throw logParserException;
        }
    }

    public abstract String getName();

    public abstract String getVersion();

    public void setUserInput(Hashtable hashtable) throws LogParserException {
        this.file_path = null;
        try {
            this.file_path = (String)hashtable.get("file_path");
            if (this.file_path != null) {
                this.logFile = new BufferedReader(new FileReader(this.file_path));
            }
            this.messages = new ICommonBaseEvent[this.MessageArraySize];
            int n = 0;
            while (n < this.MessageArraySize) {
                this.messages[n] = eventFactory.createCommonBaseEvent();
                ++n;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            LogParserException logParserException = new LogParserException(ParserUtilities.getResourceString("REMOTE_LOG_PARSER_INITIALIZATION_ERROR_", this.file_path), fileNotFoundException);
            logParserException.fillInStackTrace();
            this.file_path = null;
            throw logParserException;
        }
    }

    protected void getLocalHostId() {
        try {
            this.localHostId = InetAddress.getLocalHost().getHostAddress();
            this.localHostIdFormat = this.localHostId.indexOf(58) != -1 ? "IPV6" : "IPV4";
        }
        catch (Exception exception) {
            this.localHostId = UNKNOWN_HOST;
            this.localHostIdFormat = "None";
        }
        try {
            this.localHostName = InetAddress.getByName(this.localHostId).getHostName();
        }
        catch (Exception exception) {
            this.localHostName = null;
        }
    }

    protected String getLocale() {
        String string = System.getProperty("user.language");
        String string2 = System.getProperty("user.region");
        String string3 = "Unknown";
        if (string != null && string2 != null) {
            string3 = string + "-" + string2;
        }
        return string3;
    }

    protected void writePartialArray() {
        this.closeFiles();
    }

    protected boolean isNum(String string, int n) {
        try {
            return Character.isDigit(string.charAt(n));
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean isNum(String string, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            if (!this.isNum(string, n + n3)) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    protected boolean isLet(String string, int n) {
        try {
            return Character.isLetter(string.charAt(n));
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean isLet(String string, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            if (!this.isLet(string, n + n3)) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    protected boolean isChar(String string, int n, char c) {
        try {
            return string.charAt(n) == c;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void closeFiles() {
        try {
            if (this.logFile != null) {
                this.logFile.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected String readLine() {
        String string = null;
        try {
            string = this.logFile.readLine();
        }
        catch (IOException iOException) {
            return null;
        }
        return string;
    }

    protected static IExtendedDataElement createStringEDE(String string, String string2) {
        IExtendedDataElement iExtendedDataElement = eventFactory.createExtendedDataElement();
        iExtendedDataElement.setName(string);
        iExtendedDataElement.setType("string");
        String[] stringArray = new String[]{string2};
        iExtendedDataElement.setValues(stringArray);
        return iExtendedDataElement;
    }
}

