/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.preferences;

import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.util.ContextIds;
import org.eclipse.hyades.log.ui.internal.util.LogUIConstants;
import org.eclipse.hyades.log.ui.internal.util.RecordChangeEvent;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.help.WorkbenchHelp;

public class LogAnalyzerFormatPrefPage {
    private Combo dateFormatCombo;
    private Combo timeFormatCombo;
    private IPreferenceStore _preferenceStore;

    public LogAnalyzerFormatPrefPage(IPreferenceStore iPreferenceStore) {
        this._preferenceStore = iPreferenceStore;
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)GridUtil.createHorizontalFill());
        Label label = new Label(composite2, 0);
        label.setText(LogUIPlugin.getResourceString("LOG_ANALYZER_FORMAT_PREF_PAGE_DESCRIPTION"));
        Composite composite3 = this.createComboGroup(composite2);
        this.createFormatComboBoxes(composite3);
        return composite2;
    }

    private Composite createComboGroup(Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 20;
        gridLayout.verticalSpacing = 10;
        gridLayout.numColumns = 2;
        Composite composite2 = new Composite(composite, 16384);
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)GridUtil.createHorizontalFill());
        return composite2;
    }

    private void createFormatComboBoxes(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(LogUIPlugin.getResourceString("LOG_ANALYZER_FORMAT_PREF_PAGE_DATE_FORMAT_LABEL"));
        this.dateFormatCombo = new Combo(composite, 8);
        this.dateFormatCombo.setItems(LogUIConstants.LOG_ANALYZER_FORMAT_DATE_LIST);
        this.dateFormatCombo.setLayoutData((Object)GridUtil.createHorizontalFill());
        Label label2 = new Label(composite, 0);
        label2.setText(LogUIPlugin.getResourceString("LOG_ANALYZER_FORMAT_PREF_PAGE_TIME_FORMAT_LABEL"));
        this.timeFormatCombo = new Combo(composite, 8);
        this.timeFormatCombo.setItems(LogUIConstants.LOG_ANALYZER_FORMAT_TIME_LIST);
        this.timeFormatCombo.setLayoutData((Object)GridUtil.createHorizontalFill());
        this.dateFormatCombo.select(this.dateFormatCombo.indexOf(this._preferenceStore.getString("LogAnalyzer.DateFormat")));
        this.timeFormatCombo.select(this.timeFormatCombo.indexOf(this._preferenceStore.getString("LogAnalyzer.TimeFormat")));
        WorkbenchHelp.setHelp((Control)this.dateFormatCombo, (String)ContextIds.ACTLOG_PREF_FORMAT_DATE);
        WorkbenchHelp.setHelp((Control)this.timeFormatCombo, (String)ContextIds.ACTLOG_PREF_FORMAT_TIME);
    }

    public void init(IWorkbench iWorkbench) {
    }

    protected void performDefaults() {
        this.dateFormatCombo.select(this._preferenceStore.getDefaultInt("LogAnalyzer.DateFormat"));
        this.timeFormatCombo.select(this._preferenceStore.getDefaultInt("LogAnalyzer.TimeFormat"));
    }

    public boolean performOk() {
        String string = LogUIConstants.LOG_ANALYZER_FORMAT_DATE_LIST[this.dateFormatCombo.getSelectionIndex()];
        this._preferenceStore.setValue("LogAnalyzer.DateFormat", string);
        String string2 = LogUIConstants.LOG_ANALYZER_FORMAT_TIME_LIST[this.timeFormatCombo.getSelectionIndex()];
        this._preferenceStore.setValue("LogAnalyzer.TimeFormat", string2);
        LogUIPlugin.getDefault().savePluginPreferences();
        LogUIPlugin.getDefault().fireRecordChangeNotification(new RecordChangeEvent(3, this));
        return true;
    }
}

