/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.views;

import org.eclipse.hyades.analysis.engine.IAnalysisEngine;
import org.eclipse.hyades.analysis.engine.Incident;
import org.eclipse.hyades.analysis.engine.Solution;
import org.eclipse.hyades.log.ui.internal.views.XMISymptomDatabase;

public final class AnalysisEngine
implements IAnalysisEngine {
    private XMISymptomDatabase symptomDatabase = null;

    private AnalysisEngine() {
    }

    private AnalysisEngine(String string) {
        this.symptomDatabase = new XMISymptomDatabase();
        this.replaceSymptomDatabase(string);
    }

    public static AnalysisEngine getInstance() {
        return new AnalysisEngine(null);
    }

    public static AnalysisEngine getInstance(String string) {
        return new AnalysisEngine(string);
    }

    public synchronized boolean reloadSymptomDatabase() {
        return this.symptomDatabase.load();
    }

    public synchronized boolean mergeSymptomDatabase(String string) {
        return this.symptomDatabase.merge(string);
    }

    public synchronized boolean removeSymptomDatabase() {
        return this.symptomDatabase.replace(null);
    }

    public synchronized boolean replaceSymptomDatabase(String string) {
        if (string != null && !string.trim().equals("")) {
            return this.symptomDatabase.replace(string);
        }
        return false;
    }

    public synchronized String getSymptomDatabasePath() {
        if (this.symptomDatabase != null) {
            return this.symptomDatabase.getPath();
        }
        return null;
    }

    public synchronized Object[] analyze(Incident incident) {
        return this.symptomDatabase.getDirectives(incident);
    }

    public Solution[] analyzeForSolutions(Incident incident) {
        return this.symptomDatabase.getSolutions(incident);
    }
}

