/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.LogUIPluginImages;
import org.eclipse.hyades.log.ui.internal.wizards.IImportWizardWidget;
import org.eclipse.hyades.log.ui.internal.wizards.ISetLastWasHome;
import org.eclipse.hyades.log.ui.internal.wizards.ImportLogWizard;
import org.eclipse.hyades.log.ui.internal.wizards.ImportWizardCheckBox;
import org.eclipse.hyades.log.ui.internal.wizards.ImportWizardComboBox;
import org.eclipse.hyades.log.ui.internal.wizards.ImportWizardRadioButton;
import org.eclipse.hyades.log.ui.internal.wizards.ImportWizardTextArea;
import org.eclipse.hyades.log.ui.internal.wizards.ImportWizardTextField;
import org.eclipse.hyades.log.ui.internal.wizards.LogParserItem;
import org.eclipse.hyades.log.ui.internal.wizards.ParserField;
import org.eclipse.hyades.sdb.internal.util.TString;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;

public class ImportLogUserPage
extends WizardPage
implements Listener,
ModifyListener,
ISetLastWasHome {
    private Hashtable _filtersTable = new Hashtable();
    private Map controlLookup = new HashMap();
    private ArrayList _idList = new ArrayList();
    private ArrayList _fieldList = new ArrayList();
    private ArrayList _buttonList = new ArrayList();
    private String _logParserId;
    private String lastWasHome = "";
    private String prefix = "ImportLogFile.";
    private String host = "";
    private boolean bTextHasChanged = false;
    private Shell shell;

    public ImportLogUserPage(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        super("ImportLogUserPage");
        this.setTitle(LogUIPlugin.getResourceString("STR_IMPORT_LOG_FILE_LOC_TITLE"));
        this.setDescription(LogUIPlugin.getResourceString("STR_IMPORT_LOG_FILE_LOC_DESC"));
        this.setImageDescriptor(LogUIPluginImages.getImageDescriptor("importactivitylog_wiz.gif"));
        this.shell = iWorkbench.getActiveWorkbenchWindow().getShell();
    }

    public boolean isPageComplete() {
        Iterator iterator = this.controlLookup.values().iterator();
        while (iterator.hasNext()) {
            IImportWizardWidget iImportWizardWidget = (IImportWizardWidget)iterator.next();
            if (iImportWizardWidget.isValid()) continue;
            return false;
        }
        return true;
    }

    public void createControl(Composite composite) {
        this._idList.clear();
        this._filtersTable.clear();
        this._fieldList.clear();
        this._buttonList.clear();
        this.controlLookup.clear();
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)GridUtil.createFill());
        LogParserItem logParserItem = ((ImportLogWizard)this.getWizard()).getLogParser();
        ArrayList arrayList = logParserItem.getFields();
        this.prefix = ((ImportLogWizard)this.getWizard()).getHostName() + "." + ((ImportLogWizard)this.getWizard()).getLogAgentName() + ".";
        int n = 0;
        while (n < arrayList.size()) {
            ParserField parserField = (ParserField)arrayList.get(n);
            if (parserField != null) {
                this.createWidget(composite2, parserField);
                this._idList.add(parserField.getId());
            }
            ++n;
        }
        this.setControl((Control)composite2);
    }

    protected void createVerticalSpace(Composite composite, int n) {
        Label label = new Label(composite, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = n;
        label.setLayoutData((Object)gridData);
    }

    public void createWidget(Composite composite, ParserField parserField) {
        IImportWizardWidget iImportWizardWidget = null;
        String string = parserField.getUiType().trim();
        iImportWizardWidget = string.equals("combobox") ? new ImportWizardComboBox() : (string.equals("checkbox") ? new ImportWizardCheckBox() : (string.equals("radio") ? new ImportWizardRadioButton() : (string.equals("text_area") ? new ImportWizardTextArea() : new ImportWizardTextField(this._filtersTable, this))));
        iImportWizardWidget.createControl(composite, parserField, this.prefix);
        if (iImportWizardWidget instanceof ImportWizardTextField) {
            ImportWizardTextField importWizardTextField = (ImportWizardTextField)iImportWizardWidget;
            importWizardTextField.getText().addModifyListener((ModifyListener)this);
            this._buttonList.add(((ImportWizardTextField)iImportWizardWidget).getBtn());
            this._fieldList.add(parserField);
        }
        this.controlLookup.put(parserField.getId(), iImportWizardWidget);
    }

    private void initializeTextFields() {
        this.prefix = ((ImportLogWizard)this.getWizard()).getHostName() + "." + ((ImportLogWizard)this.getWizard()).getLogAgentName() + ".";
        IPreferenceStore iPreferenceStore = LogUIPlugin.getDefault().getPreferenceStore();
        String string = "";
        Text text = null;
        ParserField parserField = null;
        int n = 0;
        while (n < this._fieldList.size()) {
            parserField = (ParserField)this._fieldList.get(n);
            text = ((ImportWizardTextField)this.controlLookup.get(parserField.getId())).getText();
            string = iPreferenceStore.getString(this.prefix + parserField.getId());
            if (string != null && !string.equals("")) {
                text.setText(string);
            } else {
                text.setText(parserField.getDefaultValue());
            }
            ++n;
        }
        this.bTextHasChanged = false;
    }

    public void initializePage() {
        if (!this.bTextHasChanged) {
            this.initializeTextFields();
        }
        this.setPageComplete(this.isPageComplete());
    }

    public Hashtable getUserInput() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Iterator iterator = this.controlLookup.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            IImportWizardWidget iImportWizardWidget = (IImportWizardWidget)this.controlLookup.get(string);
            hashtable.put(string, iImportWizardWidget.getValue());
        }
        return hashtable;
    }

    public ArrayList getIndexList() {
        return this._idList;
    }

    public boolean finish() {
        ParserField parserField = null;
        Text text = null;
        int n = 0;
        while (n < this._fieldList.size()) {
            Object object;
            parserField = (ParserField)this._fieldList.get(n);
            text = ((ImportWizardTextField)this.controlLookup.get(parserField.getId())).getText();
            IImportWizardWidget iImportWizardWidget = (IImportWizardWidget)this.controlLookup.get(parserField.getId());
            if (parserField.useBrowse() && ((ImportLogWizard)this.getWizard()).isLocalHost() && !new File(iImportWizardWidget.getValue()).exists()) {
                object = LogUIPlugin.getResourceString("IMPORT_LOG_FILE_NO_FILE_EXISTS");
                object = TString.change((String)object, (String)"%1", (String)iImportWizardWidget.getValue());
                MessageDialog.openError((Shell)this.getShell(), (String)LogUIPlugin.getResourceString("LOGGING_MESSAGE"), (String)object);
                return false;
            }
            if (iImportWizardWidget.isValid()) {
                object = LogUIPlugin.getDefault().getPreferenceStore();
                object.setValue(this.prefix + parserField.getId(), iImportWizardWidget.getValue());
            }
            ++n;
        }
        return true;
    }

    public void handleEvent(Event event) {
    }

    public void modifyText(ModifyEvent modifyEvent) {
        this.setPageComplete(this.isPageComplete());
        this.bTextHasChanged = true;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            LogParserItem logParserItem = ((ImportLogWizard)this.getWizard()).getLogParser();
            if (this._logParserId == null || !logParserItem.getId().equals(this._logParserId) || this.host != ((ImportLogWizard)this.getWizard()).getHostName()) {
                this._logParserId = logParserItem.getId();
                this.initializePage();
            }
            this.enableButtons();
        }
    }

    public void enableButtons() {
        boolean bl = ((ImportLogWizard)this.getWizard()).isLocalHost();
        int n = 0;
        while (n < this._buttonList.size()) {
            Button button = (Button)this._buttonList.get(n);
            button.setEnabled(bl);
            ++n;
        }
    }

    public String getLastWasHome() {
        return this.lastWasHome;
    }

    public void setLastWasHome(String string) {
        this.lastWasHome = string;
    }
}

