/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.wizards;

import java.net.InetAddress;
import java.net.URL;
import java.text.DateFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.DataProcessor;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.AgentFactory;
import org.eclipse.hyades.internal.execution.local.control.AgentListener;
import org.eclipse.hyades.internal.execution.local.control.NoSuchApplicationException;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NodeFactory;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.internal.execution.local.control.ProcessFactory;
import org.eclipse.hyades.internal.execution.local.control.ProcessListener;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.XMLLoader;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.util.TraceMergeUIDialog;
import org.eclipse.hyades.log.ui.internal.wizards.ISetParser;
import org.eclipse.hyades.log.ui.internal.wizards.ImportLogHostPage;
import org.eclipse.hyades.log.ui.internal.wizards.ImportLogLocationPage;
import org.eclipse.hyades.log.ui.internal.wizards.ImportLogUserPage;
import org.eclipse.hyades.log.ui.internal.wizards.ImportLogWizard;
import org.eclipse.hyades.log.ui.internal.wizards.LocalLogParserLoader;
import org.eclipse.hyades.log.ui.internal.wizards.LogParserItem;
import org.eclipse.hyades.log.ui.internal.wizards.LogParsersPage;
import org.eclipse.hyades.log.ui.internal.wizards.ParserField;
import org.eclipse.hyades.logging.parsers.LogParserException;
import org.eclipse.hyades.logging.parsers.Parser;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.util.SaveUtil;
import org.eclipse.hyades.security.util.TString;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceAssociationManager;
import org.eclipse.hyades.trace.ui.internal.piclient.XMLTraceDataProcessor;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.extension.IAssociationMapping;
import org.eclipse.hyades.ui.extension.IAssociationMappingRegistry;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ImportLogWizard
extends Wizard
implements INewWizard,
IRunnableWithProgress,
ISetParser {
    protected IStructuredSelection selection;
    protected IWorkbench workbench;
    protected ImportLogHostPage hostPage;
    protected ImportLogLocationPage locPage;
    protected ImportLogUserPage userPage;
    protected LogParserItem _parser;
    protected LogParsersPage parserPage;
    protected PDProjectExplorer fViewer;
    protected Shell fShell;
    protected String errorMessage = null;
    protected String logParserId;
    protected String reasonAction = null;
    private LogParserItem currentSelectedParser;
    private boolean bAppend = false;
    private final String CANCEL = "cancel";
    private boolean addParserPage = true;

    public ImportLogWizard() {
        AbstractUIPlugin abstractUIPlugin = (AbstractUIPlugin)Platform.getPlugin((String)"org.eclipse.ui");
        IDialogSettings iDialogSettings = abstractUIPlugin.getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection("com.ibm.etools.pd.ras.wizard.ImportLogFile");
        if (iDialogSettings2 == null) {
            iDialogSettings2 = iDialogSettings.addNewSection("com.ibm.etools.pd.ras.wizard.ImportLogFile");
        }
        this.setDialogSettings(iDialogSettings2);
    }

    public void setAddParserPage(boolean bl) {
        this.addParserPage = bl;
    }

    public boolean isAddParserPage() {
        return this.addParserPage;
    }

    public void setCurrentSelectedParser(LogParserItem logParserItem) {
        if (this.currentSelectedParser != logParserItem) {
            this.userPage.initializePage();
            this.getContainer().updateButtons();
        }
        this.currentSelectedParser = logParserItem;
    }

    public LogParserItem getCurrentSelectedParser() {
        return this.currentSelectedParser;
    }

    public String getHostName() {
        return this.hostPage.getHost();
    }

    public ArrayList getIndexList() {
        return this.userPage.getIndexList();
    }

    public boolean isLocalHost() {
        return this.hostPage.isLocaHost();
    }

    public String getLogAgentName() {
        return this.getLogParser().getName();
    }

    public LogParserItem getLogParser() {
        if (this.addParserPage) {
            return this.parserPage.getParser();
        }
        return this._parser;
    }

    public void setLogParserId(String string) {
        this.logParserId = string;
        this.addParserPage = false;
        this.initializeValues();
    }

    public String getLogParserId() {
        return this.logParserId;
    }

    public Parser getLogParserInstance() {
        return this.getLogParser().getParserInstance();
    }

    public String getParserClass() {
        return this.getLogParser().getParserClass();
    }

    public int getPort() {
        return this.hostPage.getPort();
    }

    public Hashtable getUserInput() {
        return this.userPage.getUserInput();
    }

    public void addPages() {
        super.addPages();
        this.setWindowTitle(LogUIPlugin.getResourceString("IMPORT_LOG_FILE_WIZARD_TITLE"));
        if (this.addParserPage) {
            this.parserPage = new LogParsersPage("parserPage");
        }
        this.hostPage = new ImportLogHostPage();
        this.userPage = new ImportLogUserPage(this.workbench, this.selection);
        this.locPage = new ImportLogLocationPage();
        this.addAllPages();
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.workbench = iWorkbench;
        this.selection = iStructuredSelection;
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        TraceMergeUIDialog traceMergeUIDialog;
        if (!this.performPageFinish()) {
            return false;
        }
        if (this.locPage.getSelection()) {
            traceMergeUIDialog = new TraceMergeUIDialog(this.getShell(), LogUIPlugin.getResourceString("STR_EXISTING_DATA_DESC_2"));
            int n = traceMergeUIDialog.open();
            if (n == 1) {
                return false;
            }
            if (n == 2) {
                this.bAppend = true;
            }
            if (n == 3) {
                this.bAppend = false;
            }
        }
        this.errorMessage = null;
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.errorMessage = exception.toString();
        }
        if (this.errorMessage != null) {
            if (this.errorMessage.startsWith("cancel")) {
                return false;
            }
            if (this.reasonAction == null) {
                MessageDialog.openError((Shell)this.fShell, (String)LogUIPlugin.getResourceString("LOGGING_MESSAGE"), (String)this.errorMessage);
            } else {
                traceMergeUIDialog = new Status(4, "org.eclipse.core.resources", 566, this.reasonAction, null);
                ErrorDialog.openError((Shell)LogUIPlugin.getActiveWorkbenchShell(), (String)LogUIPlugin.getResourceString("LOGGING_MESSAGE"), (String)this.errorMessage, (IStatus)traceMergeUIDialog);
            }
            return false;
        }
        return true;
    }

    public void run(IProgressMonitor iProgressMonitor) {
        Object object;
        Object object2;
        TRCMonitor tRCMonitor;
        IContainer iContainer;
        Object object3;
        IPreferenceStore iPreferenceStore;
        Node node;
        Node node2;
        String string = this.locPage.getProject();
        String string2 = this.locPage.getMonitor();
        String string3 = this.getHostName();
        boolean bl = true;
        iProgressMonitor.beginTask(LogUIPlugin.getResourceString("IMPORT_LOG_FILE_PROGRESS_DESC"), 5);
        try {
            node2 = NodeFactory.createNode((String)string3);
            node = NodeFactory.createNode((String)"localhost");
            bl = node2.getName().equals(node.getName());
        }
        catch (Exception exception) {
            this.errorMessage = LogUIPlugin.getResourceString("IMPORT_LOG_FILE_HOST_ERROR_");
            this.reasonAction = LogUIPlugin.getResourceString("IMPORT_LOG_FILE_HOST_REASON");
            this.reasonAction = HyadesUtil.change((String)this.reasonAction, (String)"%1", (String)string3);
            return;
        }
        try {
            node = UIPlugin.getActivePage();
            this.fViewer = (PDProjectExplorer)node.showView("org.eclipse.hyades.trace.internal.ui.PDProjectExplorer");
            this.fShell = this.fViewer.getShell();
            iPreferenceStore = UIPlugin.getDefault().getPreferenceStore();
            iPreferenceStore.setValue("show_monitor", true);
            iPreferenceStore.setValue("show_node", true);
            object3 = this.fViewer.getViewer();
            object3.showMonitorAction().setChecked(true, false);
            object3.showNodesAction().setChecked(true, false);
        }
        catch (Exception exception) {
            this.errorMessage = LogUIPlugin.getResourceString("IMPORT_LOG_FILE_DEST_ERROR_");
            this.reasonAction = null;
            return;
        }
        node = this.locPage.getAgentProxy() != null ? this.locPage.getAgentProxy().getAgent() : null;
        object3 = this.getUserInput();
        if (node == null) {
            iContainer = PDCoreUtil.createContainer((IPath)new Path(string));
            tRCMonitor = PDCoreUtil.createMonitor((IContainer)iContainer, (String)string2);
            this.fViewer.getViewer().refresh((Object)iContainer);
            this.fViewer.getViewer().setExpandedState((Object)iContainer, true);
            object2 = UIPlugin.getDefault().getPreferenceStore().getString("localhost_port");
            object = PDCoreUtil.createNode((TRCMonitor)tRCMonitor, (String)node2.getName(), (String)object2);
            this.fViewer.getViewer().refresh((Object)tRCMonitor);
            this.fViewer.getViewer().setExpandedState((Object)tRCMonitor, true);
            iPreferenceStore = this.createProcess(iContainer, (TRCNode)object);
            this.fViewer.getViewer().refresh(object);
            this.fViewer.getViewer().setExpandedState(object, true);
            node = this.createAgent(iContainer, (TRCProcessProxy)iPreferenceStore);
            if (this.errorMessage != null && this.errorMessage.startsWith("cancel")) {
                return;
            }
            this.fViewer.getViewer().refresh((Object)iPreferenceStore);
            this.fViewer.getViewer().setExpandedState((Object)iPreferenceStore, true);
        } else {
            iPreferenceStore = node.getAgentProxy().getProcessProxy();
            if (!this.bAppend) {
                node.getDefaultEvents().clear();
            }
        }
        iContainer = node;
        tRCMonitor = iPreferenceStore;
        iProgressMonitor.worked(1);
        if (bl) {
            try {
                object2 = new XMLLoader((TRCAgent)iContainer);
                object2.loadEvent("<CommonBaseEvents>".getBytes(), "<CommonBaseEvents>".getBytes().length);
                object = new LocalLogParserLoader(this.getLogParserInstance(), (Hashtable)object3);
                ((LocalLogParserLoader)object).setXMLLoader((XMLLoader)object2);
                ((LocalLogParserLoader)object).startParsing();
                object2.loadEvent("</CommonBaseEvents>".getBytes(), "</CommonBaseEvents>".getBytes().length);
                try {
                    object2.cleanUp();
                }
                catch (Exception exception) {}
            }
            catch (LogParserException logParserException) {
                this.errorMessage = logParserException.getMessage();
            }
            iProgressMonitor.worked(1);
            this.fViewer.getViewer().setExpandedState((Object)tRCMonitor, true);
            this.fViewer.selectObject((Object)iContainer.getAgentProxy());
            iProgressMonitor.done();
        } else {
            node2 = PDCoreUtil.profileConnect((String)string3, (String)String.valueOf(10002));
            if (node2 == null) {
                iProgressMonitor.done();
                return;
            }
            iProgressMonitor.done();
            object2 = ProcessFactory.createProcess((Node)node2, (String)"RemoteLogParserLoader", (String)this.getParserCommand());
            object2.addProcessListener((ProcessListener)new ProcessListenerImpl((TRCProcessProxy)tRCMonitor, iContainer.getAgentProxy()));
            object = AgentFactory.createAgent((Process)object2, (String)"Remote Log Loader IRemoteEntity", (String)"Logging");
            TRCAgentProxy tRCAgentProxy = iContainer.getAgentProxy();
            object.setAutoAttach(true);
            object.addAgentListener((AgentListener)new LogAgentListener((TRCAgent)iContainer, tRCAgentProxy, (TRCProcessProxy)tRCMonitor));
            Agent agent = AgentFactory.createAgent((Process)object2, (String)"Remote Log Loader Error IRemoteEntity", (String)"Logging");
            agent.setAutoAttach(true);
            agent.addAgentListener((AgentListener)new ErrorAgentListener());
            try {
                object2.launch();
            }
            catch (NoSuchApplicationException noSuchApplicationException) {
                String string4 = this.getParserClass().trim();
                if (!string4.equals("com.ibm.etools.logging.parsers.WASV4ActivityLogParser") && !string4.equals("com.ibm.etools.logging.parsers.WASV5ActivityLogParser")) {
                    this.errorMessage = LogUIPlugin.getResourceString("IMPORT_LOG_FILE_RAC_ERROR_");
                    this.errorMessage = TString.change((String)this.errorMessage, (String)"%1", (String)string3);
                    this.reasonAction = LogUIPlugin.getResourceString("IMPORT_LOG_FILE_RAC_REASON");
                    this.reasonAction = TString.change((String)this.reasonAction, (String)"%1", (String)string3);
                    return;
                }
                Hashtable hashtable = this.getUserInput();
                String string5 = (String)hashtable.get("was_home");
                String string6 = (String)hashtable.get("file_path");
                Process process = ProcessFactory.createProcess((Node)node2, (String)"ActivityLogParser", (String)"com.ibm.etools.logging.was.WASActivityLogParser".concat(" \"").concat(string6).concat("\" \"").concat(string5).concat("\""));
                process.addProcessListener((ProcessListener)new ProcessListenerImpl((TRCProcessProxy)tRCMonitor, iContainer.getAgentProxy()));
                Agent agent2 = AgentFactory.createAgent((Process)process, (String)"WAS Activity Log Agent", (String)"Logging");
                agent2.setAutoAttach(true);
                agent2.addAgentListener((AgentListener)new LogAgentListener((TRCAgent)iContainer, tRCAgentProxy, (TRCProcessProxy)tRCMonitor));
                Agent agent3 = AgentFactory.createAgent((Process)process, (String)"WAS Activity Log Error Agent", (String)"Logging");
                agent3.setAutoAttach(true);
                agent3.addAgentListener((AgentListener)new ErrorAgentListener());
                try {
                    process.launch();
                }
                catch (Exception exception) {
                    this.errorMessage = LogUIPlugin.getResourceString("IMPORT_LOG_FILE_RAC_ERROR_");
                    this.errorMessage = TString.change((String)this.errorMessage, (String)"%1", (String)string3);
                    this.reasonAction = LogUIPlugin.getResourceString("IMPORT_LOG_FILE_RAC_REASON");
                    this.reasonAction = TString.change((String)this.reasonAction, (String)"%1", (String)string3);
                    return;
                }
            }
            catch (Exception exception) {
                this.errorMessage = LogUIPlugin.getResourceString("IMPORT_LOG_FILE_RAC_ERROR_");
                this.errorMessage = HyadesUtil.change((String)this.errorMessage, (String)"%1", (String)string3);
                this.reasonAction = LogUIPlugin.getResourceString("IMPORT_LOG_FILE_RAC_REASON");
                this.reasonAction = HyadesUtil.change((String)this.reasonAction, (String)"%1", (String)string3);
                return;
            }
        }
        this.openLogView((TRCAgent)iContainer);
    }

    protected void addAllPages() {
        if (this.addParserPage) {
            this.addPage((IWizardPage)this.parserPage);
        }
        this.addPage((IWizardPage)this.hostPage);
        this.addPage((IWizardPage)this.userPage);
        this.addPage((IWizardPage)this.locPage);
    }

    protected boolean performPageFinish() {
        return this.hostPage.finish() && this.userPage.finish() && this.locPage.finish();
    }

    private String getParserCommand() {
        String string = this.getParserClass().concat(" ");
        Hashtable hashtable = this.getUserInput();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            String string2 = hashtable.get(k).toString();
            string = string.concat("\"").concat(k.toString()).concat("=");
            string = string2.endsWith("\\") || string2.endsWith("/") ? string.concat(string2.substring(0, string2.length() - 1)).concat("\" ") : string.concat(string2).concat("\" ");
        }
        return string.trim();
    }

    private TRCAgent createAgent(IContainer iContainer, TRCProcessProxy tRCProcessProxy) {
        String string;
        TRCAgentProxy tRCAgentProxy = null;
        String string2 = this.getLogAgentName();
        String string3 = "Logging";
        EList eList = tRCProcessProxy.getAgentProxies();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            tRCAgentProxy = (TRCAgentProxy)iterator.next();
            if (!tRCAgentProxy.getName().equals(string2)) continue;
            if (!this.locPage.getSelection()) {
                String string4 = LogUIPlugin.getResourceString("STR_EXISTING_DATA_DESC_1");
                string4 = TString.change((String)string4, (String)"%1", (String)string2);
                TraceMergeUIDialog traceMergeUIDialog = new TraceMergeUIDialog(this.getShell(), string4);
                int n = traceMergeUIDialog.open();
                if (n == 1) {
                    this.errorMessage = "cancel";
                    return null;
                }
                if (n == 2) {
                    this.bAppend = true;
                }
                if (n == 3) {
                    this.bAppend = false;
                }
            }
            if (this.bAppend) {
                return tRCAgentProxy.getAgent();
            }
            tRCAgentProxy.getAgent().getDefaultEvents().clear();
            return tRCAgentProxy.getAgent();
        }
        String string5 = string = DateFormat.getDateTimeInstance(0, 0).format(new Date());
        string5 = HyadesUtil.change((String)string5, (String)" ", (String)"");
        string5 = HyadesUtil.change((String)string5, (String)":", (String)"");
        String string6 = tRCProcessProxy.getNode().getMonitor().getName() + "_" + tRCProcessProxy.getNode().getName() + "_" + tRCProcessProxy.getPid() + "_" + string5 + "_" + string2;
        string6 = HyadesUtil.change((String)string6, (String)" ", (String)"");
        String string7 = tRCProcessProxy.eResource().getURI().toString();
        Path path = new Path(string7);
        if (path.segmentCount() > 1) {
            string7 = path.removeLastSegments(1).toString();
        }
        String string8 = string6 + "." + "trcaxmi";
        IPath iPath = new Path(string7).append(string8);
        URI uRI = URI.createURI((String)iPath.toString());
        Resource resource = Resource.Factory.Registry.INSTANCE.getFactory(uRI).createResource(uRI);
        EList eList2 = resource.getContents();
        UIPlugin.getDefault().getResourceSet().getResources().add(resource);
        HierarchyFactory hierarchyFactory = UIPlugin.getDefault().getPerftraceFactory();
        tRCAgentProxy = hierarchyFactory.createTRCAgentProxy();
        tRCAgentProxy.setName(string2);
        tRCAgentProxy.setType(string3);
        tRCAgentProxy.setProcessProxy(tRCProcessProxy);
        tRCProcessProxy.getAgentProxies().add(tRCAgentProxy);
        TRCAgent tRCAgent = hierarchyFactory.createTRCAgent();
        tRCAgent.setAgentProxy(tRCAgentProxy);
        tRCAgent.setType(string3);
        eList2.add(tRCAgent);
        SaveUtil.addDocument((Resource)resource);
        return tRCAgent;
    }

    private TRCProcessProxy createProcess(IContainer iContainer, TRCNode tRCNode) {
        int n = 0;
        String string = "";
        Hashtable hashtable = this.getUserInput();
        ArrayList arrayList = this.getIndexList();
        Iterator iterator = ((AbstractList)arrayList).iterator();
        if (iterator.hasNext()) {
            string = string + hashtable.get(iterator.next()).toString();
        }
        while (iterator.hasNext()) {
            string = string + " " + hashtable.get(iterator.next()).toString();
        }
        TRCProcessProxy tRCProcessProxy = null;
        EList eList = tRCNode.getProcessProxies();
        Iterator iterator2 = eList.iterator();
        int n2 = 0;
        while (iterator2.hasNext()) {
            tRCProcessProxy = (TRCProcessProxy)iterator2.next();
            ++n2;
            if (tRCProcessProxy.getName() == null || !tRCProcessProxy.getName().equals(string)) continue;
            return tRCProcessProxy;
        }
        TRCMonitor tRCMonitor = tRCNode.getMonitor();
        String string2 = new Date().toString();
        string2 = HyadesUtil.change((String)string2, (String)" ", (String)"");
        string2 = HyadesUtil.change((String)string2, (String)":", (String)"");
        String string3 = tRCNode.getMonitor().getName() + "_" + tRCNode.getName() + "_" + n2 + "_" + n;
        String string4 = string3 + "." + "trcpxmi";
        IPath iPath = iContainer.getFullPath().append(string4);
        URI uRI = URI.createURI((String)("platform:/resource" + iPath.toString()));
        Resource resource = Resource.Factory.Registry.INSTANCE.getFactory(uRI).createResource(uRI);
        EList eList2 = resource.getContents();
        UIPlugin.getDefault().getResourceSet().getResources().add(resource);
        SaveUtil.addDocument((Resource)resource);
        HierarchyFactory hierarchyFactory = UIPlugin.getDefault().getPerftraceFactory();
        tRCProcessProxy = hierarchyFactory.createTRCProcessProxy();
        tRCProcessProxy.setPid(n);
        tRCProcessProxy.setRuntimeId(String.valueOf(n));
        tRCProcessProxy.setName(string);
        tRCProcessProxy.setLaunchMode(0);
        tRCProcessProxy.setNode(tRCNode);
        eList2.add(tRCProcessProxy);
        ProfileEvent profileEvent = UIPlugin.getDefault().getProfileEvent();
        profileEvent.setSource((Object)tRCProcessProxy);
        profileEvent.setType(128);
        UIPlugin.getDefault().notifyProfileEventListener(profileEvent);
        return tRCProcessProxy;
    }

    private void initializeValues() {
        IPluginRegistry iPluginRegistry = Platform.getPluginRegistry();
        IConfigurationElement[] iConfigurationElementArray = iPluginRegistry.getConfigurationElementsFor("org.eclipse.hyades.logging.parsers", "logParser");
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            block6: {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
                if (this.logParserId.trim().equals(iConfigurationElement.getAttribute("id").trim())) {
                    IConfigurationElement iConfigurationElement2;
                    Object object;
                    this._parser = new LogParserItem(iConfigurationElement.getAttribute("id"), iConfigurationElement.getAttribute("name"), iConfigurationElement.getAttribute("ui_name"), iConfigurationElement.getAttribute("description"));
                    this._parser.setConfigurationElement(iConfigurationElement);
                    this._parser.setClass(iConfigurationElement.getAttribute("class"));
                    this._parser.setUIType(iConfigurationElement.getAttribute("ui_type"));
                    String string = iConfigurationElement.getAttribute("icon");
                    if (string != null && !string.equals("")) {
                        object = iConfigurationElement.getDeclaringExtension().getDeclaringPluginDescriptor().getInstallURL();
                        try {
                            URL uRL = new URL((URL)object, string);
                            iConfigurationElement2 = ImageDescriptor.createFromURL((URL)uRL);
                            this._parser.setImageDescriptor((ImageDescriptor)iConfigurationElement2);
                        }
                        catch (Exception exception) {
                            iConfigurationElement2 = new Status(4, LogUIPlugin.getPluginId(), 2, "exception.malformedURL", (Throwable)exception);
                            LogUIPlugin.getDefault().getLog().log((IStatus)iConfigurationElement2);
                            break block6;
                        }
                    }
                    object = iConfigurationElement.getChildren("field");
                    int n2 = 0;
                    while (n2 < ((IConfigurationElement[])object).length) {
                        iConfigurationElement2 = object[n2];
                        ParserField parserField = new ParserField(iConfigurationElement2.getAttribute("id"), iConfigurationElement2.getAttribute("name"));
                        parserField.setDefaultValue(iConfigurationElement2.getAttribute("defaultValue"));
                        parserField.setContextId(iConfigurationElement2.getAttribute("helpContextId"));
                        parserField.setTooltip(iConfigurationElement2.getAttribute("tooltip"));
                        parserField.setFilters(iConfigurationElement2.getAttribute("browseType"));
                        parserField.useBrowse(iConfigurationElement2.getAttribute("useBrowse").equals("true"));
                        parserField.setUiType(iConfigurationElement2.getAttribute("ui_type"));
                        this._parser.addEntry(parserField);
                        ++n2;
                    }
                }
            }
            ++n;
        }
    }

    private void openLogView(TRCAgent tRCAgent) {
        if (tRCAgent.getDefaultEvents().size() > 10000) {
            return;
        }
        IAssociationMappingRegistry iAssociationMappingRegistry = TraceAssociationManager.getTraceViewMappingRegistry();
        IAssociationMapping iAssociationMapping = iAssociationMappingRegistry.getAssociationMapping("analyzerExtensions");
        if (iAssociationMapping == null) {
            return;
        }
        IAssociationDescriptor[] iAssociationDescriptorArray = iAssociationMapping.getAssociationDescriptors(tRCAgent.getType());
        if (iAssociationDescriptorArray.length > 0) {
            IAssociationDescriptor iAssociationDescriptor = iAssociationDescriptorArray[0];
            try {
                IAction iAction = (IAction)iAssociationDescriptor.createImplementationClassInstance();
                if (iAction != null) {
                    iAction.run();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    class ErrorAgentListener
    implements AgentListener {
        public void agentActive(Agent agent) {
            try {
                agent.startMonitoring(new DataProcessor(this){
                    private final /* synthetic */ ErrorAgentListener this$1;
                    {
                        this.this$1 = errorAgentListener;
                    }

                    public void incommingData(byte[] byArray, int n, InetAddress inetAddress) {
                        String string = new String(byArray, 0, n);
                        Display display = ErrorAgentListener.access$200((ErrorAgentListener)this.this$1).fShell.getDisplay();
                        display.asyncExec(new Runnable(this, string){
                            private final /* synthetic */ String val$agentErrorMessage;
                            private final /* synthetic */ 8 this$2;
                            {
                                this.this$2 = var1_1;
                                this.val$agentErrorMessage = string;
                            }

                            public void run() {
                                MessageDialog.openError((Shell)ErrorAgentListener.access$200((ErrorAgentListener)8.access$300(this.this$2)).fShell, (String)LogUIPlugin.getResourceString("LOGGING_MESSAGE"), (String)this.val$agentErrorMessage);
                            }
                        });
                    }

                    public void incommingData(char[] cArray, int n, InetAddress inetAddress) {
                    }

                    public void invalidDataType(byte[] byArray, int n, InetAddress inetAddress) {
                    }

                    public void waitingForData() {
                    }

                    static /* synthetic */ ErrorAgentListener access$300(8 var0) {
                        return var0.this$1;
                    }
                });
            }
            catch (Exception exception) {
                String string = exception.toString();
                Display display = ImportLogWizard.this.fShell.getDisplay();
                display.asyncExec(new Runnable(this, string){
                    private final /* synthetic */ String val$agentErrorMessage;
                    private final /* synthetic */ ErrorAgentListener this$1;
                    {
                        this.this$1 = errorAgentListener;
                        this.val$agentErrorMessage = string;
                    }

                    public void run() {
                        MessageDialog.openError((Shell)ErrorAgentListener.access$200((ErrorAgentListener)this.this$1).fShell, (String)LogUIPlugin.getResourceString("LOGGING_MESSAGE"), (String)this.val$agentErrorMessage);
                    }
                });
            }
        }

        public void agentInactive(Agent agent) {
        }

        public void error(Agent agent, String string, String string2) {
            String string3 = string.concat(": ").concat(string2);
            Display display = ImportLogWizard.this.fShell.getDisplay();
            display.asyncExec(new Runnable(this, string3){
                private final /* synthetic */ String val$errMsg;
                private final /* synthetic */ ErrorAgentListener this$1;
                {
                    this.this$1 = errorAgentListener;
                    this.val$errMsg = string;
                }

                public void run() {
                    MessageDialog.openError((Shell)ErrorAgentListener.access$200((ErrorAgentListener)this.this$1).fShell, (String)LogUIPlugin.getResourceString("LOGGING_MESSAGE"), (String)this.val$errMsg);
                }
            });
        }

        public void handleCommand(Agent agent, CommandElement commandElement) {
        }

        static /* synthetic */ ImportLogWizard access$200(ErrorAgentListener errorAgentListener) {
            return errorAgentListener.ImportLogWizard.this;
        }
    }

    class LogAgentListener
    implements AgentListener {
        private TRCAgentProxy aproxy;
        private TRCAgent trcAgent;
        private TRCProcessProxy trcProcess;

        public LogAgentListener(TRCAgent tRCAgent, TRCAgentProxy tRCAgentProxy, TRCProcessProxy tRCProcessProxy) {
            this.aproxy = tRCAgentProxy;
            this.trcAgent = tRCAgent;
            this.trcProcess = tRCProcessProxy;
        }

        public void agentActive(Agent agent) {
            this.aproxy.setActive(true);
            this.aproxy.setAttached(true);
            this.aproxy.setMonitored(true);
            LoadersUtils.registerAgentInstance((TRCAgentProxy)this.aproxy, (Object)agent);
            Display display = ImportLogWizard.this.fShell.getDisplay();
            display.asyncExec(new Runnable(this){
                private final /* synthetic */ LogAgentListener this$1;
                {
                    this.this$1 = logAgentListener;
                }

                public void run() {
                    ProfileEvent profileEvent = UIPlugin.getDefault().getProfileEvent();
                    profileEvent.setSource((Object)LogAgentListener.access$100(this.this$1));
                    profileEvent.setType(1);
                    UIPlugin.getDefault().notifyProfileEventListener(profileEvent);
                }
            });
            try {
                XMLTraceDataProcessor xMLTraceDataProcessor = new XMLTraceDataProcessor(this, this.trcAgent.getAgentProxy()){
                    private final /* synthetic */ LogAgentListener this$1;
                    {
                        this.this$1 = logAgentListener;
                    }

                    public void dataServerExited() {
                        super.dataServerExited();
                        LoadersUtils.deregisterAgentInstance((TRCAgentProxy)LogAgentListener.access$100(this.this$1));
                    }
                };
                agent.startMonitoring((DataProcessor)xMLTraceDataProcessor);
            }
            catch (Exception exception) {
                String string = exception.toString();
                Display display2 = ImportLogWizard.this.fShell.getDisplay();
                display2.asyncExec(new Runnable(this, string){
                    private final /* synthetic */ String val$agentErrorMessage;
                    private final /* synthetic */ LogAgentListener this$1;
                    {
                        this.this$1 = logAgentListener;
                        this.val$agentErrorMessage = string;
                    }

                    public void run() {
                        MessageDialog.openError((Shell)UIPlugin.getActiveWorkbenchShell(), (String)LogUIPlugin.getResourceString("LOGGING_MESSAGE"), (String)this.val$agentErrorMessage);
                    }
                });
            }
        }

        public void agentInactive(Agent agent) {
            this.aproxy.setActive(false);
            this.aproxy.setAttached(false);
            this.aproxy.setMonitored(false);
            this.trcProcess.setActive(false);
            Display display = ImportLogWizard.this.fShell.getDisplay();
            display.asyncExec(new Runnable(this){
                private final /* synthetic */ LogAgentListener this$1;
                {
                    this.this$1 = logAgentListener;
                }

                public void run() {
                    ProfileEvent profileEvent = UIPlugin.getDefault().getProfileEvent();
                    profileEvent.setSource((Object)LogAgentListener.access$100(this.this$1));
                    profileEvent.setType(16);
                    UIPlugin.getDefault().notifyProfileEventListener(profileEvent);
                }
            });
        }

        public void error(Agent agent, String string, String string2) {
            String string3 = string.concat(": ").concat(string2);
            Display display = ImportLogWizard.this.fShell.getDisplay();
            display.asyncExec(new Runnable(this, string3){
                private final /* synthetic */ String val$errMsg;
                private final /* synthetic */ LogAgentListener this$1;
                {
                    this.this$1 = logAgentListener;
                    this.val$errMsg = string;
                }

                public void run() {
                    MessageDialog.openError((Shell)UIPlugin.getActiveWorkbenchShell(), (String)LogUIPlugin.getResourceString("LOGGING_MESSAGE"), (String)this.val$errMsg);
                }
            });
        }

        public void handleCommand(Agent agent, CommandElement commandElement) {
        }

        static /* synthetic */ TRCAgentProxy access$100(LogAgentListener logAgentListener) {
            return logAgentListener.aproxy;
        }
    }

    class ProcessListenerImpl
    implements ProcessListener {
        TRCAgentProxy trcAgent;
        TRCProcessProxy trcProcess;

        public ProcessListenerImpl(TRCProcessProxy tRCProcessProxy, TRCAgentProxy tRCAgentProxy) {
            this.trcProcess = tRCProcessProxy;
            this.trcAgent = tRCAgentProxy;
        }

        public void processExited(Process process) {
            this.trcAgent.setActive(false);
            this.trcAgent.setAttached(false);
            this.trcAgent.setMonitored(false);
            Display display = ImportLogWizard.this.fShell.getDisplay();
            display.asyncExec(new Runnable(this){
                private final /* synthetic */ ProcessListenerImpl this$1;
                {
                    this.this$1 = processListenerImpl;
                }

                public void run() {
                    ProcessListenerImpl.access$000((ProcessListenerImpl)this.this$1).fViewer.getViewer().refresh((Object)this.this$1.trcAgent);
                }
            });
        }

        public void processLaunched(Process process) {
            try {
                if (this.trcProcess != null) {
                    this.trcProcess.setPid(Integer.parseInt(process.getProcessId()));
                    this.trcProcess.setRuntimeId(process.getUUID());
                    this.trcProcess.setActive(true);
                    Display display = ImportLogWizard.this.fShell.getDisplay();
                    display.asyncExec(new Runnable(this){
                        private final /* synthetic */ ProcessListenerImpl this$1;
                        {
                            this.this$1 = processListenerImpl;
                        }

                        public void run() {
                            ProcessListenerImpl.access$000((ProcessListenerImpl)this.this$1).fViewer.getViewer().refresh((Object)this.this$1.trcProcess);
                            ProcessListenerImpl.access$000((ProcessListenerImpl)this.this$1).fViewer.selectObject((Object)this.this$1.trcAgent);
                        }
                    });
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        static /* synthetic */ ImportLogWizard access$000(ProcessListenerImpl processListenerImpl) {
            return processListenerImpl.ImportLogWizard.this;
        }
    }
}

