/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.wizards;

import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import org.eclipse.hyades.internal.logging.core.XmlGenerator;
import org.eclipse.hyades.loaders.util.XMLLoader;
import org.eclipse.hyades.logging.core.ILogger;
import org.eclipse.hyades.logging.parsers.LogParserException;
import org.eclipse.hyades.logging.parsers.Parser;

public class LocalLogParserLoader
implements ILogger {
    private Hashtable parserParameters = null;
    private Parser parser = null;
    private XmlGenerator xmlGenerator = new XmlGenerator("ParseLogger");
    private XMLLoader xmlLoader = null;
    private boolean first = true;

    public LocalLogParserLoader(Parser parser, Hashtable hashtable) {
        this.parser = parser;
        this.parserParameters = hashtable;
        this.xmlGenerator.reset("FINEST", true, 8);
    }

    public void setXMLLoader(XMLLoader xMLLoader) {
        this.xmlLoader = xMLLoader;
    }

    public void startParsing() throws LogParserException {
        this.parser.setUserInput(this.parserParameters);
        this.parser.parse((ILogger)this);
    }

    public void write(boolean bl) {
        this.logXMLToModel(XmlGenerator.primitiveToXML((boolean)bl));
    }

    public void write(char c) {
        this.logXMLToModel(XmlGenerator.primitiveToXML((char)c));
    }

    public void write(byte by) {
        this.logXMLToModel(XmlGenerator.primitiveToXML((byte)by));
    }

    public void write(short s) {
        this.logXMLToModel(XmlGenerator.primitiveToXML((short)s));
    }

    public void write(int n) {
        this.logXMLToModel(XmlGenerator.primitiveToXML((int)n));
    }

    public void write(long l) {
        this.logXMLToModel(XmlGenerator.primitiveToXML((long)l));
    }

    public void write(float f) {
        this.logXMLToModel(XmlGenerator.primitiveToXML((float)f));
    }

    public void write(double d) {
        this.logXMLToModel(XmlGenerator.primitiveToXML((double)d));
    }

    public void write(Object object) {
        try {
            this.logXMLToModel(this.xmlGenerator.objectToXML(object));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void logXMLToModel(String string) {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string.getBytes();
        }
        this.xmlLoader.loadEvent(byArray, byArray.length);
    }
}

