/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import org.eclipse.hyades.loaders.trace.IDelta;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.impl.TRCClassImpl;
import org.eclipse.hyades.trace.ui.ITraceSelection;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.hyades.trace.views.adapter.internal.ClassInstanceStatisticPage;
import org.eclipse.hyades.trace.views.internal.StatisticView;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.PerftraceUtil;
import org.eclipse.hyades.trace.views.util.internal.StatisticTableColumnInfo;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class ClassInstanceStatistic
extends StatisticView {
    private final TRCClassImpl.TRCClassSnapshot class1Delta = new TRCClassImpl.TRCClassSnapshot();
    private final TRCClassImpl.TRCClassSnapshot class2Delta = new TRCClassImpl.TRCClassSnapshot();

    protected Composite createTable(Composite composite, int n) {
        return new TableTree(composite, n);
    }

    public ClassInstanceStatistic(Composite composite, TraceViewerPage traceViewerPage) {
        super(composite, traceViewerPage);
        this._viewerFilter = new ClassStatisticFilter();
    }

    public String getColumnsPreferencesKey() {
        return "ClassI60";
    }

    public String getDefaultColumnsTemplate() {
        String string = TraceUIPlugin.getString("STR_ST_CLASS_NAME") + ":0:" + String.valueOf(7) + ":left:200," + TraceUIPlugin.getString("STR_ST_PACKAGE") + ":1:" + String.valueOf(1) + ":left:100," + TraceUIPlugin.getString("STR_ST_INSTANCES") + ":2:" + String.valueOf(17) + ":right:100," + TraceUIPlugin.getString("STR_ST_LIVE_INSTANCES") + ":3:" + String.valueOf(17) + ":right:100," + TraceUIPlugin.getString("STR_ST_COLLECTED") + ":4:" + String.valueOf(16) + ":right:100," + TraceUIPlugin.getString("STR_ST_SIZE") + ":5:" + String.valueOf(17) + ":right:100," + TraceUIPlugin.getString("STR_ST_LIVE_STORAGE") + ":6:" + String.valueOf(17) + ":right:100," + TraceUIPlugin.getString("STR_ST_CPU_TIME") + ":7:" + String.valueOf(16) + ":right:100," + TraceUIPlugin.getString("STR_ST_CPU_INHTIME") + ":8:" + String.valueOf(16) + ":right:100," + TraceUIPlugin.getString("STR_ST_STACK_TIME") + ":9:" + String.valueOf(16) + ":right:100," + TraceUIPlugin.getString("STR_ST_STACK_INHTIME") + ":10:" + String.valueOf(16) + ":right:100," + TraceUIPlugin.getString("STR_ST_CALLS") + ":11:" + String.valueOf(16) + ":right:50," + TraceUIPlugin.getString("STR_ST_INHCALLS") + ":12:" + String.valueOf(16) + ":right:100";
        return string;
    }

    protected IContentProvider getContentProvider() {
        return new ClassStatisticContentProvider();
    }

    public LabelProvider getTableLabelProvider() {
        return new ClassStatisticLabelProvider(this);
    }

    public Table getTable() {
        return ((TableTree)this.getTableViewer().getControl()).getTable();
    }

    protected StructuredViewer createTableViewer(Composite composite) {
        ClassTreeViewer classTreeViewer = new ClassTreeViewer((TableTree)composite);
        return classTreeViewer;
    }

    protected void handleSelectionEvent() {
        ((ClassInstanceStatisticPage)this.getTraceViewerPage()).openSource().setEnabled(false);
        ITraceSelection iTraceSelection = UIPlugin.getDefault().getSelectionModel(this._page.getMOFObject());
        if (iTraceSelection.size() > 0) {
            Object object = iTraceSelection.getFirstElement();
            if (object instanceof TRCMethod) {
                object = ((TRCMethod)object).getDefiningClass();
            } else if (object instanceof TRCObject) {
                this.select((TRCObject)object);
            } else if (object instanceof TRCClass) {
                this.select((TRCClass)object);
            } else if (object instanceof TRCMethodInvocation) {
                this.select(PerftraceUtil.getClass((TRCMethodInvocation)object));
            }
        }
    }

    public void menuAboutToShow(IMenuManager iMenuManager) {
        iMenuManager.add((IContributionItem)this.fSeparator);
        iMenuManager.add((IAction)this.getUpdateAction());
        iMenuManager.add((IContributionItem)this.fSeparator);
        iMenuManager.add((IAction)this.getChooseColumnsAction(this.getColumnDataList(), this.getColumnsPreferencesKey()));
    }

    private void select(TRCObject tRCObject) {
        boolean bl = true;
        TRCClass tRCClass = tRCObject.getIsA();
        TableTree tableTree = ((TableTreeViewer)this.getTableViewer()).getTableTree();
        TableTreeItem[] tableTreeItemArray = tableTree.getItems();
        int n = 0;
        while (n < tableTreeItemArray.length) {
            TableTreeItem tableTreeItem = tableTreeItemArray[n];
            if (tableTreeItem.getData() == tRCClass) {
                ((ClassTreeViewer)this.getTableViewer()).expandItem(tableTreeItem);
                TableTreeItem[] tableTreeItemArray2 = tableTreeItem.getItems();
                int n2 = 0;
                while (n2 < tableTreeItemArray2.length) {
                    TableTreeItem tableTreeItem2 = tableTreeItemArray2[n2];
                    if (tRCObject == tableTreeItem2.getData()) {
                        ((ClassTreeViewer)this.getTableViewer()).expandItem(tableTreeItem);
                        tableTree.setSelection(new TableTreeItem[]{tableTreeItem2});
                        return;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        tableTree.deselectAll();
    }

    private void select(TRCClass tRCClass) {
        TableTree tableTree = ((TableTreeViewer)this.getTableViewer()).getTableTree();
        TableTreeItem[] tableTreeItemArray = tableTree.getItems();
        int n = 0;
        while (n < tableTreeItemArray.length) {
            Object object = tableTreeItemArray[n].getData();
            if (object != null && object == tRCClass) {
                tableTree.setSelection(new TableTreeItem[]{tableTreeItemArray[n]});
                return;
            }
            ++n;
        }
        tableTree.deselectAll();
    }

    public void updateButtons() {
        ((ClassInstanceStatisticPage)this.getTraceViewerPage()).deltaColumns().setChecked(this.showingDeltaColumns());
        ((ClassInstanceStatisticPage)this.getTraceViewerPage()).percentMode().setChecked(this.isShowPercent());
    }

    protected void updateDetailsPane() {
        int n = this.getTable().getSelectionIndex();
        if (n < 0) {
            return;
        }
        TableItem tableItem = this.getTable().getItem(n);
        Object object = tableItem.getData();
        if (object == null) {
            return;
        }
        if (object != null && object instanceof TableTreeItem) {
            object = ((TableTreeItem)object).getData();
        }
    }

    public void updateModelSelection() {
        ISelection iSelection = this.getTableViewer().getSelection();
        if (iSelection != null && !iSelection.isEmpty()) {
            Object object = ((IStructuredSelection)iSelection).getFirstElement();
            UIPlugin.getDefault().getSelectionModel(this._page.getMOFObject()).add(object);
            ViewSelectionChangedEvent viewSelectionChangedEvent = UIPlugin.getDefault().getViewSelectionChangedEvent();
            viewSelectionChangedEvent.setSource((Object)this._page.getMOFObject());
            UIPlugin.getDefault().notifyViewSelectionChangedListener(viewSelectionChangedEvent);
        }
    }

    public void update() {
        if (this._firstTime) {
            this.getTableViewer().addFilter((ViewerFilter)this.getViewerFilter());
            this._firstTime = false;
            Table table = this.getTable();
            TableColumn tableColumn = table.getColumn(0);
            this._viewerSorter = new ClassStatisticSorter();
            this.getViewerSorter().setSortedColumn(tableColumn);
            this.getTableViewer().setSorter((ViewerSorter)this.getViewerSorter());
        }
        if (this.isShowPercent()) {
            this._totalCalls = PerftraceUtil.getTotalCalls(this._page.getMOFObject());
            this._totalInst = PerftraceUtil.getTotalInstances(this._page.getMOFObject());
            this._activeInst = PerftraceUtil.getActiveInstances(this._page.getMOFObject());
            this._totalSize = PerftraceUtil.getTotalSize(this._page.getMOFObject());
            this._activeSize = PerftraceUtil.getActiveSize(this._page.getMOFObject());
            this._maxTime = PerftraceUtil.getMaximumTime(this._page.getMOFObject());
        }
        this.getTableViewer().setInput((Object)this._page.getMOFObject());
        this.getTable().setRedraw(false);
        this.getTableViewer().refresh();
        this.getTable().setRedraw(true);
        this.handleSelectionEvent();
    }

    public void handleViewSelectionChangedEvent(ViewSelectionChangedEvent viewSelectionChangedEvent) {
        if (!this.getTraceViewerPage().getTraceViewer().isProcessRefreshEvents() || this.getTable().isFocusControl()) {
            return;
        }
        this.handleSelectionEvent();
    }

    public boolean isEmpty() {
        return PerftraceUtil.getAllClasses(this._page.getMOFObject()).length <= 0;
    }

    class ClassTreeViewer
    extends TableTreeViewer {
        public ClassTreeViewer(Composite composite) {
            super(composite);
        }

        public ClassTreeViewer(TableTree tableTree) {
            super(tableTree);
        }

        public void expandItem(TableTreeItem tableTreeItem) {
            tableTreeItem.setExpanded(true);
            this.createChildren((Widget)tableTreeItem);
        }
    }

    public class ClassStatisticLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected StatisticView _viewer;

        public ClassStatisticLabelProvider(StatisticView statisticView) {
            this._viewer = statisticView;
        }

        public Image getColumnImage(Object object, int n) {
            StatisticTableColumnInfo statisticTableColumnInfo = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTable().getColumn(n));
            int n2 = statisticTableColumnInfo.getColumnData().getInitalPos();
            if (statisticTableColumnInfo.isDeltaColumn()) {
                return null;
            }
            int n3 = 0;
            double d = 0.0;
            if (object instanceof TRCClass) {
                TRCClass tRCClass = (TRCClass)object;
                if (((TRCClass)object).computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 14) < 0) {
                    if (n == 1) {
                        return TracePluginImages.getImage("newentry_obj.gif");
                    }
                    return null;
                }
                switch (n2) {
                    case 2: {
                        tRCClass.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 14);
                        n3 = ClassInstanceStatistic.this.class1Delta.getTotalInstances();
                        break;
                    }
                    case 3: {
                        tRCClass.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 14);
                        tRCClass.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 16);
                        n3 = ClassInstanceStatistic.this.class1Delta.getTotalInstances() - ClassInstanceStatistic.this.class1Delta.getCollectedInstances();
                        break;
                    }
                    case 4: {
                        tRCClass.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 16);
                        n3 = ClassInstanceStatistic.this.class1Delta.getCollectedInstances();
                        break;
                    }
                    case 5: {
                        tRCClass.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 13);
                        n3 = ClassInstanceStatistic.this.class1Delta.getTotalSize();
                        break;
                    }
                    case 6: {
                        tRCClass.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 13);
                        tRCClass.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 15);
                        n3 = ClassInstanceStatistic.this.class1Delta.getTotalSize() - ClassInstanceStatistic.this.class1Delta.getCollectedSize();
                        break;
                    }
                    case 7: {
                        tRCClass.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 7);
                        d = ClassInstanceStatistic.this.class1Delta.getBaseTime();
                        if (d < 0.0) {
                            n3 = -1;
                            break;
                        }
                        if (!(d > 0.0)) break;
                        n3 = 1;
                        break;
                    }
                    case 8: {
                        tRCClass.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 11);
                        d = ClassInstanceStatistic.this.class1Delta.getInheritedBaseTime();
                        if (d < 0.0) {
                            n3 = -1;
                            break;
                        }
                        if (!(d > 0.0)) break;
                        n3 = 1;
                        break;
                    }
                    case 9: {
                        tRCClass.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 8);
                        d = ClassInstanceStatistic.this.class1Delta.getCumulativeTime();
                        if (d < 0.0) {
                            n3 = -1;
                            break;
                        }
                        if (!(d > 0.0)) break;
                        n3 = 1;
                        break;
                    }
                    case 10: {
                        tRCClass.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 12);
                        d = ClassInstanceStatistic.this.class1Delta.getInheritedCumulativeTime();
                        if (d < 0.0) {
                            n3 = -1;
                            break;
                        }
                        if (!(d > 0.0)) break;
                        n3 = 1;
                        break;
                    }
                    case 11: {
                        tRCClass.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 9);
                        n3 = ClassInstanceStatistic.this.class1Delta.getCalls();
                        break;
                    }
                    case 12: {
                        tRCClass.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 10);
                        n3 = ClassInstanceStatistic.this.class1Delta.getInheritedCalls();
                    }
                }
            }
            if (n3 < 0) {
                return TracePluginImages.getImage("decreasedvalue_obj.gif");
            }
            if (n3 > 0) {
                return TracePluginImages.getImage("increasedvalue_obj.gif");
            }
            return null;
        }

        public String getColumnText(Object object, int n) {
            StatisticTableColumnInfo statisticTableColumnInfo = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTable().getColumn(n));
            int n2 = statisticTableColumnInfo.getColumnData().getInitalPos();
            if (object instanceof TRCClass) {
                TRCClass tRCClass = (TRCClass)object;
                TRCClassImpl.TRCClassSnapshot tRCClassSnapshot = (TRCClassImpl.TRCClassSnapshot)tRCClass.retrieveSnapshot();
                switch (n2) {
                    case 0: {
                        return tRCClass.getName();
                    }
                    case 1: {
                        return PerftraceUtil.getPackageName(tRCClass.getPackage(), ClassInstanceStatistic.this._page.getMOFObject()).toString();
                    }
                    case 2: {
                        if (!statisticTableColumnInfo.isDeltaColumn()) {
                            if (ClassInstanceStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)((double)tRCClassSnapshot.getTotalInstances() / (double)ClassInstanceStatistic.this._totalInst));
                            }
                            return String.valueOf(tRCClassSnapshot.getTotalInstances());
                        }
                        tRCClass.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 14);
                        return String.valueOf(ClassInstanceStatistic.this.class1Delta.getTotalInstances());
                    }
                    case 3: {
                        if (!statisticTableColumnInfo.isDeltaColumn()) {
                            if (ClassInstanceStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)(((double)tRCClassSnapshot.getTotalInstances() - (double)tRCClassSnapshot.getCollectedInstances()) / (double)ClassInstanceStatistic.this._totalInst));
                            }
                            return String.valueOf(tRCClassSnapshot.getTotalInstances() - tRCClassSnapshot.getCollectedInstances());
                        }
                        tRCClass.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 14);
                        tRCClass.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 16);
                        return String.valueOf(ClassInstanceStatistic.this.class1Delta.getTotalInstances() - ClassInstanceStatistic.this.class1Delta.getCollectedInstances());
                    }
                    case 4: {
                        if (!statisticTableColumnInfo.isDeltaColumn()) {
                            if (ClassInstanceStatistic.this.isShowPercent()) {
                                int n3 = tRCClass.getTotalInstances();
                                if (n3 == 0) {
                                    n3 = 1;
                                }
                                return TString.formatAsPercentage((double)((double)tRCClassSnapshot.getCollectedInstances() / (double)n3));
                            }
                            return String.valueOf(tRCClassSnapshot.getCollectedInstances());
                        }
                        tRCClass.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 16);
                        return String.valueOf(ClassInstanceStatistic.this.class1Delta.getCollectedInstances());
                    }
                    case 5: {
                        if (!statisticTableColumnInfo.isDeltaColumn()) {
                            if (ClassInstanceStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)((double)tRCClassSnapshot.getTotalSize() / (double)ClassInstanceStatistic.this._totalSize));
                            }
                            return String.valueOf(tRCClassSnapshot.getTotalSize());
                        }
                        tRCClass.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 13);
                        return String.valueOf(ClassInstanceStatistic.this.class1Delta.getTotalSize());
                    }
                    case 6: {
                        if (!statisticTableColumnInfo.isDeltaColumn()) {
                            if (ClassInstanceStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)(((double)tRCClassSnapshot.getTotalSize() - (double)tRCClassSnapshot.getCollectedSize()) / (double)ClassInstanceStatistic.this._activeSize));
                            }
                            return String.valueOf(tRCClassSnapshot.getTotalSize() - tRCClassSnapshot.getCollectedSize());
                        }
                        tRCClass.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 13);
                        tRCClass.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 15);
                        return String.valueOf(ClassInstanceStatistic.this.class1Delta.getTotalSize() - ClassInstanceStatistic.this.class1Delta.getCollectedSize());
                    }
                    case 7: {
                        if (!statisticTableColumnInfo.isDeltaColumn()) {
                            if (ClassInstanceStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)(tRCClassSnapshot.getBaseTime() / ClassInstanceStatistic.this._maxTime));
                            }
                            return TString.formatTimeValue((double)tRCClassSnapshot.getBaseTime());
                        }
                        tRCClass.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 7);
                        return TString.formatTimeValue((double)ClassInstanceStatistic.this.class1Delta.getBaseTime());
                    }
                    case 8: {
                        if (!statisticTableColumnInfo.isDeltaColumn()) {
                            if (ClassInstanceStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)(tRCClassSnapshot.getInheritedBaseTime() / ClassInstanceStatistic.this._maxTime));
                            }
                            return TString.formatTimeValue((double)tRCClassSnapshot.getInheritedBaseTime());
                        }
                        tRCClass.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 11);
                        return TString.formatTimeValue((double)ClassInstanceStatistic.this.class1Delta.getInheritedBaseTime());
                    }
                    case 9: {
                        if (!statisticTableColumnInfo.isDeltaColumn()) {
                            if (ClassInstanceStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)(tRCClassSnapshot.getCumulativeTime() / ClassInstanceStatistic.this._maxTime));
                            }
                            return TString.formatTimeValue((double)tRCClassSnapshot.getCumulativeTime());
                        }
                        tRCClass.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 8);
                        return TString.formatTimeValue((double)ClassInstanceStatistic.this.class1Delta.getCumulativeTime());
                    }
                    case 10: {
                        if (!statisticTableColumnInfo.isDeltaColumn()) {
                            if (ClassInstanceStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)(tRCClassSnapshot.getInheritedCumulativeTime() / ClassInstanceStatistic.this._maxTime));
                            }
                            return TString.formatTimeValue((double)tRCClassSnapshot.getInheritedCumulativeTime());
                        }
                        tRCClass.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 12);
                        return TString.formatTimeValue((double)ClassInstanceStatistic.this.class1Delta.getInheritedCumulativeTime());
                    }
                    case 11: {
                        if (!statisticTableColumnInfo.isDeltaColumn()) {
                            if (ClassInstanceStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)((double)tRCClassSnapshot.getCalls() / (double)ClassInstanceStatistic.this._totalCalls));
                            }
                            return String.valueOf(tRCClassSnapshot.getCalls());
                        }
                        tRCClass.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 9);
                        return String.valueOf(ClassInstanceStatistic.this.class1Delta.getCalls());
                    }
                    case 12: {
                        if (!statisticTableColumnInfo.isDeltaColumn()) {
                            if (ClassInstanceStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)((double)tRCClassSnapshot.getInheritedCalls() / (double)ClassInstanceStatistic.this._totalCalls));
                            }
                            return String.valueOf(tRCClassSnapshot.getInheritedCalls());
                        }
                        tRCClass.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 10);
                        return String.valueOf(ClassInstanceStatistic.this.class1Delta.getInheritedCalls());
                    }
                }
            } else {
                if (!(object instanceof TRCFullTraceObject)) {
                    return "";
                }
                if (statisticTableColumnInfo.isDeltaColumn()) {
                    return "";
                }
                TRCFullTraceObject tRCFullTraceObject = (TRCFullTraceObject)object;
                switch (n2) {
                    case 0: {
                        TRCClass tRCClass = PerftraceUtil.getClass((TRCObject)tRCFullTraceObject);
                        if (tRCClass == tRCFullTraceObject.getProcess().getClassClass()) {
                            return tRCClass.getName();
                        }
                        return tRCClass.getName() + "." + tRCFullTraceObject.getId();
                    }
                    case 1: {
                        return "";
                    }
                    case 2: {
                        return "";
                    }
                    case 3: {
                        return "";
                    }
                    case 4: {
                        if (tRCFullTraceObject.getCollectTime() == 0.0) {
                            return "0";
                        }
                        return "1";
                    }
                    case 5: {
                        return String.valueOf(((TRCObject)object).getSize());
                    }
                    case 6: {
                        if (tRCFullTraceObject.getCollectTime() != 0.0) {
                            return "0";
                        }
                        return String.valueOf(tRCFullTraceObject.getSize());
                    }
                    case 7: {
                        if (ClassInstanceStatistic.this.isShowPercent()) {
                            return TString.formatAsPercentage((double)(tRCFullTraceObject.getBaseTime() / ClassInstanceStatistic.this._maxTime));
                        }
                        return TString.formatTimeValue((double)tRCFullTraceObject.getBaseTime());
                    }
                    case 9: {
                        if (ClassInstanceStatistic.this.isShowPercent()) {
                            return TString.formatAsPercentage((double)(tRCFullTraceObject.getCumulativeTime() / ClassInstanceStatistic.this._maxTime));
                        }
                        return TString.formatTimeValue((double)tRCFullTraceObject.getCumulativeTime());
                    }
                    case 11: {
                        if (ClassInstanceStatistic.this.isShowPercent()) {
                            return TString.formatAsPercentage((double)((double)tRCFullTraceObject.getCalls() / (double)ClassInstanceStatistic.this._totalCalls));
                        }
                        return String.valueOf(tRCFullTraceObject.getCalls());
                    }
                }
            }
            return "";
        }
    }

    public class ClassStatisticContentProvider
    implements ITreeContentProvider {
        public void dispose() {
        }

        public Object getParent(Object object) {
            if (object instanceof TRCObject) {
                PerftraceUtil.getClass((TRCObject)object);
            }
            return null;
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }

        public Object[] getElements(Object object) {
            return PerftraceUtil.getAllClasses(ClassInstanceStatistic.this._page.getMOFObject());
        }

        public Object[] getChildren(Object object) {
            ClassInstanceStatistic.this.tmpList.clear();
            if (object instanceof TRCClass) {
                TRCClass tRCClass = (TRCClass)object;
                Object[] objectArray = tRCClass.getClassObjects().toArray();
                int n = 0;
                while (n < objectArray.length) {
                    if (objectArray[n] instanceof TRCFullTraceObject) {
                        ClassInstanceStatistic.this.tmpList.add(objectArray[n]);
                    }
                    ++n;
                }
                Object[] objectArray2 = tRCClass.getObjects().toArray();
                int n2 = 0;
                while (n2 < objectArray2.length) {
                    if (objectArray2[n2] instanceof TRCFullTraceObject) {
                        ClassInstanceStatistic.this.tmpList.add(objectArray2[n2]);
                    }
                    ++n2;
                }
            }
            return ClassInstanceStatistic.this.tmpList.toArray();
        }

        public boolean hasChildren(Object object) {
            if (object instanceof TRCClass) {
                TRCClass tRCClass = (TRCClass)object;
                Object[] objectArray = tRCClass.getClassObjects().toArray();
                int n = 0;
                while (n < objectArray.length) {
                    if (objectArray[n] instanceof TRCFullTraceObject) {
                        return true;
                    }
                    ++n;
                }
                Object[] objectArray2 = tRCClass.getObjects().toArray();
                int n2 = 0;
                while (n2 < objectArray2.length) {
                    if (objectArray2[n2] instanceof TRCFullTraceObject) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }
    }

    public class ClassStatisticSorter
    extends StatisticView.StatisticSorter {
        public ClassStatisticSorter() {
            super(ClassInstanceStatistic.this);
        }

        public int compare(Viewer viewer, Object object, Object object2) {
            double d = 0.0;
            if (object instanceof TRCClass) {
                TRCClass tRCClass = (TRCClass)object;
                TRCClass tRCClass2 = (TRCClass)object2;
                TRCClassImpl.TRCClassSnapshot tRCClassSnapshot = (TRCClassImpl.TRCClassSnapshot)tRCClass.retrieveSnapshot();
                TRCClassImpl.TRCClassSnapshot tRCClassSnapshot2 = (TRCClassImpl.TRCClassSnapshot)tRCClass2.retrieveSnapshot();
                switch (this._pos) {
                    case 0: {
                        return this._sortSequence * tRCClass.getName().compareToIgnoreCase(tRCClass2.getName());
                    }
                    case 1: {
                        return this._sortSequence * tRCClass.getPackage().getName().compareToIgnoreCase(tRCClass2.getPackage().getName());
                    }
                    case 2: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (tRCClassSnapshot.getTotalInstances() - tRCClassSnapshot2.getTotalInstances());
                        }
                        tRCClass.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 14);
                        tRCClass2.computeDelta((IDelta)ClassInstanceStatistic.this.class2Delta, 14);
                        return this._sortSequence * (ClassInstanceStatistic.this.class1Delta.getTotalInstances() - ClassInstanceStatistic.this.class2Delta.getTotalInstances());
                    }
                    case 3: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (tRCClassSnapshot.getTotalInstances() - tRCClassSnapshot.getCollectedInstances() - tRCClassSnapshot2.getTotalInstances() + tRCClassSnapshot2.getCollectedInstances());
                        }
                        tRCClass.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 14);
                        tRCClass2.computeDelta((IDelta)ClassInstanceStatistic.this.class2Delta, 14);
                        tRCClass.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 16);
                        tRCClass2.computeDelta((IDelta)ClassInstanceStatistic.this.class2Delta, 16);
                        return this._sortSequence * (ClassInstanceStatistic.this.class1Delta.getTotalInstances() - ClassInstanceStatistic.this.class1Delta.getCollectedInstances() - (ClassInstanceStatistic.this.class2Delta.getTotalInstances() - ClassInstanceStatistic.this.class2Delta.getCollectedInstances()));
                    }
                    case 4: {
                        if (!this._info.isDeltaColumn()) {
                            if (ClassInstanceStatistic.this.isShowPercent()) {
                                int n = tRCClassSnapshot.getTotalInstances();
                                if (n == 0) {
                                    n = 1;
                                }
                                double d2 = (double)tRCClassSnapshot.getCollectedInstances() / (double)n;
                                n = tRCClassSnapshot2.getTotalInstances();
                                if (n == 0) {
                                    n = 1;
                                }
                                return this._sortSequence * (int)((d2 -= (double)tRCClassSnapshot2.getCollectedInstances() / (double)n) * 10000.0);
                            }
                            return this._sortSequence * (tRCClassSnapshot.getCollectedInstances() - tRCClassSnapshot2.getCollectedInstances());
                        }
                        tRCClass.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 16);
                        tRCClass2.computeDelta((IDelta)ClassInstanceStatistic.this.class2Delta, 16);
                        return this._sortSequence * (ClassInstanceStatistic.this.class1Delta.getCollectedInstances() - ClassInstanceStatistic.this.class2Delta.getCollectedInstances());
                    }
                    case 5: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (tRCClassSnapshot.getTotalSize() - tRCClassSnapshot2.getTotalSize());
                        }
                        tRCClass.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 13);
                        tRCClass2.computeDelta((IDelta)ClassInstanceStatistic.this.class2Delta, 13);
                        return this._sortSequence * (ClassInstanceStatistic.this.class1Delta.getTotalSize() - ClassInstanceStatistic.this.class2Delta.getTotalSize());
                    }
                    case 6: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (tRCClassSnapshot.getTotalSize() - tRCClassSnapshot2.getCollectedSize() - ((TRCClass)object2).getTotalSize() + ((TRCClass)object2).getCollectedSize());
                        }
                        tRCClass.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 13);
                        tRCClass2.computeDelta((IDelta)ClassInstanceStatistic.this.class2Delta, 13);
                        tRCClass.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 15);
                        tRCClass2.computeDelta((IDelta)ClassInstanceStatistic.this.class2Delta, 15);
                        return this._sortSequence * (ClassInstanceStatistic.this.class1Delta.getTotalSize() - ClassInstanceStatistic.this.class1Delta.getCollectedSize() - (ClassInstanceStatistic.this.class2Delta.getTotalSize() - ClassInstanceStatistic.this.class2Delta.getCollectedSize()));
                    }
                    case 7: {
                        if (!this._info.isDeltaColumn()) {
                            d = tRCClassSnapshot.getBaseTime() - tRCClassSnapshot2.getBaseTime();
                        } else {
                            tRCClass.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 7);
                            tRCClass2.computeDelta((IDelta)ClassInstanceStatistic.this.class2Delta, 7);
                            d = ClassInstanceStatistic.this.class1Delta.getBaseTime() - ClassInstanceStatistic.this.class2Delta.getBaseTime();
                        }
                        if (d < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                    case 8: {
                        if (!this._info.isDeltaColumn()) {
                            d = tRCClassSnapshot.getInheritedBaseTime() - tRCClassSnapshot2.getInheritedBaseTime();
                        } else {
                            tRCClass.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 11);
                            tRCClass2.computeDelta((IDelta)ClassInstanceStatistic.this.class2Delta, 11);
                            d = ClassInstanceStatistic.this.class1Delta.getInheritedBaseTime() - ClassInstanceStatistic.this.class2Delta.getInheritedBaseTime();
                        }
                        if (d < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                    case 9: {
                        if (!this._info.isDeltaColumn()) {
                            d = tRCClassSnapshot.getCumulativeTime() - tRCClassSnapshot2.getCumulativeTime();
                        } else {
                            tRCClass.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 8);
                            tRCClass2.computeDelta((IDelta)ClassInstanceStatistic.this.class2Delta, 8);
                            d = ClassInstanceStatistic.this.class1Delta.getCumulativeTime() - ClassInstanceStatistic.this.class2Delta.getCumulativeTime();
                        }
                        if (d < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                    case 10: {
                        if (!this._info.isDeltaColumn()) {
                            d = tRCClassSnapshot.getInheritedCumulativeTime() - tRCClassSnapshot2.getInheritedCumulativeTime();
                        } else {
                            tRCClass.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 12);
                            tRCClass2.computeDelta((IDelta)ClassInstanceStatistic.this.class2Delta, 12);
                            d = ClassInstanceStatistic.this.class1Delta.getInheritedCumulativeTime() - ClassInstanceStatistic.this.class2Delta.getInheritedCumulativeTime();
                        }
                        if (d < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                    case 11: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (tRCClassSnapshot.getCalls() - tRCClassSnapshot2.getCalls());
                        }
                        tRCClass.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 9);
                        tRCClass2.computeDelta((IDelta)ClassInstanceStatistic.this.class2Delta, 9);
                        return this._sortSequence * (ClassInstanceStatistic.this.class1Delta.getCalls() - ClassInstanceStatistic.this.class2Delta.getCalls());
                    }
                    case 12: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (tRCClassSnapshot.getInheritedCalls() - tRCClassSnapshot2.getInheritedCalls());
                        }
                        tRCClass.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 10);
                        tRCClass2.computeDelta((IDelta)ClassInstanceStatistic.this.class2Delta, 10);
                        return this._sortSequence * (ClassInstanceStatistic.this.class1Delta.getInheritedCalls() - ClassInstanceStatistic.this.class2Delta.getInheritedCalls());
                    }
                }
            } else {
                if (!(object instanceof TRCFullTraceObject) || !(object2 instanceof TRCFullTraceObject)) {
                    return 0;
                }
                TRCFullTraceObject tRCFullTraceObject = (TRCFullTraceObject)object;
                TRCFullTraceObject tRCFullTraceObject2 = (TRCFullTraceObject)object2;
                switch (this._pos) {
                    case 0: {
                        return this._sortSequence * (int)(tRCFullTraceObject.getId() - tRCFullTraceObject2.getId());
                    }
                    case 1: {
                        return 0;
                    }
                    case 2: {
                        return 0;
                    }
                    case 3: {
                        int n = tRCFullTraceObject.getCollectTime() == 0.0 ? 1 : 0;
                        int n2 = tRCFullTraceObject2.getCollectTime() == 0.0 ? 1 : 0;
                        return this._sortSequence * (n - n2);
                    }
                    case 4: {
                        int n = tRCFullTraceObject.getCollectTime() == 0.0 ? 0 : 1;
                        int n3 = tRCFullTraceObject2.getCollectTime() == 0.0 ? 0 : 1;
                        return this._sortSequence * (n - n3);
                    }
                    case 5: {
                        return this._sortSequence * (tRCFullTraceObject.getSize() - tRCFullTraceObject2.getSize());
                    }
                    case 6: {
                        int n = tRCFullTraceObject.getCollectTime() == 0.0 ? tRCFullTraceObject.getSize() : 0;
                        int n4 = tRCFullTraceObject2.getCollectTime() == 0.0 ? tRCFullTraceObject2.getSize() : 0;
                        return this._sortSequence * (n - n4);
                    }
                    case 7: {
                        d = tRCFullTraceObject.getBaseTime() - tRCFullTraceObject2.getBaseTime();
                        if (d < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                    case 9: {
                        d = tRCFullTraceObject.getCumulativeTime() - tRCFullTraceObject2.getCumulativeTime();
                        if (d < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                    case 11: {
                        return this._sortSequence * (tRCFullTraceObject.getCalls() - tRCFullTraceObject2.getCalls());
                    }
                }
            }
            return 0;
        }
    }

    public class ClassStatisticFilter
    extends StatisticView.StatisticFilter {
        public ClassStatisticFilter() {
            super(ClassInstanceStatistic.this);
        }

        public boolean select(Viewer viewer, Object object, Object object2) {
            boolean bl = true;
            if (!(object2 instanceof TRCClass)) {
                return true;
            }
            String string = "";
            if (this._noPattern) {
                return true;
            }
            if (object2 instanceof TRCClass) {
                string = ((TRCClass)object2).getName();
            }
            if (!this._caseSensitive) {
                string = string.toLowerCase();
            }
            if (this._exactMatch) {
                return string.compareTo(this._prefix) == 0;
            }
            if (this._prefix != "") {
                bl = string.startsWith(this._prefix);
            }
            if (bl && this._suffix != "") {
                bl = string.endsWith(this._suffix);
            }
            if (bl) {
                int n = 0;
                while (n < this._textList.size()) {
                    String string2 = (String)this._textList.get(n);
                    int n2 = string.lastIndexOf(string2);
                    if (n2 == -1) {
                        bl = false;
                        break;
                    }
                    string = string.substring(n2 + string2.length());
                    ++n;
                }
            }
            return bl;
        }
    }
}

