/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCTraceObject;
import org.eclipse.hyades.trace.ui.ITraceSelection;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.hyades.trace.views.internal.GraphDrawStrategy;
import org.eclipse.hyades.trace.views.internal.JCanvas;
import org.eclipse.hyades.trace.views.internal.Pattern;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.LinearPattern;
import org.eclipse.hyades.trace.views.util.internal.PerftraceUtil;
import org.eclipse.hyades.trace.views.util.internal.SpectrumColorMap;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.help.WorkbenchHelp;

public class PatternDrawStrategy
extends GraphDrawStrategy {
    protected ArrayList _visibleThreads = new ArrayList();
    protected ArrayList _popupThreads = new ArrayList();
    protected Object[] _tmpArray;
    private final int NRLABELS = 10;
    private final float MAG_STEP = 2.0f;
    private Pattern _parent;
    protected int _maxdepth = 0;
    protected long _maxtime = 0L;
    private float timescale = 0.1f;
    private boolean _hidedetails = true;
    protected boolean _collectedempty = false;
    private boolean _drawgc = false;
    private int _drawMode = TraceUIPlugin.getDefault().getPreferenceStore().getInt("time_display");
    private Hashtable _foldedInvocations;
    protected float _canvasVisibleBottom;
    protected float _canvasVisibleTop;
    protected float _canvasVisibleLeft;
    protected float _canvasVisibleRight;
    protected static final int MAXINV = 256;
    protected TRCMethodInvocation[] _drawArray = new TRCMethodInvocation[256];
    protected float[] _x = new float[256];
    protected float[] _y = new float[256];
    protected float[] _w = new float[256];
    protected float[] _h = new float[256];
    private DetectAllRepetitionsdAction rep1;
    private HideAllRepetitionsAction rep2;
    private ShowAllThreadsAction _showAll;
    private HideAllThreadsAction _hideAll;
    private ThreadAction _gcThread;

    public PatternDrawStrategy(Pattern pattern) {
        this._parent = pattern;
        this.setNonPropZoom(true);
        this._foldedInvocations = new Hashtable();
        Object[] objectArray = PerftraceUtil.getAllThreads(this._parent.getPage().getMOFObject());
        int n = 0;
        while (n < objectArray.length) {
            this._visibleThreads.add(objectArray[n]);
            ++n;
        }
        this.rep1 = new DetectAllRepetitionsdAction(TraceUIPlugin.getString("STR_DETECT_REP"));
        this.rep2 = new HideAllRepetitionsAction(TraceUIPlugin.getString("STR_HIDE_REP"));
        this._showAll = new ShowAllThreadsAction(TraceUIPlugin.getString("STR_SHOW_THREADS"));
        this._hideAll = new HideAllThreadsAction(TraceUIPlugin.getString("STR_HIDE_THREADS"));
        this._gcThread = new ThreadAction();
        this._gcThread.setName(TraceUIPlugin.getString("STR_GC"));
    }

    public void bgRedraw(GC gC) {
        JCanvas jCanvas = this.jcanvas();
        if (jCanvas == null) {
            return;
        }
        int n = 0;
        while (n < this._visibleThreads.size()) {
            TRCThread tRCThread = (TRCThread)this._visibleThreads.get(n);
            float f = n * this.treeWidth() + this.gcWidth();
            if (f + (float)this.treeWidth() > jCanvas.visibleLeft() && f < jCanvas.visibleRight()) {
                this.drawThread(gC, tRCThread, f, 0.0f);
            }
            ++n;
        }
        this._hidedetails = false;
        if (this._drawgc) {
            this.drawGC(gC, 0, 0);
        }
        int n2 = 0;
        while (n2 < this._visibleThreads.size()) {
            TRCThread tRCThread = (TRCThread)this._visibleThreads.get(n2);
            float f = n2 * this.treeWidth() + this.gcWidth();
            if (f + (float)this.treeWidth() > jCanvas.visibleLeft() && f < jCanvas.visibleRight()) {
                this.drawThread(gC, tRCThread, f, 0.0f);
            }
            ++n2;
        }
        this.drawTimeMarks(gC, 0, 0);
    }

    protected int cellHeight() {
        return 20;
    }

    protected int cellWidth() {
        return 20;
    }

    protected void detectLinearPatterns() {
        int n = 0;
        while (n < this._visibleThreads.size()) {
            TRCThread tRCThread = (TRCThread)this._visibleThreads.get(n);
            Object[] objectArray = tRCThread.getInitialInvocations().toArray();
            int n2 = 0;
            while (n2 < objectArray.length) {
                this.detectLinearPatterns((TRCMethodInvocation)objectArray[n2]);
                ++n2;
            }
            ++n;
        }
    }

    protected void detectLinearPatterns(TRCMethodInvocation tRCMethodInvocation) {
        int n;
        Object[] objectArray = tRCMethodInvocation.getInvokes().toArray();
        int n2 = objectArray.length;
        LinearPattern linearPattern = null;
        if (n2 > 2) {
            linearPattern = new LinearPattern();
            n = 0;
            while (n < n2) {
                linearPattern.add(((TRCMethodInvocation)objectArray[n]).getMethod());
                ++n;
            }
        } else {
            int n3 = 0;
            while (n3 < n2) {
                this.detectLinearPatterns((TRCMethodInvocation)objectArray[n3]);
                ++n3;
            }
            return;
        }
        linearPattern.compute();
        if (linearPattern.hasRepetition()) {
            this._foldedInvocations.put(tRCMethodInvocation, linearPattern);
        }
        n = 0;
        while (n < n2) {
            TRCMethodInvocation tRCMethodInvocation2 = (TRCMethodInvocation)objectArray[n];
            int n4 = linearPattern.repetition(n);
            if (n4 == 1) {
                this.detectLinearPatterns(tRCMethodInvocation2);
            } else {
                int n5 = linearPattern.length(n);
                if (n4 == 0 || n5 == 0) {
                    System.err.println("linpattern impossible (fanout :" + n2 + ")");
                } else {
                    n += n5 * n4 - 1;
                }
            }
            ++n;
        }
    }

    void drawExtension(GC gC, TRCMethodInvocation tRCMethodInvocation, float f, float f2, float f3, float f4) {
        JCanvas jCanvas = this.jcanvas();
        if (jCanvas == null) {
            return;
        }
        String string = tRCMethodInvocation.getMethod().getDefiningClass().getName();
        Color color = SpectrumColorMap.color(string);
        if ((double)(jCanvas.xscale() * f3) > 20.0) {
            jCanvas.fillRect(gC, f + 3.0f * f3 / 4.0f, f2, f3 / 4.0f, f4, color);
        } else {
            jCanvas.fillRect(gC, f + f3 * 7.0f / 8.0f, f2, f3 / 8.0f, f4, color);
        }
    }

    protected void drawGC(GC gC, int n, int n2) {
        JCanvas jCanvas = this.jcanvas();
        if (this.isDirty() || jCanvas == null || (float)(n + this.gcWidth()) < jCanvas.visibleLeft()) {
            return;
        }
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        float f = jCanvas.yscale();
        float f2 = 0.0f;
        this._canvasVisibleBottom = jCanvas.visibleBottom();
        this._canvasVisibleTop = jCanvas.visibleTop();
        ITraceSelection iTraceSelection = UIPlugin.getDefault().getSelectionModel(this._parent.getPage().getMOFObject());
        Object[] objectArray = PerftraceUtil.getAllClasses(this._parent.getPage().getMOFObject());
        int n3 = 0;
        while (n3 < objectArray.length) {
            TRCClass tRCClass = (TRCClass)objectArray[n3];
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(tRCClass.getObjects());
            arrayList.addAll(tRCClass.getClassObjects());
            int n4 = 0;
            while (n4 < arrayList.size()) {
                TRCFullTraceObject tRCFullTraceObject;
                float f3;
                if (arrayList.get(n4) instanceof TRCFullTraceObject && (f3 = (float)TString.getTime((double)(tRCFullTraceObject = (TRCFullTraceObject)arrayList.get(n4)).getCollectTime()) * this.timescale + (float)this.titleMargin()) != 0.0f) {
                    if (this.isDirty()) {
                        return;
                    }
                    if (f3 > this._canvasVisibleBottom) break;
                    if (!(f3 < this._canvasVisibleTop)) {
                        if (iTraceSelection.contains((Object)tRCFullTraceObject)) {
                            jCanvas.fill3DRect(gC, n, (float)n2 + f3, this.gcWidth(), this.cellHeight() * 2, SpectrumColorMap.getSelectionColor());
                        }
                        if (!((f3 - f2) * f < 1.0f)) {
                            TRCClass tRCClass2 = PerftraceUtil.getClass((TRCObject)tRCFullTraceObject);
                            f2 = f3;
                            Color color = SpectrumColorMap.color(tRCClass2.toString());
                            jCanvas.fillRect(gC, n, (float)n2 + f3, this.cellWidth() * 5, this.cellHeight() * 2, color);
                        }
                    }
                }
                ++n4;
            }
            ++n3;
        }
        float f4 = (float)gC.getFontMetrics().getHeight() / jCanvas.yscale();
        jCanvas.drawString(gC, TraceUIPlugin.getString("STR_GC"), n, jCanvas.visibleTop() + f4, display.getSystemColor(9));
    }

    void drawInvocation(GC gC, TRCMethodInvocation tRCMethodInvocation, float f, float f2, float f3, float f4, boolean bl, boolean bl2) {
        JCanvas jCanvas = this.jcanvas();
        if (jCanvas == null) {
            return;
        }
        String string = tRCMethodInvocation.getMethod().getName();
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        Color color = display.getSystemColor(2);
        if ((tRCMethodInvocation.getMethod().getModifier() & 0x80) != 0) {
            color = display.getSystemColor(3);
        }
        double d = 0.0;
        TRCTraceObject tRCTraceObject = tRCMethodInvocation.getOwningObject();
        if (tRCTraceObject instanceof TRCFullTraceObject) {
            d = ((TRCFullTraceObject)tRCTraceObject).getCollectTime();
        }
        TRCClass tRCClass = PerftraceUtil.getClass(tRCMethodInvocation);
        String string2 = tRCClass.getName();
        Color color2 = SpectrumColorMap.color(string2);
        float f5 = jCanvas.xscale();
        if (bl && (double)f5 > 0.5 && !this._hidedetails) {
            int n = (int)(f3 * f5 / 5.0f);
            if (string.length() > n) {
                string = string.substring(0, n);
            }
            float f6 = (float)gC.getFontMetrics().getHeight() / jCanvas.yscale();
            jCanvas.drawString(gC, string, f, f2 + f6, color);
        }
        if ((double)(f5 * f3) > 20.0) {
            jCanvas.drawLine(gC, f, f2, f + 3.0f * f3 / 4.0f, f2, color);
            if (!this._collectedempty) {
                jCanvas.fillRect(gC, f + 3.0f * f3 / 4.0f, f2, f3 / 4.0f, f4, color2);
            } else if (d > 0.0) {
                jCanvas.drawRect(gC, f + 3.0f * f3 / 4.0f, f2, f3 / 4.0f, f4, color2);
            } else {
                jCanvas.fillRect(gC, f + 3.0f * f3 / 4.0f, f2, f3 / 4.0f, f4, color2);
            }
        } else {
            jCanvas.fillRect(gC, f + f3 / 4.0f, f2, f3 * 3.0f / 4.0f, f4, color2);
        }
    }

    void drawRepetition(GC gC, TRCMethodInvocation tRCMethodInvocation, int n, float f, float f2, int n2, LinearPattern linearPattern) {
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        JCanvas jCanvas = this.jcanvas();
        if (jCanvas == null || !(tRCMethodInvocation instanceof TRCFullMethodInvocation)) {
            return;
        }
        TRCFullMethodInvocation tRCFullMethodInvocation = (TRCFullMethodInvocation)tRCMethodInvocation;
        double d = tRCFullMethodInvocation.getOwningObject().getProcess().getLastEventTime();
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        float f8 = jCanvas.yscale();
        int n3 = linearPattern.repetition(n2);
        int n4 = linearPattern.length(n2);
        double d2 = ((TRCFullMethodInvocation)((TRCMethodInvocation)tRCFullMethodInvocation.getInvokes().get(n2))).getEntryTime();
        if (d2 == 0.0) {
            d2 = d;
        }
        float f9 = (float)PerftraceUtil.getTime(d2) * this.timescale + f2;
        d2 = ((TRCFullMethodInvocation)((TRCMethodInvocation)tRCFullMethodInvocation.getInvokes().get(n2 + n3 * n4 - 1))).getExitTime();
        if (d2 == 0.0) {
            d2 = d;
        }
        if ((f7 = (float)PerftraceUtil.getTime(d2) * this.timescale + f2) < f9) {
            f7 = (float)PerftraceUtil.getTime(((TRCFullMethodInvocation)((TRCMethodInvocation)tRCFullMethodInvocation.getInvokes().get(n2 + n3 * n4 - 1))).getEntryTime()) * this.timescale + f2;
        }
        float f10 = f7 - f9;
        jCanvas.fill3DRect(gC, f + (float)((4 * n + 4) * this.cellWidth()), f9, 8 * this.cellWidth(), f10, display.getSystemColor(15));
        jCanvas.fill3DRect(gC, f + (float)((4 * n + 6) * this.cellWidth()), f9 + f10 / 40.0f, 5.5f * (float)this.cellWidth(), f10 * 0.95f, display.getSystemColor(15));
        if (f10 * f8 < 5.0f) {
            return;
        }
        jCanvas.drawLine(gC, f + (float)((4 * n + 5) * this.cellWidth()) + 5.0f, f9, f + (float)((4 * n + 6) * this.cellWidth()), f9 + f10 / 40.0f, display.getSystemColor(15));
        d2 = ((TRCFullMethodInvocation)((TRCMethodInvocation)tRCFullMethodInvocation.getInvokes().get(n2 + n4 - 1))).getExitTime();
        if (d2 == 0.0) {
            d2 = d;
        }
        if ((f6 = (float)PerftraceUtil.getTime(d2) * this.timescale + f2) < f9) {
            f6 = f9;
        }
        jCanvas.drawLine(gC, f + (float)((4 * n + 5) * this.cellWidth()) + 5.0f, f6, f + (float)((4 * n + 6) * this.cellWidth()), f9 + f10 * 0.975f, display.getSystemColor(15));
        if (n3 < 1000) {
            int n5 = 0;
            while (n5 < n3) {
                f5 = (float)PerftraceUtil.getTime(((TRCFullMethodInvocation)((TRCMethodInvocation)tRCFullMethodInvocation.getInvokes().get(n2 + n5 * n4))).getEntryTime()) * this.timescale + f2;
                d2 = ((TRCFullMethodInvocation)((TRCMethodInvocation)tRCFullMethodInvocation.getInvokes().get(n2 + n5 * n4 + n4 - 1))).getExitTime();
                if (d2 == 0.0) {
                    d2 = d;
                }
                if ((f4 = (float)PerftraceUtil.getTime(d2) * this.timescale + f2 - f5) < 0.0f) {
                    f4 = 0.0f;
                }
                jCanvas.fill3DRect(gC, f + (float)((4 * n + 4) * this.cellWidth()) + 5.0f, f5, this.cellWidth(), f4, display.getSystemColor(15));
                ++n5;
            }
        }
        if ((d2 = ((TRCFullMethodInvocation)((TRCMethodInvocation)tRCFullMethodInvocation.getInvokes().get(n2 + n4 - 1))).getExitTime()) == 0.0) {
            d2 = d;
        }
        if ((f5 = (f3 = (float)PerftraceUtil.getTime(d2) * this.timescale + f2) - f9) < 0.0f) {
            f5 = 0.0f;
        }
        f4 = 1.0f;
        if (f5 > 0.0f) {
            f4 = (f7 - f9) / f5 * 0.9f;
        }
        int n6 = 0;
        while (n6 < n4) {
            TRCFullMethodInvocation tRCFullMethodInvocation2 = (TRCFullMethodInvocation)((TRCMethodInvocation)tRCFullMethodInvocation.getInvokes().get(n2 + n6));
            float f11 = (float)PerftraceUtil.getTime(tRCFullMethodInvocation2.getEntryTime()) * this.timescale + f2;
            d2 = tRCFullMethodInvocation2.getExitTime();
            if (d2 == 0.0) {
                d2 = d;
            }
            float f12 = (float)PerftraceUtil.getTime(d2) * this.timescale + f2;
            float f13 = f12 - f11;
            float f14 = f9 + (f11 - f9) * f4 + f10 / 20.0f;
            float f15 = f13 * f4;
            this.drawInvocation(gC, (TRCMethodInvocation)tRCFullMethodInvocation2, f + (float)((4 * n + 7) * this.cellWidth()), f14, this.cellWidth() * 4, f15, true, false);
            ++n6;
        }
        jCanvas.drawString(gC, " X " + Integer.toString(n3), f + (float)((4 * n + 6) * this.cellWidth()), f9 + f10 * 0.97f, display.getSystemColor(2));
    }

    protected void drawThread(GC gC, TRCThread tRCThread, float f, float f2) {
        JCanvas jCanvas = this.jcanvas();
        if (jCanvas == null) {
            return;
        }
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        float f3 = (float)gC.getFontMetrics().getHeight() / jCanvas.yscale();
        jCanvas.drawLine(gC, f, jCanvas.visibleTop(), f, jCanvas.visibleBottom(), display.getSystemColor(2));
        jCanvas.drawString(gC, PerftraceUtil.getThreadName(tRCThread), f, jCanvas.visibleTop() + f3, display.getSystemColor(9));
        this._canvasVisibleBottom = jCanvas.visibleBottom();
        this._canvasVisibleTop = jCanvas.visibleTop();
        this._canvasVisibleLeft = jCanvas.visibleLeft();
        this._canvasVisibleRight = jCanvas.visibleRight();
        this.initDrawArray();
        Object[] objectArray = tRCThread.getInitialInvocations().toArray();
        int n = 0;
        while (n < objectArray.length) {
            this.drawTree(gC, (TRCMethodInvocation)tRCThread.getInitialInvocations().get(n), 0, f, f2 + (float)this.titleMargin());
            ++n;
        }
        this.flushDrawArray(gC);
    }

    protected void drawTimeMarks(GC gC, int n, int n2) {
        JCanvas jCanvas = this.jcanvas();
        if (this.isDirty() || jCanvas == null) {
            return;
        }
        float f = 50.0f / jCanvas.xscale();
        float f2 = jCanvas.visibleRight();
        long l = (long)((jCanvas.visibleTop() - (float)this.titleMargin()) / this.timescale);
        long l2 = (long)(jCanvas.visibleHeight() / this.timescale);
        long l3 = l2 / 10L;
        float f3 = f2 - f;
        float f4 = (float)gC.getFontMetrics().getHeight() / jCanvas.yscale();
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        if (this._visibleThreads.size() == 0 && this._parent.getPage().isEmpty()) {
            jCanvas.drawString(gC, TraceUIPlugin.getString("EXEC_STAT_INFO"), n, jCanvas.visibleTop() + f4, Display.getDefault().getSystemColor(2), Display.getDefault().getSystemColor(1));
            return;
        }
        if (l3 > 1L) {
            long l4 = (long)Math.pow(10.0, (int)(Math.log(l3) / Math.log(10.0)) + 1) / 2L;
            long l5 = l4 * (l / l4 + 1L);
            int n3 = 0;
            while (n3 < 20) {
                long l6 = l5 + (long)n3 * l4;
                float f5 = (float)l6 * this.timescale + (float)this.titleMargin();
                jCanvas.drawString(gC, PerftraceUtil.formatTimeValue((double)l6 / 1000000.0), (float)n + f3, (float)n2 + f5, display.getSystemColor(2), display.getSystemColor(1));
                ++n3;
            }
        }
        jCanvas.drawString(gC, TraceUIPlugin.getString("STR_GRAPH_UNIT"), (float)n + f3 - 20.0f, jCanvas.visibleTop() + f4, display.getSystemColor(2), display.getSystemColor(1));
    }

    protected void drawTree(GC gC, TRCMethodInvocation tRCMethodInvocation, int n, float f, float f2) {
        JCanvas jCanvas = this.jcanvas();
        if (tRCMethodInvocation == null || !(tRCMethodInvocation instanceof TRCFullMethodInvocation) || this.isDirty() || jCanvas == null) {
            return;
        }
        TRCFullMethodInvocation tRCFullMethodInvocation = (TRCFullMethodInvocation)tRCMethodInvocation;
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        long l = PerftraceUtil.getTime(tRCFullMethodInvocation.getEntryTime());
        long l2 = PerftraceUtil.getTime(tRCFullMethodInvocation.getExitTime());
        if (l2 <= 0L) {
            l2 = this._maxtime;
        }
        if (f2 + (float)l * this.timescale > this._canvasVisibleBottom || f2 + (float)l2 * this.timescale < this._canvasVisibleTop) {
            return;
        }
        if (n > this._maxdepth) {
            this._maxdepth = n;
        }
        float f3 = (float)(l2 - l) * this.timescale;
        if (this._hidedetails && jCanvas.yscale() * f3 < 10.0f) {
            return;
        }
        boolean bl = false;
        ITraceSelection iTraceSelection = UIPlugin.getDefault().getSelectionModel(this._parent.getPage().getMOFObject());
        if (iTraceSelection.contains((Object)tRCFullMethodInvocation) || iTraceSelection.contains((Object)tRCFullMethodInvocation.getMethod())) {
            jCanvas.fill3DRect(gC, f + (float)(4 * n * this.cellWidth()), f2 + (float)l * this.timescale, this.treeWidth() - 4 * n * this.cellWidth(), f3, SpectrumColorMap.getSelectionColor());
            bl = true;
        } else if (iTraceSelection.contains((Object)tRCFullMethodInvocation.getOwningObject())) {
            jCanvas.fill3DRect(gC, f + (float)((4 * n + 3) * this.cellWidth()) - 5.0f, f2 + (float)l * this.timescale, (float)(this.treeWidth() - (4 * n + 3) * this.cellWidth()) + 5.0f, f3, SpectrumColorMap.getSelectionColor());
            bl = true;
        }
        if (f + (float)((n + 1) * this.cellWidth() * 4) < this._canvasVisibleRight) {
            Object[] objectArray = tRCFullMethodInvocation.getInvokes().toArray();
            LinearPattern linearPattern = this.linearPattern((TRCMethodInvocation)tRCFullMethodInvocation);
            int n2 = 0;
            while (n2 < objectArray.length) {
                TRCMethodInvocation tRCMethodInvocation2 = (TRCMethodInvocation)objectArray[n2];
                if (tRCMethodInvocation2 instanceof TRCFullMethodInvocation) {
                    int n3;
                    TRCFullMethodInvocation tRCFullMethodInvocation2 = (TRCFullMethodInvocation)tRCMethodInvocation2;
                    if (linearPattern == null || (n3 = linearPattern.repetition(n2)) == 1) {
                        if ((float)PerftraceUtil.getTime(tRCFullMethodInvocation2.getEntryTime()) * this.timescale + f2 > this._canvasVisibleBottom) break;
                        long l3 = PerftraceUtil.getTime(tRCFullMethodInvocation2.getExitTime());
                        if (l3 <= 0L) {
                            l3 = this._maxtime;
                        }
                        if (!((float)l3 * this.timescale + f2 < this._canvasVisibleTop)) {
                            this.drawTree(gC, (TRCMethodInvocation)tRCFullMethodInvocation2, n + 1, f, f2);
                        }
                    } else if (!this._hidedetails) {
                        int n4 = linearPattern.length(n2);
                        if (n3 == 0 || n4 == 0) {
                            System.err.println("linpattern impossible (fanout :" + objectArray.length + ")");
                        } else {
                            this.drawRepetition(gC, (TRCMethodInvocation)tRCFullMethodInvocation, n, f, f2, n2, linearPattern);
                            n2 += n4 * n3 - 1;
                        }
                    }
                }
                ++n2;
            }
        }
        if (n < 256) {
            this.push(gC, n, (TRCMethodInvocation)tRCFullMethodInvocation, f + (float)(n * this.cellWidth() * 4), f2 + (float)l * this.timescale, this.cellWidth() * 4, f3);
        } else {
            this.drawInvocation(gC, (TRCMethodInvocation)tRCFullMethodInvocation, f + (float)(n * this.cellWidth() * 4), f2 + (float)l * this.timescale, this.cellWidth() * 4, f3, true, !bl && UIPlugin.getDefault().getSelectionModel(this._parent.getPage().getMOFObject()).size() > 1);
        }
        this.extendToCanvas((TRCMethodInvocation)tRCFullMethodInvocation);
    }

    private void extendToCanvas(TRCMethodInvocation tRCMethodInvocation) {
        TRCThread tRCThread = tRCMethodInvocation.getMethod().getDefiningClass().getLoadedBy();
        if (tRCThread == null || !(tRCMethodInvocation instanceof TRCFullMethodInvocation)) {
            return;
        }
        TRCFullMethodInvocation tRCFullMethodInvocation = (TRCFullMethodInvocation)tRCMethodInvocation;
        int n = this._visibleThreads.indexOf(tRCThread);
        long l = PerftraceUtil.getTime(tRCFullMethodInvocation.getEntryTime());
        long l2 = PerftraceUtil.getTime(tRCFullMethodInvocation.getExitTime());
        float f = (float)l * this.timescale + (float)this.titleMargin();
        float f2 = (float)(this.treeWidth() * n + this.gcWidth()) + 1.0f;
        float f3 = f;
        Object object = tRCFullMethodInvocation;
        int n2 = -1;
        while (object != null) {
            ++n2;
            object = object.getInvokedBy() != null ? object.getInvokedBy() : null;
        }
        f2 = Math.max(f2, (float)(this.treeWidth() * n + this.gcWidth() + (n2 + 1) * this.cellWidth() * 4));
        this.jcanvas().extendedTo(f2, f3);
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        ThreadAction threadAction;
        iMenuManager.add((IContributionItem)this.fSeparator);
        iMenuManager.add((IAction)this.rep1);
        iMenuManager.add((IAction)this.rep2);
        iMenuManager.add((IContributionItem)this.fSeparator);
        MenuManager menuManager = new MenuManager(TraceUIPlugin.getString("STR_THREADS"));
        iMenuManager.add((IContributionItem)menuManager);
        menuManager.add((IAction)this._showAll);
        menuManager.add((IAction)this._hideAll);
        menuManager.add((IContributionItem)this.fSeparator);
        this._gcThread.setText(this._gcThread.getName());
        this._gcThread.setChecked(this._drawgc);
        menuManager.add((IAction)this._gcThread);
        Object[] objectArray = PerftraceUtil.getAllThreads(this._parent.getPage().getMOFObject());
        int n = 0;
        while (n < objectArray.length) {
            TRCThread tRCThread = (TRCThread)objectArray[n];
            if (!this.hasThread(tRCThread)) {
                threadAction = new ThreadAction();
                threadAction.setThread(tRCThread);
                this._popupThreads.add(threadAction);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this._popupThreads.size()) {
            threadAction = (ThreadAction)((Object)this._popupThreads.get(n2));
            threadAction.setText(threadAction.getName());
            threadAction.setChecked(this._visibleThreads.contains(threadAction.getThread()));
            menuManager.add((IAction)threadAction);
            ++n2;
        }
        iMenuManager.add((IContributionItem)this.fSeparator);
        iMenuManager.add((IContributionItem)this.fSeparator);
        super.fillContextMenu(iMenuManager);
    }

    protected void flushDrawArray(GC gC) {
        ITraceSelection iTraceSelection = UIPlugin.getDefault().getSelectionModel(this._parent.getPage().getMOFObject());
        int n = 0;
        while (n < 256) {
            if (this._drawArray[n] != null) {
                this.drawInvocation(gC, this._drawArray[n], this._x[n], this._y[n], this._w[n], this._h[n], true, iTraceSelection.size() > 1 && !iTraceSelection.contains((Object)this._drawArray[n].getOwningObject()) && !iTraceSelection.contains((Object)this._drawArray[n].getMethod()));
                this._drawArray[n] = null;
            }
            ++n;
        }
    }

    protected int gcWidth() {
        return this._drawgc ? 300 : 100;
    }

    protected boolean hasThread(TRCThread tRCThread) {
        int n = 0;
        while (n < this._popupThreads.size()) {
            ThreadAction threadAction = (ThreadAction)((Object)this._popupThreads.get(n));
            if (threadAction.getThread() == tRCThread) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public float height() {
        this._maxtime = PerftraceUtil.getTime(PerftraceUtil.getMaximumTime(this._parent.getPage().getMOFObject()));
        return (float)this._maxtime * this.timescale + (float)this.titleMargin() + (float)(10 * this.cellHeight());
    }

    protected void initDrawArray() {
        int n = 0;
        while (n < 256) {
            this._drawArray[n] = null;
            this._h[n] = 0.0f;
            this._w[n] = 0.0f;
            this._y[n] = 0.0f;
            this._x[n] = 0.0f;
            ++n;
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        JCanvas jCanvas = this.jcanvas();
        if (jCanvas == null) {
            return;
        }
        if (keyEvent.keyCode == 262144) {
            this._controlDown = true;
        } else if (keyEvent.keyCode == 0x1000007) {
            jCanvas.zoomToFit();
        } else {
            float f = jCanvas.normX(jCanvas.getSize().width / 2);
            float f2 = jCanvas.normY(jCanvas.getSize().height / 2);
            if (keyEvent.character == ',' || keyEvent.character == '<') {
                jCanvas.zoom(1.0f, 0.5f, f, f2);
            } else if (keyEvent.character == '.' || keyEvent.character == '>') {
                jCanvas.zoom(1.0f, 2.0f, f, f2);
            }
        }
    }

    protected LinearPattern linearPattern(TRCMethodInvocation tRCMethodInvocation) {
        return (LinearPattern)this._foldedInvocations.get(tRCMethodInvocation);
    }

    public void mouseDown(MouseEvent mouseEvent) {
        if (mouseEvent.button == 3) {
            return;
        }
        super.mouseDown(mouseEvent);
    }

    public void mouseUp(MouseEvent mouseEvent) {
        if (mouseEvent.button == 3) {
            return;
        }
        super.mouseUp(mouseEvent);
    }

    public void moved(float f, float f2) {
        if (f <= (float)this.gcWidth()) {
            Object[] objectArray = PerftraceUtil.getAllClasses(this._parent.getPage().getMOFObject());
            int n = 0;
            while (n < objectArray.length) {
                TRCClass tRCClass = (TRCClass)objectArray[n];
                ArrayList arrayList = new ArrayList();
                arrayList.addAll(tRCClass.getObjects());
                arrayList.addAll(tRCClass.getClassObjects());
                int n2 = 0;
                while (n2 < arrayList.size()) {
                    TRCFullTraceObject tRCFullTraceObject;
                    if (arrayList.get(n2) instanceof TRCFullTraceObject && (tRCFullTraceObject = (TRCFullTraceObject)arrayList.get(n2)).getCollectTime() != 0.0) {
                        float f3 = (float)TString.getTime((double)tRCFullTraceObject.getCollectTime()) * this.timescale + (float)this.titleMargin();
                        if (f2 >= f3) {
                            if (f2 <= f3 + (float)(this.cellHeight() * 2)) {
                                String string = TraceUIPlugin.getString("GC_ED_OBJECT");
                                string = TString.change((String)string, (String)"%1", (String)(PerftraceUtil.getClass((TRCObject)tRCFullTraceObject).getName() + "." + tRCFullTraceObject.getId()));
                                this.status(string);
                                return;
                            }
                        } else {
                            this.status(TraceUIPlugin.getString("STR_GC"));
                            return;
                        }
                    }
                    ++n2;
                }
                ++n;
            }
            this.status(TraceUIPlugin.getString("STR_GC"));
            return;
        }
        int n = (int)((f -= (float)this.gcWidth()) / (float)this.treeWidth());
        if (n < 0 || n >= this._visibleThreads.size()) {
            long l = (long)((f2 - (float)this.titleMargin()) / this.timescale);
            String string = TraceUIPlugin.getString("TIME_X");
            string = TString.change((String)string, (String)"%1", (String)String.valueOf(l));
            this.status(string);
            return;
        }
        TRCThread tRCThread = (TRCThread)this._visibleThreads.get(n);
        f %= (float)this.treeWidth();
        Object[] objectArray = tRCThread.getInitialInvocations().toArray();
        int n3 = 0;
        while (n3 < objectArray.length) {
            TRCMethodInvocation tRCMethodInvocation = this.subtreeContains((TRCMethodInvocation)objectArray[n3], f, f2, 0);
            if (tRCMethodInvocation != null && tRCMethodInvocation instanceof TRCFullMethodInvocation) {
                TRCFullMethodInvocation tRCFullMethodInvocation = (TRCFullMethodInvocation)tRCMethodInvocation;
                TRCTraceObject tRCTraceObject = tRCFullMethodInvocation.getOwningObject();
                String string = tRCFullMethodInvocation.getMethod().getDefiningClass().getName();
                String string2 = tRCFullMethodInvocation.getMethod().getName();
                String string3 = tRCTraceObject.getIsA().getName();
                double d = tRCFullMethodInvocation.getExitTime();
                if (d == 0.0) {
                    d = tRCTraceObject.getProcess().getLastEventTime();
                }
                String string4 = TraceUIPlugin.getString("THREAD_A_ON_B_AT_C_TIME");
                if (this._drawMode == 1) {
                    string4 = TraceUIPlugin.getString("THREAD_A_ON_B_AT_RAW_TIME");
                }
                string4 = TString.change((String)string4, (String)"%1", (String)(PerftraceUtil.getThreadName(tRCThread) + "   " + string + "." + string2));
                string4 = TString.change((String)string4, (String)"%2", (String)(string3 + "." + tRCTraceObject.getId()));
                string4 = TString.change((String)string4, (String)"%3", (String)TString.formatTimeValue((double)tRCFullMethodInvocation.getEntryTime()));
                string4 = TString.change((String)string4, (String)"%4", (String)TString.formatTimeValue((double)(d - tRCFullMethodInvocation.getEntryTime())));
                this.status(string4);
                return;
            }
            ++n3;
        }
        long l = (long)((f2 - (float)this.titleMargin()) / this.timescale);
        String string = TraceUIPlugin.getString("THREAD_A_TIME_X");
        string = TString.change((String)string, (String)"%1", (String)tRCThread.getName());
        string = TString.change((String)string, (String)"%2", (String)TString.formatTimeValue((double)((double)l / 1000000.0)));
        this.status(string);
    }

    protected void push(GC gC, int n, TRCMethodInvocation tRCMethodInvocation, float f, float f2, float f3, float f4) {
        JCanvas jCanvas = this.jcanvas();
        if (n >= 256 || jCanvas == null) {
            return;
        }
        if (this._drawArray[n] != null) {
            float f5 = jCanvas.yscale();
            float f6 = (f2 - this._y[n]) * f5;
            float f7 = (f2 + f4 - this._y[n]) * f5;
            if ((double)f7 < 1.0) {
                return;
            }
            this.drawInvocation(gC, this._drawArray[n], this._x[n], this._y[n], this._w[n], this._h[n], (double)f6 > 8.0, true);
        }
        this._drawArray[n] = tRCMethodInvocation;
        this._x[n] = f;
        this._y[n] = f2;
        this._w[n] = f3;
        this._h[n] = f4;
    }

    public void redraw() {
        this._visibleThreads.clear();
        Object[] objectArray = PerftraceUtil.getAllThreads(this._parent.getPage().getMOFObject());
        int n = 0;
        while (n < objectArray.length) {
            this._visibleThreads.add(objectArray[n]);
            ++n;
        }
        this.jcanvas().zoomToFill(1.0f, 1000.0f);
        this.jcanvas().redraw();
    }

    protected void removeLinearPatterns() {
        this._foldedInvocations.clear();
    }

    protected void removeLinearPatterns(TRCMethodInvocation tRCMethodInvocation) {
        this._foldedInvocations.remove(tRCMethodInvocation);
        Object[] objectArray = tRCMethodInvocation.getInvokes().toArray();
        int n = 0;
        while (n < objectArray.length) {
            this.removeLinearPatterns((TRCMethodInvocation)objectArray[n]);
            ++n;
        }
    }

    public void selected(float f, float f2, boolean bl, boolean bl2, boolean bl3) {
        ViewSelectionChangedEvent viewSelectionChangedEvent;
        ITraceSelection iTraceSelection = UIPlugin.getDefault().getSelectionModel(this._parent.getPage().getMOFObject());
        float f3 = f;
        float f4 = f2;
        if (f <= (float)this.gcWidth() && bl3) {
            return;
        }
        int n = (int)((f -= (float)this.gcWidth()) / (float)this.treeWidth());
        if (n < 0 || n >= this._visibleThreads.size()) {
            return;
        }
        TRCThread tRCThread = (TRCThread)this._visibleThreads.get(n);
        f %= (float)this.treeWidth();
        Object[] objectArray = tRCThread.getInitialInvocations().toArray();
        int n2 = 0;
        while (n2 < objectArray.length) {
            viewSelectionChangedEvent = this.subtreeContains((TRCMethodInvocation)objectArray[n2], f, f2, 0);
            iTraceSelection.add((Object)viewSelectionChangedEvent);
            ++n2;
        }
        viewSelectionChangedEvent = UIPlugin.getDefault().getViewSelectionChangedEvent();
        viewSelectionChangedEvent.setSource((Object)this._parent.getPage().getMOFObject());
        UIPlugin.getDefault().notifyViewSelectionChangedListener(viewSelectionChangedEvent);
    }

    public void shutdown() {
        this._parent = null;
        this._foldedInvocations.clear();
        this._hideAll = null;
        this._showAll = null;
        this.rep1 = null;
        this.rep2 = null;
        this._visibleThreads.clear();
        int n = 0;
        while (n < this._popupThreads.size()) {
            ((ThreadAction)((Object)this._popupThreads.get(n))).setThread(null);
            ++n;
        }
        this._popupThreads.clear();
        this._gcThread = null;
    }

    protected void status(String string) {
        this._parent.updateStatus(string);
    }

    protected TRCMethodInvocation subtreeContains(TRCMethodInvocation tRCMethodInvocation, float f, float f2, int n) {
        if (tRCMethodInvocation == null || !(tRCMethodInvocation instanceof TRCFullMethodInvocation)) {
            return null;
        }
        TRCFullMethodInvocation tRCFullMethodInvocation = (TRCFullMethodInvocation)tRCMethodInvocation;
        int n2 = (int)(f / (float)this.cellWidth() / 4.0f);
        if (n == n2) {
            return tRCFullMethodInvocation;
        }
        if (n > n2) {
            return null;
        }
        LinearPattern linearPattern = null;
        if (f / (float)this.cellWidth() > (float)((n + 1) * 4 + 2)) {
            linearPattern = this.linearPattern((TRCMethodInvocation)tRCFullMethodInvocation);
        }
        Object[] objectArray = tRCFullMethodInvocation.getInvokes().toArray();
        int n3 = 0;
        while (n3 < objectArray.length) {
            int n4;
            TRCFullMethodInvocation tRCFullMethodInvocation2 = (TRCFullMethodInvocation)objectArray[n3];
            if (f2 < (float)PerftraceUtil.getTime(tRCFullMethodInvocation2.getEntryTime()) * this.timescale + (float)this.titleMargin()) {
                return null;
            }
            if (linearPattern == null || (n4 = linearPattern.repetition(n3)) == 1) {
                if (tRCFullMethodInvocation2.getExitTime() == 0.0 || (float)PerftraceUtil.getTime(tRCFullMethodInvocation2.getExitTime()) * this.timescale + (float)this.titleMargin() >= f2) {
                    return this.subtreeContains((TRCMethodInvocation)tRCFullMethodInvocation2, f, f2, n + 1);
                }
            } else {
                int n5 = linearPattern.length(n3);
                if (n3 >= objectArray.length) {
                    return null;
                }
                float f3 = (float)PerftraceUtil.getTime(tRCFullMethodInvocation2.getEntryTime()) * this.timescale + (float)this.titleMargin();
                TRCFullMethodInvocation tRCFullMethodInvocation3 = (TRCFullMethodInvocation)objectArray[n3 + n4 * n5 - 1];
                float f4 = (float)PerftraceUtil.getTime(tRCFullMethodInvocation3.getExitTime()) * this.timescale + (float)this.titleMargin();
                if (f2 >= f3 && f2 <= f4) {
                    if (linearPattern != null && n4 > 1 && f / (float)this.cellWidth() > (float)((n + 1) * 4 + 7)) {
                        return null;
                    }
                    float f5 = f4 - f3;
                    TRCFullMethodInvocation tRCFullMethodInvocation4 = (TRCFullMethodInvocation)objectArray[n3 + n5 - 1];
                    float f6 = (float)PerftraceUtil.getTime(tRCFullMethodInvocation4.getExitTime()) * this.timescale + (float)this.titleMargin();
                    float f7 = f6 - f3;
                    if (f7 < 0.0f) {
                        f7 = 0.0f;
                    }
                    float f8 = 1.0f;
                    if (f7 > 0.0f) {
                        f8 = (f4 - f3) / f7 * 0.9f;
                    }
                    int n6 = 0;
                    while (n6 < n5) {
                        TRCFullMethodInvocation tRCFullMethodInvocation5 = (TRCFullMethodInvocation)objectArray[n3 + n6];
                        float f9 = (float)PerftraceUtil.getTime(tRCFullMethodInvocation5.getEntryTime()) * this.timescale + (float)this.titleMargin();
                        float f10 = (float)PerftraceUtil.getTime(tRCFullMethodInvocation5.getExitTime()) * this.timescale + (float)this.titleMargin();
                        float f11 = f10 - f9;
                        float f12 = f3 + (f9 - f3) * f8 + f5 / 20.0f;
                        float f13 = f11 * f8;
                        if (f2 < f12) {
                            return null;
                        }
                        if (f2 < f12 + f13) {
                            return tRCFullMethodInvocation5;
                        }
                        ++n6;
                    }
                }
                n3 += n5 * n4 - 1;
            }
            ++n3;
        }
        return null;
    }

    public String title() {
        return "";
    }

    protected int titleMargin() {
        return 0;
    }

    protected int treeWidth() {
        if (this._maxdepth == 0) {
            int n = 0;
            while (n < this._visibleThreads.size()) {
                TRCThread tRCThread = (TRCThread)this._visibleThreads.get(n);
                if (this._maxdepth < tRCThread.getMaxStackDepth()) {
                    this._maxdepth = tRCThread.getMaxStackDepth();
                }
                ++n;
            }
        }
        return this.cellWidth() * 4 * (10 + this._maxdepth / 10 * 10);
    }

    public float width() {
        float f = (float)(this.gcWidth() + this._visibleThreads.size() * this.treeWidth()) + 1.0f;
        return f;
    }

    public void setDrawMode(int n) {
        this._drawMode = n;
    }

    class ThreadAction
    extends Action {
        protected TRCThread _thread;
        protected String _name = "";

        public ThreadAction() {
            super("");
        }

        public void setThread(TRCThread tRCThread) {
            this._thread = tRCThread;
            if (this._thread != null) {
                this._name = PerftraceUtil.getThreadName(tRCThread);
            }
        }

        public void setName(String string) {
            this._name = string;
        }

        public TRCThread getThread() {
            return this._thread;
        }

        public String getName() {
            return this._name;
        }

        public void run() {
            if (PatternDrawStrategy.this.jcanvas() == null) {
                return;
            }
            if (this.getName().equals(TraceUIPlugin.getString("STR_GC"))) {
                PatternDrawStrategy.this._drawgc = !PatternDrawStrategy.this._drawgc;
            } else if (PatternDrawStrategy.this._visibleThreads.contains(this._thread)) {
                ((AbstractCollection)PatternDrawStrategy.this._visibleThreads).remove(this._thread);
            } else {
                PatternDrawStrategy.this._visibleThreads.add(this._thread);
            }
            PatternDrawStrategy.this._maxdepth = 0;
            PatternDrawStrategy.this._maxtime = 0L;
            PatternDrawStrategy.this.resetArea();
            PatternDrawStrategy.this.jcanvas().zoomToFill(1.0f, 1000.0f);
            PatternDrawStrategy.this.jcanvas().redraw();
        }
    }

    class ShowAllThreadsAction
    extends Action {
        public ShowAllThreadsAction(String string) {
            super(string);
            WorkbenchHelp.setHelp((IAction)this, (String)(TraceUIPlugin.getPluginId() + ".exef0006"));
        }

        public void run() {
            if (PatternDrawStrategy.this.jcanvas() == null) {
                return;
            }
            Object[] objectArray = PerftraceUtil.getAllThreads(PatternDrawStrategy.this._parent.getPage().getMOFObject());
            int n = 0;
            while (n < objectArray.length) {
                int n2 = 0;
                n2 = 0;
                while (n2 < PatternDrawStrategy.this._visibleThreads.size()) {
                    if (PatternDrawStrategy.this._visibleThreads.get(n2) == objectArray[n]) break;
                    ++n2;
                }
                if (n2 == PatternDrawStrategy.this._visibleThreads.size()) {
                    PatternDrawStrategy.this._visibleThreads.add(objectArray[n]);
                }
                ++n;
            }
            PatternDrawStrategy.this._maxdepth = 0;
            PatternDrawStrategy.this._drawgc = true;
            PatternDrawStrategy.this.resetArea();
            PatternDrawStrategy.this.jcanvas().zoomToFill(1.0f, 1000.0f);
            PatternDrawStrategy.this.jcanvas().redraw();
        }
    }

    class HideAllThreadsAction
    extends Action {
        public HideAllThreadsAction(String string) {
            super(string);
            WorkbenchHelp.setHelp((IAction)this, (String)(TraceUIPlugin.getPluginId() + ".exef0007"));
        }

        public void run() {
            if (PatternDrawStrategy.this.jcanvas() == null) {
                return;
            }
            PatternDrawStrategy.this._visibleThreads.clear();
            PatternDrawStrategy.this._drawgc = false;
            PatternDrawStrategy.this.jcanvas().zoomToFill(1.0f, 1000.0f);
            PatternDrawStrategy.this.jcanvas().redraw();
        }
    }

    class HideAllRepetitionsAction
    extends Action {
        public HideAllRepetitionsAction(String string) {
            super(string);
            WorkbenchHelp.setHelp((IAction)this, (String)(TraceUIPlugin.getPluginId() + ".exef0005"));
        }

        public void run() {
            if (PatternDrawStrategy.this.jcanvas() == null) {
                return;
            }
            PatternDrawStrategy.this.removeLinearPatterns();
            PatternDrawStrategy.this.jcanvas().redraw();
        }
    }

    class DetectAllRepetitionsdAction
    extends Action {
        public DetectAllRepetitionsdAction(String string) {
            super(string);
            WorkbenchHelp.setHelp((IAction)this, (String)(TraceUIPlugin.getPluginId() + ".exef0004"));
        }

        public void run() {
            if (PatternDrawStrategy.this.jcanvas() == null) {
                return;
            }
            PatternDrawStrategy.this.detectLinearPatterns();
            PatternDrawStrategy.this.jcanvas().redraw();
        }
    }
}

