/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.internal.ui;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.models.hierarchy.util.IUnresolvedResourceHelper;
import org.eclipse.hyades.models.hierarchy.util.SaveUtil;
import org.eclipse.hyades.trace.internal.ui.PDContentProvider;
import org.eclipse.hyades.trace.internal.ui.PDLabelProvider;
import org.eclipse.hyades.trace.internal.ui.PDProjectViewer;
import org.eclipse.hyades.trace.ui.IProfileEventListener;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.actions.DeleteAction;
import org.eclipse.hyades.trace.ui.internal.actions.OpenWizardAction;
import org.eclipse.hyades.trace.ui.internal.actions.RefreshFromLocalAction;
import org.eclipse.hyades.trace.ui.internal.actions.RefreshTreeAction;
import org.eclipse.hyades.trace.ui.internal.actions.SaveAction;
import org.eclipse.hyades.trace.ui.internal.actions.StartTraceAction;
import org.eclipse.hyades.trace.ui.internal.actions.StopTraceAction;
import org.eclipse.hyades.trace.ui.internal.core.TraceAssociationManager;
import org.eclipse.hyades.trace.ui.internal.launcher.AttachTraceAction;
import org.eclipse.hyades.trace.ui.internal.launcher.LaunchTraceAction;
import org.eclipse.hyades.trace.ui.internal.launcher.RelaunchTraceAction;
import org.eclipse.hyades.trace.ui.internal.util.UnresolvedResourceHelper;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.extension.IAssociationMapping;
import org.eclipse.hyades.ui.extension.IAssociationMappingRegistry;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.ExportResourcesAction;
import org.eclipse.ui.actions.ImportResourcesAction;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.part.ViewPart;

public class PDProjectExplorer
extends ViewPart
implements IMenuListener,
IProfileEventListener,
IPropertyListener {
    private PDProjectViewer fViewer;
    protected DeleteAction fDeleteAction;
    protected OpenWizardAction fOpenMonitorAction;
    protected OpenWizardAction fOpenNodeAction;
    protected OpenWizardAction fOpenProfAgentAction;
    protected OpenWizardAction fOpenLogAgentAction;
    protected RefreshFromLocalAction fRefreshLocal;
    protected RefreshTreeAction fRefreshTree;
    protected SaveAction fSaveToFile;
    protected StartTraceAction fStartTraceAction;
    protected StopTraceAction fStopTraceAction;
    protected PropertyDialogAction fPropertyDialogAction;
    protected OpenWizardAction fOpenProcessAction;
    protected Menu fContextMenu;
    protected Map traceViewsMap;
    protected ActionGroup fImportActionGroup;
    protected Separator fAttachGrp;
    protected Separator fGCGroup;
    protected Separator fMonitorGrp;
    protected Separator fTerminateGrp;
    protected Separator fRefreshGrp;
    protected RelaunchTraceAction fRelaunchAction;
    private static Hashtable propertyPageActionMap = null;
    private final String GROUP_ADD_VIEWS = "group.add.views";
    private final String GROUP_REFRESH = "group.refresh";
    private final String GROUP_SAVE = "group.save";
    private final String GROUP_OPEN_PROPERTY = "group.open.property";
    static /* synthetic */ Class class$org$eclipse$hyades$trace$ui$internal$wizard$OpenMonitorWizard;
    static /* synthetic */ Class class$org$eclipse$hyades$trace$ui$internal$wizard$OpenProfAgentWizard;
    static /* synthetic */ Class class$org$eclipse$hyades$trace$ui$internal$wizard$OpenLogAgentWizard;
    static /* synthetic */ Class class$org$eclipse$hyades$trace$ui$internal$wizard$OpenNodeWizard;
    static /* synthetic */ Class class$org$eclipse$hyades$trace$ui$internal$wizard$OpenProcessWizard;

    public PDProjectExplorer() {
        IUnresolvedResourceHelper iUnresolvedResourceHelper = HierarchyResourceSetImpl.getInstance().getUnresolvedException();
        if (iUnresolvedResourceHelper != null && iUnresolvedResourceHelper instanceof UnresolvedResourceHelper) {
            ((UnresolvedResourceHelper)iUnresolvedResourceHelper).setPDProjectExplorer(this);
        }
    }

    protected void addViews(IMenuManager iMenuManager, Object object) {
        block28: {
            MenuManager menuManager;
            block27: {
                if (object == null || !(object instanceof EObject)) {
                    return;
                }
                menuManager = new MenuManager(UIPlugin.getResourceString("MENU_MANAGER"));
                iMenuManager.appendToGroup("group.add.views", (IContributionItem)menuManager);
                if (!(object instanceof TRCMonitor)) break block27;
                TRCMonitor tRCMonitor = (TRCMonitor)object;
                IAction[] iActionArray = this.getViewMappingForType("Monitor");
                int n = 0;
                while (n < iActionArray.length) {
                    if (iActionArray[n] != null) {
                        menuManager.add(iActionArray[n]);
                    }
                    ++n;
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                EList eList = tRCMonitor.getNodes();
                if (eList.size() <= 0) break block28;
                int n2 = 0;
                while (n2 < eList.size()) {
                    TRCNode tRCNode = (TRCNode)eList.get(n2);
                    EList eList2 = tRCNode.getProcessProxies();
                    int n3 = 0;
                    while (n3 < eList2.size()) {
                        TRCProcessProxy tRCProcessProxy = (TRCProcessProxy)eList2.get(n3);
                        EList eList3 = tRCProcessProxy.getAgentProxies();
                        int n4 = 0;
                        while (n4 < eList3.size()) {
                            TRCAgentProxy tRCAgentProxy = (TRCAgentProxy)eList3.get(n4);
                            if (!arrayList.contains(tRCAgentProxy.getType())) {
                                arrayList.add(tRCAgentProxy.getType());
                                iActionArray = this.getViewMappingForType(tRCAgentProxy.getType());
                                if (iActionArray.length > 0) {
                                    menuManager.add((IContributionItem)new Separator());
                                    int n5 = 0;
                                    while (n5 < iActionArray.length) {
                                        menuManager.add(iActionArray[n5]);
                                        ++n5;
                                    }
                                }
                            }
                            ++n4;
                        }
                        ++n3;
                    }
                    ++n2;
                }
                break block28;
            }
            if (object instanceof TRCNode) {
                IAction[] iActionArray = this.getViewMappingForType("Host");
                int n = 0;
                while (n < iActionArray.length) {
                    if (iActionArray[n] != null) {
                        menuManager.add(iActionArray[n]);
                    }
                    ++n;
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                EList eList = ((TRCNode)object).getProcessProxies();
                int n6 = 0;
                while (n6 < eList.size()) {
                    TRCProcessProxy tRCProcessProxy = (TRCProcessProxy)eList.get(n6);
                    EList eList4 = tRCProcessProxy.getAgentProxies();
                    int n7 = 0;
                    while (n7 < eList4.size()) {
                        TRCAgentProxy tRCAgentProxy = (TRCAgentProxy)eList4.get(n7);
                        if (!arrayList.contains(tRCAgentProxy.getType())) {
                            arrayList.add(tRCAgentProxy.getType());
                            iActionArray = this.getViewMappingForType(tRCAgentProxy.getType());
                            if (iActionArray.length > 0) {
                                menuManager.add((IContributionItem)new Separator());
                                int n8 = 0;
                                while (n8 < iActionArray.length) {
                                    menuManager.add(iActionArray[n8]);
                                    ++n8;
                                }
                            }
                        }
                        ++n7;
                    }
                    ++n6;
                }
            } else if (object instanceof TRCProcessProxy) {
                ArrayList<String> arrayList = new ArrayList<String>();
                EList eList = ((TRCProcessProxy)object).getAgentProxies();
                int n = 0;
                while (n < eList.size()) {
                    TRCAgentProxy tRCAgentProxy = (TRCAgentProxy)eList.get(n);
                    if (!arrayList.contains(tRCAgentProxy.getType())) {
                        arrayList.add(tRCAgentProxy.getType());
                        IAction[] iActionArray = this.getViewMappingForType(tRCAgentProxy.getType());
                        if (iActionArray.length > 0) {
                            menuManager.add((IContributionItem)new Separator());
                            int n9 = 0;
                            while (n9 < iActionArray.length) {
                                menuManager.add(iActionArray[n9]);
                                ++n9;
                            }
                        }
                    }
                    ++n;
                }
            } else if (object instanceof TRCAgentProxy) {
                IAction[] iActionArray = this.getViewMappingForType(((TRCAgentProxy)object).getType());
                int n = 0;
                while (n < iActionArray.length) {
                    if (iActionArray[n] != null) {
                        menuManager.add(iActionArray[n]);
                    }
                    ++n;
                }
            }
        }
    }

    public void createPartControl(Composite composite) {
        this.traceViewsMap = new HashMap();
        TraceAssociationManager.getTraceViewMappingRegistry().addCommitChangeListener((IPropertyListener)this);
        this.fViewer = new PDProjectViewer(composite);
        this.fViewer.setContentProvider((IContentProvider)new PDContentProvider(this));
        this.fViewer.setLabelProvider((IBaseLabelProvider)new PDLabelProvider());
        this.fViewer.setInput(ResourcesPlugin.getWorkspace().getRoot());
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)this);
        this.fContextMenu = menuManager.createContextMenu((Control)this.fViewer.getTree());
        this.fViewer.getTree().setMenu(this.fContextMenu);
        this.makeActions();
        IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
        iWorkbenchPartSite.registerContextMenu(menuManager, (ISelectionProvider)this.fViewer);
        iWorkbenchPartSite.setSelectionProvider((ISelectionProvider)this.fViewer);
        this.fillLocalToolBar();
        UIPlugin.getDefault().addSelectionProvider((ISelectionProvider)this.fViewer, (IWorkbenchPart)this);
        this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                PDProjectExplorer.this.handleDoubleClick(doubleClickEvent);
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)this.fViewer);
        UIPlugin.getDefault().addProfileEventListener(this);
    }

    public void dispose() {
        TraceAssociationManager.getTraceViewMappingRegistry().removeCommitChangeListener((IPropertyListener)this);
        if (this.fContextMenu != null && !this.fContextMenu.isDisposed()) {
            this.fContextMenu.dispose();
        }
        UIPlugin.getDefault().removeProfileEventListener(this);
        if (this.fViewer != null) {
            UIPlugin.getDefault().removeSelectionProvider((ISelectionProvider)this.fViewer, (IWorkbenchPart)this);
        }
        if (this.fImportActionGroup != null) {
            this.fImportActionGroup.dispose();
        }
        this.fAttachGrp = null;
        this.fRefreshGrp = null;
        this.fTerminateGrp = null;
        this.fMonitorGrp = null;
        this.fSaveToFile.dispose();
        this.fDeleteAction.dispose();
        this.fOpenLogAgentAction.dispose();
        this.fOpenMonitorAction.dispose();
        this.fOpenNodeAction.dispose();
        this.fOpenProcessAction.dispose();
        this.fPropertyDialogAction.dispose();
        this.fRefreshLocal.dispose();
        this.fRefreshTree.dispose();
        this.fSaveToFile.dispose();
        try {
            boolean bl = false;
            if (SaveUtil.documentsSize() > 0) {
                String string;
                Object object;
                Enumeration enumeration = SaveUtil.getDocuments().elements();
                while (enumeration.hasMoreElements()) {
                    object = (Resource)enumeration.nextElement();
                    if (object == null || !object.isLoaded() || !object.isModified()) continue;
                    bl = true;
                    break;
                }
                if (bl && MessageDialog.openQuestion(null, (String)(object = UIPlugin.getResourceString("TRACE_MSG")), (String)(string = UIPlugin.getResourceString("SAVE_PROJECT_SQ")))) {
                    SaveUtil.saveDocuments();
                    IWorkspaceRoot iWorkspaceRoot = UIPlugin.getPluginWorkbench().getRoot();
                    iWorkspaceRoot.refreshLocal(2, null);
                }
                SaveUtil.getDocuments().clear();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.fViewer.dispose();
        this.fViewer = null;
        super.dispose();
    }

    public final boolean hasFilter(int n) {
        return this.fViewer.hasFilter(n);
    }

    public Control getControl() {
        return this.fViewer.getControl();
    }

    public void refresh() {
        this.fViewer.refresh();
    }

    private boolean areAllProcessActive(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            if (!((TRCProcessProxy)objectArray[n]).isActive()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean anyProcessActive(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            if (((TRCProcessProxy)objectArray[n]).isActive()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean areSameClass(Object[] objectArray) {
        Class<?> clazz = objectArray[0].getClass();
        int n = 1;
        while (n < objectArray.length) {
            if (!clazz.equals(objectArray[n].getClass())) {
                return false;
            }
            clazz = objectArray[n].getClass();
            ++n;
        }
        return true;
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        Object e;
        boolean bl;
        String string = "";
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fViewer.getSelection();
        if (iStructuredSelection.isEmpty()) {
            this.addLaunchOptions(iMenuManager);
            iMenuManager.add((IContributionItem)new Separator("group.refresh"));
            iMenuManager.appendToGroup("group.refresh", (IAction)this.fRefreshTree);
            iMenuManager.add((IContributionItem)new Separator("group.reorganize"));
            iMenuManager.add((IContributionItem)new Separator("additions"));
            return;
        }
        Object[] objectArray = iStructuredSelection.toArray();
        boolean bl2 = false;
        boolean bl3 = bl = objectArray.length > 1;
        if (bl) {
            bl2 = this.areSameClass(objectArray);
        }
        if ((e = iStructuredSelection.iterator().next()) instanceof IContainer) {
            this.addLaunchOptions(iMenuManager);
        } else if (e instanceof TRCMonitor) {
            this.addLaunchOptions(iMenuManager);
            iMenuManager.add((IContributionItem)new Separator("group.add.views"));
            this.addViews(iMenuManager, e);
            iMenuManager.add((IContributionItem)this.fRefreshGrp);
        } else if (e instanceof TRCNode) {
            this.addLaunchOptions(iMenuManager);
            iMenuManager.add((IContributionItem)new Separator("group.add.views"));
            this.addViews(iMenuManager, e);
            iMenuManager.add((IContributionItem)this.fRefreshGrp);
        } else if (e instanceof TRCProcessProxy) {
            if (!bl) {
                iMenuManager.add((IContributionItem)this.fGCGroup);
                iMenuManager.add((IContributionItem)this.fTerminateGrp);
                if (((TRCProcessProxy)e).getLaunchMode() == 1) {
                    iMenuManager.add((IAction)this.fRelaunchAction);
                }
                iMenuManager.add((IContributionItem)new Separator("group.add.views"));
                this.addViews(iMenuManager, e);
                iMenuManager.add((IContributionItem)this.fRefreshGrp);
            }
        } else if (e instanceof TRCAgentProxy) {
            if (!bl || bl2) {
                iMenuManager.add((IContributionItem)this.fMonitorGrp);
                iMenuManager.add((IContributionItem)this.fGCGroup);
                iMenuManager.add((IContributionItem)this.fAttachGrp);
            }
            if (!bl) {
                iMenuManager.add((IContributionItem)this.fTerminateGrp);
                if (((TRCAgentProxy)e).getProcessProxy().getLaunchMode() == 1) {
                    iMenuManager.add((IAction)this.fRelaunchAction);
                }
                iMenuManager.add((IContributionItem)new Separator("group.add.views"));
                this.addViews(iMenuManager, e);
                iMenuManager.add((IContributionItem)this.fRefreshGrp);
            }
        }
        iMenuManager.add((IContributionItem)new Separator("group.save"));
        iMenuManager.appendToGroup("group.save", (IAction)this.fSaveToFile);
        iMenuManager.add((IContributionItem)new Separator("group.refresh"));
        iMenuManager.appendToGroup("group.refresh", (IAction)this.fRefreshLocal);
        iMenuManager.appendToGroup("group.refresh", (IAction)this.fRefreshTree);
        this.fDeleteAction.setSelections(objectArray);
        iMenuManager.appendToGroup("group.refresh", (IAction)this.fDeleteAction);
        if (!bl) {
            iMenuManager.add((IContributionItem)new Separator("group.open.property"));
            if (this.fPropertyDialogAction.isApplicableForSelection()) {
                iMenuManager.appendToGroup("group.open.property", (IAction)this.fPropertyDialogAction);
            }
            if (e instanceof TRCMonitor) {
                iMenuManager.appendToGroup("group.open.property", (IAction)this.fOpenMonitorAction);
            } else if (e instanceof TRCNode) {
                iMenuManager.appendToGroup("group.open.property", (IAction)this.fOpenNodeAction);
            } else if (e instanceof TRCProcessProxy) {
                iMenuManager.appendToGroup("group.open.property", (IAction)this.fOpenProcessAction);
            } else if (e instanceof TRCAgentProxy) {
                if (((TRCAgentProxy)e).getType().equals("Profiler")) {
                    iMenuManager.appendToGroup("group.open.property", (IAction)this.fOpenProfAgentAction);
                } else if (propertyPageActionMap != null) {
                    String string2 = ((TRCAgentProxy)e).getType();
                    if (propertyPageActionMap.containsKey(string2)) {
                        Object v = propertyPageActionMap.get(string2);
                        if (v instanceof Action) {
                            iMenuManager.appendToGroup("group.open.property", (IAction)((Action)v));
                        }
                    } else {
                        iMenuManager.appendToGroup("group.open.property", (IAction)this.fOpenLogAgentAction);
                    }
                } else {
                    iMenuManager.appendToGroup("group.open.property", (IAction)this.fOpenLogAgentAction);
                }
            }
        }
        iMenuManager.add((IContributionItem)new Separator("group.reorganize"));
        iMenuManager.add((IContributionItem)new Separator("additions"));
    }

    protected void fillLocalToolBar() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        IToolBarManager iToolBarManager = iActionBars.getToolBarManager();
        IMenuManager iMenuManager = iActionBars.getMenuManager();
        iMenuManager.add((IAction)this.fViewer.showFolderAction());
        iMenuManager.add((IAction)this.fViewer.showMonitorAction());
        iMenuManager.add((IAction)this.fViewer.showNodesAction());
        iMenuManager.add((IAction)this.fViewer.showProcessAction());
        iMenuManager.add((IAction)this.fViewer.showProfAgentsAction());
        if (this.fViewer.showLogAgentsAction() != null) {
            iMenuManager.add((IAction)this.fViewer.showLogAgentsAction());
        }
        iActionBars.updateActionBars();
    }

    public static PDProjectExplorer getFromActivePerspective() {
        try {
            IViewPart iViewPart = UIPlugin.getActivePage().showView("org.eclipse.hyades.trace.internal.ui.PDProjectExplorer");
            if (iViewPart instanceof PDProjectExplorer) {
                return (PDProjectExplorer)iViewPart;
            }
        }
        catch (PartInitException partInitException) {
            partInitException.printStackTrace();
            return null;
        }
        return null;
    }

    public IResource getSelectionFolder() {
        return this.fViewer.getSelectionFolder();
    }

    public IResource getSelectionFolder(TreeItem treeItem) {
        return this.fViewer.getSelectionFolder(treeItem);
    }

    public Shell getShell() {
        return this.fViewer.getTree().getShell();
    }

    protected String getToolTipText() {
        return UIPlugin.getResourceString("PDPROEXPTOOLTIP");
    }

    public PDProjectViewer getViewer() {
        return this.fViewer;
    }

    protected void handleDoubleClick(DoubleClickEvent doubleClickEvent) {
        IAction[] iActionArray;
        IStructuredSelection iStructuredSelection = (IStructuredSelection)doubleClickEvent.getSelection();
        Object object = iStructuredSelection.getFirstElement();
        if (object == null || !(object instanceof EObject)) {
            return;
        }
        if (object instanceof TRCMonitor) {
            IAction[] iActionArray2 = this.getViewMappingForType("Monitor");
            if (iActionArray2.length > 0 && iActionArray2[0] != null) {
                iActionArray2[0].run();
            }
        } else if (object instanceof TRCNode) {
            IAction[] iActionArray3 = this.getViewMappingForType("Host");
            if (iActionArray3.length > 0 && iActionArray3[0] != null) {
                iActionArray3[0].run();
            }
        } else if (object instanceof TRCProcessProxy) {
            EList eList = ((TRCProcessProxy)object).getAgentProxies();
            int n = 0;
            while (n < eList.size()) {
                IAction[] iActionArray4;
                TRCAgentProxy tRCAgentProxy = (TRCAgentProxy)eList.get(n);
                if (tRCAgentProxy != null && !tRCAgentProxy.eIsProxy() && (iActionArray4 = this.getViewMappingForType(tRCAgentProxy.getType())).length > 0 && iActionArray4[0] != null) {
                    iActionArray4[0].run();
                    return;
                }
                ++n;
            }
        } else if (object instanceof TRCAgentProxy && (iActionArray = this.getViewMappingForType(((TRCAgentProxy)object).getType())).length > 0 && iActionArray[0] != null) {
            iActionArray[0].run();
        }
    }

    public void init(IViewSite iViewSite, IMemento iMemento) throws PartInitException {
        super.init(iViewSite, iMemento);
    }

    public static Hashtable getPropertyPageActionMap() {
        return propertyPageActionMap;
    }

    protected void makeActions() {
        this.fImportActionGroup = new ImportActionGroup((IViewPart)this);
        this.fAttachGrp = new Separator("attachGroup");
        this.fGCGroup = new Separator("gcGroup");
        this.fRefreshGrp = new Separator("refreshGroup");
        this.fTerminateGrp = new Separator("terminateGroup");
        this.fMonitorGrp = new Separator("monitoringGroup");
        this.fRefreshTree = new RefreshTreeAction(this);
        this.fRefreshLocal = new RefreshFromLocalAction(this);
        this.fSaveToFile = new SaveAction(this);
        this.fOpenMonitorAction = new OpenWizardAction(this, class$org$eclipse$hyades$trace$ui$internal$wizard$OpenMonitorWizard == null ? (class$org$eclipse$hyades$trace$ui$internal$wizard$OpenMonitorWizard = PDProjectExplorer.class$("org.eclipse.hyades.trace.ui.internal.wizard.OpenMonitorWizard")) : class$org$eclipse$hyades$trace$ui$internal$wizard$OpenMonitorWizard, UIPlugin.getResourceString("PROPERTIES"));
        this.fOpenProfAgentAction = new OpenWizardAction(this, class$org$eclipse$hyades$trace$ui$internal$wizard$OpenProfAgentWizard == null ? (class$org$eclipse$hyades$trace$ui$internal$wizard$OpenProfAgentWizard = PDProjectExplorer.class$("org.eclipse.hyades.trace.ui.internal.wizard.OpenProfAgentWizard")) : class$org$eclipse$hyades$trace$ui$internal$wizard$OpenProfAgentWizard, UIPlugin.getResourceString("PROPERTIES"));
        this.fOpenLogAgentAction = new OpenWizardAction(this, class$org$eclipse$hyades$trace$ui$internal$wizard$OpenLogAgentWizard == null ? (class$org$eclipse$hyades$trace$ui$internal$wizard$OpenLogAgentWizard = PDProjectExplorer.class$("org.eclipse.hyades.trace.ui.internal.wizard.OpenLogAgentWizard")) : class$org$eclipse$hyades$trace$ui$internal$wizard$OpenLogAgentWizard, UIPlugin.getResourceString("PROPERTIES"));
        this.fOpenNodeAction = new OpenWizardAction(this, class$org$eclipse$hyades$trace$ui$internal$wizard$OpenNodeWizard == null ? (class$org$eclipse$hyades$trace$ui$internal$wizard$OpenNodeWizard = PDProjectExplorer.class$("org.eclipse.hyades.trace.ui.internal.wizard.OpenNodeWizard")) : class$org$eclipse$hyades$trace$ui$internal$wizard$OpenNodeWizard, UIPlugin.getResourceString("PROPERTIES"));
        this.fOpenProcessAction = new OpenWizardAction(this, class$org$eclipse$hyades$trace$ui$internal$wizard$OpenProcessWizard == null ? (class$org$eclipse$hyades$trace$ui$internal$wizard$OpenProcessWizard = PDProjectExplorer.class$("org.eclipse.hyades.trace.ui.internal.wizard.OpenProcessWizard")) : class$org$eclipse$hyades$trace$ui$internal$wizard$OpenProcessWizard, UIPlugin.getResourceString("PROPERTIES"));
        this.fDeleteAction = new DeleteAction(this);
        this.fPropertyDialogAction = new PropertyDialogAction(this.getShell(), (ISelectionProvider)this.getViewer());
        this.fRelaunchAction = new RelaunchTraceAction(this);
    }

    public void menuAboutToShow(IMenuManager iMenuManager) {
        this.fillContextMenu(iMenuManager);
        this.fImportActionGroup.fillContextMenu(iMenuManager);
    }

    public void refreshView(Object object) {
        this.fViewer.refresh();
        this.fViewer.selectObject(object);
    }

    public void selectObject(Object object) {
        this.fViewer.selectObject(object);
    }

    public void setFocus() {
        if (this.fViewer != null) {
            this.fViewer.getControl().setFocus();
        }
    }

    private void addLaunchOptions(IMenuManager iMenuManager) {
        iMenuManager.add((IAction)new LaunchTraceAction());
        iMenuManager.add((IAction)new AttachTraceAction());
    }

    public void handleProfileEvent(ProfileEvent profileEvent) {
        switch (profileEvent.getType()) {
            case 1: {
                this.fViewer.selectObject(profileEvent.getSource());
                break;
            }
            case 4: {
                this.fViewer.selectObject(profileEvent.getSource());
                break;
            }
            default: {
                this.fViewer.refresh(profileEvent.getSource());
            }
        }
    }

    protected IAction[] getViewMappingForType(String string) {
        Object v = this.traceViewsMap.get(string);
        if (v != null) {
            return (IAction[])v;
        }
        IAssociationMappingRegistry iAssociationMappingRegistry = TraceAssociationManager.getTraceViewMappingRegistry();
        IAssociationMapping iAssociationMapping = iAssociationMappingRegistry.getAssociationMapping("analyzerExtensions");
        if (iAssociationMapping == null) {
            IAction[] iActionArray = new IAction[]{};
            this.traceViewsMap.put(string, iActionArray);
            return iActionArray;
        }
        IAssociationDescriptor[] iAssociationDescriptorArray = iAssociationMapping.getAssociationDescriptors(string);
        IAction[] iActionArray = new IAction[iAssociationDescriptorArray.length];
        int n = 0;
        while (n < iAssociationDescriptorArray.length) {
            IAssociationDescriptor iAssociationDescriptor = iAssociationDescriptorArray[n];
            try {
                IAction iAction = (IAction)iAssociationDescriptor.createImplementationClassInstance();
                if (iAction != null) {
                    iAction.setText(iAssociationDescriptor.getName());
                    iAction.setImageDescriptor(iAssociationDescriptor.getImageDescriptor());
                    iActionArray[n] = iAction;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n;
        }
        this.traceViewsMap.put(string, iActionArray);
        return iActionArray;
    }

    public void propertyChanged(Object object, int n) {
        if (object instanceof IAssociationMappingRegistry) {
            this.traceViewsMap.clear();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ImportActionGroup
    extends ActionGroup {
        private final String GROUP_IMPORT = "group.import";
        private ImportResourcesAction fImportAction;
        private ExportResourcesAction fExportAction;

        public ImportActionGroup(IViewPart iViewPart) {
            IWorkbenchWindow iWorkbenchWindow = iViewPart.getSite().getWorkbenchWindow();
            this.fImportAction = new ImportResourcesAction(iWorkbenchWindow);
            this.fExportAction = new ExportResourcesAction(iWorkbenchWindow);
        }

        public void fillContextMenu(IMenuManager iMenuManager) {
            iMenuManager.appendToGroup("group.reorganize", (IContributionItem)new Separator("group.import"));
            iMenuManager.appendToGroup("group.import", (IAction)this.fImportAction);
            iMenuManager.appendToGroup("group.import", (IAction)this.fExportAction);
            super.fillContextMenu(iMenuManager);
        }
    }
}

