/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.actions;

import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.actions.AbstractListenerActionDelegate;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class RunGCActionDelegate
extends AbstractListenerActionDelegate {
    public void run(TRCAgentProxy tRCAgentProxy, PDProjectExplorer pDProjectExplorer) {
        if (!tRCAgentProxy.isMonitored()) {
            MessageDialog.openInformation((Shell)UIPlugin.getActiveWorkbenchShell(), (String)UIPlugin.getResourceString("TRACE_MSG"), (String)UIPlugin.getResourceString("RUN_GC_INFO_"));
            return;
        }
        if (tRCAgentProxy.getType().equals("Profiler")) {
            TRCProcessProxy tRCProcessProxy = tRCAgentProxy.getProcessProxy();
            String string = tRCProcessProxy.getNode().getName();
            try {
                Node node = PDCoreUtil.profileConnect(string, String.valueOf(tRCProcessProxy.getNode().getPort()));
                if (node == null) {
                    return;
                }
                Object object = LoadersUtils.locateAgentInstance((TRCAgentProxy)tRCAgentProxy);
                if (object != null && object instanceof Agent) {
                    Agent agent = (Agent)object;
                    CustomCommand customCommand = new CustomCommand();
                    customCommand.setData("RUNGC");
                    agent.invokeCustomCommand(customCommand);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected boolean isEnabledFor(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof TRCAgentProxy) {
            TRCAgentProxy tRCAgentProxy = (TRCAgentProxy)object;
            return tRCAgentProxy.getType().equals("Profiler") && tRCAgentProxy.isMonitored();
        }
        if (object instanceof TRCProcessProxy) {
            EList eList = ((TRCProcessProxy)object).getAgentProxies();
            int n = 0;
            while (n < eList.size()) {
                TRCAgentProxy tRCAgentProxy = (TRCAgentProxy)eList.get(n);
                if (!tRCAgentProxy.eIsProxy() && tRCAgentProxy.getType().equals("Profiler") && tRCAgentProxy.isMonitored()) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public void doAction(Object object) throws Exception {
        if (object == null || !(object instanceof TRCAgentProxy)) {
            return;
        }
        PDProjectExplorer pDProjectExplorer = UIPlugin.getDefault().getViewer();
        if (pDProjectExplorer == null) {
            MessageDialog.openInformation((Shell)UIPlugin.getActiveWorkbenchShell(), (String)"title", (String)"Action not available in current context");
            return;
        }
        this.run((TRCAgentProxy)object, pDProjectExplorer);
    }
}

