/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.console;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.console.ConsoleDataProcessor;
import org.eclipse.hyades.trace.ui.internal.console.TraceConsoleDocument;
import org.eclipse.hyades.trace.ui.internal.console.TraceConsoleView;
import org.eclipse.hyades.trace.ui.internal.util.ColorManager;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;

public class ConsoleManager
implements IDocumentListener {
    protected ColorManager fColorManager = new ColorManager();
    protected Map fConsoleDocuments = new HashMap(3);
    protected Map fConsoleData = new HashMap(3);
    protected TRCProcessProxy fCurrentProcess = null;
    protected TRCProcessProxy fProcessTemp;

    public ColorManager getColorManager() {
        return this.fColorManager;
    }

    public void deregisterLaunchProcess(TRCProcessProxy tRCProcessProxy) {
        this.fProcessTemp = tRCProcessProxy;
        Display display = this.getDisplay();
        if (display != null) {
            display.syncExec(new Runnable(){

                public void run() {
                    if (ConsoleManager.this.fProcessTemp != null) {
                        TraceConsoleDocument traceConsoleDocument = (TraceConsoleDocument)ConsoleManager.this.getConsoleDocument(ConsoleManager.this.fProcessTemp);
                        if (traceConsoleDocument != null) {
                            traceConsoleDocument.removeDocumentListener(ConsoleManager.this);
                            traceConsoleDocument.close();
                        }
                        ConsoleManager.this.setConsoleDocument(ConsoleManager.this.fProcessTemp, null);
                        ConsoleManager.this.setConsoleData(ConsoleManager.this.fProcessTemp, null);
                        ConsoleManager.this.fCurrentProcess = null;
                        ConsoleManager.this.fProcessTemp = null;
                    }
                }
            });
        }
    }

    public TRCProcessProxy determineCurrentProcess() {
        PDProjectExplorer pDProjectExplorer = UIPlugin.getDefault().getViewer();
        if (pDProjectExplorer != null) {
            TreeItem treeItem = pDProjectExplorer.getViewer().getTreeSelection();
            if (treeItem == null || treeItem.getData() == null) {
                return null;
            }
            Object object = treeItem.getData();
            if (object instanceof TRCProcessProxy) {
                return (TRCProcessProxy)object;
            }
            if (object instanceof TRCAgentProxy) {
                return ((TRCAgentProxy)object).getProcessProxy();
            }
        }
        return null;
    }

    public ConsoleDataProcessor getConsoleData(TRCProcessProxy tRCProcessProxy, boolean bl) {
        if (tRCProcessProxy != null) {
            ConsoleDataProcessor consoleDataProcessor = (ConsoleDataProcessor)this.fConsoleData.get(tRCProcessProxy);
            if (consoleDataProcessor != null) {
                return consoleDataProcessor;
            }
            consoleDataProcessor = new ConsoleDataProcessor(null);
            this.fConsoleData.put(tRCProcessProxy, consoleDataProcessor);
            return consoleDataProcessor;
        }
        if (bl) {
            TRCProcessProxy tRCProcessProxy2;
            if (this.getCurrentProcess() == null) {
                this.setCurrentProcess(this.determineCurrentProcess());
            }
            if ((tRCProcessProxy2 = this.getCurrentProcess()) != null) {
                ConsoleDataProcessor consoleDataProcessor = (ConsoleDataProcessor)this.fConsoleData.get(tRCProcessProxy2);
                if (consoleDataProcessor != null) {
                    return consoleDataProcessor;
                }
                consoleDataProcessor = new ConsoleDataProcessor(null);
                this.fConsoleData.put(tRCProcessProxy2, consoleDataProcessor);
                return consoleDataProcessor;
            }
        }
        return new ConsoleDataProcessor(null);
    }

    public IDocument getConsoleDocument(TRCProcessProxy tRCProcessProxy) {
        return this.getConsoleDocument(tRCProcessProxy, true);
    }

    public IDocument getConsoleDocument(TRCProcessProxy tRCProcessProxy, boolean bl) {
        if (tRCProcessProxy != null) {
            Object object = (IDocument)this.fConsoleDocuments.get(tRCProcessProxy);
            if (object != null) {
                return object;
            }
            ConsoleDataProcessor consoleDataProcessor = (ConsoleDataProcessor)this.fConsoleData.get(tRCProcessProxy);
            object = new TraceConsoleDocument(consoleDataProcessor);
            this.fConsoleDocuments.put(tRCProcessProxy, object);
            return object;
        }
        if (bl) {
            TRCProcessProxy tRCProcessProxy2;
            if (this.getCurrentProcess() == null) {
                this.setCurrentProcess(this.determineCurrentProcess());
            }
            if ((tRCProcessProxy2 = this.getCurrentProcess()) != null) {
                Object object = (IDocument)this.fConsoleDocuments.get(tRCProcessProxy2);
                if (object != null) {
                    return object;
                }
                ConsoleDataProcessor consoleDataProcessor = (ConsoleDataProcessor)this.fConsoleData.get(tRCProcessProxy2);
                object = new TraceConsoleDocument(consoleDataProcessor);
                this.fConsoleDocuments.put(tRCProcessProxy2, object);
                return object;
            }
        }
        return new TraceConsoleDocument(null);
    }

    public TRCProcessProxy getCurrentProcess() {
        return this.fCurrentProcess;
    }

    public void setCurrentProcess(TRCProcessProxy tRCProcessProxy) {
        if (this.fCurrentProcess != null) {
            this.getConsoleDocument(this.fCurrentProcess).removeDocumentListener((IDocumentListener)this);
        }
        this.fCurrentProcess = tRCProcessProxy;
        if (this.fCurrentProcess != null) {
            this.getConsoleDocument(this.fCurrentProcess).addDocumentListener((IDocumentListener)this);
        }
    }

    private void setConsoleData(TRCProcessProxy tRCProcessProxy, ConsoleDataProcessor consoleDataProcessor) {
        if (consoleDataProcessor == null) {
            Object v = this.fConsoleData.get(tRCProcessProxy);
            if (v != null && v instanceof ConsoleDataProcessor) {
                ((ConsoleDataProcessor)v).dispose();
            }
            this.fConsoleData.remove(tRCProcessProxy);
        } else {
            this.fConsoleData.put(tRCProcessProxy, consoleDataProcessor);
        }
    }

    private void setConsoleDocument(TRCProcessProxy tRCProcessProxy, IDocument iDocument) {
        if (iDocument == null) {
            this.fConsoleDocuments.remove(tRCProcessProxy);
        } else {
            this.fConsoleDocuments.put(tRCProcessProxy, iDocument);
        }
    }

    protected void setConsoleInput(final TRCProcessProxy tRCProcessProxy) {
        Display display = this.getDisplay();
        if (display != null) {
            display.asyncExec(new Runnable(){

                public void run() {
                    IWorkbenchWindow[] iWorkbenchWindowArray = UIPlugin.getDefault().getWorkbench().getWorkbenchWindows();
                    int n = 0;
                    while (n < iWorkbenchWindowArray.length) {
                        IWorkbenchWindow iWorkbenchWindow = iWorkbenchWindowArray[n];
                        IWorkbenchPage[] iWorkbenchPageArray = iWorkbenchWindow.getPages();
                        if (iWorkbenchPageArray != null) {
                            int n2 = 0;
                            while (n2 < iWorkbenchPageArray.length) {
                                IWorkbenchPage iWorkbenchPage = iWorkbenchPageArray[n2];
                                TraceConsoleView traceConsoleView = (TraceConsoleView)iWorkbenchPage.findView("org.eclipse.hyades.trace.ui.internal.console.TraceConsoleView");
                                if (traceConsoleView != null) {
                                    traceConsoleView.setViewerInput(tRCProcessProxy);
                                }
                                ++n2;
                            }
                        }
                        ++n;
                    }
                }
            });
        }
    }

    public void registerLaunchProcess(ConsoleDataProcessor consoleDataProcessor) {
        TRCProcessProxy tRCProcessProxy = consoleDataProcessor.getProcess();
        this.fConsoleData.put(tRCProcessProxy, consoleDataProcessor);
        this.setCurrentProcess(tRCProcessProxy);
        this.setConsoleInput(tRCProcessProxy);
        Display display = this.getDisplay();
        if (display != null) {
            display.syncExec(new Runnable(){

                public void run() {
                    TraceConsoleDocument traceConsoleDocument = new TraceConsoleDocument((ConsoleDataProcessor)ConsoleManager.this.fConsoleData.get(ConsoleManager.this.getCurrentProcess()));
                    traceConsoleDocument.startReading();
                    ConsoleManager.this.setConsoleDocument(ConsoleManager.this.getCurrentProcess(), (IDocument)traceConsoleDocument);
                }
            });
        }
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        if (!(iWorkbenchPart instanceof PDProjectExplorer)) {
            return;
        }
        IWorkbenchWindow iWorkbenchWindow = UIPlugin.getActiveWorkbenchWindow();
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
        if (iWorkbenchPage == null) {
            return;
        }
        Object object = null;
        if (iSelection instanceof IStructuredSelection) {
            object = ((IStructuredSelection)iSelection).getFirstElement();
        }
        TraceConsoleView traceConsoleView = (TraceConsoleView)iWorkbenchPage.findView("org.eclipse.hyades.trace.ui.internal.console.TraceConsoleView");
        if (object == null) {
            if (this.getCurrentProcess() != null) {
                if (traceConsoleView != null) {
                    traceConsoleView.setViewerInput(this.getCurrentProcess());
                }
            } else {
                TRCProcessProxy tRCProcessProxy = this.determineCurrentProcess();
                if (tRCProcessProxy == null) {
                    this.setCurrentProcess(tRCProcessProxy);
                    if (traceConsoleView != null) {
                        traceConsoleView.setViewerInput(tRCProcessProxy);
                    }
                }
            }
        } else {
            TRCProcessProxy tRCProcessProxy = this.getProcessFromInput(object);
            if (tRCProcessProxy == null) {
                if (traceConsoleView != null) {
                    traceConsoleView.setViewerInput(null, false);
                }
                this.setCurrentProcess(null);
                return;
            }
            if (!tRCProcessProxy.equals(this.getCurrentProcess())) {
                this.setCurrentProcess(tRCProcessProxy);
                if (traceConsoleView != null) {
                    traceConsoleView.setViewerInput(tRCProcessProxy);
                } else {
                    IDocument iDocument = this.getConsoleDocument(tRCProcessProxy);
                    if (iDocument != null) {
                        iDocument.addDocumentListener((IDocumentListener)this);
                    }
                }
            }
        }
    }

    public void documentAboutToBeChanged(DocumentEvent documentEvent) {
        Display display = this.getDisplay();
        if (display != null) {
            display.asyncExec(new Runnable(){

                public void run() {
                    IWorkbenchPage iWorkbenchPage;
                    IWorkbenchWindow iWorkbenchWindow = UIPlugin.getActiveWorkbenchWindow();
                    if (iWorkbenchWindow != null && (iWorkbenchPage = iWorkbenchWindow.getActivePage()) != null) {
                        try {
                            TraceConsoleView traceConsoleView = (TraceConsoleView)iWorkbenchPage.findView("org.eclipse.hyades.trace.ui.internal.console.TraceConsoleView");
                            if (traceConsoleView == null) {
                                traceConsoleView = (TraceConsoleView)iWorkbenchPage.showView("org.eclipse.hyades.trace.ui.internal.console.TraceConsoleView");
                                traceConsoleView.setViewerInput(ConsoleManager.this.getCurrentProcess());
                            }
                            iWorkbenchPage.bringToTop((IWorkbenchPart)traceConsoleView);
                        }
                        catch (PartInitException partInitException) {
                            // empty catch block
                        }
                    }
                }
            });
        }
    }

    public void documentChanged(DocumentEvent documentEvent) {
    }

    public Display getDisplay() {
        IWorkbench iWorkbench = UIPlugin.getDefault().getWorkbench();
        if (iWorkbench != null) {
            IWorkbenchWindow[] iWorkbenchWindowArray = iWorkbench.getWorkbenchWindows();
            Object var3_3 = null;
            if (iWorkbenchWindowArray != null && iWorkbenchWindowArray.length > 0) {
                return iWorkbenchWindowArray[0].getShell().getDisplay();
            }
        }
        return null;
    }

    protected TRCProcessProxy getProcessFromInput(Object object) {
        TRCProcessProxy tRCProcessProxy = null;
        if (object instanceof TRCProcessProxy) {
            tRCProcessProxy = (TRCProcessProxy)object;
        } else if (object instanceof TRCAgentProxy) {
            tRCProcessProxy = ((TRCAgentProxy)object).getProcessProxy();
        }
        return tRCProcessProxy;
    }
}

