/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.core;

import java.util.Vector;
import org.eclipse.hyades.internal.execution.local.control.AgentConfigurationEntry;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TraceProfileCollectionsUI
implements SelectionListener,
ModifyListener {
    private Label _limitInvocLabel;
    private Label _limitTimeLabel;
    private Text _limitTime;
    private Text _limitInvocations;
    private Button _limitTimeBtn;
    private Button _limitInvocBtn;
    private WizardPage _wizardPage;
    private PreferencePage _preferencePage;

    public Composite createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 2;
        GridData gridData = GridUtil.createFill();
        gridData.heightHint = 300;
        gridData.widthHint = 400;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)gridData);
        this.addLimitTraceGroup(composite2);
        return composite2;
    }

    private void addLimitTraceGroup(Composite composite) {
        Group group = new Group(composite, 0);
        GridData gridData = GridUtil.createHorizontalFill();
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)gridData);
        group.setText(UIPlugin.getResourceString("STR_LIMIT_DATA_AMOUNT"));
        this._limitInvocBtn = new Button((Composite)group, 32);
        this._limitInvocBtn.setText(UIPlugin.getResourceString("STR_INV_LIMIT_OPTION"));
        gridData = GridUtil.createHorizontalFill();
        gridData.horizontalSpan = 2;
        this._limitInvocBtn.setLayoutData((Object)gridData);
        this._limitInvocLabel = new Label((Composite)group, 0);
        this._limitInvocLabel.setText(UIPlugin.getResourceString("STR_INV_LIMIT_NB"));
        gridData = new GridData();
        gridData.horizontalIndent = 20;
        this._limitInvocLabel.setLayoutData((Object)gridData);
        this._limitInvocations = new Text((Composite)group, 2048);
        this._limitInvocations.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._limitTimeBtn = new Button((Composite)group, 32);
        this._limitTimeBtn.setText(UIPlugin.getResourceString("STR_TIME_LIMIT_OPTION"));
        gridData = GridUtil.createHorizontalFill();
        gridData.horizontalSpan = 2;
        this._limitTimeBtn.setLayoutData((Object)gridData);
        this._limitTimeLabel = new Label((Composite)group, 0);
        this._limitTimeLabel.setText(UIPlugin.getResourceString("STR_TIME_LIMIT_NB"));
        gridData = new GridData();
        gridData.horizontalIndent = 20;
        this._limitTimeLabel.setLayoutData((Object)gridData);
        this._limitTime = new Text((Composite)group, 2048);
        this._limitTime.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._limitInvocBtn.addSelectionListener((SelectionListener)this);
        this._limitTimeBtn.addSelectionListener((SelectionListener)this);
        this._limitInvocations.addModifyListener((ModifyListener)this);
        this._limitTime.addModifyListener((ModifyListener)this);
    }

    public void enable(boolean bl) {
        this._limitInvocations.setEnabled(bl);
        this._limitInvocBtn.setEnabled(bl);
        this._limitInvocLabel.setEnabled(bl);
        this._limitTime.setEnabled(bl);
        this._limitTimeBtn.setEnabled(bl);
        this._limitTimeLabel.setEnabled(bl);
    }

    public void enableButtons() {
        IPreferenceStore iPreferenceStore = UIPlugin.getDefault().getPreferenceStore();
        this.setLimitInvocations(iPreferenceStore.getBoolean("limitInvoc"));
        this.setLimitTime(iPreferenceStore.getBoolean("limitTime"));
        this.setLimitInvocNb(iPreferenceStore.getString("invoc_nb"));
        this.setLimitTimeNb(iPreferenceStore.getString("timeSec"));
    }

    public Vector getOptions() {
        Vector<AgentConfigurationEntry> vector = new Vector<AgentConfigurationEntry>();
        if (this.getLimitInvocations()) {
            AgentConfigurationEntry agentConfigurationEntry;
            AgentConfigurationEntry agentConfigurationEntry2 = new AgentConfigurationEntry();
            agentConfigurationEntry2.setName("BURST_MODE");
            agentConfigurationEntry2.setType("SETOPTION");
            if (this.getLimitTime()) {
                agentConfigurationEntry2.setValue("secondsAndInvocations");
                agentConfigurationEntry = new AgentConfigurationEntry();
                agentConfigurationEntry.setName("BURST_SECONDS");
                agentConfigurationEntry.setValue(String.valueOf(this.getLimitTimeNb()));
                agentConfigurationEntry.setType("SETOPTION");
                vector.addElement(agentConfigurationEntry);
            } else {
                agentConfigurationEntry2.setValue("invocations");
            }
            vector.addElement(agentConfigurationEntry2);
            agentConfigurationEntry = new AgentConfigurationEntry();
            agentConfigurationEntry.setName("BURST_INVOCATIONS");
            agentConfigurationEntry.setValue(String.valueOf(this.getLimitInvocNb()));
            agentConfigurationEntry.setType("SETOPTION");
            vector.addElement(agentConfigurationEntry);
        } else if (this.getLimitTime()) {
            AgentConfigurationEntry agentConfigurationEntry = new AgentConfigurationEntry();
            agentConfigurationEntry.setName("BURST_MODE");
            agentConfigurationEntry.setType("SETOPTION");
            agentConfigurationEntry.setValue("seconds");
            vector.addElement(agentConfigurationEntry);
            agentConfigurationEntry = new AgentConfigurationEntry();
            agentConfigurationEntry.setName("BURST_SECONDS");
            agentConfigurationEntry.setValue(String.valueOf(this.getLimitTimeNb()));
            agentConfigurationEntry.setType("SETOPTION");
            vector.addElement(agentConfigurationEntry);
        }
        return vector;
    }

    public void modifyText(ModifyEvent modifyEvent) {
        if (modifyEvent.getSource() == this._limitInvocations || modifyEvent.getSource() == this._limitTime) {
            this.checkNumbersAndPrintErrorMsg();
        }
    }

    private boolean checkValidTextInput() {
        String string;
        if (this._limitInvocBtn.getSelection()) {
            string = this._limitInvocations.getText().trim();
            try {
                if (Integer.parseInt(string) <= 0) {
                    return false;
                }
            }
            catch (Exception exception) {
                return false;
            }
        }
        if (this._limitTimeBtn.getSelection()) {
            string = this._limitTime.getText().trim();
            try {
                if (Integer.parseInt(string) <= 0) {
                    return false;
                }
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    public boolean getLimitInvocations() {
        return this._limitInvocBtn.getSelection();
    }

    public int getLimitInvocNb() {
        String string = this._limitInvocations.getText().trim();
        try {
            int n = Integer.parseInt(string);
            if (n > 0) {
                return n;
            }
            return UIPlugin.getDefault().getPreferenceStore().getDefaultInt("invoc_nb");
        }
        catch (Exception exception) {
            return UIPlugin.getDefault().getPreferenceStore().getDefaultInt("invoc_nb");
        }
    }

    public boolean getLimitTime() {
        return this._limitTimeBtn.getSelection();
    }

    public int getLimitTimeNb() {
        String string = this._limitTime.getText().trim();
        try {
            int n = Integer.parseInt(string);
            if (n > 0) {
                return n;
            }
            return UIPlugin.getDefault().getPreferenceStore().getDefaultInt("timeSec");
        }
        catch (Exception exception) {
            return UIPlugin.getDefault().getPreferenceStore().getDefaultInt("timeSec");
        }
    }

    public void setLimitInvocations(boolean bl) {
        this._limitInvocBtn.setSelection(bl);
        if (!this._limitInvocBtn.isEnabled()) {
            return;
        }
        this._limitInvocations.setEnabled(bl);
        this._limitInvocLabel.setEnabled(bl);
    }

    public void setLimitInvocNb(String string) {
        this._limitInvocations.setText(string);
    }

    public void setLimitTime(boolean bl) {
        this._limitTimeBtn.setSelection(bl);
        if (!this._limitTimeBtn.isEnabled()) {
            return;
        }
        this._limitTime.setEnabled(bl);
        this._limitTimeLabel.setEnabled(bl);
    }

    public void setLimitTimeNb(String string) {
        this._limitTime.setText(string);
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this._limitInvocBtn) {
            this._limitInvocations.setEnabled(this._limitInvocBtn.getSelection());
            this._limitInvocLabel.setEnabled(this._limitInvocBtn.getSelection());
        } else if (selectionEvent.widget == this._limitTimeBtn) {
            this._limitTime.setEnabled(this._limitTimeBtn.getSelection());
            this._limitTimeLabel.setEnabled(this._limitTimeBtn.getSelection());
        }
    }

    public void checkNumbersAndPrintErrorMsg() {
        if (this._wizardPage != null) {
            if (!this.checkValidTextInput()) {
                this._wizardPage.setErrorMessage(UIPlugin.getResourceString("STR_INVALID_COLLECTION_VALUE"));
                this._wizardPage.setPageComplete(false);
            } else {
                this._wizardPage.setErrorMessage(null);
                this._wizardPage.setPageComplete(true);
            }
        } else if (this._preferencePage != null) {
            if (!this.checkValidTextInput()) {
                this._preferencePage.setErrorMessage(UIPlugin.getResourceString("STR_INVALID_COLLECTION_VALUE"));
                this._preferencePage.setValid(false);
            } else {
                this._preferencePage.setErrorMessage(null);
                this._preferencePage.setValid(true);
            }
        }
    }

    public void setWizardPage(WizardPage wizardPage) {
        this._wizardPage = wizardPage;
    }

    public void setPreferencePage(PreferencePage preferencePage) {
        this._preferencePage = preferencePage;
    }
}

