/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.preferences;

import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.internal.ui.PDProjectViewer;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceViewOptionsUI;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.help.WorkbenchHelp;

public class TraceViewPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private TraceViewOptionsUI _options;

    public TraceViewPreferencePage() {
        this.setPreferenceStore(UIPlugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        WorkbenchHelp.setHelp((Control)composite, (String)(UIPlugin.getPluginId() + ".tvpp0000"));
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 5;
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        this._options = new TraceViewOptionsUI();
        this._options.createControl(composite2);
        return composite2;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return UIPlugin.getDefault().getPreferenceStore();
    }

    public void init(IWorkbench iWorkbench) {
    }

    private void initializeDefaults() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        this._options.setShowFolder(iPreferenceStore.getDefaultBoolean("show_folder"));
        this._options.setShowMonitor(iPreferenceStore.getDefaultBoolean("show_monitor"));
        this._options.setShowNode(iPreferenceStore.getDefaultBoolean("show_node"));
        this._options.setShowProcess(iPreferenceStore.getDefaultBoolean("show_process"));
        this._options.setShowLog(iPreferenceStore.getDefaultBoolean("show_log"));
        this._options.setShowProf(iPreferenceStore.getDefaultBoolean("show_prof"));
    }

    protected void performDefaults() {
        super.performDefaults();
        this.initializeDefaults();
        this.updateTraceView();
    }

    public boolean performOk() {
        this.storeValues();
        this.updateTraceView();
        UIPlugin.getDefault().savePluginPreferences();
        return true;
    }

    private void storeValues() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        iPreferenceStore.setValue("show_folder", this._options.getShowFolder());
        iPreferenceStore.setValue("show_monitor", this._options.getShowMonitor());
        iPreferenceStore.setValue("show_node", this._options.getShowNode());
        iPreferenceStore.setValue("show_process", this._options.getShowProcess());
        iPreferenceStore.setValue("show_log", this._options.getShowLog());
        iPreferenceStore.setValue("show_prof", this._options.getShowProf());
    }

    private void updateTraceView() {
        IWorkbenchWindow iWorkbenchWindow = UIPlugin.getActiveWorkbenchWindow();
        if (iWorkbenchWindow == null) {
            return;
        }
        IWorkbenchPage[] iWorkbenchPageArray = iWorkbenchWindow.getPages();
        int n = 0;
        while (n < iWorkbenchPageArray.length) {
            IWorkbenchPage iWorkbenchPage;
            IViewPart iViewPart;
            if (iWorkbenchPageArray[n].getPerspective().getId().equals("org.eclipse.hyades.trace.internal.ui.tracePerspective") && (iViewPart = (iWorkbenchPage = iWorkbenchPageArray[n]).findView("org.eclipse.hyades.trace.internal.ui.PDProjectExplorer")) != null) {
                PDProjectViewer pDProjectViewer = ((PDProjectExplorer)iViewPart).getViewer();
                pDProjectViewer.showFolderAction().setChecked(this._options.getShowFolder(), false);
                pDProjectViewer.showMonitorAction().setChecked(this._options.getShowMonitor(), false);
                pDProjectViewer.showNodesAction().setChecked(this._options.getShowNode(), false);
                pDProjectViewer.showProcessAction().setChecked(this._options.getShowProcess(), false);
                pDProjectViewer.showProfAgentsAction().setChecked(this._options.getShowProf(), false);
                if (pDProjectViewer.showLogAgentsAction() != null) {
                    pDProjectViewer.showLogAgentsAction().setChecked(this._options.getShowLog(), false);
                }
                pDProjectViewer.refresh();
            }
            ++n;
        }
    }
}

