/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.util;

import java.util.ArrayList;
import java.util.Date;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.jdt.core.IType;

public class TraceArguments {
    private String fHostName;
    private String fClassName;
    private String fClassPath;
    private String fParameters;
    private String fVMArgs;
    private int fPortNumber;
    private ArrayList fEnvionmentVariable;
    private String fTraceMode;
    private Date fTimestamp;
    private String fId = "";
    private TRCAgentProxy fAgent;
    private TRCProcessProxy fProcess;
    private IType fType;
    private String fPath;
    private String fLocation;
    private String profileFile = null;

    public TraceArguments(TRCAgentProxy tRCAgentProxy, String string) {
        this.fAgent = tRCAgentProxy;
        this.fProcess = tRCAgentProxy.getProcessProxy();
        this.fTraceMode = string;
        this.fTimestamp = new Date();
    }

    public TraceArguments(TRCProcessProxy tRCProcessProxy, String string) {
        this.fProcess = tRCProcessProxy;
        this.fTraceMode = string;
        this.fTimestamp = new Date();
    }

    public TraceArguments(String string) {
        this.fClassName = string;
        this.fTimestamp = new Date();
    }

    public TraceArguments(IType iType) {
        this.fType = iType;
        this.setClassName(iType.getFullyQualifiedName());
        this.fTimestamp = new Date();
    }

    public TRCAgentProxy getAgent() {
        return this.fAgent;
    }

    public String getClassName() {
        if (this.fType != null) {
            return this.fType.getFullyQualifiedName();
        }
        if (this.fProcess == null) {
            return this.fClassName;
        }
        return this.fProcess.getName();
    }

    public ArrayList getEnvironmentVariable() {
        return this.fEnvionmentVariable;
    }

    public String getClassPath() {
        return this.fClassPath;
    }

    public String getHostName() {
        if (this.fProcess == null) {
            return this.fHostName;
        }
        return this.fProcess.getNode().getName();
    }

    public int getPortNumber() {
        return this.fPortNumber;
    }

    public String getId() {
        if (this.fAgent != null) {
            return this.fAgent.getRuntimeId();
        }
        if (this.fProcess != null) {
            return this.fProcess.getRuntimeId();
        }
        return this.fId;
    }

    public String getLocation() {
        if (this.fProcess != null) {
            return this.fProcess.getLocation();
        }
        if (this.fAgent != null) {
            return this.fAgent.getProcessProxy().getLocation();
        }
        return this.fLocation;
    }

    public String getParameters() {
        return this.fParameters;
    }

    public String getPath() {
        return this.fPath;
    }

    public TRCProcessProxy getProcess() {
        return this.fProcess;
    }

    public Date getTimestamp() {
        return this.fTimestamp;
    }

    public IType getType() {
        return this.fType;
    }

    public String getVMArguments() {
        return this.fVMArgs;
    }

    public void setAgent(TRCAgentProxy tRCAgentProxy) {
        this.fAgent = tRCAgentProxy;
    }

    public void setClassName(String string) {
        this.fClassName = string;
    }

    public void setEnvironmentVariable(ArrayList arrayList) {
        this.fEnvionmentVariable = arrayList;
    }

    public void setClassPath(String string) {
        this.fClassPath = string;
    }

    public void setHostName(String string) {
        this.fHostName = string;
    }

    public void setPortNumber(int n) {
        this.fPortNumber = n;
    }

    public void setId(String string) {
        this.fId = string;
    }

    public void setLocation(String string) {
        this.fLocation = string;
    }

    public void setParameters(String string) {
        this.fParameters = string;
    }

    public void setPath(String string) {
        this.fPath = string;
    }

    public void setProcess(TRCProcessProxy tRCProcessProxy) {
        this.fProcess = tRCProcessProxy;
    }

    public void setTraceMode(String string) {
        this.fTraceMode = string;
    }

    public void setType(IType iType) {
        this.fType = iType;
    }

    public void setVMArguments(String string) {
        this.fVMArgs = string;
    }

    public String toString() {
        if (this.fProcess != null) {
            return this.fProcess.getName();
        }
        return this.fClassName;
    }

    public boolean isToProfileFile() {
        return this.profileFile != null && !this.profileFile.trim().equals("");
    }

    public String getProfileFile() {
        return this.profileFile;
    }

    public void setProfileFile(String string) {
        this.profileFile = string;
    }
}

