/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.wizard;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.models.hierarchy.TRCOption;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceProfileCollectionsUI;
import org.eclipse.hyades.trace.ui.internal.util.DoubleCTree;
import org.eclipse.hyades.trace.ui.internal.wizard.AttachLocalWizard;
import org.eclipse.hyades.trace.ui.internal.wizard.AttachRemoteWizard;
import org.eclipse.hyades.trace.ui.internal.wizard.RelaunchWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;

public class AgentCollectionsPage
extends WizardPage {
    protected TraceProfileCollectionsUI _optionsUI;
    protected String _type;

    public AgentCollectionsPage(String string, String string2) {
        super(string);
        this._type = string2;
        this.setTitle(UIPlugin.getResourceString("AGENT_LIMIT_WIZARD_TITLE"));
        this.setDescription(UIPlugin.getResourceString("AGENT_LIMIT_WIZARD_DESCR"));
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 5;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = GridUtil.createFill();
        gridData.widthHint = 500;
        gridData.heightHint = 400;
        composite2.setLayoutData((Object)gridData);
        this._optionsUI = new TraceProfileCollectionsUI();
        this._optionsUI.createControl(composite2);
        this._optionsUI.setWizardPage(this);
        this.setControl((Control)composite2);
        this.initializeValues();
        WorkbenchHelp.setHelp((Control)composite, (String)(UIPlugin.getPluginId() + ".pcwp0000"));
    }

    public boolean finish() {
        return true;
    }

    public Vector getOptions() {
        return this._optionsUI.getOptions();
    }

    private void initializeValues() {
        this._optionsUI.enableButtons();
        if (this.getWizard() instanceof RelaunchWizard) {
            ((RelaunchWizard)this.getWizard()).setAgentOptions();
        }
    }

    public void initializeValues(EList eList) {
        if (eList != null) {
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                TRCOption tRCOption = (TRCOption)iterator.next();
                if (tRCOption.getKey().equals("BURST_MODE")) {
                    if (tRCOption.getValue().equals("secondsAndInvocations")) {
                        this._optionsUI.setLimitInvocations(true);
                        this._optionsUI.setLimitTime(true);
                        continue;
                    }
                    if (tRCOption.getValue().equals("invocations")) {
                        this._optionsUI.setLimitInvocations(true);
                        this._optionsUI.setLimitTime(false);
                        continue;
                    }
                    if (!tRCOption.getValue().equals("seconds")) continue;
                    this._optionsUI.setLimitInvocations(false);
                    this._optionsUI.setLimitTime(true);
                    continue;
                }
                if (tRCOption.getKey().equals("BURST_INVOCATIONS")) {
                    this._optionsUI.setLimitInvocNb(tRCOption.getValue());
                    continue;
                }
                if (!tRCOption.getKey().equals("BURST_SECONDS")) continue;
                this._optionsUI.setLimitTimeNb(tRCOption.getValue());
            }
        }
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            Vector vector = this.getAgentsList();
            if (vector != null && !this.hasProfilingAgent(vector)) {
                this.getControl().setEnabled(false);
                this.getControl().setVisible(false);
                this.setDescription(UIPlugin.getResourceString("STR_LIMIT_IGNORED"));
            } else {
                this.getControl().setEnabled(true);
                this.getControl().setVisible(true);
                this.setDescription(UIPlugin.getResourceString("AGENT_LIMIT_WIZARD_DESCR"));
            }
        }
    }

    private Vector getAgentsList() {
        DoubleCTree doubleCTree = null;
        Vector vector = null;
        if (this._type.equals("AttachLocalWizard")) {
            doubleCTree = ((AttachLocalWizard)this.getWizard()).getAgentList();
        } else if (this._type.equals("AttachRemoteWizard")) {
            doubleCTree = ((AttachRemoteWizard)this.getWizard()).getAgentList();
        }
        if (doubleCTree != null) {
            vector = doubleCTree.getSelectedAgents();
        }
        return vector;
    }

    private boolean hasProfilingAgent(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            Agent agent = (Agent)vector.elementAt(n);
            if (agent.getType() != null && agent.getType().equals("Profiler") && !agent.getName().equals("J2EE Request Profiler")) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

