/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.wizard;

import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.DoubleCTree;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.internal.wizard.AgentCollectionsPage;
import org.eclipse.hyades.trace.ui.internal.wizard.AgentOptionsPage;
import org.eclipse.hyades.trace.ui.internal.wizard.AttachLocalPage;
import org.eclipse.hyades.trace.ui.internal.wizard.DestinationFolderPage;
import org.eclipse.hyades.trace.ui.internal.wizard.ProfileOptionsPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class AttachLocalWizard
extends Wizard
implements INewWizard {
    protected AttachLocalPage fNamePage;
    protected DestinationFolderPage fFolderPage;
    protected ProfileOptionsPage fProfilePage;
    protected IStructuredSelection fSelection;
    protected AgentOptionsPage fOptionsPage;
    protected AgentCollectionsPage fCollectionsPage;
    protected String fNodeName = "";
    protected int fPortNumber = 10002;
    private boolean isProfilingEnabled = UIPlugin.getDefault().getPreferenceStore().getBoolean("prof_option");

    public AttachLocalWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.setWindowTitle(UIPlugin.getResourceString("ATTACH_JAVA_APP_TITLE"));
        this.fNamePage = new AttachLocalPage("namePage");
        this.fFolderPage = new DestinationFolderPage("folderPage");
        this.addPage((IWizardPage)this.fNamePage);
        this.addPage((IWizardPage)this.fFolderPage);
        if (this.isProfilingEnabled) {
            this.fProfilePage = new ProfileOptionsPage("optionsPage", "AttachLocalWizard");
            this.fOptionsPage = new AgentOptionsPage("agentPage", "AttachLocalWizard");
            this.fCollectionsPage = new AgentCollectionsPage("collentionsPage", "LaunchLocalWizard");
            this.addPage((IWizardPage)this.fProfilePage);
            this.addPage((IWizardPage)this.fOptionsPage);
            this.addPage((IWizardPage)this.fCollectionsPage);
            this.fProfilePage.setImageDescriptor(UIPlugin.getImageDescriptor("attach_wiz.gif"));
            this.fOptionsPage.setImageDescriptor(UIPlugin.getImageDescriptor("attach_wiz.gif"));
            this.fCollectionsPage.setImageDescriptor(UIPlugin.getImageDescriptor("attach_wiz.gif"));
        }
        this.fNamePage.setImageDescriptor(UIPlugin.getImageDescriptor("attach_wiz.gif"));
        this.fFolderPage.setImageDescriptor(UIPlugin.getImageDescriptor("attach_wiz.gif"));
    }

    public DoubleCTree getAgentList() {
        return this.fNamePage.getList();
    }

    public ArrayList getFilterSet() {
        return this.fProfilePage.getFilterSet();
    }

    public String getNodeName() {
        return this.fNodeName;
    }

    public int getPortSelection() {
        IPreferenceStore iPreferenceStore = UIPlugin.getDefault().getPreferenceStore();
        this.fPortNumber = Integer.parseInt(iPreferenceStore.getString("localhost_port"));
        return this.fPortNumber;
    }

    public String getNodeSelected() {
        return "localhost";
    }

    public Vector getOptions() {
        Vector vector = this.fOptionsPage.getOptions();
        Vector vector2 = this.fCollectionsPage.getOptions();
        vector.addAll(vector2);
        return vector;
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.fSelection = iStructuredSelection;
        this.setDefaultPageImageDescriptor(UIPlugin.getImageDescriptor("attach_wiz.gif"));
    }

    public boolean isComplete() {
        return this.fNamePage.isComplete();
    }

    public String pageDetails() {
        return this.fNamePage.pageDetails();
    }

    public boolean performFinish() {
        if (!(this.fFolderPage.getFile().equals("") || PDCoreUtil.isPathExists(this.fFolderPage.getFile()) || PDCoreUtil.createDirectoryMessage(this.fFolderPage.getFile(), this.getShell()))) {
            return false;
        }
        if (this.isProfilingEnabled) {
            this.fProfilePage.finish();
            this.fOptionsPage.finish();
        }
        this.fFolderPage.finish();
        return this.fNamePage.finish(this.fFolderPage.getProject(), this.fFolderPage.getMonitor(), this.fFolderPage.getFile());
    }

    public void setNodeSelection(String string) {
        this.fNodeName = string;
    }

    public void setPortSelection(int n) {
        this.fPortNumber = n;
    }

    public boolean isProfilingEnabled() {
        return this.isProfilingEnabled;
    }
}

