/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.wizard;

import org.eclipse.core.resources.IResource;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceLocationUI;
import org.eclipse.hyades.trace.ui.internal.wizard.OpenLogAgentWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class OpenLogAgentPage
extends WizardPage {
    protected TraceLocationUI _locationUI;
    protected Text _name;
    protected PDProjectExplorer fViewer;

    public OpenLogAgentPage(String string, PDProjectExplorer pDProjectExplorer) {
        super(string);
        this.setTitle(UIPlugin.getResourceString("LOG_AGENT_TITLE"));
        this.fViewer = pDProjectExplorer;
        this.setDescription("");
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 5;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = GridUtil.createFill();
        gridData.widthHint = 500;
        gridData.heightHint = 400;
        composite2.setLayoutData((Object)gridData);
        this._locationUI = new TraceLocationUI();
        this._locationUI.createControl(composite2);
        this._locationUI.setEnabled(false);
        Composite composite3 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.verticalSpacing = 5;
        composite3.setLayout((Layout)gridLayout);
        composite3.setLayoutData((Object)GridUtil.createHorizontalFill());
        Label label = new Label(composite3, 0);
        label.setText(UIPlugin.getResourceString("STR_AGENT_NAME"));
        this._name = new Text(composite3, 2048);
        this._name.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._name.setEnabled(false);
        this.setControl((Control)composite2);
        this.populateData();
        WorkbenchHelp.setHelp((Control)composite, (String)(UIPlugin.getPluginId() + ".olap0000"));
    }

    public boolean finish() {
        return true;
    }

    protected void populateData() {
        TRCAgentProxy tRCAgentProxy;
        IResource iResource = this.fViewer.getSelectionFolder();
        if (iResource != null) {
            this._locationUI.setLocation(iResource.getFullPath().toOSString());
        }
        if ((tRCAgentProxy = ((OpenLogAgentWizard)this.getWizard()).getAgent()) == null) {
            return;
        }
        this._locationUI.setMonitor(tRCAgentProxy.getProcessProxy().getNode().getMonitor().getName());
        this._name.setText(tRCAgentProxy.getName());
    }
}

