/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.internal.sdb.util;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.models.internal.sdb.SDBPlugin;
import org.eclipse.hyades.models.internal.sdb.util.RegistryReader;
import org.eclipse.hyades.models.internal.sdb.util.ResourceExtensions;
import org.eclipse.hyades.models.internal.sdb.util.SDBXMLResourceLoader;

class ResourceRegistryReader
extends RegistryReader {
    static final String TAG_RESOURCE_LOADER = "resourceLoader";
    static final String ATT_FILE_EXTENSION = "fileExtension";
    static final String ATT_CLASS = "class";

    public ResourceRegistryReader() {
        super(Platform.getPluginRegistry(), SDBPlugin.getPlugin().getDescriptor().getUniqueIdentifier(), "sdb_resource_loader");
    }

    protected boolean readElement(IConfigurationElement iConfigurationElement) {
        if (iConfigurationElement.getName().equals(TAG_RESOURCE_LOADER)) {
            String string = iConfigurationElement.getAttribute(ATT_FILE_EXTENSION);
            if (string == null) {
                this.logMissingAttribute(iConfigurationElement, ATT_FILE_EXTENSION);
            } else if (iConfigurationElement.getAttribute(ATT_CLASS) == null) {
                this.logMissingAttribute(iConfigurationElement, ATT_CLASS);
            } else if (ResourceExtensions.getInstance().containsKey(string)) {
                this.logError(iConfigurationElement, "A resource loader for this element already exists, this loader will be ignored.");
            } else {
                try {
                    RegistryReader.PluginClassDescriptor pluginClassDescriptor = new RegistryReader.PluginClassDescriptor(iConfigurationElement, ATT_CLASS);
                    ResourceExtensions.getInstance().put(string, (SDBXMLResourceLoader)pluginClassDescriptor.createInstance());
                }
                catch (Exception exception) {
                    this.logError(iConfigurationElement, exception.getLocalizedMessage());
                }
                return true;
            }
        }
        return false;
    }
}

