/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.common.facades.behavioral.test;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.hyades.models.common.facades.behavioral.IAction;
import org.eclipse.hyades.models.common.facades.behavioral.IBlock;
import org.eclipse.hyades.models.common.facades.behavioral.ICondition;
import org.eclipse.hyades.models.common.facades.behavioral.IDecision;
import org.eclipse.hyades.models.common.facades.behavioral.IImplementor;
import org.eclipse.hyades.models.common.facades.behavioral.ILoop;
import org.eclipse.hyades.models.common.facades.behavioral.IMethod;
import org.eclipse.hyades.models.common.facades.behavioral.IProperty;
import org.eclipse.hyades.models.common.facades.behavioral.IStub;
import org.eclipse.hyades.models.common.facades.behavioral.ISystemUnderTest;
import org.eclipse.hyades.models.common.facades.behavioral.ITargetInvocation;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestInvocation;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.facades.behavioral.IVerificationPoint;
import org.eclipse.hyades.models.common.facades.behavioral.impl.FacadeResourceFactoryImpl;
import org.eclipse.hyades.models.common.facades.behavioral.impl.HyadesFactory;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofileFactory;
import org.eclipse.hyades.models.common.testprofile.impl.TPFBehaviorImpl;
import org.eclipse.hyades.models.common.testprofile.impl.TPFTestSuiteImpl;

public class ValidateFacadeImpl
extends TestCase {
    Resource suite1Resource = null;
    String xmiFile = "TempEMFFile.testsuite";
    Resource suite2Resource = null;
    String xmiFile2 = "TempEMFFile2.testsuite";

    public ValidateFacadeImpl(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("EMF Facade Impl Validation");
        testSuite.addTest((Test)new ValidateFacadeImpl("testTestSuiteCreation"));
        testSuite.addTest((Test)new ValidateFacadeImpl("testTestSuiteModification"));
        testSuite.addTest((Test)new ValidateFacadeImpl("testTestSUTRemoval"));
        testSuite.addTest((Test)new ValidateFacadeImpl("testAddActions"));
        testSuite.addTest((Test)new ValidateFacadeImpl("testRemoveActions"));
        testSuite.addTest((Test)new ValidateFacadeImpl("testAddTargetInvocation"));
        testSuite.addTest((Test)new ValidateFacadeImpl("testRemoveTargetInvocation"));
        testSuite.addTest((Test)new ValidateFacadeImpl("testAddTestInvocation"));
        testSuite.addTest((Test)new ValidateFacadeImpl("testRemoveTestInvocation"));
        testSuite.addTest((Test)new ValidateFacadeImpl("testAddDecision"));
        testSuite.addTest((Test)new ValidateFacadeImpl("testRemoveDecision"));
        testSuite.addTest((Test)new ValidateFacadeImpl("testAddLoop"));
        testSuite.addTest((Test)new ValidateFacadeImpl("testRemoveLoop"));
        testSuite.addTest((Test)new ValidateFacadeImpl("testAddProperties"));
        testSuite.addTest((Test)new ValidateFacadeImpl("testAddTestCases"));
        testSuite.addTest((Test)new ValidateFacadeImpl("testRemoveTestCases"));
        testSuite.addTest((Test)new ValidateFacadeImpl("testAddMethod"));
        testSuite.addTest((Test)new ValidateFacadeImpl("testRemoveMethod"));
        testSuite.addTest((Test)new ValidateFacadeImpl("testAddProperties"));
        testSuite.addTest((Test)new ValidateFacadeImpl("testRemoveProperties"));
        testSuite.addTest((Test)new ValidateFacadeImpl("testAddExternalImplementor"));
        testSuite.addTest((Test)new ValidateFacadeImpl("testChangeImplementorType"));
        testSuite.addTest((Test)new ValidateFacadeImpl("testGetObjectByID"));
        testSuite.addTest((Test)new ValidateFacadeImpl("testGetTestSuiteFromObject"));
        testSuite.addTest((Test)new ValidateFacadeImpl("testAddTestInvocationException"));
        testSuite.addTest((Test)new ValidateFacadeImpl("testAddMethodToTest"));
        return testSuite;
    }

    public void setUp() {
        Map map;
        Resource.Factory.Registry registry;
        URI uRI;
        File file;
        ResourceSetImpl resourceSetImpl;
        if (this.suite1Resource == null) {
            resourceSetImpl = new ResourceSetImpl();
            file = new File(this.xmiFile);
            uRI = URI.createFileURI((String)file.getAbsolutePath());
            registry = Resource.Factory.Registry.INSTANCE;
            map = registry.getExtensionToFactoryMap();
            map.put("testsuite", new FacadeResourceFactoryImpl());
            resourceSetImpl.getResourceFactoryRegistry();
            this.suite1Resource = resourceSetImpl.createResource(uRI);
        }
        if (this.suite2Resource == null) {
            resourceSetImpl = new ResourceSetImpl();
            file = new File(this.xmiFile2);
            uRI = URI.createFileURI((String)file.getAbsolutePath());
            registry = Resource.Factory.Registry.INSTANCE;
            map = registry.getExtensionToFactoryMap();
            map.put("testsuite", new FacadeResourceFactoryImpl());
            resourceSetImpl.getResourceFactoryRegistry();
            this.suite2Resource = resourceSetImpl.createResource(uRI);
        }
    }

    public void tearDown() {
    }

    public void testTestSuiteCreation() {
        ITestSuite iTestSuite = this.createTestSuite(this.suite1Resource);
        ITestCase iTestCase = this.createTestCase();
        iTestCase.setName("Test Case 1");
        iTestCase.setDescription("A simple test case");
        IImplementor iImplementor = this.createImplementor(iTestSuite, false);
        iImplementor.setName("Test Driver 1");
        iImplementor.setDescription("A test driver");
        iImplementor.setLocation("main");
        iImplementor.setResource("C:\\temp\\testDriver1.java");
        ISystemUnderTest iSystemUnderTest = this.createSystemUnderTest();
        iSystemUnderTest.setName("System Under Test 1");
        iSystemUnderTest.setDescription("A generic system under test");
        iSystemUnderTest.setLocation("");
        iSystemUnderTest.setResource("C:\\temp\\systemUnderTest1.java");
        IStub iStub = this.createStub(iTestSuite);
        iStub.setName("Stub 1");
        iStub.setDescription("A sample stub");
        iStub.setResource("c:\\temp\\stub1.java");
        iStub.setLocation("");
        iTestSuite.setName("Test Suite 1");
        iTestSuite.setDescription("A simple Test Suite with one of everythiing");
        iTestSuite.getITestCases().add(0, iTestCase);
        iTestSuite.getISystemsUnderTest().add(0, iSystemUnderTest);
        iTestSuite.getIStubs().add(0, iStub);
        Assert.assertEquals((String)"Test Suite 1", (String)iTestSuite.getName());
        Assert.assertEquals((String)"A simple Test Suite with one of everythiing", (String)iTestSuite.getDescription());
        Assert.assertEquals((Object)iTestCase, iTestSuite.getITestCases().get(0));
        Assert.assertEquals((Object)iStub, iTestSuite.getIStubs().get(0));
        Assert.assertEquals((Object)iSystemUnderTest, iTestSuite.getISystemsUnderTest().get(0));
        Assert.assertEquals((Object)iImplementor, (Object)iTestSuite.getImplementor());
        this.save(iTestSuite);
        ITestSuite iTestSuite2 = (ITestSuite)this.load();
        Assert.assertEquals((String)"Test Suite 1", (String)iTestSuite2.getName());
        Assert.assertEquals((String)"A simple Test Suite with one of everythiing", (String)iTestSuite2.getDescription());
        Assert.assertEquals((String)"Test Case 1", (String)((ITestCase)iTestSuite2.getITestCases().get(0)).getName());
        Assert.assertEquals((String)"A simple test case", (String)((ITestCase)iTestSuite2.getITestCases().get(0)).getDescription());
        Assert.assertEquals((Object)iTestSuite2, (Object)((ITestCase)iTestSuite2.getITestCases().get(0)).getOwner());
        Assert.assertEquals((String)"Stub 1", (String)((IStub)iTestSuite2.getIStubs().get(0)).getName());
        Assert.assertEquals((String)"A sample stub", (String)((IStub)iTestSuite2.getIStubs().get(0)).getDescription());
        Assert.assertEquals((String)"c:\\temp\\stub1.java", (String)((IStub)iTestSuite2.getIStubs().get(0)).getResource());
        Assert.assertEquals((String)"", (String)((IStub)iTestSuite2.getIStubs().get(0)).getLocation());
        Assert.assertEquals((Object)iTestSuite2, (Object)((IStub)iTestSuite2.getIStubs().get(0)).getOwner());
        Assert.assertEquals((String)"System Under Test 1", (String)((ISystemUnderTest)iTestSuite2.getISystemsUnderTest().get(0)).getName());
        Assert.assertEquals((String)"A generic system under test", (String)((ISystemUnderTest)iTestSuite2.getISystemsUnderTest().get(0)).getDescription());
        Assert.assertEquals((String)"C:\\temp\\systemUnderTest1.java", (String)((ISystemUnderTest)iTestSuite2.getISystemsUnderTest().get(0)).getResource());
        Assert.assertEquals((String)"", (String)((ISystemUnderTest)iTestSuite2.getISystemsUnderTest().get(0)).getLocation());
        Assert.assertEquals((Object)iTestSuite2, (Object)((ISystemUnderTest)iTestSuite2.getISystemsUnderTest().get(0)).getOwner());
        Assert.assertEquals((String)"Test Driver 1", (String)iTestSuite2.getImplementor().getName());
        Assert.assertEquals((String)"A test driver", (String)iTestSuite2.getImplementor().getDescription());
        Assert.assertEquals((String)"C:\\temp\\testDriver1.java", (String)iTestSuite2.getImplementor().getResource());
        Assert.assertEquals((String)"main", (String)iTestSuite2.getImplementor().getLocation());
        Assert.assertEquals((Object)iTestSuite2, (Object)iTestSuite2.getImplementor().getOwner());
    }

    public void testTestSUTRemoval() {
        this.createSimpleTestSuite();
        ITestSuite iTestSuite = (ITestSuite)this.load();
        iTestSuite.getISystemsUnderTest().remove(0);
        Assert.assertEquals((int)1, (int)((TPFBehaviorImpl)iTestSuite.getImplementor()).getInteraction().getLifelines().size());
        this.save(iTestSuite);
        ITestSuite iTestSuite2 = (ITestSuite)this.load();
        Assert.assertEquals((int)0, (int)iTestSuite2.getISystemsUnderTest().size());
    }

    public void testTestSuiteModification() {
        this.createSimpleTestSuite();
        ITestSuite iTestSuite = (ITestSuite)this.load();
        iTestSuite.setName("Changed Test Suite");
        iTestSuite.setDescription("A changed Test Suite");
        ISystemUnderTest iSystemUnderTest = this.createSystemUnderTest();
        ISystemUnderTest iSystemUnderTest2 = this.createSystemUnderTest();
        iSystemUnderTest.setName("System Under Test 2");
        iSystemUnderTest.setDescription("A generic system under test");
        iSystemUnderTest.setLocation("");
        iSystemUnderTest.setResource("C:\\temp\\systemUnderTest2.java");
        iSystemUnderTest2.setName("System Under Test 3");
        iSystemUnderTest2.setDescription("A generic system under test");
        iSystemUnderTest2.setLocation("");
        iSystemUnderTest2.setResource("C:\\temp\\systemUnderTest3.java");
        Vector<ISystemUnderTest> vector = new Vector<ISystemUnderTest>();
        vector.add(iSystemUnderTest);
        vector.add(iSystemUnderTest2);
        iTestSuite.getISystemsUnderTest().addAll(vector);
        this.save(iTestSuite);
        IStub iStub = this.createStub(iTestSuite);
        iStub.setName("Stub 2");
        iStub.setDescription("A second stub");
        iStub.setLocation("");
        iStub.setResource("c:\\temp\\stub2.java");
        iTestSuite.getIStubs().add(iStub);
        Assert.assertEquals((String)"Changed Test Suite", (String)iTestSuite.getName());
        Assert.assertEquals((String)"A changed Test Suite", (String)iTestSuite.getDescription());
        Assert.assertEquals((int)3, (int)iTestSuite.getISystemsUnderTest().size());
        Assert.assertEquals((Object)iSystemUnderTest, iTestSuite.getISystemsUnderTest().get(1));
        Assert.assertEquals((Object)iSystemUnderTest2, iTestSuite.getISystemsUnderTest().get(2));
        Assert.assertEquals((String)"System Under Test 2", (String)((ISystemUnderTest)iTestSuite.getISystemsUnderTest().get(1)).getName());
        Assert.assertEquals((Object)iStub, iTestSuite.getIStubs().get(1));
        this.save(iTestSuite);
        ITestSuite iTestSuite2 = (ITestSuite)this.load();
        Assert.assertEquals((String)"Changed Test Suite", (String)iTestSuite2.getName());
        Assert.assertEquals((String)"A changed Test Suite", (String)iTestSuite2.getDescription());
        Assert.assertEquals((String)"System Under Test 2", (String)((ISystemUnderTest)iTestSuite2.getISystemsUnderTest().get(1)).getName());
        Assert.assertEquals((String)"A generic system under test", (String)((ISystemUnderTest)iTestSuite2.getISystemsUnderTest().get(1)).getDescription());
        Assert.assertEquals((String)"C:\\temp\\systemUnderTest2.java", (String)((ISystemUnderTest)iTestSuite2.getISystemsUnderTest().get(1)).getResource());
        Assert.assertEquals((String)"", (String)((ISystemUnderTest)iTestSuite2.getISystemsUnderTest().get(1)).getLocation());
        Assert.assertEquals((Object)iTestSuite2, (Object)((ISystemUnderTest)iTestSuite2.getISystemsUnderTest().get(1)).getOwner());
        Assert.assertEquals((String)"System Under Test 3", (String)((ISystemUnderTest)iTestSuite2.getISystemsUnderTest().get(2)).getName());
        Assert.assertEquals((String)"A generic system under test", (String)((ISystemUnderTest)iTestSuite2.getISystemsUnderTest().get(2)).getDescription());
        Assert.assertEquals((String)"C:\\temp\\systemUnderTest3.java", (String)((ISystemUnderTest)iTestSuite2.getISystemsUnderTest().get(2)).getResource());
        Assert.assertEquals((String)"", (String)((ISystemUnderTest)iTestSuite2.getISystemsUnderTest().get(2)).getLocation());
        Assert.assertEquals((Object)iTestSuite2, (Object)((ISystemUnderTest)iTestSuite2.getISystemsUnderTest().get(2)).getOwner());
        Assert.assertEquals((String)"Stub 2", (String)((IStub)iTestSuite2.getIStubs().get(1)).getName());
        Assert.assertEquals((String)"A second stub", (String)((IStub)iTestSuite2.getIStubs().get(1)).getDescription());
        Assert.assertEquals((String)"c:\\temp\\stub2.java", (String)((IStub)iTestSuite2.getIStubs().get(1)).getResource());
        Assert.assertEquals((String)"", (String)((IStub)iTestSuite2.getIStubs().get(1)).getLocation());
        Assert.assertEquals((Object)iTestSuite2, (Object)((IStub)iTestSuite2.getIStubs().get(1)).getOwner());
        Vector vector2 = new Vector();
        vector2.add(iTestSuite2.getISystemsUnderTest().get(0));
        vector2.add(iTestSuite2.getISystemsUnderTest().get(1));
        iTestSuite2.getISystemsUnderTest().removeAll(vector2);
        Assert.assertEquals((String)"System Under Test 3", (String)((ISystemUnderTest)iTestSuite2.getISystemsUnderTest().get(0)).getName());
        Assert.assertEquals((String)"A generic system under test", (String)((ISystemUnderTest)iTestSuite2.getISystemsUnderTest().get(0)).getDescription());
        Assert.assertEquals((String)"C:\\temp\\systemUnderTest3.java", (String)((ISystemUnderTest)iTestSuite2.getISystemsUnderTest().get(0)).getResource());
        Assert.assertEquals((String)"", (String)((ISystemUnderTest)iTestSuite2.getISystemsUnderTest().get(0)).getLocation());
        Assert.assertEquals((Object)iTestSuite2, (Object)((ISystemUnderTest)iTestSuite2.getISystemsUnderTest().get(0)).getOwner());
    }

    public void testAddActions() {
        this.createSimpleTestSuite();
        ITestSuite iTestSuite = (ITestSuite)this.load();
        IImplementor iImplementor = iTestSuite.getImplementor();
        IBlock iBlock = iImplementor.getBlock();
        ISystemUnderTest iSystemUnderTest = (ISystemUnderTest)iTestSuite.getISystemsUnderTest().get(0);
        iSystemUnderTest.setDescription("An SUT with operations");
        iSystemUnderTest.setLocation("main");
        Vector<IAction> vector = new Vector<IAction>();
        IMethod iMethod = this.createMethod();
        iMethod.setName("method1");
        iMethod.setDescription("Pick me!  Pick me!!");
        iSystemUnderTest.getMethods().add(iMethod);
        ITargetInvocation iTargetInvocation = this.createTargetInvocation(iMethod);
        iTargetInvocation.setName("Target Invocation 1");
        iTargetInvocation.setDescription("A simple target invocation");
        iTargetInvocation.setSynchronous(true);
        ITestSuite iTestSuite2 = this.createTestSuite(this.suite2Resource);
        IImplementor iImplementor2 = this.createImplementor(iTestSuite2, false);
        iTestSuite2.setName("Invokable Test Suite");
        iTestSuite2.setDescription("A TestSuite to be invoked");
        this.save(iTestSuite2);
        ITestInvocation iTestInvocation = this.createTestInvocation(iTestSuite2);
        iTestInvocation.setName("Test Invocation 1");
        iTestInvocation.setDescription("A simple test invocation");
        iTestInvocation.setSynchronous(true);
        IVerificationPoint iVerificationPoint = this.createVerificationPoint();
        iVerificationPoint.setName("VP 1");
        iVerificationPoint.setDescription("A generic VP");
        vector.add(iTargetInvocation);
        vector.add(iTestInvocation);
        vector.add(iVerificationPoint);
        iBlock.getActions().addAll(vector);
        Assert.assertEquals((int)3, (int)iBlock.getActions().size());
        Assert.assertEquals((Object)iTargetInvocation, iBlock.getActions().get(0));
        Assert.assertEquals((Object)iTestInvocation, iBlock.getActions().get(1));
        Assert.assertEquals((Object)iVerificationPoint, iBlock.getActions().get(2));
        this.save(iTestSuite);
        ITestSuite iTestSuite3 = (ITestSuite)this.load();
        IBlock iBlock2 = iTestSuite3.getImplementor().getBlock();
        Assert.assertEquals((int)3, (int)iBlock2.getActions().size());
        Assert.assertEquals((String)"Target Invocation 1", (String)((ITargetInvocation)iBlock2.getActions().get(0)).getName());
        Assert.assertEquals((String)"method1", (String)((ITargetInvocation)iBlock2.getActions().get(0)).getInvocation().getName());
        Assert.assertEquals((boolean)true, (boolean)((ITargetInvocation)iBlock2.getActions().get(0)).isSynchronous());
        Assert.assertEquals((String)"Test Invocation 1", (String)((ITestInvocation)iBlock2.getActions().get(1)).getName());
        Assert.assertEquals((String)"A simple test invocation", (String)((ITestInvocation)iBlock2.getActions().get(1)).getDescription());
        Assert.assertEquals((boolean)true, (boolean)((ITestInvocation)iBlock2.getActions().get(1)).isSynchronous());
        Assert.assertEquals((String)"Invokable Test Suite", (String)((ITestInvocation)iBlock2.getActions().get(1)).getInvokedTest().getName());
        Assert.assertEquals((String)"VP 1", (String)((IVerificationPoint)iBlock2.getActions().get(2)).getName());
        Assert.assertEquals((String)"A generic VP", (String)((IVerificationPoint)iBlock2.getActions().get(2)).getDescription());
    }

    public void testRemoveActions() {
        this.testAddActions();
        ITestSuite iTestSuite = (ITestSuite)this.load();
        IImplementor iImplementor = iTestSuite.getImplementor();
        IBlock iBlock = iImplementor.getBlock();
        IAction iAction = (IAction)iBlock.getActions().get(0);
        IAction iAction2 = (IAction)iBlock.getActions().get(1);
        Vector<IAction> vector = new Vector<IAction>();
        vector.add(iAction);
        vector.add(iAction2);
        iBlock.getActions().removeAll(vector);
        Assert.assertEquals((int)1, (int)iBlock.getActions().size());
        Assert.assertTrue((boolean)(iBlock.getActions().get(0) instanceof IVerificationPoint));
        this.save(iTestSuite);
        ITestSuite iTestSuite2 = (ITestSuite)this.load();
        IBlock iBlock2 = iTestSuite2.getImplementor().getBlock();
        Assert.assertEquals((int)1, (int)iBlock2.getActions().size());
        Assert.assertEquals((String)"VP 1", (String)((IVerificationPoint)iBlock2.getActions().get(0)).getName());
        Assert.assertEquals((String)"A generic VP", (String)((IVerificationPoint)iBlock2.getActions().get(0)).getDescription());
    }

    public void testAddTargetInvocation() {
        this.createSimpleTestSuite();
        ITestSuite iTestSuite = (ITestSuite)this.load();
        IImplementor iImplementor = iTestSuite.getImplementor();
        IBlock iBlock = iImplementor.getBlock();
        ISystemUnderTest iSystemUnderTest = (ISystemUnderTest)iTestSuite.getISystemsUnderTest().get(0);
        iSystemUnderTest.setDescription("An SUT with operations");
        iSystemUnderTest.setLocation("main");
        IMethod iMethod = this.createMethod();
        iMethod.setName("method1");
        iMethod.setDescription("Pick me!  Pick me!!");
        iSystemUnderTest.getMethods().add(iMethod);
        ITargetInvocation iTargetInvocation = this.createTargetInvocation(iMethod);
        iTargetInvocation.setName("Target Invocation 1");
        iTargetInvocation.setDescription("A simple target invocation");
        iTargetInvocation.setSynchronous(true);
        iBlock.getActions().add(0, iTargetInvocation);
        Assert.assertEquals((Object)iTargetInvocation, iBlock.getActions().get(0));
        this.save(iTestSuite);
        ITestSuite iTestSuite2 = (ITestSuite)this.load();
        IImplementor iImplementor2 = iTestSuite2.getImplementor();
        IAction iAction = (IAction)iImplementor2.getBlock().getActions().get(0);
        Assert.assertEquals((String)"Target Invocation 1", (String)iAction.getName());
        Assert.assertEquals((String)"method1", (String)((ITargetInvocation)iAction).getInvocation().getName());
        Assert.assertEquals((boolean)true, (boolean)((ITargetInvocation)iAction).isSynchronous());
    }

    public void testRemoveTargetInvocation() {
        this.testAddTargetInvocation();
        ITestSuite iTestSuite = (ITestSuite)this.load();
        IImplementor iImplementor = iTestSuite.getImplementor();
        IBlock iBlock = iImplementor.getBlock();
        iBlock.getActions().remove(0);
        this.save(iTestSuite);
        ITestSuite iTestSuite2 = (ITestSuite)this.load();
        IImplementor iImplementor2 = iTestSuite2.getImplementor();
        Assert.assertEquals((int)0, (int)iImplementor2.getBlock().getActions().size());
    }

    public void testAddTestInvocation() {
        this.createSimpleTestSuite();
        ITestSuite iTestSuite = (ITestSuite)this.load();
        IImplementor iImplementor = iTestSuite.getImplementor();
        IBlock iBlock = iImplementor.getBlock();
        ITestSuite iTestSuite2 = this.createTestSuite(this.suite2Resource);
        IImplementor iImplementor2 = this.createImplementor(iTestSuite2, false);
        iTestSuite2.setName("Invokable Test Suite");
        iTestSuite2.setDescription("A TestSuite to be invoked");
        this.save(iTestSuite2);
        ITestInvocation iTestInvocation = this.createTestInvocation(iTestSuite2);
        iTestInvocation.setName("Test Invocation 1");
        iTestInvocation.setDescription("A simple test invocation");
        iTestInvocation.setSynchronous(true);
        iBlock.getActions().add(0, iTestInvocation);
        Assert.assertEquals((Object)iTestInvocation, (Object)((ITestInvocation)iTestSuite.getImplementor().getBlock().getActions().get(0)));
        this.save(iTestSuite);
        ITestSuite iTestSuite3 = (ITestSuite)this.load();
        IImplementor iImplementor3 = iTestSuite3.getImplementor();
        IAction iAction = (IAction)iImplementor3.getBlock().getActions().get(0);
        Assert.assertEquals((String)"Test Invocation 1", (String)iAction.getName());
        Assert.assertEquals((String)"A simple test invocation", (String)iAction.getDescription());
        Assert.assertEquals((boolean)true, (boolean)((ITestInvocation)iAction).isSynchronous());
        Assert.assertEquals((String)"Invokable Test Suite", (String)((ITestInvocation)iAction).getInvokedTest().getName());
    }

    public void testRemoveTestInvocation() {
        this.testAddTestInvocation();
        ITestSuite iTestSuite = (ITestSuite)this.load();
        IImplementor iImplementor = iTestSuite.getImplementor();
        IBlock iBlock = iImplementor.getBlock();
        iBlock.getActions().remove(0);
        Assert.assertEquals((int)0, (int)iBlock.getActions().size());
        this.save(iTestSuite);
        ITestSuite iTestSuite2 = (ITestSuite)this.load();
        Assert.assertEquals((int)0, (int)iTestSuite2.getImplementor().getBlock().getActions().size());
    }

    public void testAddDecision() {
        this.createSimpleTestSuite();
        ITestSuite iTestSuite = (ITestSuite)this.load();
        IImplementor iImplementor = iTestSuite.getImplementor();
        IBlock iBlock = iImplementor.getBlock();
        Vector<IAction> vector = new Vector<IAction>();
        ITestSuite iTestSuite2 = this.createTestSuite(this.suite2Resource);
        IImplementor iImplementor2 = this.createImplementor(iTestSuite2, false);
        iTestSuite2.setName("Invokable Test Suite");
        iTestSuite2.setDescription("A TestSuite to be invoked");
        this.save(iTestSuite2);
        IVerificationPoint iVerificationPoint = this.createVerificationPoint();
        iVerificationPoint.setName("VP 1");
        iVerificationPoint.setDescription("A generic VP");
        ISystemUnderTest iSystemUnderTest = (ISystemUnderTest)iTestSuite.getISystemsUnderTest().get(0);
        IMethod iMethod = this.createMethod();
        iMethod.setName("method1");
        iMethod.setDescription("Pick me!  Pick me!!");
        iSystemUnderTest.getMethods().add(iMethod);
        ITargetInvocation iTargetInvocation = this.createTargetInvocation(iMethod);
        iTargetInvocation.setName("Target Invocation 1");
        iTargetInvocation.setDescription("A simple target invocation");
        ITestInvocation iTestInvocation = this.createTestInvocation(iTestSuite2);
        iTestInvocation.setName("Test Invocation 1");
        iTestInvocation.setDescription("A simple test invocation");
        IDecision iDecision = this.createDecision();
        iBlock.getActions().add(iDecision);
        ICondition iCondition = iDecision.getCondition();
        iCondition.setConstraint("i>5");
        iCondition.setName("Condition 1");
        iCondition.setDescription("Less than 5");
        iDecision.getSuccessBlock().getActions().add(iTestInvocation);
        iDecision.getSuccessBlock().getActions().add(iVerificationPoint);
        IDecision iDecision2 = this.createDecision();
        iDecision2.setName("Nested Decision");
        vector.add(iTargetInvocation);
        vector.add(iDecision2);
        iDecision.getFailureBlock().getActions().addAll(vector);
        IImplementor iImplementor3 = iTestSuite.getImplementor();
        IAction iAction = (IAction)iImplementor3.getBlock().getActions().get(0);
        Assert.assertEquals((Object)iDecision, (Object)iAction);
        Assert.assertEquals((String)"i>5", (String)((IDecision)iAction).getCondition().getConstraint());
        Assert.assertEquals((int)2, (int)((IDecision)iAction).getSuccessBlock().getActions().size());
        Assert.assertEquals((int)2, (int)((IDecision)iAction).getFailureBlock().getActions().size());
        Assert.assertEquals((Object)iTestSuite2, (Object)((ITestInvocation)((IDecision)iAction).getSuccessBlock().getActions().get(0)).getInvokedTest());
        Assert.assertEquals((Object)iTestInvocation, ((IDecision)iAction).getSuccessBlock().getActions().get(0));
        Assert.assertEquals((Object)iVerificationPoint, ((IDecision)iAction).getSuccessBlock().getActions().get(1));
        Assert.assertEquals((Object)iTargetInvocation, ((IDecision)iAction).getFailureBlock().getActions().get(0));
        Assert.assertEquals((Object)iDecision2, ((IDecision)iAction).getFailureBlock().getActions().get(1));
        this.save(iTestSuite);
        ITestSuite iTestSuite3 = (ITestSuite)this.load();
        iImplementor3 = iTestSuite3.getImplementor();
        iAction = (IAction)iImplementor3.getBlock().getActions().get(0);
        IDecision iDecision3 = (IDecision)iAction;
        Assert.assertEquals((String)"i>5", (String)iDecision3.getCondition().getConstraint());
        Assert.assertEquals((int)2, (int)iDecision3.getSuccessBlock().getActions().size());
        Assert.assertEquals((int)2, (int)iDecision3.getFailureBlock().getActions().size());
        Assert.assertEquals((String)"Test Invocation 1", (String)((ITestInvocation)iDecision3.getSuccessBlock().getActions().get(0)).getName());
        Assert.assertEquals((String)"A simple test invocation", (String)((ITestInvocation)iDecision3.getSuccessBlock().getActions().get(0)).getDescription());
        Assert.assertEquals((String)iTestSuite2.getName(), (String)((ITestInvocation)iDecision3.getSuccessBlock().getActions().get(0)).getInvokedTest().getName());
        Assert.assertEquals((String)"VP 1", (String)((IVerificationPoint)iDecision3.getSuccessBlock().getActions().get(1)).getName());
        Assert.assertEquals((String)"A generic VP", (String)((IVerificationPoint)iDecision3.getSuccessBlock().getActions().get(1)).getDescription());
        Assert.assertEquals((String)"Target Invocation 1", (String)((ITargetInvocation)iDecision3.getFailureBlock().getActions().get(0)).getName());
        Assert.assertEquals((String)"A simple target invocation", (String)((ITargetInvocation)iDecision3.getFailureBlock().getActions().get(0)).getDescription());
        Assert.assertEquals((String)"Nested Decision", (String)((IDecision)iDecision3.getFailureBlock().getActions().get(1)).getName());
    }

    public void testRemoveDecision() {
        this.testAddDecision();
        ITestSuite iTestSuite = (ITestSuite)this.load();
        IImplementor iImplementor = iTestSuite.getImplementor();
        IBlock iBlock = iImplementor.getBlock();
        IDecision iDecision = (IDecision)iBlock.getActions().get(0);
        iDecision.getFailureBlock().getActions().remove(1);
        Assert.assertEquals((int)1, (int)iDecision.getFailureBlock().getActions().size());
        Assert.assertTrue((!(iDecision.getFailureBlock().getActions().get(0) instanceof IDecision) ? 1 : 0) != 0);
        Vector vector = new Vector();
        vector.add(iDecision.getSuccessBlock().getActions().get(0));
        iDecision.getSuccessBlock().getActions().removeAll(vector);
        Assert.assertEquals((int)1, (int)iDecision.getSuccessBlock().getActions().size());
        Assert.assertTrue((boolean)(iDecision.getSuccessBlock().getActions().get(0) instanceof IVerificationPoint));
        iBlock.getActions().remove(0);
        Assert.assertEquals((int)0, (int)iBlock.getActions().size());
        this.save(iTestSuite);
        ITestSuite iTestSuite2 = (ITestSuite)this.load();
        Assert.assertEquals((int)0, (int)iTestSuite2.getImplementor().getBlock().getActions().size());
    }

    public void testAddLoop() {
        this.createSimpleTestSuite();
        ITestSuite iTestSuite = (ITestSuite)this.load();
        IImplementor iImplementor = iTestSuite.getImplementor();
        IBlock iBlock = iImplementor.getBlock();
        Vector<IAction> vector = new Vector<IAction>();
        ITestSuite iTestSuite2 = this.createTestSuite(this.suite2Resource);
        IImplementor iImplementor2 = this.createImplementor(iTestSuite2, false);
        iTestSuite2.setName("Invokable Test Suite");
        iTestSuite2.setDescription("A TestSuite to be invoked");
        this.save(iTestSuite2);
        IVerificationPoint iVerificationPoint = this.createVerificationPoint();
        iVerificationPoint.setName("VP 1");
        iVerificationPoint.setDescription("A generic VP");
        ITestInvocation iTestInvocation = this.createTestInvocation(iTestSuite2);
        iTestInvocation.setName("Test Invocation 1");
        iTestInvocation.setDescription("A simple test invocation");
        ILoop iLoop = this.createLoop();
        iBlock.getActions().add(iLoop);
        vector.add(iTestInvocation);
        vector.add(iVerificationPoint);
        iLoop.getBlock().getActions().addAll(vector);
        iLoop.getCondition().setConstraint("int i = 0; i < 5; i++");
        ILoop iLoop2 = this.createLoop();
        iLoop2.setName("Nested Loop");
        iLoop2.getCondition().setConstraint("true");
        iLoop.getBlock().getActions().add(iLoop2);
        IImplementor iImplementor3 = iTestSuite.getImplementor();
        IAction iAction = (IAction)iImplementor3.getBlock().getActions().get(0);
        Assert.assertEquals((Object)iLoop, (Object)iAction);
        Assert.assertEquals((String)"int i = 0; i < 5; i++", (String)((ILoop)iAction).getCondition().getConstraint());
        Assert.assertEquals((int)3, (int)((ILoop)iAction).getBlock().getActions().size());
        Assert.assertEquals((Object)iTestSuite2, (Object)((ITestInvocation)((ILoop)iAction).getBlock().getActions().get(0)).getInvokedTest());
        Assert.assertEquals((Object)iTestInvocation, ((ILoop)iAction).getBlock().getActions().get(0));
        Assert.assertEquals((Object)iVerificationPoint, ((ILoop)iAction).getBlock().getActions().get(1));
        Assert.assertEquals((Object)iLoop2, ((ILoop)iAction).getBlock().getActions().get(2));
        this.save(iTestSuite);
        ITestSuite iTestSuite3 = (ITestSuite)this.load();
        iImplementor3 = iTestSuite3.getImplementor();
        iAction = (IAction)iImplementor3.getBlock().getActions().get(0);
        ILoop iLoop3 = (ILoop)iAction;
        Assert.assertEquals((String)"int i = 0; i < 5; i++", (String)iLoop3.getCondition().getConstraint());
        Assert.assertEquals((int)3, (int)iLoop3.getBlock().getActions().size());
        Assert.assertEquals((String)"Test Invocation 1", (String)((ITestInvocation)iLoop3.getBlock().getActions().get(0)).getName());
        Assert.assertEquals((String)"A simple test invocation", (String)((ITestInvocation)iLoop3.getBlock().getActions().get(0)).getDescription());
        Assert.assertEquals((String)iTestSuite2.getName(), (String)((ITestInvocation)iLoop3.getBlock().getActions().get(0)).getInvokedTest().getName());
        Assert.assertEquals((String)"VP 1", (String)((IVerificationPoint)iLoop3.getBlock().getActions().get(1)).getName());
        Assert.assertEquals((String)"A generic VP", (String)((IVerificationPoint)iLoop3.getBlock().getActions().get(1)).getDescription());
        Assert.assertEquals((String)"Nested Loop", (String)((ILoop)iLoop3.getBlock().getActions().get(2)).getName());
    }

    public void testRemoveLoop() {
        this.testAddLoop();
        ITestSuite iTestSuite = (ITestSuite)this.load();
        IImplementor iImplementor = iTestSuite.getImplementor();
        IBlock iBlock = iImplementor.getBlock();
        ILoop iLoop = (ILoop)iBlock.getActions().get(0);
        iLoop.getBlock().getActions().remove(2);
        Assert.assertEquals((int)2, (int)iLoop.getBlock().getActions().size());
        Assert.assertTrue((!(iLoop.getBlock().getActions().get(0) instanceof ILoop) ? 1 : 0) != 0);
        Assert.assertTrue((!(iLoop.getBlock().getActions().get(1) instanceof ILoop) ? 1 : 0) != 0);
        Vector vector = new Vector();
        vector.add(iLoop.getBlock().getActions().get(0));
        vector.add(iLoop.getBlock().getActions().get(1));
        iLoop.getBlock().getActions().removeAll(vector);
        Assert.assertEquals((int)0, (int)iLoop.getBlock().getActions().size());
        iBlock.getActions().remove(0);
        Assert.assertEquals((int)0, (int)iBlock.getActions().size());
        this.save(iTestSuite);
        ITestSuite iTestSuite2 = (ITestSuite)this.load();
        Assert.assertEquals((int)0, (int)iTestSuite2.getImplementor().getBlock().getActions().size());
    }

    public void testAddProperties() {
        this.createSimpleTestSuite();
        ITestSuite iTestSuite = (ITestSuite)this.load();
        IImplementor iImplementor = iTestSuite.getImplementor();
        IBlock iBlock = iImplementor.getBlock();
        IVerificationPoint iVerificationPoint = this.createVerificationPoint();
        iVerificationPoint.setName("VP 1");
        iVerificationPoint.setDescription("A generic VP");
        IProperty iProperty = this.createProperty();
        iProperty.setName("prop1");
        iProperty.setDescription("The frist property");
        iProperty.setValue("foo");
        IProperty iProperty2 = this.createProperty();
        iProperty2.setName("Prop2");
        iProperty2.setDescription("The second property");
        iProperty2.setValue("bar");
        iVerificationPoint.getActionProperties().getProperties().add(0, iProperty);
        iVerificationPoint.getActionProperties().getProperties().add(1, iProperty2);
        iBlock.getActions().add(iVerificationPoint);
        Assert.assertEquals((Object)iProperty, (Object)((IAction)iBlock.getActions().get(0)).getActionProperties().getPropertyByName("prop1"));
        Assert.assertEquals((Object)iProperty2, (Object)((IProperty)((IAction)iBlock.getActions().get(0)).getActionProperties().getProperties().get(1)));
        this.save(iTestSuite);
        ITestSuite iTestSuite2 = (ITestSuite)this.load();
        IImplementor iImplementor2 = iTestSuite2.getImplementor();
        IAction iAction = (IAction)iImplementor2.getBlock().getActions().get(0);
        Assert.assertEquals((String)"foo", (String)iAction.getActionProperties().getPropertyByName("prop1").getValue());
        Assert.assertEquals((String)"bar", (String)((IProperty)iAction.getActionProperties().getProperties().get(1)).getValue());
    }

    public void testRemoveProperties() {
        this.testAddProperties();
        ITestSuite iTestSuite = (ITestSuite)this.load();
        IImplementor iImplementor = iTestSuite.getImplementor();
        IBlock iBlock = iImplementor.getBlock();
        IAction iAction = (IAction)iBlock.getActions().get(0);
        iAction.getActionProperties().getProperties().remove(0);
        Assert.assertEquals((int)1, (int)iAction.getActionProperties().getProperties().size());
        Assert.assertEquals((String)"bar", (String)iAction.getActionProperties().getPropertyByName("Prop2").getValue());
        this.save(iTestSuite);
        ITestSuite iTestSuite2 = (ITestSuite)this.load();
        IImplementor iImplementor2 = iTestSuite2.getImplementor();
        IAction iAction2 = (IAction)iImplementor2.getBlock().getActions().get(0);
        Assert.assertEquals((int)1, (int)iAction2.getActionProperties().getProperties().size());
        Assert.assertEquals((String)"bar", (String)iAction2.getActionProperties().getPropertyByName("Prop2").getValue());
        Assert.assertEquals((String)"bar", (String)((IProperty)iAction2.getActionProperties().getProperties().get(0)).getValue());
    }

    public void testAddExternalImplementor() {
        this.createBlankTestSuite();
        ITestSuite iTestSuite = (ITestSuite)this.load();
        IImplementor iImplementor = this.createImplementor(iTestSuite, true);
        iImplementor.setName("An External Implementor");
        iImplementor.setLocation("main");
        iImplementor.setResource("ExternalImplementor.java");
        Assert.assertEquals((boolean)true, (boolean)iImplementor.isExternalImplementor());
        Assert.assertEquals((Object)iImplementor, (Object)iTestSuite.getImplementor());
        this.save(iTestSuite);
        ITestSuite iTestSuite2 = (ITestSuite)this.load();
        Assert.assertNotNull((Object)iTestSuite.getImplementor());
        IImplementor iImplementor2 = iTestSuite2.getImplementor();
        Assert.assertEquals((boolean)true, (boolean)iImplementor2.isExternalImplementor());
        Assert.assertEquals((String)"main", (String)iImplementor2.getLocation());
        Assert.assertNull((Object)iImplementor2.getBlock());
    }

    public void testChangeImplementorType() {
        this.testAddExternalImplementor();
        ITestSuite iTestSuite = (ITestSuite)this.load();
        IImplementor iImplementor = this.createImplementor(iTestSuite, false);
        iImplementor.setName("An Modeled Implementor");
        iImplementor.setLocation("main");
        iImplementor.setResource("ModeledImplementor.java");
        Assert.assertEquals((boolean)false, (boolean)iImplementor.isExternalImplementor());
        Assert.assertEquals((Object)iImplementor, (Object)iTestSuite.getImplementor());
        this.save(iTestSuite);
        ITestSuite iTestSuite2 = (ITestSuite)this.load();
        Assert.assertNotNull((Object)iTestSuite.getImplementor());
        IImplementor iImplementor2 = iTestSuite2.getImplementor();
        Assert.assertEquals((boolean)false, (boolean)iImplementor2.isExternalImplementor());
        Assert.assertEquals((String)"main", (String)iImplementor2.getLocation());
        Assert.assertNotNull((Object)iImplementor2.getBlock());
        Assert.assertEquals((int)0, (int)iImplementor2.getBlock().getActions().size());
    }

    public void testAddTestCases() {
        ITestSuite iTestSuite = this.createBlankTestSuite();
        ITestCase iTestCase = this.createTestCase();
        iTestCase.setName("TestCase1");
        iTestCase.setDescription("A Test Case to test the get Method");
        ITestCase iTestCase2 = this.createTestCase();
        iTestCase2.setName("TestCase2");
        iTestCase2.setDescription("A Test Case to test the put Method");
        ITestCase iTestCase3 = this.createTestCase();
        iTestCase3.setName("TestCase3");
        iTestCase3.setDescription("A Test Case to test the get Method");
        ITestCase iTestCase4 = this.createTestCase();
        iTestCase4.setName("TestCase4");
        iTestCase4.setDescription("A Test Case to test the put Method");
        Vector<ITestCase> vector = new Vector<ITestCase>();
        vector.add(iTestCase3);
        vector.add(iTestCase4);
        List list = iTestSuite.getITestCases();
        list.add(iTestCase);
        list.add(iTestCase2);
        list.addAll(vector);
        IImplementor iImplementor = this.createImplementor(iTestCase, false);
        iImplementor.setName("TestCase1Implementor");
        iImplementor.setDescription("An Implementor for test case 1");
        iImplementor.setResource("TestCase1.java");
        iImplementor.setLocation("main");
        IImplementor iImplementor2 = this.createImplementor(iTestCase2, false);
        iImplementor2.setName("TestCase2Implementor");
        iImplementor2.setDescription("An Implementor for test case 2");
        iImplementor2.setResource("TestCase2.java");
        iImplementor2.setLocation("main");
        ISystemUnderTest iSystemUnderTest = this.createSystemUnderTest();
        iSystemUnderTest.setName("SUT1");
        iSystemUnderTest.setDescription("A system under test");
        iSystemUnderTest.setResource("SystemUnderTest1.java");
        iSystemUnderTest.setLocation("main");
        List list2 = iTestSuite.getISystemsUnderTest();
        list2.add(iSystemUnderTest);
        IBlock iBlock = iImplementor.getBlock();
        List list3 = iBlock.getActions();
        IBlock iBlock2 = iImplementor2.getBlock();
        List list4 = iBlock2.getActions();
        IMethod iMethod = this.createMethod();
        iMethod.setName("method1");
        iMethod.setDescription("The first method");
        iSystemUnderTest.getMethods().add(iMethod);
        IMethod iMethod2 = this.createMethod();
        iMethod2.setName("method2");
        iMethod2.setDescription("The second method");
        iSystemUnderTest.getMethods().add(iMethod2);
        ITargetInvocation iTargetInvocation = this.createTargetInvocation(iMethod);
        iTargetInvocation.setName("Invocation of method1");
        iTargetInvocation.setDescription("A invocation of the first method");
        ITargetInvocation iTargetInvocation2 = this.createTargetInvocation(iMethod2);
        iTargetInvocation2.setName("Invocation of method2");
        iTargetInvocation2.setDescription("A invocation of the second method");
        list3.add(iTargetInvocation);
        list4.add(iTargetInvocation2);
        Assert.assertEquals((int)4, (int)iTestSuite.getITestCases().size());
        Assert.assertEquals((int)1, (int)iTestSuite.getISystemsUnderTest().size());
        Assert.assertEquals((Object)iTestCase, (Object)((ITestCase)iTestSuite.getITestCases().get(0)));
        Assert.assertEquals((Object)iTestCase2, (Object)((ITestCase)iTestSuite.getITestCases().get(1)));
        Assert.assertEquals((Object)iTestCase3, (Object)((ITestCase)iTestSuite.getITestCases().get(2)));
        Assert.assertEquals((Object)iTestCase4, (Object)((ITestCase)iTestSuite.getITestCases().get(3)));
        Assert.assertEquals((Object)iSystemUnderTest, (Object)((ISystemUnderTest)iTestSuite.getISystemsUnderTest().get(0)));
        Assert.assertEquals((Object)iImplementor, (Object)((ITestCase)iTestSuite.getITestCases().get(0)).getImplementor());
        Assert.assertEquals((Object)iImplementor2, (Object)((ITestCase)iTestSuite.getITestCases().get(1)).getImplementor());
        Assert.assertEquals((int)2, (int)((ISystemUnderTest)iTestSuite.getISystemsUnderTest().get(0)).getMethods().size());
        Assert.assertEquals((Object)iMethod, (Object)((IMethod)((ISystemUnderTest)iTestSuite.getISystemsUnderTest().get(0)).getMethods().get(0)));
        Assert.assertEquals((Object)iMethod2, (Object)((IMethod)((ISystemUnderTest)iTestSuite.getISystemsUnderTest().get(0)).getMethods().get(1)));
        Assert.assertEquals((int)1, (int)((ITestCase)iTestSuite.getITestCases().get(0)).getImplementor().getBlock().getActions().size());
        Assert.assertEquals((int)1, (int)((ITestCase)iTestSuite.getITestCases().get(1)).getImplementor().getBlock().getActions().size());
        Assert.assertEquals((Object)iTargetInvocation, (Object)((ITargetInvocation)((ITestCase)iTestSuite.getITestCases().get(0)).getImplementor().getBlock().getActions().get(0)));
        Assert.assertEquals((Object)iTargetInvocation2, (Object)((ITargetInvocation)((ITestCase)iTestSuite.getITestCases().get(1)).getImplementor().getBlock().getActions().get(0)));
        this.save(iTestSuite);
        ITestSuite iTestSuite2 = (ITestSuite)this.load();
        Assert.assertEquals((int)4, (int)iTestSuite2.getITestCases().size());
        Assert.assertEquals((int)1, (int)iTestSuite2.getISystemsUnderTest().size());
        ITestCase iTestCase5 = (ITestCase)iTestSuite.getITestCases().get(0);
        ITestCase iTestCase6 = (ITestCase)iTestSuite.getITestCases().get(1);
        ITestCase iTestCase7 = (ITestCase)iTestSuite.getITestCases().get(2);
        ITestCase iTestCase8 = (ITestCase)iTestSuite.getITestCases().get(3);
        Assert.assertEquals((String)"TestCase1", (String)iTestCase5.getName());
        Assert.assertEquals((String)"TestCase2", (String)iTestCase6.getName());
        Assert.assertEquals((String)"TestCase3", (String)iTestCase7.getName());
        Assert.assertEquals((String)"TestCase4", (String)iTestCase8.getName());
        Assert.assertEquals((String)"TestCase1Implementor", (String)iTestCase5.getImplementor().getName());
        Assert.assertEquals((String)"TestCase2Implementor", (String)iTestCase6.getImplementor().getName());
        Assert.assertEquals((int)1, (int)iTestCase5.getImplementor().getBlock().getActions().size());
        Assert.assertEquals((int)1, (int)iTestCase6.getImplementor().getBlock().getActions().size());
        ITargetInvocation iTargetInvocation3 = (ITargetInvocation)iTestCase5.getImplementor().getBlock().getActions().get(0);
        ITargetInvocation iTargetInvocation4 = (ITargetInvocation)iTestCase6.getImplementor().getBlock().getActions().get(0);
        Assert.assertEquals((String)"Invocation of method1", (String)iTargetInvocation3.getName());
        Assert.assertEquals((String)"Invocation of method2", (String)iTargetInvocation4.getName());
        Assert.assertEquals((String)"SUT1", (String)iTargetInvocation3.getTarget().getName());
        Assert.assertEquals((String)"SUT1", (String)iTargetInvocation4.getTarget().getName());
        ISystemUnderTest iSystemUnderTest2 = (ISystemUnderTest)iTestSuite2.getISystemsUnderTest().get(0);
        Assert.assertEquals((int)2, (int)iSystemUnderTest2.getMethods().size());
        Assert.assertEquals((String)"method1", (String)((IMethod)iSystemUnderTest2.getMethods().get(0)).getName());
        Assert.assertEquals((String)"method2", (String)((IMethod)iSystemUnderTest2.getMethods().get(1)).getName());
    }

    public void testRemoveTestCases() {
        this.testAddTestCases();
        ITestSuite iTestSuite = (ITestSuite)this.load();
        iTestSuite.getITestCases().remove(0);
        Assert.assertEquals((int)3, (int)iTestSuite.getITestCases().size());
        Assert.assertEquals((int)1, (int)iTestSuite.getISystemsUnderTest().size());
        ITestCase iTestCase = (ITestCase)iTestSuite.getITestCases().get(0);
        Assert.assertEquals((String)"TestCase2", (String)iTestCase.getName());
        Assert.assertEquals((String)"TestCase2Implementor", (String)iTestCase.getImplementor().getName());
        Assert.assertEquals((int)1, (int)iTestCase.getImplementor().getBlock().getActions().size());
        ITargetInvocation iTargetInvocation = (ITargetInvocation)iTestCase.getImplementor().getBlock().getActions().get(0);
        Assert.assertEquals((String)"Invocation of method2", (String)iTargetInvocation.getName());
        Assert.assertEquals((String)"SUT1", (String)iTargetInvocation.getTarget().getName());
        ISystemUnderTest iSystemUnderTest = (ISystemUnderTest)iTestSuite.getISystemsUnderTest().get(0);
        Assert.assertEquals((int)2, (int)iSystemUnderTest.getMethods().size());
        Assert.assertEquals((String)"method1", (String)((IMethod)iSystemUnderTest.getMethods().get(0)).getName());
        Assert.assertEquals((String)"method2", (String)((IMethod)iSystemUnderTest.getMethods().get(1)).getName());
        Vector vector = new Vector();
        vector.add(iTestSuite.getITestCases().get(1));
        vector.add(iTestSuite.getITestCases().get(2));
        iTestSuite.getITestCases().removeAll(vector);
        Assert.assertEquals((int)1, (int)iTestSuite.getITestCases().size());
        this.save(iTestSuite);
        ITestSuite iTestSuite2 = (ITestSuite)this.load();
        Assert.assertEquals((int)1, (int)iTestSuite2.getITestCases().size());
        Assert.assertEquals((int)1, (int)iTestSuite2.getISystemsUnderTest().size());
        iTestCase = (ITestCase)iTestSuite2.getITestCases().get(0);
        Assert.assertEquals((String)"TestCase2", (String)iTestCase.getName());
        Assert.assertEquals((String)"TestCase2Implementor", (String)iTestCase.getImplementor().getName());
        Assert.assertEquals((int)1, (int)iTestCase.getImplementor().getBlock().getActions().size());
        iTargetInvocation = (ITargetInvocation)iTestCase.getImplementor().getBlock().getActions().get(0);
        Assert.assertEquals((String)"Invocation of method2", (String)iTargetInvocation.getName());
        Assert.assertEquals((String)"SUT1", (String)iTargetInvocation.getTarget().getName());
        iSystemUnderTest = (ISystemUnderTest)iTestSuite2.getISystemsUnderTest().get(0);
        Assert.assertEquals((int)2, (int)iSystemUnderTest.getMethods().size());
        Assert.assertEquals((String)"method1", (String)((IMethod)iSystemUnderTest.getMethods().get(0)).getName());
        Assert.assertEquals((String)"method2", (String)((IMethod)iSystemUnderTest.getMethods().get(1)).getName());
    }

    public void testAddMethod() {
        this.createSimpleTestSuite();
        ITestSuite iTestSuite = (ITestSuite)this.load();
        IImplementor iImplementor = iTestSuite.getImplementor();
        IBlock iBlock = iImplementor.getBlock();
        ISystemUnderTest iSystemUnderTest = (ISystemUnderTest)iTestSuite.getISystemsUnderTest().get(0);
        iSystemUnderTest.setDescription("An SUT with operations");
        iSystemUnderTest.setLocation("main");
        IMethod iMethod = this.createMethod();
        iMethod.setName("method1");
        iMethod.setDescription("Pick me!  Pick me!!");
        iSystemUnderTest.getMethods().add(iMethod);
        Assert.assertEquals((Object)iMethod, (Object)((IMethod)iSystemUnderTest.getMethods().get(0)));
        this.save(iTestSuite);
        ITestSuite iTestSuite2 = (ITestSuite)this.load();
        Assert.assertEquals((int)1, (int)iTestSuite2.getISystemsUnderTest().size());
        ISystemUnderTest iSystemUnderTest2 = (ISystemUnderTest)iTestSuite2.getISystemsUnderTest().get(0);
        Assert.assertEquals((int)1, (int)iSystemUnderTest2.getMethods().size());
        IMethod iMethod2 = (IMethod)iSystemUnderTest2.getMethods().get(0);
        Assert.assertEquals((String)"method1", (String)iMethod2.getName());
    }

    public void testRemoveMethod() {
        ITestSuite iTestSuite = this.createSimpleTestSuite();
        this.testAddMethod();
        iTestSuite = (ITestSuite)this.load();
        ISystemUnderTest iSystemUnderTest = (ISystemUnderTest)iTestSuite.getISystemsUnderTest().get(0);
        iSystemUnderTest.getMethods().remove(0);
        Assert.assertEquals((int)0, (int)iSystemUnderTest.getMethods().size());
        this.save(iTestSuite);
        ITestSuite iTestSuite2 = (ITestSuite)this.load();
        Assert.assertEquals((int)1, (int)iTestSuite2.getISystemsUnderTest().size());
        ISystemUnderTest iSystemUnderTest2 = (ISystemUnderTest)iTestSuite2.getISystemsUnderTest().get(0);
        Assert.assertEquals((int)0, (int)iSystemUnderTest2.getMethods().size());
    }

    public void testGetObjectByID() {
        this.createSimpleTestSuite();
        ITestSuite iTestSuite = (ITestSuite)this.load();
        ISystemUnderTest iSystemUnderTest = this.createSystemUnderTest();
        iSystemUnderTest.setName("System Under Test 2");
        iSystemUnderTest.setDescription("A generic system under test");
        iSystemUnderTest.setLocation("");
        iSystemUnderTest.setResource("C:\\temp\\systemUnderTest2.java");
        String string = iSystemUnderTest.getId();
        Assert.assertNull((Object)HyadesFactory.INSTANCE.getObjectByID(iTestSuite, string));
        iTestSuite.getISystemsUnderTest().add(iSystemUnderTest);
        Assert.assertEquals((Object)iSystemUnderTest, (Object)HyadesFactory.INSTANCE.getObjectByID(iTestSuite, string));
        this.save(iTestSuite);
        ITestSuite iTestSuite2 = (ITestSuite)this.load();
        Assert.assertEquals((String)"System Under Test 2", (String)((ISystemUnderTest)HyadesFactory.INSTANCE.getObjectByID(iTestSuite2, string)).getName());
        TPFTestSuiteImpl tPFTestSuiteImpl = (TPFTestSuiteImpl)Common_TestprofileFactory.eINSTANCE.createTPFTestSuite();
        tPFTestSuiteImpl.setName("External Test Suite");
        TPFBehaviorImpl tPFBehaviorImpl = (TPFBehaviorImpl)Common_TestprofileFactory.eINSTANCE.createTPFBehavior();
        tPFBehaviorImpl.setName(tPFTestSuiteImpl.getName() + "_behavior");
        tPFTestSuiteImpl.setBehavior(tPFBehaviorImpl);
        String string2 = tPFBehaviorImpl.getId();
        this.suite2Resource.getContents().add(tPFTestSuiteImpl);
        this.save(tPFTestSuiteImpl);
        iTestSuite.getIReferencedSuites().add(tPFTestSuiteImpl);
        this.save(iTestSuite);
        iTestSuite2 = (ITestSuite)this.load();
        Assert.assertEquals((String)"System Under Test 2", (String)((ISystemUnderTest)HyadesFactory.INSTANCE.getObjectByID(iTestSuite2, string)).getName());
        Assert.assertEquals((String)"External Test Suite_behavior", (String)((IImplementor)HyadesFactory.INSTANCE.getObjectByID(iTestSuite2, string2)).getName());
    }

    public void testGetTestSuiteFromObject() {
        this.createSimpleTestSuite();
        ITestSuite iTestSuite = (ITestSuite)this.load();
        Object object = iTestSuite.getITestCases().get(0);
        ITestSuite iTestSuite2 = HyadesFactory.INSTANCE.getTestSuiteFromObject(object);
        Assert.assertEquals((Object)iTestSuite, (Object)iTestSuite2);
        object = new Object();
        try {
            iTestSuite2 = HyadesFactory.INSTANCE.getTestSuiteFromObject(object);
            Assert.assertTrue((boolean)false);
        }
        catch (Exception exception) {
            Assert.assertTrue((boolean)(exception instanceof IllegalArgumentException));
        }
        object = this.createSystemUnderTest();
        iTestSuite2 = HyadesFactory.INSTANCE.getTestSuiteFromObject(object);
        Assert.assertEquals(null, (Object)iTestSuite2);
    }

    public void testAddTestInvocationException() {
        this.createSimpleTestSuite();
        ITestSuite iTestSuite = (ITestSuite)this.load();
        IImplementor iImplementor = iTestSuite.getImplementor();
        IBlock iBlock = iImplementor.getBlock();
        ITestSuite iTestSuite2 = this.createTestSuite(this.suite2Resource);
        iTestSuite2.setName("Invokable Test Suite");
        iTestSuite2.setDescription("A TestSuite to be invoked");
        this.save(iTestSuite2);
        ITestInvocation iTestInvocation = null;
        try {
            iTestInvocation = this.createTestInvocation(iTestSuite2);
            Assert.assertTrue((boolean)false);
        }
        catch (Exception exception) {
            Assert.assertTrue((boolean)(exception instanceof IllegalArgumentException));
            Assert.assertEquals((String)"Invoked test must have an implementor.", (String)exception.getMessage());
        }
    }

    public void testAddMethodToTest() {
        this.createSimpleTestSuite();
        ITestSuite iTestSuite = (ITestSuite)this.load();
        IImplementor iImplementor = iTestSuite.getImplementor();
        Assert.assertNotNull((Object)iImplementor.getMethods());
        Assert.assertEquals((int)0, (int)iImplementor.getMethods().size());
        IBlock iBlock = iImplementor.getBlock();
        ISystemUnderTest iSystemUnderTest = (ISystemUnderTest)iTestSuite.getISystemsUnderTest().get(0);
        iSystemUnderTest.setDescription("An SUT with operations");
        iSystemUnderTest.setLocation("main");
        IMethod iMethod = this.createMethod();
        iMethod.setName("method1");
        iMethod.setDescription("Pick me!  Pick me!!");
        iSystemUnderTest.getMethods().add(iMethod);
        IMethod iMethod2 = this.createMethod();
        iMethod2.setName("method2");
        iMethod2.setDescription("Pick me!  Pick me!!");
        ITargetInvocation iTargetInvocation = this.createTargetInvocation(iMethod);
        iTargetInvocation.setName("Target Invocation 1");
        iTargetInvocation.setDescription("A simple target invocation");
        iTargetInvocation.setSynchronous(true);
        iBlock.getActions().add(0, iTargetInvocation);
        Assert.assertEquals((int)0, (int)iImplementor.getMethods().size());
        iImplementor.getMethods().add(iMethod2);
        Assert.assertEquals((int)1, (int)iImplementor.getMethods().size());
        Assert.assertEquals((Object)iMethod2, iImplementor.getMethods().get(0));
        this.save(iTestSuite);
        ITestSuite iTestSuite2 = (ITestSuite)this.load();
        Assert.assertEquals((int)1, (int)iTestSuite2.getImplementor().getMethods().size());
        Assert.assertEquals((String)"method2", (String)((IMethod)iTestSuite2.getImplementor().getMethods().get(0)).getName());
    }

    private ITestSuite createBlankTestSuite() {
        ITestSuite iTestSuite = this.createTestSuite(this.suite1Resource);
        iTestSuite.setName("Test Suite 1");
        iTestSuite.setDescription("A simple Test Suite with one of everythiing");
        this.save(iTestSuite);
        return iTestSuite;
    }

    private ITestSuite createSimpleTestSuite() {
        ITestSuite iTestSuite = this.createTestSuite(this.suite1Resource);
        ITestCase iTestCase = this.createTestCase();
        iTestCase.setName("Test Case 1");
        iTestCase.setDescription("A simple test case");
        IImplementor iImplementor = this.createImplementor(iTestSuite, false);
        iImplementor.setName("Test Driver 1");
        iImplementor.setDescription("A test driver");
        iImplementor.setLocation("main");
        iImplementor.setResource("C:\\temp\\testDriver1.java");
        ISystemUnderTest iSystemUnderTest = this.createSystemUnderTest();
        iSystemUnderTest.setName("System Under Test 1");
        iSystemUnderTest.setDescription("A generic system under test");
        iSystemUnderTest.setLocation("");
        iSystemUnderTest.setResource("C:\\temp\\systemUnderTest1.java");
        IStub iStub = this.createStub(iTestSuite);
        iStub.setName("Stub 1");
        iStub.setDescription("A sample stub");
        iStub.setResource("c:\\temp\\stub1.java");
        iStub.setLocation("");
        iTestSuite.setName("Test Suite 1");
        iTestSuite.setDescription("A simple Test Suite with one of everythiing");
        iTestSuite.getITestCases().add(0, iTestCase);
        iTestSuite.getISystemsUnderTest().add(0, iSystemUnderTest);
        iTestSuite.getIStubs().add(0, iStub);
        this.save(iTestSuite);
        return iTestSuite;
    }

    private ITestSuite createTestSuite(Resource resource) {
        return HyadesFactory.INSTANCE.createTestSuite(resource);
    }

    private ITestCase createTestCase() {
        return HyadesFactory.INSTANCE.createTestCase();
    }

    private IImplementor createImplementor(ITest iTest, boolean bl) {
        return HyadesFactory.INSTANCE.createImplementor(iTest, bl);
    }

    private IStub createStub(ITest iTest) {
        return HyadesFactory.INSTANCE.createStub();
    }

    private ISystemUnderTest createSystemUnderTest() {
        return HyadesFactory.INSTANCE.createSystemUnderTest();
    }

    private IDecision createDecision() {
        return HyadesFactory.INSTANCE.createDecision();
    }

    private ILoop createLoop() {
        return HyadesFactory.INSTANCE.createLoop();
    }

    private IVerificationPoint createVerificationPoint() {
        return HyadesFactory.INSTANCE.createVerificationPoint();
    }

    private ITargetInvocation createTargetInvocation(IMethod iMethod) {
        return HyadesFactory.INSTANCE.createTargetInvocation(iMethod);
    }

    private ITestInvocation createTestInvocation(ITest iTest) {
        return HyadesFactory.INSTANCE.createTestInvocation(iTest);
    }

    private IMethod createMethod() {
        return HyadesFactory.INSTANCE.createMethod();
    }

    private IProperty createProperty() {
        return HyadesFactory.INSTANCE.createProperty();
    }

    private void save(Object object) {
        if (object instanceof EObject) {
            try {
                ((EObject)object).eResource().save(Collections.EMPTY_MAP);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private Object load() {
        ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
        this.suite1Resource = resourceSetImpl.getResource(URI.createURI((String)this.xmiFile), true);
        return this.suite1Resource.getContents().get(0);
    }
}

