/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.util;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.loaders.util.RegistryReader;
import org.eclipse.hyades.loaders.util.ResourceExtensions;
import org.eclipse.hyades.loaders.util.XMLResourceLoader;
import org.eclipse.hyades.models.hierarchy.plugin.HierarchyPlugin;

class ResourceRegistryReader
extends RegistryReader {
    static final String TAG_RESOURCE_LOADER = "resourceLoader";
    static final String ATT_FILE_EXTENSION = "fileExtension";
    static final String ATT_CLASS = "class";

    public ResourceRegistryReader() {
        super(Platform.getPluginRegistry(), HierarchyPlugin.getPlugin().getDescriptor().getUniqueIdentifier(), "resource_loader");
    }

    protected boolean readElement(IConfigurationElement iConfigurationElement) {
        if (iConfigurationElement.getName().equals(TAG_RESOURCE_LOADER)) {
            String string = iConfigurationElement.getAttribute(ATT_FILE_EXTENSION);
            if (string == null) {
                this.logMissingAttribute(iConfigurationElement, ATT_FILE_EXTENSION);
            } else if (iConfigurationElement.getAttribute(ATT_CLASS) == null) {
                this.logMissingAttribute(iConfigurationElement, ATT_CLASS);
            } else if (ResourceExtensions.getInstance().containsKey(string)) {
                this.logError(iConfigurationElement, "A resource loader for this element already exists, this loader will be ignored.");
            } else {
                try {
                    RegistryReader.PluginClassDescriptor pluginClassDescriptor = new RegistryReader.PluginClassDescriptor(iConfigurationElement, ATT_CLASS);
                    ResourceExtensions.getInstance().put(string, (XMLResourceLoader)pluginClassDescriptor.createInstance());
                }
                catch (Exception exception) {
                    this.logError(iConfigurationElement, exception.getLocalizedMessage());
                }
                return true;
            }
        }
        return false;
    }
}

