/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.hierarchy.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.util.EObjectVisitor;
import org.eclipse.hyades.models.hierarchy.util.FastList;

public abstract class EObjectsTraverser {
    protected static final int AFTER_CHILDREN = 3;
    protected static final int BEFORE_CHILDREN = 1;
    private Collection contents;
    private Collection visitors;

    public EObjectsTraverser(Collection collection) {
        this.contents = collection;
        this.visitors = new FastList();
    }

    public void dispose() {
        this.visitors.clear();
        this.contents = null;
    }

    protected boolean afterChildren(EObject eObject) {
        return this.callVisitors(3, eObject);
    }

    protected boolean beforeChildren(EObject eObject) {
        return this.callVisitors(1, eObject);
    }

    public EObjectsTraverser registerVisitors(EObjectVisitor eObjectVisitor) {
        if (eObjectVisitor != null) {
            this.visitors.add(eObjectVisitor);
        }
        return this;
    }

    public EObjectsTraverser deregisterVisitor(EObjectVisitor eObjectVisitor) {
        if (eObjectVisitor != null) {
            this.visitors.remove(eObjectVisitor);
        }
        return this;
    }

    public EObjectsTraverser deregisterAllVisitors() {
        this.visitors.clear();
        return this;
    }

    protected boolean callVisitors(int n, EObject eObject) {
        boolean bl = true;
        Iterator iterator = this.visitors.iterator();
        while (iterator.hasNext()) {
            try {
                switch (n) {
                    case 1: {
                        bl = ((EObjectVisitor)iterator.next()).beforeChildren(eObject) && bl;
                        break;
                    }
                    case 3: {
                        bl = ((EObjectVisitor)iterator.next()).afterChildren(eObject) && bl;
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return bl;
    }

    public boolean traverse() {
        return this.traverse(this.contents.iterator());
    }

    protected boolean traverse(Iterator iterator) {
        while (iterator.hasNext()) {
            EObject eObject = (EObject)iterator.next();
            EObject eObject2 = this.getElement(eObject);
            if (!this.beforeChildren(eObject2)) {
                return false;
            }
            this.traverseEObject(eObject);
            if (this.afterChildren(eObject2)) continue;
            return false;
        }
        return true;
    }

    protected boolean traverse(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            EObject eObject = (EObject)iterator.next();
            EObject eObject2 = this.getElement(eObject);
            if (!this.beforeChildren(eObject2)) {
                return false;
            }
            this.traverseEObject(eObject2);
            if (this.afterChildren(eObject2)) continue;
            return false;
        }
        return true;
    }

    protected abstract boolean traverseEObject(EObject var1);

    protected abstract EObject getElement(EObject var1);
}

