/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.hierarchy.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xmi.DanglingHREFException;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMISaveImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLSaveImpl;
import org.eclipse.hyades.models.hierarchy.util.ContainmentTraverser;
import org.eclipse.hyades.models.hierarchy.util.EObjectVisitor;
import org.eclipse.hyades.models.hierarchy.util.HierarchyXMLString;

public class HierarchyXMISaveImpl
extends XMISaveImpl {
    protected final int BUFFER_SIZE = 262144;
    protected Escape escape;
    protected Lookup featureTable;
    protected String encoding;
    protected StringBuffer ids = new StringBuffer(200);
    protected StringBuffer xsiSchemaLocation = new StringBuffer(100);
    protected char[] buffer = new char[262144];
    protected byte[] bytes = new byte[262144];
    protected int[] featureKinds;
    protected List elementFeaturesPool = new ArrayList();
    protected int elementFeaturesCount = 0;
    protected int currentDepth;

    public HierarchyXMISaveImpl(XMLHelper xMLHelper) {
        super(xMLHelper);
    }

    public HierarchyXMISaveImpl(Map map, XMLHelper xMLHelper, String string) {
        super(map, xMLHelper, string);
    }

    public void addNamespaceDeclarations() {
        Object object;
        Object object2;
        EPackage ePackage;
        int n;
        ((XMLSaveImpl)this).doc.addAttribute("xmi:version", "2.0");
        ((XMLSaveImpl)this).doc.addAttribute("xmlns:xmi", "http://www.omg.org/XMI");
        EPackage[] ePackageArray = ((XMLSaveImpl)this).helper.packages();
        this.xsiSchemaLocation.setLength(0);
        if (((XMLSaveImpl)this).declareSchemaLocation) {
            n = 0;
            while (n < ePackageArray.length) {
                Resource resource;
                ePackage = ePackageArray[n];
                object2 = EcoreUtil.getRootContainer((EObject)ePackage);
                if (object2 instanceof EPackage && (resource = (object = (EPackage)object2).eResource()) != null) {
                    URI uRI = resource.getURI();
                    String string = object.getNsURI();
                    boolean bl = uRI == null ? string != null : !uRI.toString().equals(string);
                    if (bl) {
                        ((XMLSaveImpl)this).declareXSI = true;
                        if (this.xsiSchemaLocation.length() > 0) {
                            this.xsiSchemaLocation.append(' ');
                        }
                        this.xsiSchemaLocation.append(string);
                        this.xsiSchemaLocation.append(' ');
                        this.xsiSchemaLocation.append(((XMLSaveImpl)this).helper.getHREF((EObject)object));
                    }
                }
                ++n;
            }
        }
        ((XMLSaveImpl)this).doc.addAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        n = 0;
        while (n < ePackageArray.length) {
            ePackage = ePackageArray[n];
            object2 = ePackage.getNsURI();
            object = ePackage.getNsPrefix();
            ((XMLSaveImpl)this).doc.addAttributeNS("xmlns", (String)object, (String)object2);
            ++n;
        }
        if (this.xsiSchemaLocation != null && this.xsiSchemaLocation.length() > 0) {
            ((XMLSaveImpl)this).doc.addAttribute("xsi:schemaLocation", this.xsiSchemaLocation.toString());
        }
    }

    public void save(XMLResource xMLResource, OutputStream outputStream, Map map) throws IOException {
        DanglingHREFException danglingHREFException;
        this.init(xMLResource, map);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, ((XMLSaveImpl)this).helper.getJavaEncoding(this.encoding));
        ((HierarchyXMLString)((XMLSaveImpl)this).doc).setOutputStreamWriter(outputStreamWriter);
        this.traverse((List)xMLResource.getContents());
        outputStreamWriter.flush();
        this.featureTable = null;
        ((XMLSaveImpl)this).doc = null;
        if ((((XMLSaveImpl)this).processDanglingHREF == null || "THROW".equals(((XMLSaveImpl)this).processDanglingHREF)) && (danglingHREFException = ((XMLSaveImpl)this).helper.getDanglingHREFException()) != null) {
            ((XMLSaveImpl)this).helper = null;
            throw new Resource.IOWrappedException((Exception)danglingHREFException);
        }
        ((XMLSaveImpl)this).helper = null;
    }

    public char[] toChar() {
        int n = ((XMLSaveImpl)this).doc.getLength();
        char[] cArray = this.allocCharArray(n);
        ((XMLSaveImpl)this).doc.getChars(cArray, 0);
        return cArray;
    }

    public void traverse(List list) {
        int n;
        if (((XMLSaveImpl)this).declareXML) {
            ((XMLSaveImpl)this).doc.add("<?xml version=\"1.0\" encoding=\"" + this.encoding + "\"?>");
            ((XMLSaveImpl)this).doc.addLine();
        }
        Object object = (n = list.size()) == 1 ? this.writeTopObject((EObject)list.get(0)) : this.writeTopObjects(list);
        ((XMLSaveImpl)this).doc.resetToMark(object);
    }

    public void write(OutputStreamWriter outputStreamWriter) throws IOException {
        int n = 0;
        Iterator iterator = ((XMLSaveImpl)this).doc.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            int n2 = string.length();
            if (n2 + n >= this.buffer.length) {
                outputStreamWriter.write(this.buffer, 0, n);
                n = 0;
                if (n2 > this.buffer.length) {
                    this.buffer = this.allocCharArray(n2);
                }
            }
            string.getChars(0, n2, this.buffer, n);
            n += n2;
        }
        outputStreamWriter.write(this.buffer, 0, n);
        outputStreamWriter.flush();
    }

    public void writeAscii(OutputStream outputStream) throws IOException {
        int n = 0;
        Iterator iterator = ((XMLSaveImpl)this).doc.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            int n2 = string.length();
            if (n2 + n >= this.buffer.length) {
                int n3 = 0;
                while (n3 < n) {
                    this.bytes[n3] = (byte)(this.buffer[n3] & 0xFF);
                    ++n3;
                }
                outputStream.write(this.bytes, 0, n);
                n = 0;
                if (n2 > this.buffer.length) {
                    this.buffer = this.allocCharArray(n2);
                    this.bytes = this.allocByteArray(n2);
                }
            }
            string.getChars(0, n2, this.buffer, n);
            n += n2;
        }
        int n4 = 0;
        while (n4 < n) {
            this.bytes[n4] = (byte)(this.buffer[n4] & 0xFF);
            ++n4;
        }
        outputStream.write(this.bytes, 0, n);
        outputStream.flush();
    }

    public Object writeTopObjects(List list) {
        ((XMLSaveImpl)this).doc.startElement("xmi:XMI");
        this.addExtraPackages(list, Integer.MAX_VALUE);
        this.addNamespaceDeclarations();
        Object object = ((XMLSaveImpl)this).doc.mark();
        int n = 0;
        int n2 = list.size();
        while (n < n2) {
            EObject eObject = (EObject)list.get(n);
            EClass eClass = eObject.eClass();
            String string = ((XMLSaveImpl)this).helper.getQName(eClass);
            ((XMLSaveImpl)this).doc.startElement(string);
            this.saveElementID(eObject);
            ++n;
        }
        ((XMLSaveImpl)this).doc.endElement();
        return object;
    }

    private void addExtraPackages(List list, final int n) {
        this.currentDepth = 0;
        ContainmentTraverser containmentTraverser = new ContainmentTraverser(list);
        EObjectVisitor eObjectVisitor = new EObjectVisitor(){

            public boolean afterChildren(EObject eObject) {
                --HierarchyXMISaveImpl.this.currentDepth;
                ((XMLSaveImpl)HierarchyXMISaveImpl.this).helper.getQName(eObject.eClass());
                return true;
            }

            public boolean beforeChildren(EObject eObject) {
                if (HierarchyXMISaveImpl.this.currentDepth > n) {
                    return false;
                }
                ++HierarchyXMISaveImpl.this.currentDepth;
                return true;
            }
        };
        containmentTraverser.registerVisitors(eObjectVisitor);
        containmentTraverser.traverse();
    }

    protected String getContent(EObject eObject, EStructuralFeature[] eStructuralFeatureArray) {
        XMLResource.XMLMap xMLMap = ((XMLSaveImpl)this).helper.getXMLMap();
        if (xMLMap == null) {
            return null;
        }
        int n = 0;
        while (n < eStructuralFeatureArray.length) {
            XMLResource.XMLInfo xMLInfo = xMLMap.getInfo((ENamedElement)eStructuralFeatureArray[n]);
            if (xMLInfo != null && xMLInfo.getXMLRepresentation() == 2) {
                Object object = ((XMLSaveImpl)this).helper.getValue(eObject, eStructuralFeatureArray[n]);
                if (object == null) {
                    return null;
                }
                EDataType eDataType = (EDataType)eStructuralFeatureArray[n].getEType();
                EPackage ePackage = eDataType.getEPackage();
                EFactory eFactory = ePackage.getEFactoryInstance();
                String string = eFactory.convertToString(eDataType, object);
                if (this.escape != null) {
                    string = this.escape.convert(string);
                }
                return string;
            }
            ++n;
        }
        return null;
    }

    protected byte[] allocByteArray(int n) {
        return new byte[n];
    }

    protected char[] allocCharArray(int n) {
        return new char[n];
    }

    protected void init(XMLResource xMLResource, Map map) {
        this.xmiType = Boolean.TRUE.equals(map.get("USE_XMI_TYPE"));
        ((XMLSaveImpl)this).declareXSI = false;
        ((XMLSaveImpl)this).useEncodedAttributeStyle = Boolean.TRUE.equals(map.get("USE_ENCODED_ATTRIBUTE_STYLE"));
        ((XMLSaveImpl)this).declareXML = !Boolean.FALSE.equals(map.get("DECLARE_XML"));
        ((XMLSaveImpl)this).declareSchemaLocation = Boolean.TRUE.equals(map.get("SCHEMA_LOCATION"));
        Integer n = (Integer)map.get("LINE_WIDTH");
        ((XMLSaveImpl)this).doc = new HierarchyXMLString(null);
        Escape escape = this.escape = Boolean.TRUE.equals(map.get("SKIP_ESCAPE")) ? null : new Escape();
        if (map.containsKey("ENCODING")) {
            this.encoding = (String)map.get("ENCODING");
        } else if (xMLResource != null) {
            this.encoding = xMLResource.getEncoding();
        }
        ((XMLSaveImpl)this).processDanglingHREF = (String)map.get("PROCESS_DANGLING_HREF");
        ((XMLSaveImpl)this).helper.setProcessDanglingHREF(((XMLSaveImpl)this).processDanglingHREF);
        XMLResource.XMLMap xMLMap = (XMLResource.XMLMap)map.get("XML_MAP");
        if (xMLMap != null) {
            ((XMLSaveImpl)this).helper.setXMLMap(xMLMap);
            if (xMLMap.getIDAttributeName() != null) {
                ((XMLSaveImpl)this).idAttributeName = xMLMap.getIDAttributeName();
            }
        }
        this.featureTable = new Lookup(xMLMap);
    }

    protected void saveDataTypeElementSingle(EObject eObject, EStructuralFeature eStructuralFeature) {
        String string = ((XMLSaveImpl)this).helper.getQName(eStructuralFeature);
        Object object = ((XMLSaveImpl)this).helper.getValue(eObject, eStructuralFeature);
        if (object == null) {
            ((XMLSaveImpl)this).doc.startElement(string);
            ((XMLSaveImpl)this).doc.addAttribute("xsi:nil", "true");
            ((XMLSaveImpl)this).doc.endEmptyElement();
            ((XMLSaveImpl)this).declareXSI = true;
        } else {
            EDataType eDataType = (EDataType)eStructuralFeature.getEType();
            EPackage ePackage = eDataType.getEPackage();
            EFactory eFactory = ePackage.getEFactoryInstance();
            ((XMLSaveImpl)this).doc.startElement(string);
            String string2 = eFactory.convertToString(eDataType, object);
            if (this.escape != null) {
                string2 = this.escape.convert(string2);
            }
            ((XMLSaveImpl)this).doc.endContentElement(string2);
        }
    }

    protected void saveDataTypeMany(EObject eObject, EStructuralFeature eStructuralFeature) {
        EDataType eDataType = (EDataType)eStructuralFeature.getEType();
        EPackage ePackage = eDataType.getEPackage();
        EFactory eFactory = ePackage.getEFactoryInstance();
        List list = (List)((XMLSaveImpl)this).helper.getValue(eObject, eStructuralFeature);
        int n = list.size();
        if (n > 0) {
            String string = ((XMLSaveImpl)this).helper.getQName(eStructuralFeature);
            int n2 = 0;
            while (n2 < n) {
                Object e = list.get(n2);
                if (e == null) {
                    ((XMLSaveImpl)this).doc.startElement(string);
                    ((XMLSaveImpl)this).doc.addAttribute("xsi:nil", "true");
                    ((XMLSaveImpl)this).doc.endEmptyElement();
                    ((XMLSaveImpl)this).declareXSI = true;
                } else {
                    ((XMLSaveImpl)this).doc.startElement(string);
                    String string2 = eFactory.convertToString(eDataType, e);
                    if (this.escape != null) {
                        string2 = this.escape.convert(string2);
                    }
                    ((XMLSaveImpl)this).doc.endContentElement(string2);
                }
                ++n2;
            }
        }
    }

    protected void saveDataTypeSingle(EObject eObject, EStructuralFeature eStructuralFeature) {
        EDataType eDataType = (EDataType)eStructuralFeature.getEType();
        EPackage ePackage = eDataType.getEPackage();
        EFactory eFactory = ePackage.getEFactoryInstance();
        Object object = ((XMLSaveImpl)this).helper.getValue(eObject, eStructuralFeature);
        if (object != null) {
            String string = eFactory.convertToString(eDataType, object);
            if (this.escape != null) {
                string = this.escape.convert(string);
            }
            ((XMLSaveImpl)this).doc.addAttribute(((XMLSaveImpl)this).helper.getQName(eStructuralFeature), string);
        }
    }

    protected boolean saveFeatures(EObject eObject) {
        EClass eClass = eObject.eClass();
        EStructuralFeature[] eStructuralFeatureArray = this.featureTable.getFeatures(eClass);
        int[] nArray = this.featureTable.getKinds(eClass, eStructuralFeatureArray);
        int[] nArray2 = null;
        int n = 0;
        int n2 = 0;
        while (n2 < eStructuralFeatureArray.length) {
            int n3 = nArray[n2];
            EStructuralFeature eStructuralFeature = eStructuralFeatureArray[n2];
            if (n3 != 0 && eObject.eIsSet(eStructuralFeature)) {
                switch (n3) {
                    case 2: {
                        if (nArray2 == null) {
                            nArray2 = this.allocElementFeatures(eStructuralFeatureArray.length);
                        }
                        nArray2[n++] = n2;
                        break;
                    }
                    case 1: {
                        this.saveDataTypeSingle(eObject, eStructuralFeature);
                        break;
                    }
                    case 4: {
                        if (this.isNil(eObject, eStructuralFeature)) {
                            if (nArray2 == null) {
                                nArray2 = this.allocElementFeatures(eStructuralFeatureArray.length);
                            }
                            nArray2[n++] = n2;
                            break;
                        }
                        this.saveDataTypeSingle(eObject, eStructuralFeature);
                        break;
                    }
                    case 12: {
                        if (this.isNil(eObject, eStructuralFeature)) {
                            if (nArray2 == null) {
                                nArray2 = this.allocElementFeatures(eStructuralFeatureArray.length);
                            }
                            nArray2[n++] = n2;
                            break;
                        }
                    }
                    case 8: {
                        if (((XMLSaveImpl)this).useEncodedAttributeStyle) {
                            this.saveEObjectSingle(eObject, eStructuralFeature);
                            break;
                        }
                        switch (this.sameDocSingle(eObject, eStructuralFeature)) {
                            case 1: {
                                this.saveIDRefSingle(eObject, eStructuralFeature);
                                break;
                            }
                            case 2: {
                                if (nArray2 == null) {
                                    nArray2 = this.allocElementFeatures(eStructuralFeatureArray.length);
                                }
                                nArray2[n++] = n2;
                            }
                        }
                        break;
                    }
                    case 13: {
                        if (this.isEmpty(eObject, eStructuralFeature)) {
                            this.saveManyEmpty(eStructuralFeature);
                            break;
                        }
                    }
                    case 9: {
                        if (((XMLSaveImpl)this).useEncodedAttributeStyle) {
                            this.saveEObjectMany(eObject, eStructuralFeature);
                            break;
                        }
                        switch (this.sameDocMany(eObject, eStructuralFeature)) {
                            case 1: {
                                this.saveIDRefMany(eObject, eStructuralFeature);
                                break;
                            }
                            case 2: {
                                if (nArray2 == null) {
                                    nArray2 = this.allocElementFeatures(eStructuralFeatureArray.length);
                                }
                                nArray2[n++] = n2;
                            }
                        }
                        break;
                    }
                    case 5: 
                    case 11: {
                        if (this.isEmpty(eObject, eStructuralFeature)) {
                            this.saveManyEmpty(eStructuralFeature);
                            break;
                        }
                    }
                    case 6: 
                    case 7: 
                    case 10: 
                    case 14: 
                    case 15: {
                        if (nArray2 == null) {
                            nArray2 = this.allocElementFeatures(eStructuralFeatureArray.length);
                        }
                        nArray2[n++] = n2;
                    }
                }
            }
            ++n2;
        }
        String string = this.getContent(eObject, eStructuralFeatureArray);
        if (nArray2 == null) {
            if (string == null) {
                this.endSaveFeatures(eObject, 1, null);
                if (nArray2 != null) {
                    this.dealocElementFeatures();
                }
                return false;
            }
            this.endSaveFeatures(eObject, 2, string);
            if (nArray2 != null) {
                this.dealocElementFeatures();
            }
            return true;
        }
        int n4 = 0;
        while (n4 < n) {
            int n5 = nArray[nArray2[n4]];
            EStructuralFeature eStructuralFeature = eStructuralFeatureArray[nArray2[n4]];
            switch (n5) {
                case 4: {
                    this.saveNil(eStructuralFeature);
                    break;
                }
                case 5: {
                    this.saveDataTypeMany(eObject, eStructuralFeature);
                    break;
                }
                case 2: {
                    this.saveDataTypeElementSingle(eObject, eStructuralFeature);
                    break;
                }
                case 10: {
                    if (this.isNil(eObject, eStructuralFeature)) {
                        this.saveNil(eStructuralFeature);
                        break;
                    }
                }
                case 6: {
                    this.saveContainedSingle(eObject, eStructuralFeature);
                    break;
                }
                case 7: 
                case 11: {
                    this.saveContainedMany(eObject, eStructuralFeature);
                    break;
                }
                case 12: {
                    if (this.isNil(eObject, eStructuralFeature)) {
                        this.saveNil(eStructuralFeature);
                        break;
                    }
                }
                case 8: {
                    this.saveHRefSingle(eObject, eStructuralFeature);
                    break;
                }
                case 9: 
                case 13: {
                    this.saveHRefMany(eObject, eStructuralFeature);
                    break;
                }
                case 14: {
                    this.saveElementReferenceSingle(eObject, eStructuralFeature);
                    break;
                }
                case 15: {
                    this.saveElementReferenceMany(eObject, eStructuralFeature);
                }
            }
            ++n4;
        }
        this.endSaveFeatures(eObject, 0, null);
        if (nArray2 != null) {
            this.dealocElementFeatures();
        }
        return true;
    }

    protected void saveIDRefMany(EObject eObject, EStructuralFeature eStructuralFeature) {
        InternalEList internalEList = (InternalEList)((XMLSaveImpl)this).helper.getValue(eObject, eStructuralFeature);
        if (!internalEList.isEmpty()) {
            String string = ((XMLSaveImpl)this).helper.getQName(eStructuralFeature);
            this.ids.setLength(0);
            Iterator iterator = internalEList.basicIterator();
            while (true) {
                EObject eObject2 = (EObject)iterator.next();
                String string2 = ((XMLSaveImpl)this).helper.getIDREF(eObject2);
                this.ids.append(string2);
                if (!iterator.hasNext()) break;
                this.ids.append(" ");
            }
            ((XMLSaveImpl)this).doc.addAttribute(string, this.ids.toString());
        }
    }

    protected Object writeTopObject(EObject eObject) {
        EClass eClass = eObject.eClass();
        BasicEList basicEList = new BasicEList();
        basicEList.add(eObject);
        this.addExtraPackages((List)basicEList, Integer.MAX_VALUE);
        String string = ((XMLSaveImpl)this).helper.getQName(eClass);
        ((XMLSaveImpl)this).doc.startElement(string);
        this.addNamespaceDeclarations();
        Object object = ((XMLSaveImpl)this).doc.mark();
        this.saveElementID(eObject);
        return object;
    }

    private int[] allocElementFeatures(int n) {
        int[] nArray;
        if (this.elementFeaturesCount == this.elementFeaturesPool.size()) {
            nArray = new int[n];
            this.elementFeaturesPool.add(nArray);
        } else {
            nArray = (int[])this.elementFeaturesPool.get(this.elementFeaturesCount);
            if (nArray.length < n) {
                nArray = new int[n];
                this.elementFeaturesPool.set(this.elementFeaturesCount, nArray);
            }
        }
        ++this.elementFeaturesCount;
        return nArray;
    }

    private void dealocElementFeatures() {
        if (this.elementFeaturesCount > 0) {
            --this.elementFeaturesCount;
        }
    }

    protected static class Lookup {
        protected static final int SIZE = 4095;
        protected XMLResource.XMLMap map;
        protected EClass[] classes;
        protected int[][] featureKinds;
        protected EStructuralFeature[][] features;

        Lookup(XMLResource.XMLMap xMLMap) {
            this.map = xMLMap;
            this.classes = new EClass[4096];
            this.features = new EStructuralFeature[4096][];
            this.featureKinds = new int[4096][];
        }

        public EStructuralFeature[] getFeatures(EClass eClass) {
            int n = eClass.hashCode() & 0xFFF;
            EClass eClass2 = this.classes[n];
            if (eClass2 == eClass) {
                return this.features[n];
            }
            EStructuralFeature[] eStructuralFeatureArray = this.listFeatures(eClass);
            if (eClass2 == null) {
                this.classes[n] = eClass;
                this.features[n] = eStructuralFeatureArray;
                this.featureKinds[n] = this.listKinds(eStructuralFeatureArray);
            }
            return eStructuralFeatureArray;
        }

        public int[] getKinds(EClass eClass, EStructuralFeature[] eStructuralFeatureArray) {
            int n = eClass.hashCode() & 0xFFF;
            EClass eClass2 = this.classes[n];
            if (eClass2 == eClass) {
                return this.featureKinds[n];
            }
            int[] nArray = this.listKinds(eStructuralFeatureArray);
            if (eClass2 == null) {
                this.classes[n] = eClass;
                this.features[n] = eStructuralFeatureArray;
                this.featureKinds[n] = nArray;
            }
            return nArray;
        }

        protected int featureKind(EStructuralFeature eStructuralFeature) {
            if (eStructuralFeature.isTransient()) {
                return 0;
            }
            boolean bl = eStructuralFeature.isMany();
            boolean bl2 = eStructuralFeature.isUnsettable();
            if (eStructuralFeature instanceof EReference) {
                XMLResource.XMLInfo xMLInfo;
                EReference eReference = (EReference)eStructuralFeature;
                if (eReference.isContainment()) {
                    return bl ? (bl2 ? 11 : 7) : (bl2 ? 10 : 6);
                }
                EReference eReference2 = eReference.getEOpposite();
                if (eReference2 != null && eReference2.isContainment()) {
                    return 0;
                }
                if (this.map != null && (xMLInfo = this.map.getInfo((ENamedElement)eStructuralFeature)) != null && xMLInfo.getXMLRepresentation() == 0) {
                    return bl ? 15 : 14;
                }
                return bl ? (bl2 ? 13 : 9) : (bl2 ? 12 : 8);
            }
            EDataType eDataType = (EDataType)eStructuralFeature.getEType();
            if (!eDataType.isSerializable()) {
                return 0;
            }
            if (bl) {
                return 5;
            }
            if (bl2 && this.map == null) {
                return 4;
            }
            if (this.map == null) {
                return 1;
            }
            XMLResource.XMLInfo xMLInfo = this.map.getInfo((ENamedElement)eStructuralFeature);
            if (xMLInfo != null && xMLInfo.getXMLRepresentation() == 0) {
                return 2;
            }
            if (xMLInfo != null && xMLInfo.getXMLRepresentation() == 2) {
                return 3;
            }
            if (bl2) {
                return 4;
            }
            return 1;
        }

        protected EStructuralFeature[] listFeatures(EClass eClass) {
            EList eList = this.map == null ? eClass.getEAllStructuralFeatures() : this.map.getFeatures(eClass);
            return eList.toArray(new EStructuralFeature[eList.size()]);
        }

        protected int[] listKinds(EStructuralFeature[] eStructuralFeatureArray) {
            int[] nArray = new int[eStructuralFeatureArray.length];
            int n = eStructuralFeatureArray.length - 1;
            while (n >= 0) {
                nArray[n] = this.featureKind(eStructuralFeatureArray[n]);
                --n;
            }
            return nArray;
        }
    }

    protected static class Escape {
        protected final char[] AMP = new char[]{'&', 'a', 'm', 'p', ';'};
        protected final char[] CR = new char[]{'&', '#', 'x', 'D', ';'};
        protected final char[] LESS = new char[]{'&', 'l', 't', ';'};
        protected final char[] LF = new char[]{'&', '#', 'x', 'A', ';'};
        protected final char[] QUOTE = new char[]{'&', 'q', 'u', 'o', 't', ';'};
        protected final char[] TAB = new char[]{'&', '#', 'x', '9', ';'};
        protected char[] value = new char[100];

        Escape() {
        }

        public String convert(String string) {
            boolean bl = false;
            int n = string.length();
            this.grow(n);
            string.getChars(0, n, this.value, 0);
            int n2 = 0;
            while (n-- > 0) {
                switch (this.value[n2]) {
                    case '&': {
                        n2 = this.replace(n2, this.AMP, n);
                        bl = true;
                        break;
                    }
                    case '<': {
                        n2 = this.replace(n2, this.LESS, n);
                        bl = true;
                        break;
                    }
                    case '\"': {
                        n2 = this.replace(n2, this.QUOTE, n);
                        bl = true;
                        break;
                    }
                    case '\n': {
                        n2 = this.replace(n2, this.LF, n);
                        bl = true;
                        break;
                    }
                    case '\r': {
                        n2 = this.replace(n2, this.CR, n);
                        bl = true;
                        break;
                    }
                    case '\t': {
                        n2 = this.replace(n2, this.TAB, n);
                        bl = true;
                        break;
                    }
                    default: {
                        ++n2;
                    }
                }
            }
            return bl ? new String(this.value, 0, n2) : string;
        }

        protected void grow(int n) {
            int n2 = this.value.length;
            if (n2 < n) {
                char[] cArray = new char[n + n / 2];
                System.arraycopy(this.value, 0, cArray, 0, n2);
                this.value = cArray;
            }
        }

        protected int replace(int n, char[] cArray, int n2) {
            int n3 = cArray.length;
            int n4 = n + n3;
            this.grow(n4 + n2);
            System.arraycopy(this.value, n + 1, this.value, n4, n2);
            System.arraycopy(cArray, 0, this.value, n, n3);
            return n4;
        }
    }
}

