/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sdb.internal.wizard;

import java.io.File;
import java.util.HashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.analysis.engine.AnalysisEnginePlugin;
import org.eclipse.hyades.models.internal.sdb.SDBRuntime;
import org.eclipse.hyades.models.internal.sdb.impl.SDBFactoryImpl;
import org.eclipse.hyades.sdb.internal.SDbPlugin;
import org.eclipse.hyades.sdb.internal.help.ContextIds;
import org.eclipse.hyades.sdb.internal.util.GridUtil;
import org.eclipse.hyades.sdb.internal.util.TString;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.WizardDataTransferPage;
import org.eclipse.ui.help.WorkbenchHelp;

public class NewSymptomDBWizardPage
extends WizardDataTransferPage
implements Listener {
    private Text txtLocationFolder;
    private Text txtDBName;
    private Text txtDescription;
    private Button btnLocationBrowse;
    private Button btnCreateFolderCheckbox;
    private String selFolder;
    private static final String DB_EXT = ".trcdbxmi";

    protected NewSymptomDBWizardPage(String string) {
        super(string);
        this.setTitle(SDbPlugin.getResourceString("STR_SYPMTOMDB_NEW_WIZARD_PTITLE"));
        this.setDescription(SDbPlugin.getResourceString("STR_SYPMTOMDB_NEW_WIZARD_PDESC"));
    }

    protected void init(String string) {
        this.selFolder = string;
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        GridData gridData = GridUtil.createFill();
        gridData.widthHint = 300;
        composite2.setLayoutData((Object)gridData);
        composite2.setLayoutData((Object)gridData);
        Composite composite3 = this.createLocationGroup(composite2);
        this.createNameGroup(composite3);
        this.createSpacer(composite2);
        this.createOptionsGroup(composite2);
        this.setControl((Control)composite2);
        this.btnLocationBrowse.addListener(13, (Listener)this);
        this.txtLocationFolder.addListener(24, (Listener)this);
        this.txtDBName.addListener(24, (Listener)this);
        this.txtDescription.addListener(24, (Listener)this);
        this.setPageComplete(false);
        WorkbenchHelp.setHelp((Control)this.txtLocationFolder, (String)ContextIds.NEW_SYMDB_LOCATION);
        WorkbenchHelp.setHelp((Control)this.txtDBName, (String)ContextIds.NEW_SYMDB_NAME);
        WorkbenchHelp.setHelp((Control)this.txtDescription, (String)ContextIds.NEW_SYMDB_DESCRIPTION);
        WorkbenchHelp.setHelp((Control)this.btnCreateFolderCheckbox, (String)ContextIds.NEW_SYMDB_CREATE_FOLDER);
    }

    private Composite createLocationGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.verticalSpacing = 2;
        GridData gridData = GridUtil.createHorizontalFill();
        gridData.widthHint = 300;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)gridData);
        Label label = new Label(composite2, 0);
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        label.setText(SDbPlugin.getResourceString("STR_SYMPTOM_DB_LOCATION"));
        this.txtLocationFolder = new Text(composite2, 2048);
        gridData = GridUtil.createHorizontalFill();
        this.txtLocationFolder.setLayoutData((Object)gridData);
        this.txtLocationFolder.setText(this.selFolder);
        this.btnLocationBrowse = new Button(composite2, 8);
        this.btnLocationBrowse.setText(SDbPlugin.getResourceString("BROWSE"));
        return composite2;
    }

    public void createNameGroup(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(SDbPlugin.getResourceString("STR_SYMPTOM_DB_NAME"));
        this.txtDBName = new Text(composite, 2048);
        this.txtDBName.setLayoutData((Object)GridUtil.createHorizontalFill());
        Label label2 = new Label(composite, 0);
        label2.setVisible(false);
        Label label3 = new Label(composite, 0);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        label3.setText(SDbPlugin.getResourceString("STR_SYMPTOM_DB_DESCRIPTION"));
        label3.setLayoutData((Object)gridData);
        this.txtDescription = new Text(composite, 2050);
        gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        gridData.heightHint = 150;
        this.txtDescription.setLayoutData((Object)gridData);
    }

    public void createOptionsGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)GridUtil.createHorizontalFill());
        Label label = new Label(composite2, 0);
        label.setText(SDbPlugin.getResourceString("ExportDBWizardPage.options"));
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        label.setLayoutData((Object)gridData);
        this.btnCreateFolderCheckbox = new Button(composite2, 16416);
        this.btnCreateFolderCheckbox.setText(SDbPlugin.getResourceString("ExportDBWizardPage.create.folder.str"));
    }

    protected boolean allowNewContainerName() {
        return false;
    }

    private IContainer createContainer(IPath iPath) {
        IFolder iFolder = null;
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        int n = iPath.segmentCount();
        int n2 = 0;
        while (n2 < n) {
            IFolder iFolder2;
            String string = iPath.segment(n2);
            if (n2 == 0) {
                iFolder2 = iWorkspace.getRoot().getProject(iPath.uptoSegment(n2 + 1).toString());
                if (iFolder2 == null || !iFolder2.exists()) {
                    try {
                        iFolder2.create(null);
                        iFolder2.open(null);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                iFolder = iFolder2;
            } else {
                iFolder2 = iWorkspace.getRoot().getFolder(iPath.uptoSegment(n2 + 1));
                if (iFolder2 == null || !iFolder2.exists()) {
                    try {
                        iFolder2.create(false, true, null);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                iFolder = iFolder2;
            }
            ++n2;
        }
        try {
            iFolder.getProject().refreshLocal(2, null);
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        return iFolder;
    }

    private void showResourceDialog() {
        Object[] objectArray;
        ContainerSelectionDialog containerSelectionDialog;
        Path path = new Path(this.txtLocationFolder.getText().trim());
        IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
        IContainer iContainer = null;
        if (iResource != null && iResource.exists() && iResource instanceof IContainer) {
            iContainer = (IContainer)iResource;
        }
        if ((containerSelectionDialog = new ContainerSelectionDialog(this.getShell(), iContainer, true, SDbPlugin.getResourceString("STR_RES_DLG_MSG"))).open() == 0 && (objectArray = containerSelectionDialog.getResult()) != null && objectArray.length == 1 && objectArray[0] != null) {
            this.txtLocationFolder.setText(((IPath)objectArray[0]).toOSString());
        }
    }

    protected boolean validateLocationGroup() {
        IStatus iStatus;
        String string = this.txtLocationFolder.getText().trim();
        if (string.equals("")) {
            return false;
        }
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        if (string.charAt(0) != File.separatorChar) {
            string = File.separatorChar + string;
        }
        if (!(iStatus = iWorkspace.validatePath(string, 6)).isOK()) {
            this.setErrorMessage(iStatus.getMessage());
            return false;
        }
        return true;
    }

    protected boolean validateNameGroup() {
        return !this.txtDBName.getText().trim().equals("") && this.checkDBName() && this.checkFilePath();
    }

    protected boolean determinePageCompletion() {
        boolean bl;
        boolean bl2 = bl = this.validateLocationGroup() && this.validateNameGroup();
        if (bl) {
            this.setErrorMessage(null);
        }
        return bl;
    }

    public boolean performFinish() {
        int n;
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        Object object = null;
        Path path = new Path(this.txtLocationFolder.getText().trim());
        object = this.btnCreateFolderCheckbox.getSelection() ? this.createContainer((IPath)path) : ((n = path.segmentCount()) == 1 ? iWorkspace.getRoot().getProject(path.toString()) : iWorkspace.getRoot().getFolder((IPath)path));
        if (object == null || !object.exists()) {
            if (this.queryYesNoQuestion(SDbPlugin.getResourceString("STR_CONTAINER_NOT_FOUND"))) {
                object = this.createContainer((IPath)path);
            } else {
                return false;
            }
        }
        String string = object.getFullPath().toOSString().substring(1) + File.separator + this.checkFileExtension();
        String string2 = new Path(string).toString();
        URI uRI = URI.createURI((String)("platform:/resource/" + string2));
        Resource resource = Resource.Factory.Registry.INSTANCE.getFactory(uRI).createResource(uRI);
        EList eList = resource.getContents();
        SDbPlugin.getDefault().getResourceSet().getResources().add(resource);
        SDBFactoryImpl sDBFactoryImpl = SDbPlugin.getDefault().getSDBFactory();
        SDBRuntime sDBRuntime = sDBFactoryImpl.createSDBRuntime();
        sDBRuntime.setName(this.txtDBName.getText());
        sDBRuntime.setDescription(this.txtDescription.getText());
        sDBRuntime.setSymptomUrl("");
        sDBRuntime.setLocalExternalFileLocation("");
        eList.add(sDBRuntime);
        try {
            HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
            hashMap.put("DECLARE_XML", Boolean.TRUE);
            resource.save(hashMap);
            object.refreshLocal(2, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.saveInPreferenceStore(string2);
        SDbPlugin.getDefault().getResourceSet().getResources().remove(resource);
        return true;
    }

    private void saveInPreferenceStore(String string) {
        IPreferenceStore iPreferenceStore = AnalysisEnginePlugin.getPlugin().getPreferenceStore();
        String string2 = iPreferenceStore.getString("symptom_db_path");
        string = "/" + string;
        string2 = string2.length() > 0 ? string2 + ";" + string + ",1" : string + ",1";
        iPreferenceStore.setValue("symptom_db_path", string2);
    }

    private String checkFileExtension() {
        String string = this.txtDBName.getText();
        if (string.endsWith(DB_EXT)) {
            if (string.length() != DB_EXT.length()) {
                return string;
            }
            return "error";
        }
        return string + DB_EXT;
    }

    private boolean checkFilePath() {
        String string = this.checkFileExtension();
        if (string.equals("error")) {
            this.setErrorMessage(SDbPlugin.getResourceString("STR_INVALID_NAME_MSG"));
            return false;
        }
        String string2 = this.txtLocationFolder.getText() + File.separator + string;
        Path path = new Path(string2);
        IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
        if (iResource != null) {
            String string3 = SDbPlugin.getResourceString("STR_FILE_EXISTS_MSG");
            string3 = TString.change(string3, "%1", string2);
            this.setErrorMessage(string3);
            return false;
        }
        return true;
    }

    private boolean checkDBName() {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IStatus iStatus = iWorkspace.validateName(this.txtDBName.getText(), 1);
        if (!iStatus.isOK()) {
            this.setErrorMessage(iStatus.getMessage());
            return false;
        }
        return true;
    }

    public void handleEvent(Event event) {
        if (event.widget == this.btnLocationBrowse) {
            this.showResourceDialog();
        }
        if (event.widget == this.txtLocationFolder) {
            if (this.txtLocationFolder.getText().trim().length() == 0) {
                this.setErrorMessage(SDbPlugin.getResourceString("STR_INVALID_LOCATION_MSG"));
            } else {
                this.setErrorMessage(null);
            }
        }
        if (event.widget == this.txtDBName) {
            if (this.txtDBName.getText().trim().length() == 0) {
                this.setErrorMessage(SDbPlugin.getResourceString("STR_INVALID_NAME_MSG"));
            } else {
                this.setErrorMessage(null);
            }
        }
        this.setPageComplete(this.determinePageCompletion());
    }
}

