/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sd.ui.internal.model;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.sd.ui.SDPlugin;
import org.eclipse.hyades.sd.ui.internal.loader.IModelLoader;
import org.eclipse.hyades.sd.ui.internal.model.ContentFactory;
import org.eclipse.hyades.sd.ui.internal.model.Graph;
import org.eclipse.hyades.sd.ui.internal.model.GraphContentFactory;

public class GraphFactory {
    private static GraphFactory singleton = null;

    private GraphFactory() {
    }

    public static GraphFactory getGraphFactory() {
        if (singleton == null) {
            singleton = new GraphFactory();
        }
        return singleton;
    }

    public Graph createGraph(int n, Object object) {
        return this.createGraph(n, object, GraphContentFactory.getContentFactory());
    }

    public Graph createGraph(int n, Object object, ContentFactory contentFactory) {
        Graph graph = new Graph(n);
        graph.setFiltered(false);
        graph.setContentFactory(contentFactory);
        this.resolveLoader(graph, object, n);
        graph.load();
        return graph;
    }

    public Graph createFilteredGraph(int n, Object object, ContentFactory contentFactory) {
        Graph graph = new Graph(n);
        graph.setFiltered(true);
        graph.setContentFactory(contentFactory);
        this.resolveLoader(graph, object, n);
        graph.load();
        return graph;
    }

    private void resolveLoader(Graph graph, Object object, int n) {
        IModelLoader iModelLoader = null;
        try {
            if (n == 21) {
                if (SDPlugin.getGraphLoaderList().get(new Integer(21)) != null) {
                    iModelLoader = (IModelLoader)((IConfigurationElement)SDPlugin.getGraphLoaderList().get(new Integer(21))).createExecutableExtension("class");
                    iModelLoader.setObjectAndGraph(object, graph);
                    graph.setModelLoader(iModelLoader);
                }
                return;
            }
            if (n == 22) {
                if (SDPlugin.getGraphLoaderList().get(new Integer(22)) != null) {
                    iModelLoader = (IModelLoader)((IConfigurationElement)SDPlugin.getGraphLoaderList().get(new Integer(22))).createExecutableExtension("class");
                    iModelLoader.setObjectAndGraph(object, graph);
                    graph.setModelLoader(iModelLoader);
                }
                return;
            }
            if (object instanceof TRCAgentProxy) {
                if (SDPlugin.getResouceLoaderList().get(new Integer(1)) != null) {
                    iModelLoader = (IModelLoader)((IConfigurationElement)SDPlugin.getResouceLoaderList().get(new Integer(1))).createExecutableExtension("class");
                    iModelLoader.setObjectAndGraph(object, graph);
                    graph.setModelLoader(iModelLoader);
                }
                return;
            }
            if (object instanceof TRCMonitor) {
                if (SDPlugin.getResouceLoaderList().get(new Integer(4)) != null) {
                    iModelLoader = (IModelLoader)((IConfigurationElement)SDPlugin.getResouceLoaderList().get(new Integer(4))).createExecutableExtension("class");
                    iModelLoader.setObjectAndGraph(object, graph);
                    graph.setModelLoader(iModelLoader);
                }
                return;
            }
            if (object instanceof TRCProcessProxy) {
                if (SDPlugin.getResouceLoaderList().get(new Integer(2)) != null) {
                    iModelLoader = (IModelLoader)((IConfigurationElement)SDPlugin.getResouceLoaderList().get(new Integer(2))).createExecutableExtension("class");
                    iModelLoader.setObjectAndGraph(object, graph);
                    graph.setModelLoader(iModelLoader);
                }
                return;
            }
            if (object instanceof TRCNode) {
                if (SDPlugin.getResouceLoaderList().get(new Integer(3)) != null) {
                    iModelLoader = (IModelLoader)((IConfigurationElement)SDPlugin.getResouceLoaderList().get(new Integer(3))).createExecutableExtension("class");
                    iModelLoader.setObjectAndGraph(object, graph);
                    graph.setModelLoader(iModelLoader);
                }
                return;
            }
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
    }
}

