/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sd.ui.internal.views;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.sd.ui.SDPlugin;
import org.eclipse.hyades.sd.ui.internal.model.Graph;
import org.eclipse.hyades.sd.ui.internal.model.GraphContentFactory;
import org.eclipse.hyades.sd.ui.internal.model.TableContentFactory;
import org.eclipse.hyades.sd.ui.internal.util.LogCDrawUtils;
import org.eclipse.hyades.sd.ui.internal.util.LogCorrelationSelectionDialog;
import org.eclipse.hyades.sd.ui.internal.views.SDViewer;
import org.eclipse.hyades.sd.ui.internal.views.SDViewerUI;
import org.eclipse.hyades.trace.ui.TraceViewer;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SDViewerPage
extends TraceViewerPage {
    protected SDViewerUI sdViewerUI = null;
    protected Composite parent;
    protected int viewerType;
    protected IRunnableWithProgress op = null;
    protected IConfigurationElement correlationType = null;

    public SDViewerPage(EObject eObject, TraceViewer traceViewer) {
        super(eObject, traceViewer);
    }

    public void createControl(Composite composite) {
        this.parent = composite;
    }

    public Control getControl() {
        Control control = null;
        if (LogCDrawUtils.getViewerType() == LogCDrawUtils.SD_VIEWER) {
            if (this.sdViewerUI == null) {
                this.sdViewerUI = this.createEditorAndModel(((SDViewer)this.getTraceViewer()).getCurrentGraphType());
            }
            control = this.sdViewerUI.getControl();
            this.viewerType = LogCDrawUtils.SD_VIEWER;
        }
        this.setContextMenu((Control)this.sdViewerUI.getCanvas(), this.sdViewerUI);
        return control;
    }

    public void makeActions(String string) {
        this.getTraceViewer().makeActions();
    }

    public void setFocus() {
        this.getTraceViewer().setFocus();
    }

    public void setMOFObject(EObject eObject) {
        this._mofObject = eObject;
    }

    public void update() {
        ((SDViewerUI)this.getControl()).updateUI();
    }

    private Graph getGraph(int n) {
        if (LogCDrawUtils.getViewerType() == LogCDrawUtils.TABLE_VIEWER) {
            if (SDPlugin.getDefault().getPreferenceStore().getBoolean("filter_self_call")) {
                return Graph.getGraphFactory().createFilteredGraph(n, this.getMOFObject(), TableContentFactory.getContentFactory());
            }
            return Graph.getGraphFactory().createGraph(n, this.getMOFObject(), TableContentFactory.getContentFactory());
        }
        if (SDPlugin.getDefault().getPreferenceStore().getBoolean("filter_self_call")) {
            return Graph.getGraphFactory().createFilteredGraph(n, this.getMOFObject(), GraphContentFactory.getContentFactory());
        }
        return Graph.getGraphFactory().createGraph(n, this.getMOFObject(), GraphContentFactory.getContentFactory());
    }

    private IExtension showCorrelationDialog() {
        IPluginRegistry iPluginRegistry = Platform.getPluginRegistry();
        IExtensionPoint iExtensionPoint = iPluginRegistry.getExtensionPoint("org.eclipse.hyades.logc.logInteractionView");
        if (iExtensionPoint != null) {
            IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
            LogCorrelationSelectionDialog logCorrelationSelectionDialog = new LogCorrelationSelectionDialog(null, iExtensionArray, this);
            logCorrelationSelectionDialog.open();
            if (logCorrelationSelectionDialog.getReturnCode() == 0) {
                IConfigurationElement iConfigurationElement = logCorrelationSelectionDialog.getSelectedCorrelation();
                this.setCorrelationType(iConfigurationElement);
            }
        }
        return null;
    }

    public void loadModel(int n, IConfigurationElement iConfigurationElement) {
        this.setCorrelationType(iConfigurationElement);
        this.loadModel(n);
    }

    public void loadModel(int n, boolean bl) {
        if ((n == 21 || n == 22) && bl) {
            this.showCorrelationDialog();
        }
        this.loadModel(n);
    }

    public void loadModel(int n) {
        ProgressMonitorDialog progressMonitorDialog = null;
        try {
            progressMonitorDialog = new ProgressMonitorDialog(this.getTraceViewer().getSite().getShell());
            if (this.op == null) {
                this.op = new LoadThread(this, n, progressMonitorDialog.getProgressMonitor());
            }
            progressMonitorDialog.setCancelable(true);
            progressMonitorDialog.run(false, true, this.op);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.load(n);
        }
        catch (InterruptedException interruptedException) {
            if (progressMonitorDialog != null) {
                progressMonitorDialog.close();
            }
            return;
        }
    }

    public void load(int n) {
        if (LogCDrawUtils.getViewerType() == LogCDrawUtils.SD_VIEWER) {
            this.sdViewerUI = this.createEditorAndModel(n);
            ((SDViewerUI)this.sdViewerUI.getControl()).goHome();
            this.viewerType = LogCDrawUtils.SD_VIEWER;
        }
    }

    private SDViewerUI createEditorAndModel(int n) {
        Graph graph = this.getGraph(n);
        if (this.sdViewerUI == null) {
            return new SDViewerUI(this.parent, graph, this);
        }
        this.sdViewerUI.reloadGraph(graph);
        return this.sdViewerUI;
    }

    public void dispose() {
        super.dispose();
        this._mofObject = null;
        if (this.sdViewerUI != null) {
            this.sdViewerUI.dispose();
        }
        this.op = null;
        this.correlationType = null;
    }

    public IConfigurationElement getCorrelationType() {
        return this.correlationType;
    }

    public void setCorrelationType(IConfigurationElement iConfigurationElement) {
        this.correlationType = iConfigurationElement;
    }

    public SDViewerUI getSdViewerUI() {
        return this.sdViewerUI;
    }

    public void refreshPage() {
    }

    public void selectionChanged() {
    }

    public void update(boolean bl) {
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        if (this.sdViewerUI != null) {
            this.sdViewerUI.fillContextMenu(iMenuManager);
        }
    }

    public boolean isEmpty() {
        if (this.sdViewerUI == null) {
            return true;
        }
        return this.sdViewerUI.isEmpty();
    }

    public class LoadThread
    implements IRunnableWithProgress {
        SDViewerPage sdPage;
        int graphType;
        IProgressMonitor monitor;

        public LoadThread(SDViewerPage sDViewerPage2, int n, IProgressMonitor iProgressMonitor) {
            this.sdPage = sDViewerPage2;
            this.graphType = n;
            this.monitor = iProgressMonitor;
        }

        public void run(IProgressMonitor iProgressMonitor) {
            iProgressMonitor.beginTask("", -1);
            this.sdPage.load(this.graphType);
            iProgressMonitor.done();
        }
    }
}

