/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.collection.correlation;

import org.eclipse.hyades.collection.correlation.IApplication;
import org.eclipse.hyades.collection.correlation.Stack;

public class ServiceRegistry
extends Stack {
    private static final int INITIAL_REGISTRY_SIZE = 5;
    private static final int INCREMENT_REGISTRY_SIZE = 5;
    private static ServiceRegistry registry;

    private ServiceRegistry() {
        super(5, 5);
    }

    public static synchronized ServiceRegistry getRegistry() {
        if (registry == null) {
            registry = new ServiceRegistry();
        }
        return registry;
    }

    public synchronized IApplication[] getApplications() {
        return (IApplication[])this.stack;
    }

    public synchronized IApplication getApplicationById(int n) {
        int n2 = 0;
        while (n2 <= this.top) {
            IApplication iApplication = (IApplication)this.stack[n2];
            if (iApplication.getId() == n) {
                return iApplication;
            }
            ++n2;
        }
        return null;
    }

    public synchronized boolean registerApplication(IApplication iApplication) {
        if (this.getApplicationById(iApplication.getId()) == null) {
            this.push(iApplication);
            return true;
        }
        return false;
    }

    public synchronized boolean deregisterApplication(IApplication iApplication) {
        int n = 0;
        while (n <= this.top) {
            IApplication iApplication2 = (IApplication)this.stack[n];
            if (iApplication2 == iApplication) {
                this.stack[n] = this.stack[this.top--];
                return true;
            }
            ++n;
        }
        return false;
    }
}

