/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.internal.ui;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.DeleteUtil;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;

public class PDContentProvider
implements ITreeContentProvider,
IResourceChangeListener {
    protected static Hashtable fMonitors = new Hashtable();
    private IStatus error;
    private Object[] objList;
    protected PDProjectExplorer fViewer;

    public PDContentProvider(PDProjectExplorer pDProjectExplorer) {
        this.fViewer = pDProjectExplorer;
        UIPlugin.getPluginWorkbench().addResourceChangeListener((IResourceChangeListener)this);
    }

    public static void addMonitor(IResource iResource, TRCMonitor tRCMonitor) {
        Object object = fMonitors.get(iResource);
        if (object == null) {
            object = new ArrayList();
            ((ArrayList)object).add(tRCMonitor);
            fMonitors.put(iResource, object);
        } else if (!((ArrayList)object).contains(tRCMonitor)) {
            ((ArrayList)object).add(tRCMonitor);
        }
    }

    public void dispose() {
        fMonitors.clear();
        UIPlugin.getPluginWorkbench().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public Object[] getChildren(Object object) {
        return this.getElements(object);
    }

    private Object[] getContainerMonitors(IContainer iContainer) {
        return this.getContainerMonitorsArray(iContainer).toArray();
    }

    private ArrayList getContainerMonitorsArray(IContainer iContainer) {
        ArrayList arrayList = this.getContainerMonitors0(iContainer);
        ArrayList<TRCMonitor> arrayList2 = new ArrayList<TRCMonitor>();
        int n = 0;
        while (n < arrayList.size()) {
            TRCMonitor tRCMonitor;
            Object e = arrayList.get(n);
            if (e instanceof TRCMonitor) {
                tRCMonitor = (TRCMonitor)e;
                if (this.fViewer.hasFilter(1)) {
                    arrayList2.addAll(this.getMonitorChildren0(tRCMonitor));
                } else {
                    arrayList2.add(tRCMonitor);
                }
            } else if (e instanceof IContainer) {
                tRCMonitor = (IContainer)e;
                if (this.fViewer.hasFilter(64)) {
                    arrayList2.addAll(this.getContainerMonitorsArray((IContainer)tRCMonitor));
                } else {
                    arrayList2.add(tRCMonitor);
                }
            }
            ++n;
        }
        return arrayList2;
    }

    protected ArrayList getContainerMonitors0(IContainer iContainer) {
        int n;
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        IWorkspace iWorkspace = iContainer.getWorkspace();
        if (iContainer == null || !iContainer.exists()) {
            return arrayList;
        }
        try {
            object = iContainer.members();
            n = 0;
            while (n < ((IResource[])object).length) {
                IResource iResource = object[n];
                if (iResource != null && iResource.exists() && iResource instanceof IFolder) {
                    arrayList.add(iResource);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object = fMonitors.get(iContainer);
        if (object == null) {
            Object object2;
            Object object3;
            try {
                object3 = iContainer.members();
                int n2 = 0;
                while (n2 < ((IResource[])object3).length) {
                    object2 = object3[n2];
                    if (object2 != null && object2.exists() && object2 instanceof IFile && object2.getFileExtension() != null && object2.getFileExtension().equals("trcmxmi")) {
                        this.getMonitors((IResource)object2, arrayList);
                    }
                    ++n2;
                }
            }
            catch (CoreException coreException) {
                this.error = new Status(2, "org.eclipse.core.resources", 566, coreException.toString(), (Throwable)coreException);
            }
            if (arrayList.size() > 0) {
                object3 = new ArrayList();
                int n3 = 0;
                while (n3 < arrayList.size()) {
                    object2 = arrayList.get(n3);
                    if (object2 instanceof TRCMonitor) {
                        ((ArrayList)object3).add(object2);
                    }
                    ++n3;
                }
                if (((ArrayList)object3).size() > 0) {
                    fMonitors.put(iContainer, object3);
                }
            }
            return arrayList;
        }
        n = 0;
        while (n < ((ArrayList)object).size()) {
            arrayList.add(((ArrayList)object).get(n));
            ++n;
        }
        if (arrayList == null || arrayList.size() == 0) {
            return new ArrayList();
        }
        return arrayList;
    }

    public Object[] getElements(Object object) {
        final Object object2 = object;
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                try {
                    if (object2 instanceof IWorkspace) {
                        PDContentProvider.access$102(PDContentProvider.this, PDContentProvider.this.getTraceSolutions(((IWorkspace)object2).getRoot()));
                    } else if (object2 instanceof IWorkspaceRoot) {
                        PDContentProvider.access$102(PDContentProvider.this, PDContentProvider.this.getTraceSolutions((IWorkspaceRoot)object2));
                    } else if (object2 instanceof IProject) {
                        PDContentProvider.access$102(PDContentProvider.this, PDContentProvider.this.getContainerMonitors((IContainer)((IProject)object2)));
                    } else if (object2 instanceof IFolder) {
                        PDContentProvider.access$102(PDContentProvider.this, PDContentProvider.this.getContainerMonitors((IContainer)((IFolder)object2)));
                    } else if (object2 instanceof TRCMonitor) {
                        PDContentProvider.access$102(PDContentProvider.this, PDContentProvider.this.getMonitorChildren((TRCMonitor)object2));
                    } else if (object2 instanceof TRCNode) {
                        PDContentProvider.access$102(PDContentProvider.this, PDContentProvider.this.getNodeProcesses((TRCNode)object2));
                    } else if (object2 instanceof TRCProcessProxy) {
                        PDContentProvider.access$102(PDContentProvider.this, PDContentProvider.this.getProcessAgents((TRCProcessProxy)object2));
                    } else if (object2 instanceof TRCAgentProxy) {
                        PDContentProvider.access$102(PDContentProvider.this, null);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        if (this.objList == null) {
            return new ArrayList().toArray();
        }
        return this.objList;
    }

    protected Object[] getMonitorChildren(TRCMonitor tRCMonitor) {
        return this.getMonitorChildren0(tRCMonitor).toArray();
    }

    protected ArrayList getMonitorChildren0(TRCMonitor tRCMonitor) {
        ArrayList<TRCNode> arrayList = new ArrayList<TRCNode>();
        try {
            Iterator iterator = tRCMonitor.getNodes().iterator();
            while (iterator.hasNext()) {
                TRCNode tRCNode = (TRCNode)iterator.next();
                if (tRCNode.eIsProxy()) continue;
                if (this.fViewer.hasFilter(2)) {
                    arrayList.addAll(this.getNodeProcesses0(tRCNode));
                    continue;
                }
                arrayList.add(tRCNode);
            }
        }
        catch (Exception exception) {
            return arrayList;
        }
        return arrayList;
    }

    public static ArrayList getMonitors() {
        Enumeration enumeration = fMonitors.elements();
        ArrayList arrayList = new ArrayList();
        while (enumeration.hasMoreElements()) {
            ArrayList arrayList2 = (ArrayList)enumeration.nextElement();
            int n = 0;
            while (n < arrayList2.size()) {
                arrayList.add(arrayList2.get(n));
                ++n;
            }
        }
        return arrayList;
    }

    public static ArrayList getMonitors(IContainer iContainer) {
        Object v = fMonitors.get(iContainer);
        if (v == null) {
            return new ArrayList();
        }
        return (ArrayList)v;
    }

    private void getMonitors(IResource iResource, ArrayList arrayList) {
        ResourceSet resourceSet = UIPlugin.getDefault().getResourceSet();
        Resource resource = null;
        try {
            String string;
            String string2 = string = iResource.getFullPath().toString();
            resource = resourceSet.getResource(URI.createURI((String)("platform:/resource" + string2)), true);
            EList eList = resource.getContents();
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof TRCMonitor)) continue;
                arrayList.add(e);
            }
        }
        catch (Exception exception) {
            String string = "Exception caught while loading " + iResource.getFullPath().toOSString() + " document: " + exception;
            this.error = new Status(2, "org.eclipse.core.resources", 566, exception.toString(), (Throwable)exception);
            exception.printStackTrace();
            return;
        }
    }

    protected Object[] getNodeProcesses(TRCNode tRCNode) {
        return this.getNodeProcesses0(tRCNode).toArray();
    }

    protected ArrayList getNodeProcesses0(TRCNode tRCNode) {
        ArrayList<TRCProcessProxy> arrayList = new ArrayList<TRCProcessProxy>();
        try {
            Iterator iterator = tRCNode.getProcessProxies().iterator();
            while (iterator.hasNext()) {
                TRCProcessProxy tRCProcessProxy = (TRCProcessProxy)iterator.next();
                if (tRCProcessProxy.eIsProxy()) continue;
                if (this.fViewer.hasFilter(4)) {
                    arrayList.addAll(this.getProcessAgents0(tRCProcessProxy));
                    continue;
                }
                arrayList.add(tRCProcessProxy);
            }
        }
        catch (Exception exception) {
            return arrayList;
        }
        return arrayList;
    }

    public Object getParent(Object object) {
        return null;
    }

    protected Object[] getProcessAgents(TRCProcessProxy tRCProcessProxy) {
        return this.getProcessAgents0(tRCProcessProxy).toArray();
    }

    protected ArrayList getProcessAgents0(TRCProcessProxy tRCProcessProxy) {
        ArrayList<TRCAgentProxy> arrayList = new ArrayList<TRCAgentProxy>();
        try {
            Object[] objectArray = tRCProcessProxy.getAgentProxies().toArray();
            int n = 0;
            while (n < objectArray.length) {
                TRCAgentProxy tRCAgentProxy = (TRCAgentProxy)objectArray[n];
                if (!tRCAgentProxy.eIsProxy()) {
                    String string = tRCAgentProxy.getType();
                    if (!(this.fViewer.hasFilter(16) && string.equals("Profiler") || this.fViewer.hasFilter(8) && string.equals("Logging"))) {
                        arrayList.add(tRCAgentProxy);
                    }
                }
                ++n;
            }
        }
        catch (Exception exception) {
            return arrayList;
        }
        return arrayList;
    }

    protected Object[] getTraceSolutions(IWorkspaceRoot iWorkspaceRoot) {
        if (this.fViewer.hasFilter(64)) {
            ArrayList arrayList = new ArrayList();
            IProject[] iProjectArray = iWorkspaceRoot.getProjects();
            int n = 0;
            while (n < iProjectArray.length) {
                arrayList.addAll(this.getContainerMonitorsArray((IContainer)iProjectArray[n]));
                ++n;
            }
            return arrayList.toArray();
        }
        return iWorkspaceRoot.getProjects();
    }

    public boolean hasChildren(Object object) {
        return this.getChildren(object).length > 0;
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
    }

    public boolean isDeleted(Object object) {
        if (object instanceof IResource) {
            return ((IResource)object).exists();
        }
        return false;
    }

    public static void removeContainer(IContainer iContainer) {
        fMonitors.remove(iContainer);
    }

    private void removeDoc(IContainer iContainer) {
        PDContentProvider.removeContainer(iContainer);
        try {
            DeleteUtil.deleteContainer(iContainer, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void removeMonitor(IContainer iContainer, TRCMonitor tRCMonitor) {
        if (iContainer == null) {
            return;
        }
        PDContentProvider.removeMonitor(iContainer.getFullPath().toOSString(), tRCMonitor);
    }

    public static void removeMonitor(String string, TRCMonitor tRCMonitor) {
        Path path = new Path(string);
        IWorkspaceRoot iWorkspaceRoot = UIPlugin.getPluginWorkbench().getRoot();
        IResource iResource = iWorkspaceRoot.findMember((IPath)path);
        if (iResource == null) {
            return;
        }
        Object v = fMonitors.get(iResource);
        if (v == null) {
            return;
        }
        ((AbstractCollection)((ArrayList)v)).remove(tRCMonitor);
    }

    public static void resetMonitors() {
        fMonitors.clear();
    }

    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        IWorkspace iWorkspace = UIPlugin.getPluginWorkbench();
        if (iResourceChangeEvent.getType() == 1 && iResourceChangeEvent.getSource() instanceof IWorkspace) {
            ResourceDeltaVisitor resourceDeltaVisitor;
            IResource iResource = iResourceChangeEvent.getResource();
            IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta();
            try {
                resourceDeltaVisitor = new ResourceDeltaVisitor();
                iResourceDelta.accept((IResourceDeltaVisitor)resourceDeltaVisitor);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            resourceDeltaVisitor = this.fViewer.getControl();
            if (resourceDeltaVisitor != null && !resourceDeltaVisitor.isDisposed()) {
                resourceDeltaVisitor.getDisplay().syncExec(new Runnable(){

                    public void run() {
                        PDContentProvider.this.fViewer.refresh();
                    }
                });
            }
        }
    }

    static /* synthetic */ Object[] access$102(PDContentProvider pDContentProvider, Object[] objectArray) {
        pDContentProvider.objList = objectArray;
        return objectArray;
    }

    class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        ResourceDeltaVisitor() {
        }

        public boolean visit(IResourceDelta iResourceDelta) throws CoreException {
            IResource iResource = iResourceDelta.getResource();
            if (iResource.getType() == 8) {
                return true;
            }
            if (iResourceDelta.getKind() == 2) {
                if (iResource instanceof IContainer) {
                    PDContentProvider.this.removeDoc((IContainer)iResource);
                }
                return true;
            }
            if (iResourceDelta.getKind() == 1) {
                return false;
            }
            if (iResourceDelta.getKind() == 4) {
                return true;
            }
            return true;
        }
    }
}

