/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.internal.ui;

import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.models.hierarchy.util.IUnresolvedResourceHelper;
import org.eclipse.hyades.models.hierarchy.util.SaveUtil;
import org.eclipse.hyades.trace.internal.ui.PDContentProvider;
import org.eclipse.hyades.trace.internal.ui.PDLabelProvider;
import org.eclipse.hyades.trace.internal.ui.PDProjectViewer;
import org.eclipse.hyades.trace.internal.ui.TraceUIManager;
import org.eclipse.hyades.trace.ui.IProfileEventListener;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.actions.TraceNavigatorActionGroup;
import org.eclipse.hyades.trace.ui.internal.core.TraceAssociationManager;
import org.eclipse.hyades.trace.ui.internal.launcher.AttachTraceAction;
import org.eclipse.hyades.trace.ui.internal.launcher.LaunchTraceAction;
import org.eclipse.hyades.trace.ui.internal.util.UnresolvedResourceHelper;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.part.ViewPart;

public class PDProjectExplorer
extends ViewPart
implements IProfileEventListener,
IPropertyListener {
    public static final String SET_LINK_TO_VIEW = "SET_LINK_TO_VIEW";
    public static final String TRACE_SECTION = "TraceNavigator";
    protected TraceNavigatorActionGroup actionGroup;
    private PDProjectViewer structuredViewer;
    private IDialogSettings settings;
    private boolean linkingEnabled;

    public PDProjectExplorer() {
        IUnresolvedResourceHelper iUnresolvedResourceHelper = HierarchyResourceSetImpl.getInstance().getUnresolvedException();
        if (iUnresolvedResourceHelper != null && iUnresolvedResourceHelper instanceof UnresolvedResourceHelper) {
            ((UnresolvedResourceHelper)iUnresolvedResourceHelper).setPDProjectExplorer(this);
        }
    }

    public void createPartControl(Composite composite) {
        TraceAssociationManager.getTraceViewMappingRegistry().addCommitChangeListener((IPropertyListener)this);
        this.structuredViewer = new PDProjectViewer(composite);
        this.structuredViewer.setContentProvider((IContentProvider)new PDContentProvider(this));
        this.structuredViewer.setLabelProvider((IBaseLabelProvider)new PDLabelProvider());
        this.structuredViewer.setInput(ResourcesPlugin.getWorkspace().getRoot());
        this.initContextMenu();
        this.initListeners();
        this.makeActions();
        this.getActionGroup().fillActionBars(this.getViewSite().getActionBars());
        this.updateActionBars((IStructuredSelection)this.structuredViewer.getSelection());
        UIPlugin.getDefault().addSelectionProvider((ISelectionProvider)this.structuredViewer, (IWorkbenchPart)this);
        UIPlugin.getDefault().addProfileEventListener(this);
        new RefreshUI().start();
    }

    protected void updateActionBars(IStructuredSelection iStructuredSelection) {
        TraceNavigatorActionGroup traceNavigatorActionGroup = this.getActionGroup();
        if (traceNavigatorActionGroup != null) {
            traceNavigatorActionGroup.setContext(new ActionContext((ISelection)iStructuredSelection));
            traceNavigatorActionGroup.updateActionBars();
        }
    }

    public void updateActionBars() {
        TraceNavigatorActionGroup traceNavigatorActionGroup = this.getActionGroup();
        if (traceNavigatorActionGroup != null) {
            traceNavigatorActionGroup.updateActionBars();
        }
    }

    public void dispose() {
        TraceAssociationManager.getTraceViewMappingRegistry().removeCommitChangeListener((IPropertyListener)this);
        this.settings = null;
        if (this.getActionGroup() != null) {
            this.getActionGroup().dispose();
        }
        UIPlugin.getDefault().removeProfileEventListener(this);
        if (this.structuredViewer != null) {
            UIPlugin.getDefault().removeSelectionProvider((ISelectionProvider)this.structuredViewer, (IWorkbenchPart)this);
        }
        try {
            boolean bl = false;
            if (HierarchyResourceSetImpl.getInstance().getResources().size() > 0) {
                String string;
                Object object;
                Iterator iterator = HierarchyResourceSetImpl.getInstance().getResources().iterator();
                while (iterator.hasNext()) {
                    object = (Resource)iterator.next();
                    if (object == null || !object.isLoaded() || !object.isModified()) continue;
                    bl = true;
                    break;
                }
                if (bl && MessageDialog.openQuestion(null, (String)(object = UIPlugin.getResourceString("TRACE_MSG")), (String)(string = UIPlugin.getResourceString("SAVE_PROJECT_SQ")))) {
                    SaveUtil.saveDocuments();
                    IWorkspaceRoot iWorkspaceRoot = UIPlugin.getPluginWorkbench().getRoot();
                    iWorkspaceRoot.refreshLocal(2, null);
                }
                HierarchyResourceSetImpl.getInstance().getResources().clear();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.structuredViewer.dispose();
        this.structuredViewer = null;
        ProfileEvent profileEvent = new ProfileEvent();
        profileEvent.setSource(null);
        profileEvent.setType(4096);
        UIPlugin.getDefault().notifyProfileEventListener(profileEvent);
        TraceUIManager.getTraceUIManager().dispose();
        super.dispose();
    }

    public final boolean hasFilter(int n) {
        return this.structuredViewer.hasFilter(n);
    }

    public Control getControl() {
        return this.structuredViewer.getControl();
    }

    public void refresh() {
        this.structuredViewer.refresh();
    }

    private boolean areAllProcessActive(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            if (!((TRCProcessProxy)objectArray[n]).isActive()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean anyProcessActive(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            if (((TRCProcessProxy)objectArray[n]).isActive()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean areSameClass(Object[] objectArray) {
        Class<?> clazz = objectArray[0].getClass();
        int n = 1;
        while (n < objectArray.length) {
            if (!clazz.equals(objectArray[n].getClass())) {
                return false;
            }
            clazz = objectArray[n].getClass();
            ++n;
        }
        return true;
    }

    protected void initContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                PDProjectExplorer.this.fillContextMenu(iMenuManager);
            }
        });
        Menu menu = menuManager.createContextMenu((Control)this.structuredViewer.getTree());
        this.structuredViewer.getTree().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.structuredViewer);
    }

    protected void initListeners() {
        this.structuredViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                PDProjectExplorer.this.handleDoubleClick(doubleClickEvent);
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)this.structuredViewer);
        this.structuredViewer.getControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                PDProjectExplorer.this.handleKeyPressed(keyEvent);
            }

            public void keyReleased(KeyEvent keyEvent) {
                PDProjectExplorer.this.handleKeyReleased(keyEvent);
            }
        });
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.getViewer().getSelection();
        this.getActionGroup().setContext(new ActionContext((ISelection)iStructuredSelection));
        this.getActionGroup().fillContextMenu(iMenuManager);
    }

    public static PDProjectExplorer getFromActivePerspective() {
        try {
            IViewPart iViewPart = UIPlugin.getActivePage().showView("org.eclipse.hyades.trace.internal.ui.PDProjectExplorer");
            if (iViewPart instanceof PDProjectExplorer) {
                return (PDProjectExplorer)iViewPart;
            }
        }
        catch (PartInitException partInitException) {
            partInitException.printStackTrace();
            return null;
        }
        return null;
    }

    public IResource getSelectionFolder() {
        return this.structuredViewer.getSelectionFolder();
    }

    public IResource getSelectionFolder(TreeItem treeItem) {
        return this.structuredViewer.getSelectionFolder(treeItem);
    }

    public Shell getShell() {
        return this.structuredViewer.getTree().getShell();
    }

    protected String getToolTipText() {
        return UIPlugin.getResourceString("PDPROEXPTOOLTIP");
    }

    public PDProjectViewer getViewer() {
        return this.structuredViewer;
    }

    protected void handleKeyPressed(KeyEvent keyEvent) {
        this.getActionGroup().handleKeyPressed(keyEvent);
    }

    protected TraceNavigatorActionGroup getActionGroup() {
        return this.actionGroup;
    }

    protected void setActionGroup(TraceNavigatorActionGroup traceNavigatorActionGroup) {
        this.actionGroup = traceNavigatorActionGroup;
    }

    protected void handleKeyReleased(KeyEvent keyEvent) {
    }

    protected void handleDoubleClick(DoubleClickEvent doubleClickEvent) {
        this.getActionGroup().handleDoubleClick(doubleClickEvent);
    }

    public void init(IViewSite iViewSite, IMemento iMemento) throws PartInitException {
        super.init(iViewSite, iMemento);
        IDialogSettings iDialogSettings = UIPlugin.getDefault().getDialogSettings();
        this.settings = iDialogSettings.getSection(TRACE_SECTION);
        if (this.settings == null) {
            this.settings = iDialogSettings.addNewSection(TRACE_SECTION);
            this.initSettings();
        } else {
            this.loadSettings();
        }
    }

    protected void initSettings() {
    }

    protected void loadSettings() {
        this.setLinkingEnabled(this.getSettings().getBoolean(SET_LINK_TO_VIEW));
    }

    protected void makeActions() {
        this.setActionGroup(new TraceNavigatorActionGroup(this));
    }

    public void refreshView(Object object) {
        this.structuredViewer.refresh();
        this.structuredViewer.selectObject(object);
    }

    public void selectObject(Object object) {
        this.structuredViewer.selectObject(object);
    }

    public void setFocus() {
        if (this.structuredViewer != null) {
            this.structuredViewer.getTree().setFocus();
        }
    }

    private void addLaunchOptions(IMenuManager iMenuManager) {
        iMenuManager.add((IAction)new LaunchTraceAction());
        iMenuManager.add((IAction)new AttachTraceAction());
    }

    public void handleProfileEvent(ProfileEvent profileEvent) {
        switch (profileEvent.getType()) {
            case 1: {
                this.structuredViewer.selectObject(profileEvent.getSource());
                break;
            }
            case 4: {
                this.structuredViewer.selectObject(profileEvent.getSource());
                break;
            }
            default: {
                this.structuredViewer.refresh(profileEvent.getSource());
            }
        }
    }

    public void propertyChanged(Object object, int n) {
        this.getActionGroup().propertyChanged(object, n);
    }

    protected IDialogSettings getSettings() {
        return this.settings;
    }

    public boolean isLinkingEnabled() {
        return this.linkingEnabled;
    }

    public void setLinkingEnabled(boolean bl) {
        this.linkingEnabled = bl;
        this.getSettings().put(SET_LINK_TO_VIEW, bl);
        if (bl && this.getViewer() != null) {
            this.getViewer().setSelection(this.getViewer().getSelection());
        }
    }

    class RefreshUI
    extends Thread {
        public RefreshUI() {
            super("Profile_Refresh");
        }

        public void run() {
            while (PDProjectExplorer.this.structuredViewer != null) {
                try {
                    IPreferenceStore iPreferenceStore = UIPlugin.getDefault().getPreferenceStore();
                    int n = iPreferenceStore.getInt("refresh_type");
                    Display display = Display.getDefault();
                    if (n == 1 && display != null && !display.isDisposed()) {
                        display.asyncExec(new Runnable(this){
                            private final /* synthetic */ RefreshUI this$1;
                            {
                                this.this$1 = refreshUI;
                            }

                            public void run() {
                                EObject eObject;
                                TreeItem treeItem = PDProjectExplorer.access$000(RefreshUI.access$100(this.this$1)).getTreeSelection();
                                if (treeItem != null && treeItem.getData() instanceof EObject && RefreshUI.access$200(this.this$1, eObject = (EObject)treeItem.getData())) {
                                    ProfileEvent profileEvent = UIPlugin.getDefault().getUpdateModelEvent(eObject);
                                    UIPlugin.getDefault().notifyProfileEventListener(profileEvent);
                                }
                            }
                        });
                    }
                    Thread.sleep(iPreferenceStore.getInt("refresh_int") * 1000);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        private boolean isModified(Object object) {
            if (object != null) {
                if (object instanceof TRCAgentProxy) {
                    return this.isAgentModified((TRCAgentProxy)object);
                }
                if (object instanceof TRCProcessProxy) {
                    Object[] objectArray = ((TRCProcessProxy)object).getAgentProxies().toArray();
                    int n = 0;
                    while (n < objectArray.length) {
                        boolean bl = this.isAgentModified((TRCAgentProxy)objectArray[n]);
                        if (bl) {
                            return true;
                        }
                        ++n;
                    }
                    return false;
                }
                if (object instanceof TRCNode) {
                    Object[] objectArray = ((TRCNode)object).getProcessProxies().toArray();
                    int n = 0;
                    while (n < objectArray.length) {
                        Object[] objectArray2 = ((TRCProcessProxy)objectArray[n]).getAgentProxies().toArray();
                        int n2 = 0;
                        while (n2 < objectArray2.length) {
                            boolean bl = this.isAgentModified((TRCAgentProxy)objectArray2[n2]);
                            if (bl) {
                                return true;
                            }
                            ++n2;
                        }
                        ++n;
                    }
                    return false;
                }
                if (object instanceof TRCMonitor) {
                    Object[] objectArray = ((TRCMonitor)object).getNodes().toArray();
                    int n = 0;
                    while (n < objectArray.length) {
                        Object[] objectArray3 = ((TRCNode)objectArray[n]).getProcessProxies().toArray();
                        int n3 = 0;
                        while (n3 < objectArray3.length) {
                            Object[] objectArray4 = ((TRCProcessProxy)objectArray3[n3]).getAgentProxies().toArray();
                            int n4 = 0;
                            while (n4 < objectArray4.length) {
                                boolean bl = this.isAgentModified((TRCAgentProxy)objectArray4[n4]);
                                if (bl) {
                                    return true;
                                }
                                ++n4;
                            }
                            ++n3;
                        }
                        ++n;
                    }
                    return false;
                }
            }
            return false;
        }

        private boolean isAgentModified(TRCAgentProxy tRCAgentProxy) {
            if (tRCAgentProxy.getType().equals("Profiler")) {
                if (tRCAgentProxy.isCollectionData()) {
                    return true;
                }
                if (tRCAgentProxy.getAgent() != null && tRCAgentProxy.getAgent().eResource() != null && tRCAgentProxy.getAgent().eResource().isModified()) {
                    tRCAgentProxy.getAgent().eResource().setModified(false);
                    return true;
                }
                return false;
            }
            if (tRCAgentProxy.getAgent() != null && tRCAgentProxy.getAgent().eResource() != null && tRCAgentProxy.getAgent().eResource().isModified()) {
                tRCAgentProxy.getAgent().eResource().setModified(false);
                return true;
            }
            return false;
        }

        static /* synthetic */ PDProjectExplorer access$100(RefreshUI refreshUI) {
            return refreshUI.PDProjectExplorer.this;
        }

        static /* synthetic */ boolean access$200(RefreshUI refreshUI, Object object) {
            return refreshUI.isModified(object);
        }
    }
}

