/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui;

import java.text.DateFormat;
import java.util.Date;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.internal.execution.local.control.Application;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.security.util.ConnectUtil;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.internal.ui.PDProjectViewer;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;

public class HyadesUtil {
    public static final int CONNECTION_SUCCESS = 0;
    public static final int CONNECTION_CONTROLLER_ERROR = 1;
    public static final int CONNECTION_HOST_ERROR = 2;
    public static final int CONNECTION_PORT_ERROR = 3;
    private static StringBuffer tmpBuffer = new StringBuffer();

    public static String change(String string, String string2, String string3) {
        if (string2.length() == 0) {
            return string;
        }
        if (string2.length() == 1 && string3.length() == 1) {
            return string.replace(string2.charAt(0), string3.charAt(0));
        }
        int n = 0;
        int n2 = 0;
        tmpBuffer.setLength(0);
        while ((n2 = string.indexOf(string2, n)) != -1) {
            tmpBuffer.append(string.substring(n, n2)).append(string3);
            n = n2 + string2.length();
        }
        tmpBuffer.append(string.substring(n));
        return tmpBuffer.toString();
    }

    public static String getAgentName(TRCAgentProxy tRCAgentProxy) {
        String string = tRCAgentProxy.getType();
        String string2 = tRCAgentProxy.getName();
        if (string2 == null) {
            string2 = "";
        }
        if (string.equals("Profiler")) {
            if (!string2.equals("J2EE Request Profiler")) {
                string2 = UIPlugin.getResourceString("TRACE_NAME");
            }
        } else if (string.equals("Logging") && string2.equals("")) {
            string2 = UIPlugin.getResourceString("LOG_NAME");
        }
        if (tRCAgentProxy.getStartTime() > 0.0) {
            Date date = new Date((long)tRCAgentProxy.getStartTime() * 1000L);
            String string3 = DateFormat.getDateTimeInstance(3, 2).format(date);
            string2 = string2 + " (" + string3 + ")";
        }
        return string2;
    }

    public static String getProcessName(TRCProcessProxy tRCProcessProxy) {
        tmpBuffer.setLength(0);
        return tmpBuffer.append(tRCProcessProxy.getName()).append(" [ PID:").append(tRCProcessProxy.getPid()).append(" ]").toString();
    }

    public static String getAgentLabel(TRCAgentProxy tRCAgentProxy) {
        tmpBuffer.setLength(0);
        if (tRCAgentProxy.isActive() && tRCAgentProxy.isMonitored()) {
            tmpBuffer.append("<").append(UIPlugin.getResourceString("AGENT_MONITORED"));
        } else if (tRCAgentProxy.isActive() && tRCAgentProxy.isAttached()) {
            tmpBuffer.append("<").append(UIPlugin.getResourceString("AGENT_ATTACHED"));
        } else if (tRCAgentProxy.isActive()) {
            tmpBuffer.append("<").append(UIPlugin.getResourceString("AGENT_DETACTED"));
        } else {
            tmpBuffer.append("<").append(UIPlugin.getResourceString("AGENT_TERMINATED"));
        }
        if (tRCAgentProxy.isCollectionData()) {
            tmpBuffer.append(UIPlugin.getResourceString("STR_COLLECTING")).append(">");
        } else {
            tmpBuffer.append(">");
        }
        return tmpBuffer.toString();
    }

    public static int testConnection(String string, String string2, boolean bl, Shell shell) {
        if (string == null || string.trim() == "" || string2 == null || string2.trim() == "") {
            String string3 = UIPlugin.getResourceString("INVALID_HOST");
            Status status = new Status(2, "org.eclipse.core.resources", 2, string3, null);
            ErrorDialog.openError((Shell)shell, (String)UIPlugin.getResourceString("STR_TITLE_MSG"), (String)UIPlugin.getResourceString("CONNECT_ERROR_"), (IStatus)status);
            return 2;
        }
        IPreferenceStore iPreferenceStore = UIPlugin.getDefault().getPreferenceStore();
        ConnectUtil connectUtil = new ConnectUtil(string, string2, iPreferenceStore.getString("user_id"), (Application)UIPlugin.getDefault());
        int n = connectUtil.connect();
        if (n == 0) {
            iPreferenceStore.setValue("user_id", connectUtil.getUserId());
            if (bl) {
                String string4 = UIPlugin.getResourceString("CONNECTION_SUCCESS_TEXT");
                MessageDialog.openInformation((Shell)shell, (String)UIPlugin.getResourceString("STR_HYADES_MSG"), (String)string4);
            }
        }
        return n;
    }

    public static EObject getSelectedObject() {
        IWorkbenchPage iWorkbenchPage = UIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (iWorkbenchPage == null || !iWorkbenchPage.getPerspective().getId().equals("org.eclipse.hyades.trace.internal.ui.tracePerspective")) {
            return null;
        }
        IViewPart iViewPart = iWorkbenchPage.findView("org.eclipse.hyades.trace.internal.ui.PDProjectExplorer");
        if (iViewPart == null || !(iViewPart instanceof PDProjectExplorer)) {
            return null;
        }
        TreeItem treeItem = null;
        PDProjectViewer pDProjectViewer = ((PDProjectExplorer)iViewPart).getViewer();
        if (pDProjectViewer != null) {
            treeItem = pDProjectViewer.getTreeSelection();
        }
        if (treeItem == null || !(treeItem.getData() instanceof EObject)) {
            return null;
        }
        return (EObject)treeItem.getData();
    }
}

