/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.actions;

import java.io.File;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.local.common.DataProcessor;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.XMLLoader;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.actions.AbstractListenerActionDelegate;
import org.eclipse.hyades.trace.ui.internal.piclient.XMLTraceDataProcessor;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class StartTraceActionDelegate
extends AbstractListenerActionDelegate {
    public void doAction(Object object) throws Exception {
        if (object == null || !(object instanceof TRCAgentProxy)) {
            return;
        }
        PDProjectExplorer pDProjectExplorer = UIPlugin.getDefault().getViewer();
        if (pDProjectExplorer == null) {
            MessageDialog.openInformation((Shell)UIPlugin.getActiveWorkbenchShell(), (String)"title", (String)"Action not available in current context");
            return;
        }
        this.run((TRCAgentProxy)object, pDProjectExplorer);
    }

    public void run(TRCAgentProxy tRCAgentProxy, PDProjectExplorer pDProjectExplorer) {
        TRCProcessProxy tRCProcessProxy = tRCAgentProxy.getProcessProxy();
        String string = tRCProcessProxy.getNode().getName();
        try {
            Agent agent;
            Node node = PDCoreUtil.profileConnect(string, String.valueOf(tRCProcessProxy.getNode().getPort()));
            if (node == null) {
                return;
            }
            Object object = LoadersUtils.locateAgentInstance((TRCAgentProxy)tRCAgentProxy);
            if (object != null && object instanceof Agent && (agent = (Agent)object).isActive()) {
                Object object2;
                if (tRCAgentProxy.isToProfileFile()) {
                    agent.setProfileFile(tRCAgentProxy.getProfileFile());
                } else {
                    agent.setProfileFile(null);
                }
                PDCoreUtil.setAgentConfiguration(tRCAgentProxy, agent);
                agent.publishConfiguration();
                CustomCommand customCommand = new CustomCommand();
                customCommand.setData("APPLYFILTERS");
                agent.invokeCustomCommand(customCommand);
                XMLTraceDataProcessor xMLTraceDataProcessor = (XMLTraceDataProcessor)LoadersUtils.locateDataProcessor((TRCAgentProxy)tRCAgentProxy);
                if (xMLTraceDataProcessor == null) {
                    xMLTraceDataProcessor = new XMLTraceDataProcessor(tRCAgentProxy);
                    LoadersUtils.registerDataProcessor((TRCAgentProxy)tRCAgentProxy, (XMLLoader)xMLTraceDataProcessor);
                }
                if (xMLTraceDataProcessor != null) {
                    File file;
                    object2 = xMLTraceDataProcessor.getProfileFileName();
                    File file2 = object2 == null ? null : new File((String)object2);
                    boolean bl = true;
                    if (tRCAgentProxy.isToProfileFile() && (file = new File(tRCAgentProxy.getProfileFile())).exists()) {
                        bl = false;
                    }
                    if (file2 == null && tRCAgentProxy.isToProfileFile()) {
                        xMLTraceDataProcessor.setProfileFileName(tRCAgentProxy.getProfileFile());
                        xMLTraceDataProcessor.createWriter();
                        bl = xMLTraceDataProcessor.isNewProfileFile();
                        if (bl) {
                            xMLTraceDataProcessor.writeXMLVersion(xMLTraceDataProcessor.getWriter());
                            xMLTraceDataProcessor.startTrace(xMLTraceDataProcessor.getWriter());
                        }
                    } else if (!(object2 == null || ((String)object2).equals(tRCAgentProxy.getProfileFile()) && file2.exists())) {
                        if (file2.exists()) {
                            xMLTraceDataProcessor.endTrace(xMLTraceDataProcessor.getWriter());
                        }
                        xMLTraceDataProcessor.setProfileFileName(tRCAgentProxy.getProfileFile());
                        xMLTraceDataProcessor.createWriter();
                        bl = xMLTraceDataProcessor.isNewProfileFile();
                        if (bl) {
                            xMLTraceDataProcessor.writeXMLVersion(xMLTraceDataProcessor.getWriter());
                            xMLTraceDataProcessor.startTrace(xMLTraceDataProcessor.getWriter());
                        }
                    }
                }
                agent.startMonitoring((DataProcessor)xMLTraceDataProcessor);
                tRCAgentProxy.setCollectionData(true);
                customCommand.setData("RESUME");
                agent.invokeCustomCommand(customCommand);
                tRCAgentProxy.setMonitored(true);
                tRCAgentProxy.setActive(true);
                tRCAgentProxy.setAttached(true);
                object2 = UIPlugin.getDefault().getProfileEvent();
                ((ProfileEvent)object2).setSource(tRCAgentProxy);
                ((ProfileEvent)object2).setType(1);
                UIPlugin.getDefault().notifyProfileEventListener((ProfileEvent)object2);
            }
            pDProjectExplorer.getViewer().refresh(tRCAgentProxy);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected boolean isEnabledFor(Object object) {
        return object != null && object instanceof TRCAgentProxy && ((TRCAgentProxy)object).isAttached() && !((TRCAgentProxy)object).isMonitored();
    }
}

