/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.console;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.console.ConsoleDataProcessor;
import org.eclipse.hyades.trace.ui.internal.console.ConsoleOutputTextStore;
import org.eclipse.hyades.trace.ui.internal.console.TraceConsoleViewer;
import org.eclipse.hyades.trace.ui.internal.preferences.TraceConsolePreferencePage;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.ITextStore;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;

public class TraceConsoleDocument
extends AbstractDocument {
    public static final int fgMinimumSize = 500;
    public static final int fgMinMaxRation = 5;
    private boolean fClosed = false;
    private int fMinSize = 500;
    private int fMaxSize = 2500;
    private int fLastStreamWriteEnd = 0;
    private int fNewStreamWriteEnd = 0;
    protected boolean fNeedsToStartReading = true;
    public static final int OUT = 0;
    public static final int ERR = 1;
    protected List fStyleRanges = new ArrayList(2);
    protected ConsoleDataProcessor fDataConsole;
    protected TraceConsoleViewer fConsoleViewer = null;

    public TraceConsoleDocument(ConsoleDataProcessor consoleDataProcessor) {
        this.fDataConsole = consoleDataProcessor;
        this.setTextStore(new ConsoleOutputTextStore(this.fMaxSize));
        this.setLineTracker((ILineTracker)new DefaultLineTracker());
        this.completeInitialization();
    }

    protected void addNewStyleRange(StyleRange styleRange) {
        List list = this.fStyleRanges;
        if (this.fClosed) {
            return;
        }
        list.add(styleRange);
    }

    protected void clearDocument() {
        this.fStyleRanges = new ArrayList(2);
        this.set("");
    }

    public void close() {
        this.stopReading();
        this.fClosed = true;
        this.fStyleRanges = Collections.EMPTY_LIST;
        this.set("");
    }

    protected void coaleseRanges() {
        StyleRange styleRange;
        StyleRange styleRange2;
        int n = this.fStyleRanges.size();
        if (n > 1 && (styleRange2 = (StyleRange)this.fStyleRanges.get(n - 1)).similarTo(styleRange = (StyleRange)this.fStyleRanges.get(n - 2))) {
            StyleRange styleRange3 = new StyleRange(styleRange.start, styleRange2.length + styleRange.length, styleRange2.foreground, null);
            this.fStyleRanges.remove(n - 1);
            this.fStyleRanges.remove(n - 2);
            this.addNewStyleRange(styleRange3);
        }
    }

    protected void ensureSizeConstraints() {
        if (this.getLength() > this.fMaxSize) {
            this.replace(0, this.getLength() - this.fMinSize, "");
        }
    }

    public boolean equals(Object object) {
        boolean bl = object instanceof TraceConsoleDocument;
        if (this.fDataConsole != null) {
            return bl && this.fDataConsole.equals(((TraceConsoleDocument)((Object)object)).fDataConsole);
        }
        return bl && ((TraceConsoleDocument)((Object)object)).fDataConsole == null;
    }

    protected void fireDocumentChanged(DocumentEvent documentEvent) {
        super.fireDocumentChanged(documentEvent);
        String string = documentEvent.getText();
        if (string == null || 0 >= string.length() || string.length() > 2) {
            return;
        }
        String[] stringArray = documentEvent.getDocument().getLegalLineDelimiters();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                try {
                    String string2 = documentEvent.getDocument().get();
                    string2 = string2.substring(this.fNewStreamWriteEnd, string2.length());
                    if (string2.length() == 0) {
                        return;
                    }
                    if (this.fDataConsole != null) {
                        this.fDataConsole.write(string2);
                    }
                    this.fLastStreamWriteEnd = this.getLength();
                    return;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            ++n;
        }
    }

    protected int getStartOfEditableContent() {
        return this.fLastStreamWriteEnd;
    }

    protected ITextStore getStore() {
        return super.getStore();
    }

    protected StyleRange[] getStyleRanges() {
        if (this.fStyleRanges.isEmpty()) {
            return new StyleRange[0];
        }
        StyleRange[] styleRangeArray = new StyleRange[this.fStyleRanges.size()];
        return this.fStyleRanges.toArray(styleRangeArray);
    }

    public boolean isClosed() {
        return this.fClosed;
    }

    protected boolean isReadOnly() {
        return false;
    }

    public void replace(int n, int n2, String string) {
        if (this.isReadOnly() || n < this.getStartOfEditableContent()) {
            return;
        }
        this.replace0(n, n2, string);
        int n3 = this.getLength();
        if (n3 == this.fNewStreamWriteEnd) {
            this.fStyleRanges.remove(this.fStyleRanges.size() - 1);
        } else {
            this.updateInputStyleRange(n3);
            this.fireDocumentChanged(new DocumentEvent((IDocument)this, 0, 0, ""));
        }
    }

    protected void replace0(int n, int n2, String string) {
        try {
            super.replace(n, n2, string);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        if (string != null && string.length() - n2 > this.fMaxSize / 2) {
            this.ensureSizeConstraints();
        }
    }

    public void set(String string) {
        this.fNewStreamWriteEnd = string.length();
        super.set(string);
        this.fLastStreamWriteEnd = this.fNewStreamWriteEnd;
        this.ensureSizeConstraints();
    }

    public void setBufferSize(int n, int n2) {
        this.fMinSize = n < 500 ? 500 : n;
        int n3 = this.fMaxSize = n2 < n * 5 ? n * 5 : n2;
        if (this.getStore() instanceof ConsoleOutputTextStore) {
            ((ConsoleOutputTextStore)this.getStore()).setMinimalBufferSize(this.fMinSize);
        }
        this.ensureSizeConstraints();
    }

    protected void setConsoleViewer(TraceConsoleViewer traceConsoleViewer) {
        this.fConsoleViewer = traceConsoleViewer;
    }

    protected void setStyleRanges(List list) {
        this.fStyleRanges = list;
    }

    public void startReading() {
    }

    protected void stopReading() {
    }

    protected void streamAppended(final String string, final int n) {
        this.update(new Runnable(){

            public void run() {
                try {
                    IWorkbenchPage iWorkbenchPage = UIPlugin.getActivePage();
                    if (iWorkbenchPage != null) {
                        iWorkbenchPage.showView("org.eclipse.hyades.trace.ui.internal.console.TraceConsoleView");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                int n2 = string.length();
                TraceConsoleDocument.this.fNewStreamWriteEnd = TraceConsoleDocument.this.fLastStreamWriteEnd + n2;
                TraceConsoleDocument.this.replace0(TraceConsoleDocument.this.fLastStreamWriteEnd, 0, string);
                TraceConsoleDocument.this.updateOutputStyleRanges(n);
                TraceConsoleDocument.this.fLastStreamWriteEnd = TraceConsoleDocument.this.fNewStreamWriteEnd;
            }
        });
    }

    protected void systemErrAppended(String string) {
        this.streamAppended(string, 1);
    }

    protected void systemOutAppended(String string) {
        this.streamAppended(string, 0);
    }

    protected void update(Runnable runnable) {
        if (this.fConsoleViewer != null) {
            this.fConsoleViewer.getControl().getDisplay().asyncExec(runnable);
        } else {
            Display display = UIPlugin.getDefault().getConsoleManager().getDisplay();
            if (display != null) {
                display.asyncExec(runnable);
            }
        }
    }

    protected void updateInputStyleRange(int n) {
        if (this.fClosed) {
            return;
        }
        if (n != this.fNewStreamWriteEnd) {
            StyleRange styleRange = new StyleRange(this.fNewStreamWriteEnd, n - this.fNewStreamWriteEnd, TraceConsolePreferencePage.getPreferenceColor("Console.stdInColor"), null);
            if (!this.fStyleRanges.isEmpty() && ((StyleRange)this.fStyleRanges.get(this.fStyleRanges.size() - 1)).similarTo(styleRange)) {
                this.fStyleRanges.remove(this.fStyleRanges.size() - 1);
            }
            this.addNewStyleRange(styleRange);
        }
    }

    protected void updateOutputStyleRanges(int n) {
        if (this.fClosed) {
            return;
        }
        int n2 = this.getLength();
        if (n2 == 0) {
            return;
        }
        if (this.fNewStreamWriteEnd == 0 && 0 == this.fLastStreamWriteEnd) {
            return;
        }
        if (this.fNewStreamWriteEnd == this.fLastStreamWriteEnd) {
            return;
        }
        Color color = n == 0 ? TraceConsolePreferencePage.getPreferenceColor("Console.stdOutColor") : TraceConsolePreferencePage.getPreferenceColor("Console.stdErrColor");
        StyleRange styleRange = new StyleRange(this.fLastStreamWriteEnd, this.fNewStreamWriteEnd - this.fLastStreamWriteEnd, color, null);
        if (!this.fStyleRanges.isEmpty() && n2 != this.fNewStreamWriteEnd && ((StyleRange)this.fStyleRanges.get((int)(this.fStyleRanges.size() - 1))).foreground == TraceConsolePreferencePage.getPreferenceColor("Console.stdInColor")) {
            this.fStyleRanges.remove(this.fStyleRanges.size() - 1);
        }
        this.addNewStyleRange(styleRange);
        this.coaleseRanges();
        this.updateInputStyleRange(n2);
        this.fireDocumentChanged(new DocumentEvent((IDocument)this, 0, 0, null));
    }
}

