/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.console;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.IProfileEventListener;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.console.ClearOutputAction;
import org.eclipse.hyades.trace.ui.internal.console.ConsoleGotoLineAction;
import org.eclipse.hyades.trace.ui.internal.console.ConsoleViewerAction;
import org.eclipse.hyades.trace.ui.internal.console.TraceConsoleDocument;
import org.eclipse.hyades.trace.ui.internal.console.TraceConsoleViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.FindReplaceAction;
import org.eclipse.ui.texteditor.IUpdate;

public class TraceConsoleView
extends ViewPart
implements IProfileEventListener,
ISelectionListener {
    protected static final String PREFIX = "console_view.";
    protected static final String _title = UIPlugin.getResourceString("STR_TRACE_CONSOLE");
    protected TraceConsoleViewer fConsoleViewer = null;
    protected ClearOutputAction fClearOutputAction = null;
    protected Map fGlobalActions = new HashMap(10);
    protected List fSelectionActions = new ArrayList(7);
    protected Separator fAdditions;
    protected Separator fSeparator;
    static /* synthetic */ Class class$org$eclipse$jface$text$IFindReplaceTarget;

    public void createPartControl(Composite composite) {
        UIPlugin.getDefault().addProfileEventListener(this);
        UIPlugin.getDefault().addSelectionListener(this);
        this.fConsoleViewer = new TraceConsoleViewer(composite);
        this.initializeActions();
        this.initializeToolBar();
        MenuManager menuManager = new MenuManager("#PopUp", "org.eclipse.hyades.trace.ui.internal.console.TraceConsoleView");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                TraceConsoleView.this.fillContextMenu(iMenuManager);
            }
        });
        Menu menu = menuManager.createContextMenu((Control)this.fConsoleViewer.getTextWidget());
        this.fConsoleViewer.getTextWidget().setMenu(menu);
        this.getSite().registerContextMenu(menuManager.getId(), menuManager, (ISelectionProvider)this.fConsoleViewer);
        this.fConsoleViewer.getSelectionProvider().addSelectionChangedListener(this.getSelectionChangedListener());
        this.setViewerInput(UIPlugin.getDefault().getConsoleManager().getCurrentProcess());
        this.setTitleToolTip(UIPlugin.getResourceString("TRACECONSOLEVIEW_TOOLTIP"));
    }

    protected void fillContextMenu(IMenuManager iMenuManager) {
        Point point = this.fConsoleViewer.getTextWidget().getSelection();
        TraceConsoleDocument traceConsoleDocument = (TraceConsoleDocument)this.fConsoleViewer.getDocument();
        if (traceConsoleDocument == null) {
            return;
        }
        if (traceConsoleDocument.isReadOnly() || point.x < traceConsoleDocument.getStartOfEditableContent()) {
            iMenuManager.add((IAction)this.fGlobalActions.get("copy"));
            iMenuManager.add((IAction)this.fGlobalActions.get("selectAll"));
        } else {
            iMenuManager.add((IAction)this.fGlobalActions.get("cut"));
            iMenuManager.add((IAction)this.fGlobalActions.get("copy"));
            iMenuManager.add((IAction)this.fGlobalActions.get("paste"));
            iMenuManager.add((IAction)this.fGlobalActions.get("selectAll"));
        }
        iMenuManager.add((IContributionItem)this.fSeparator);
        iMenuManager.add((IAction)this.fGlobalActions.get("find"));
        iMenuManager.add((IAction)this.fGlobalActions.get("GotoLine"));
        iMenuManager.add((IAction)this.fClearOutputAction);
        iMenuManager.add((IContributionItem)this.fAdditions);
    }

    public Object getAdapter(Class clazz) {
        if ((class$org$eclipse$jface$text$IFindReplaceTarget == null ? (class$org$eclipse$jface$text$IFindReplaceTarget = TraceConsoleView.class$("org.eclipse.jface.text.IFindReplaceTarget")) : class$org$eclipse$jface$text$IFindReplaceTarget).equals(clazz)) {
            return this.fConsoleViewer.getFindReplaceTarget();
        }
        return super.getAdapter(clazz);
    }

    protected final ISelectionChangedListener getSelectionChangedListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                TraceConsoleView.this.updateSelectionDependentActions();
            }
        };
    }

    private void initializeActions() {
        this.fSeparator = new Separator("FIND");
        this.fAdditions = new Separator("additions");
        this.fClearOutputAction = new ClearOutputAction(this.fConsoleViewer);
        this.fClearOutputAction.setImageDescriptor(PDPluginImages.getImageDescriptor("clear_co.gif"));
        ResourceBundle resourceBundle = UIPlugin.getDefault().getResourceBundle();
        IActionBars iActionBars = this.getViewSite().getActionBars();
        this.setGlobalAction(iActionBars, "cut", (IAction)new ConsoleViewerAction(resourceBundle, "cut_action.", this.fConsoleViewer, 3));
        this.setGlobalAction(iActionBars, "copy", (IAction)new ConsoleViewerAction(resourceBundle, "copy_action.", this.fConsoleViewer, 4));
        this.setGlobalAction(iActionBars, "paste", (IAction)new ConsoleViewerAction(resourceBundle, "paste_action.", this.fConsoleViewer, 5));
        this.setGlobalAction(iActionBars, "selectAll", (IAction)new ConsoleViewerAction(resourceBundle, "select_all_action.", this.fConsoleViewer, 7));
        this.setGlobalAction(iActionBars, "find", (IAction)new FindReplaceAction(resourceBundle, "find_replace_action.", (IWorkbenchPart)this));
        this.setGlobalAction(iActionBars, "GotoLine", (IAction)new ConsoleGotoLineAction(resourceBundle, "goto_line_action.", this.fConsoleViewer));
        this.fSelectionActions.add("cut");
        this.fSelectionActions.add("copy");
        this.fSelectionActions.add("paste");
        this.updateAction("find");
    }

    private void initializeToolBar() {
        IToolBarManager iToolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        iToolBarManager.add((IAction)this.fClearOutputAction);
        this.getViewSite().getActionBars().updateActionBars();
    }

    public void markAsSelectionDependentAction(String string) {
        if (!this.fSelectionActions.contains(string)) {
            this.fSelectionActions.add(string);
        }
    }

    public void setFocus() {
        this.fConsoleViewer.getControl().setFocus();
    }

    protected void setGlobalAction(IActionBars iActionBars, String string, IAction iAction) {
        this.fGlobalActions.put(string, iAction);
        iActionBars.setGlobalActionHandler(string, iAction);
    }

    public void setViewerInput(TRCProcessProxy tRCProcessProxy) {
        this.setViewerInput(tRCProcessProxy, true);
    }

    public void setViewerInput(final TRCProcessProxy tRCProcessProxy, final boolean bl) {
        if (this.fConsoleViewer == null) {
            return;
        }
        Display display = this.fConsoleViewer.getControl().getDisplay();
        if (display != null) {
            display.asyncExec(new Runnable(){

                public void run() {
                    IDocument iDocument = UIPlugin.getDefault().getConsoleManager().getConsoleDocument(tRCProcessProxy, bl);
                    TraceConsoleView.this.fConsoleViewer.setDocument(iDocument);
                }
            });
        }
    }

    protected void updateAction(String string) {
        IAction iAction = (IAction)this.fGlobalActions.get(string);
        if (iAction instanceof IUpdate) {
            ((IUpdate)iAction).update();
        }
    }

    protected void updateSelectionDependentActions() {
        Iterator iterator = this.fSelectionActions.iterator();
        while (iterator.hasNext()) {
            this.updateAction((String)iterator.next());
        }
    }

    public void handleProfileEvent(ProfileEvent profileEvent) {
        this.setViewTitle(profileEvent.getSource());
    }

    private void setViewTitle(Object object) {
        if (object != null) {
            if (object instanceof EObject) {
                object = this.getObjectToView((EObject)object);
            }
            if (object instanceof TRCAgentProxy) {
                TRCAgentProxy tRCAgentProxy = (TRCAgentProxy)object;
                String string = HyadesUtil.getAgentLabel(tRCAgentProxy);
                this.setTitle(this.getViewTitle() + " [" + string + " " + HyadesUtil.getProcessName(tRCAgentProxy.getProcessProxy()) + "]");
                return;
            }
        }
        this.setTitle(this.getViewTitle());
    }

    public EObject getObjectToView(EObject eObject) {
        if (eObject == null) {
            return eObject;
        }
        if (eObject instanceof TRCProcessProxy) {
            EList eList = ((TRCProcessProxy)eObject).getAgentProxies();
            int n = 0;
            while (n < eList.size()) {
                TRCAgentProxy tRCAgentProxy = (TRCAgentProxy)eList.get(n);
                if (!tRCAgentProxy.eIsProxy() && tRCAgentProxy.getType().equals("Profiler")) {
                    return tRCAgentProxy;
                }
                ++n;
            }
        }
        return eObject;
    }

    public String getViewTitle() {
        return _title;
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        if (iWorkbenchPart == null || iWorkbenchPart.getSite().getWorkbenchWindow() != this.getSite().getWorkbenchWindow()) {
            return;
        }
        if (iSelection == null || iSelection.isEmpty() || !(iSelection instanceof IStructuredSelection)) {
            this.setViewTitle(null);
            return;
        }
        Object object = ((IStructuredSelection)iSelection).getFirstElement();
        this.setViewTitle(object);
    }

    public void dispose() {
        super.dispose();
        UIPlugin.getDefault().removeSelectionListener(this);
        UIPlugin.getDefault().removeProfileEventListener(this);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

