/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.core;

import java.util.Vector;
import org.eclipse.hyades.internal.execution.local.common.Options;
import org.eclipse.hyades.internal.execution.local.control.AgentConfigurationEntry;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class TraceProfileOptionsUI
implements SelectionListener,
ModifyListener {
    private Button _appHeapBtn;
    private Label _appHeapLabel;
    private Button _heapAdvanced;
    private Composite _detailsHeapGroup;
    private Button _showHeapInstance;
    private Button _appExecBtn;
    private Label _appExecLabel;
    private Button _boundary;
    private Label _traceDepthLabel;
    private Text _traceDepth;
    private Button _execAdvanced;
    private Composite _detailsExecGroup;
    private Button _showExecStatistic;
    private Button _showExecFlow;
    private Button _appCoverageBtn;
    private Label _appCoverageLabel;
    private boolean _enableHeap = true;
    private WizardPage wizardPage;
    private PreferencePage preferencePage;

    public Composite createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 2;
        GridData gridData = GridUtil.createFill();
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)gridData);
        Composite composite3 = new Composite(composite2, 0);
        gridData = GridUtil.createHorizontalFill();
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite3.setLayout((Layout)gridLayout);
        composite3.setLayoutData((Object)gridData);
        this._appHeapBtn = new Button(composite3, 32);
        this._appHeapBtn.setText(UIPlugin.getResourceString("STR_TOO_MUCH_MEMORY"));
        this._appHeapBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._appHeapLabel = new Label(composite3, 64);
        this._appHeapLabel.setText(UIPlugin.getResourceString("STR_ANALYZE_HEAP"));
        gridData = new GridData();
        gridData.horizontalIndent = 20;
        gridData.widthHint = 375;
        this._appHeapLabel.setLayoutData((Object)gridData);
        this._heapAdvanced = new Button(composite3, 0);
        this._heapAdvanced.setText(UIPlugin.getResourceString("SHOW_DET"));
        this.addHeapOption(composite3);
        this._detailsHeapGroup.setVisible(false);
        this._heapAdvanced.addSelectionListener((SelectionListener)this);
        this._appExecBtn = new Button(composite3, 32);
        this._appExecBtn.setText(UIPlugin.getResourceString("STR_APP_TOO_SLOW"));
        this._appExecBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._appExecLabel = new Label(composite3, 64);
        this._appExecLabel.setText(UIPlugin.getResourceString("STR_ANALYZE_EXE_TIME"));
        gridData = new GridData();
        gridData.horizontalIndent = 20;
        gridData.widthHint = 375;
        this._appExecLabel.setLayoutData((Object)gridData);
        this._execAdvanced = new Button(composite3, 0);
        this._execAdvanced.setText(UIPlugin.getResourceString("SHOW_DET2"));
        this.addExecutionOption(composite3);
        this._detailsExecGroup.setVisible(false);
        this._appCoverageBtn = new Button(composite3, 32);
        this._appCoverageBtn.setText(UIPlugin.getResourceString("STR_APP_COVERAGE"));
        this._appCoverageBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._appCoverageLabel = new Label(composite3, 64);
        this._appCoverageLabel.setText(UIPlugin.getResourceString("STR_ANALYZE_COVERAGE"));
        gridData = new GridData();
        gridData.horizontalIndent = 20;
        gridData.widthHint = 375;
        this._appCoverageLabel.setLayoutData((Object)gridData);
        this._execAdvanced.addSelectionListener((SelectionListener)this);
        this._appHeapBtn.addSelectionListener((SelectionListener)this);
        this._appExecBtn.addSelectionListener((SelectionListener)this);
        return composite2;
    }

    private void addHeapOption(Composite composite) {
        this._detailsHeapGroup = new Composite(composite, 0);
        GridData gridData = GridUtil.createHorizontalFill();
        gridData.horizontalIndent = 20;
        this._detailsHeapGroup.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this._detailsHeapGroup.setLayout((Layout)gridLayout);
        this._showHeapInstance = new Button(this._detailsHeapGroup, 32);
        this._showHeapInstance.setText(UIPlugin.getResourceString("STR_SHOW_INST_LEVEL_INFO"));
        WorkbenchHelp.setHelp((Control)this._showHeapInstance, (String)(UIPlugin.getPluginId() + ".topp0011"));
    }

    private void addExecutionOption(Composite composite) {
        this._detailsExecGroup = new Composite(composite, 0);
        GridData gridData = GridUtil.createHorizontalFill();
        gridData.horizontalIndent = 20;
        this._detailsExecGroup.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this._detailsExecGroup.setLayout((Layout)gridLayout);
        this._boundary = new Button(this._detailsExecGroup, 32);
        gridData = GridUtil.createHorizontalFill();
        gridData.horizontalSpan = 2;
        this._boundary.setLayoutData((Object)gridData);
        this._boundary.setText(UIPlugin.getResourceString("AGENT_UI_BOUNDARY_CLASS"));
        this._traceDepthLabel = new Label(this._detailsExecGroup, 0);
        this._traceDepthLabel.setText(UIPlugin.getResourceString("STR_COLLECT_DEPTH"));
        this._traceDepth = new Text(this._detailsExecGroup, 2048);
        gridData = new GridData();
        gridData.widthHint = 70;
        this._traceDepth.setLayoutData((Object)gridData);
        Group group = new Group(this._detailsExecGroup, 0);
        gridData = GridUtil.createHorizontalFill();
        gridData.horizontalSpan = 2;
        group.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        group.setLayout((Layout)gridLayout);
        this._showExecStatistic = new Button((Composite)group, 16);
        this._showExecStatistic.setText(UIPlugin.getResourceString("EXEC_STAT"));
        this._showExecFlow = new Button((Composite)group, 16);
        this._showExecFlow.setText(UIPlugin.getResourceString("DETAILED_DATA"));
        this._boundary.addSelectionListener((SelectionListener)this);
        this._traceDepth.addModifyListener((ModifyListener)this);
        WorkbenchHelp.setHelp((Control)this._boundary, (String)(UIPlugin.getPluginId() + ".topp0002"));
        WorkbenchHelp.setHelp((Control)this._traceDepth, (String)(UIPlugin.getPluginId() + ".topp0008"));
    }

    public void enable(boolean bl) {
        this._appHeapBtn.setEnabled(bl);
        this._appHeapLabel.setEnabled(this._appHeapBtn.getEnabled());
        this._appExecBtn.setEnabled(bl);
        this._appExecLabel.setEnabled(this._appExecBtn.getEnabled());
        this._appCoverageBtn.setEnabled(bl);
        this._appCoverageLabel.setEnabled(this._appCoverageBtn.getEnabled());
        this._showHeapInstance.setEnabled(this._appHeapBtn.getEnabled());
        this.enableExecutionButtons(this._appExecBtn.getEnabled());
    }

    public void enableExecutionButtons(boolean bl) {
        this._boundary.setEnabled(bl);
        this._traceDepth.setEnabled(bl);
        this._traceDepthLabel.setEnabled(bl);
        this._showExecStatistic.setEnabled(bl);
        this._showExecFlow.setEnabled(bl);
    }

    public void enableButtons() {
        IPreferenceStore iPreferenceStore = UIPlugin.getDefault().getPreferenceStore();
        this.setHeap(iPreferenceStore.getBoolean("prof_heap_stat"));
        this.setHeapDetails(iPreferenceStore.getBoolean("prof_heap_inst"));
        this.setExecution(iPreferenceStore.getBoolean("prof_execution"));
        this.setExecutionBoundary(iPreferenceStore.getBoolean("prof_execution_boundary"));
        this.setCollectionDepth(iPreferenceStore.getString("collect_depth"));
        this.setExecutionStatistic(iPreferenceStore.getBoolean("prof_exec_stat"));
        this.setExecutionFlow(!iPreferenceStore.getBoolean("prof_exec_stat"));
        this.setCoverage(iPreferenceStore.getBoolean("prof_coverage"));
        this.enableBtnGroup();
    }

    public void enableBtnGroup() {
        this.enableHeptBtnGroup();
        this.enableExecutionBtnGroup();
    }

    private void enableHeptBtnGroup() {
        this._showHeapInstance.setEnabled(this._appHeapBtn.getSelection());
    }

    private void enableExecutionBtnGroup() {
        if (this._appExecBtn.getSelection()) {
            this._boundary.setEnabled(true);
            this._showExecFlow.setEnabled(true);
            this._showExecStatistic.setEnabled(true);
        } else {
            this._boundary.setEnabled(false);
            this._boundary.setSelection(false);
            this._showExecFlow.setEnabled(false);
            this._showExecStatistic.setEnabled(false);
        }
        this._traceDepth.setEnabled(this._boundary.getSelection());
        this._traceDepthLabel.setEnabled(this._boundary.getSelection());
    }

    public void enableHeapInfo(boolean bl) {
        this._enableHeap = bl;
        if (!bl) {
            this._appHeapBtn.setEnabled(false);
            this._showHeapInstance.setEnabled(false);
        }
    }

    public Vector getOptions() {
        AgentConfigurationEntry agentConfigurationEntry;
        int n;
        String[][] stringArray;
        Vector<AgentConfigurationEntry> vector = new Vector<AgentConfigurationEntry>();
        if (!this.getHeap()) {
            stringArray = Options.OPTIONS_ANALYZE_HEAP_NONE;
            n = 0;
            while (n < stringArray.length) {
                agentConfigurationEntry = new AgentConfigurationEntry();
                agentConfigurationEntry.setName(stringArray[n][0]);
                agentConfigurationEntry.setValue(stringArray[n][1]);
                agentConfigurationEntry.setType("SETOPTION");
                vector.addElement(agentConfigurationEntry);
                ++n;
            }
        } else {
            stringArray = Options.OPTIONS_ANALYZE_HEAP;
            n = 0;
            while (n < stringArray.length) {
                agentConfigurationEntry = new AgentConfigurationEntry();
                agentConfigurationEntry.setName(stringArray[n][0]);
                agentConfigurationEntry.setValue(stringArray[n][1]);
                agentConfigurationEntry.setType("SETOPTION");
                vector.addElement(agentConfigurationEntry);
                ++n;
            }
        }
        if (this.getHeap() && !this.getExecution()) {
            stringArray = Options.OPTIONS_EXECUTION_FLOW_NONE;
            n = 0;
            while (n < stringArray.length) {
                agentConfigurationEntry = new AgentConfigurationEntry();
                agentConfigurationEntry.setName(stringArray[n][0]);
                agentConfigurationEntry.setValue(stringArray[n][1]);
                agentConfigurationEntry.setType("SETOPTION");
                vector.addElement(agentConfigurationEntry);
                ++n;
            }
            return vector;
        }
        if (this.getExecutionBoundary()) {
            stringArray = Options.OPTIONS_EXECUTION_FLOW_BOUNDARY;
            n = 0;
            while (n < stringArray.length) {
                agentConfigurationEntry = new AgentConfigurationEntry();
                agentConfigurationEntry.setName(stringArray[n][0]);
                agentConfigurationEntry.setValue(stringArray[n][1]);
                agentConfigurationEntry.setType("SETOPTION");
                vector.addElement(agentConfigurationEntry);
                ++n;
            }
            agentConfigurationEntry = new AgentConfigurationEntry();
            agentConfigurationEntry.setName("BOUNDARY_DEPTH");
            agentConfigurationEntry.setValue(String.valueOf(this.getCollectionDepth()));
            agentConfigurationEntry.setType("SETOPTION");
            vector.addElement(agentConfigurationEntry);
        } else if (this.getExecution()) {
            stringArray = Options.OPTIONS_EXECUTION_FLOW;
            n = 0;
            while (n < stringArray.length) {
                agentConfigurationEntry = new AgentConfigurationEntry();
                agentConfigurationEntry.setName(stringArray[n][0]);
                agentConfigurationEntry.setValue(stringArray[n][1]);
                agentConfigurationEntry.setType("SETOPTION");
                vector.addElement(agentConfigurationEntry);
                ++n;
            }
        } else {
            stringArray = Options.OPTIONS_EXECUTION_FLOW_NONE;
            n = 0;
            while (n < stringArray.length) {
                agentConfigurationEntry = new AgentConfigurationEntry();
                agentConfigurationEntry.setName(stringArray[n][0]);
                agentConfigurationEntry.setValue(stringArray[n][1]);
                agentConfigurationEntry.setType("SETOPTION");
                vector.addElement(agentConfigurationEntry);
                ++n;
            }
        }
        if (this.getExecution() && !this.getHeap()) {
            stringArray = Options.OPTIONS_NO_INSTANCE_INFORMATION;
            n = 0;
            while (n < stringArray.length) {
                agentConfigurationEntry = new AgentConfigurationEntry();
                agentConfigurationEntry.setName(stringArray[n][0]);
                agentConfigurationEntry.setValue(stringArray[n][1]);
                agentConfigurationEntry.setType("SETOPTION");
                vector.addElement(agentConfigurationEntry);
                ++n;
            }
        }
        if (this.getCoverage()) {
            stringArray = Options.OPTIONS_COVERAGE_NO_FLOW;
            if (this.getExecution()) {
                stringArray = Options.OPTIONS_COVERAGE;
            }
            n = 0;
            while (n < stringArray.length) {
                agentConfigurationEntry = new AgentConfigurationEntry();
                agentConfigurationEntry.setName(stringArray[n][0]);
                agentConfigurationEntry.setValue(stringArray[n][1]);
                agentConfigurationEntry.setType("SETOPTION");
                vector.addElement(agentConfigurationEntry);
                ++n;
            }
        }
        return vector;
    }

    private boolean checkValidTraceDepth() {
        if (this._boundary.getSelection()) {
            String string = this._traceDepth.getText().trim();
            try {
                if (Integer.parseInt(string) <= 0) {
                    return false;
                }
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    public void modifyText(ModifyEvent modifyEvent) {
        if (modifyEvent.getSource() == this._traceDepth) {
            this.checkNumbersAndPrintErrorMsg();
        }
    }

    public boolean getHeap() {
        return this._appHeapBtn.getSelection();
    }

    public boolean getHeapDetails() {
        return this._showHeapInstance.getSelection();
    }

    public boolean getExecution() {
        return this._appExecBtn.getSelection();
    }

    public boolean getExecutionStatistic() {
        return this._showExecStatistic.getSelection();
    }

    public boolean getExecutionBoundary() {
        return this._boundary.getSelection();
    }

    public int getCollectionDepth() {
        String string = this._traceDepth.getText().trim();
        try {
            int n = Integer.parseInt(string);
            if (n > 0) {
                return n;
            }
            return UIPlugin.getDefault().getPreferenceStore().getDefaultInt("collect_depth");
        }
        catch (Exception exception) {
            return UIPlugin.getDefault().getPreferenceStore().getDefaultInt("collect_depth");
        }
    }

    public void setHeap(boolean bl) {
        this._appHeapBtn.setSelection(bl);
    }

    public void setHeapDetails(boolean bl) {
        this._showHeapInstance.setSelection(bl);
    }

    public void setExecution(boolean bl) {
        this._appExecBtn.setSelection(bl);
    }

    public void setExecutionStatistic(boolean bl) {
        this._showExecStatistic.setSelection(bl);
    }

    public void setExecutionFlow(boolean bl) {
        this._showExecFlow.setSelection(bl);
    }

    public void setExecutionBoundary(boolean bl) {
        this._boundary.setSelection(bl);
        this._traceDepth.setEnabled(this._boundary.getSelection());
        this._traceDepthLabel.setEnabled(this._boundary.getSelection());
    }

    public void setCollectionDepth(String string) {
        this._traceDepth.setText(string);
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this._appHeapBtn) {
            this._showHeapInstance.setEnabled(this._appHeapBtn.getSelection());
            if (!this._showHeapInstance.getEnabled()) {
                this._showHeapInstance.setSelection(false);
            }
        } else if (selectionEvent.widget == this._appExecBtn) {
            this.enableExecutionBtnGroup();
        } else if (selectionEvent.widget == this._boundary) {
            this._traceDepth.setEnabled(this._boundary.getSelection());
            this._traceDepthLabel.setEnabled(this._boundary.getSelection());
        } else if (selectionEvent.widget == this._execAdvanced) {
            this._detailsExecGroup.setVisible(!this._detailsExecGroup.getVisible());
            if (this._detailsExecGroup.getVisible()) {
                this._execAdvanced.setText(UIPlugin.getResourceString("HIDE_DET2"));
            } else {
                this._execAdvanced.setText(UIPlugin.getResourceString("SHOW_DET2"));
            }
            this._execAdvanced.pack();
        } else if (selectionEvent.widget == this._heapAdvanced) {
            this._detailsHeapGroup.setVisible(!this._detailsHeapGroup.getVisible());
            if (this._detailsHeapGroup.getVisible()) {
                this._heapAdvanced.setText(UIPlugin.getResourceString("HIDE_DET"));
            } else {
                this._heapAdvanced.setText(UIPlugin.getResourceString("SHOW_DET"));
            }
            this._heapAdvanced.pack();
        }
        this.checkNumbersAndPrintErrorMsg();
    }

    public void checkNumbersAndPrintErrorMsg() {
        if (this.wizardPage != null) {
            if (!this.checkValidTraceDepth()) {
                this.wizardPage.setErrorMessage(UIPlugin.getResourceString("STR_INVALID_BOUND_VALUE"));
                this.wizardPage.setPageComplete(false);
            } else {
                this.wizardPage.setErrorMessage(null);
                this.wizardPage.setPageComplete(true);
            }
        } else if (this.preferencePage != null) {
            if (!this.checkValidTraceDepth()) {
                this.preferencePage.setErrorMessage(UIPlugin.getResourceString("STR_INVALID_BOUND_VALUE"));
                this.preferencePage.setValid(false);
            } else {
                this.preferencePage.setErrorMessage(null);
                this.preferencePage.setValid(true);
            }
        }
    }

    public void storeValues() {
        IPreferenceStore iPreferenceStore = UIPlugin.getDefault().getPreferenceStore();
        iPreferenceStore.setValue("prof_heap_stat", this.getHeap());
        iPreferenceStore.setValue("prof_heap_inst", this.getHeapDetails());
        iPreferenceStore.setValue("prof_execution", this.getExecution());
        iPreferenceStore.setValue("prof_execution_boundary", this.getExecutionBoundary());
        iPreferenceStore.setValue("collect_depth", this.getCollectionDepth());
        iPreferenceStore.setValue("prof_exec_stat", this.getExecutionStatistic());
        iPreferenceStore.setValue("prof_coverage", this.getCoverage());
    }

    public void setWizardPage(WizardPage wizardPage) {
        this.wizardPage = wizardPage;
    }

    public void setPreferencePage(PreferencePage preferencePage) {
        this.preferencePage = preferencePage;
    }

    public boolean getCoverage() {
        return this._appCoverageBtn.getSelection();
    }

    public void setCoverage(boolean bl) {
        this._appCoverageBtn.setSelection(bl);
    }
}

