/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.util;

import java.net.UnknownHostException;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NodeFactory;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.XMLLoader;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.util.HierarchyXMIResourceImpl;
import org.eclipse.hyades.models.hierarchy.util.SaveUtil;
import org.eclipse.hyades.trace.internal.ui.PDContentProvider;
import org.eclipse.hyades.trace.ui.IDeleteListener;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.piclient.PIProcessListener;
import org.eclipse.hyades.trace.ui.internal.piclient.XMLTraceDataProcessor;
import org.eclipse.hyades.trace.ui.internal.util.TString;

public class DeleteUtil {
    public static void deleteAgent(TRCAgentProxy tRCAgentProxy, boolean bl, boolean bl2) {
        if (tRCAgentProxy == null) {
            return;
        }
        TRCProcessProxy tRCProcessProxy = tRCAgentProxy.getProcessProxy();
        if (tRCProcessProxy == null) {
            return;
        }
        if (tRCProcessProxy.getAgentProxies().size() == 1) {
            DeleteUtil.deleteProcess(tRCProcessProxy, bl, bl2);
        } else {
            DeleteUtil.removeDoc(tRCAgentProxy, bl2);
            tRCAgentProxy.setProcessProxy(null);
        }
        if (bl) {
            ProfileEvent profileEvent = UIPlugin.getDefault().getProfileEvent();
            profileEvent.setSource(null);
            profileEvent.setType(128);
            UIPlugin.getDefault().notifyProfileEventListener(profileEvent);
        }
    }

    public static void deleteMonitor(TRCMonitor tRCMonitor, boolean bl, boolean bl2) {
        if (tRCMonitor == null) {
            return;
        }
        Path path = new Path(TString.resourcePath(tRCMonitor.eResource().getURI()));
        if (path.segmentCount() > 1) {
            path = path.removeLastSegments(1);
        }
        PDContentProvider.removeMonitor(path.toOSString(), tRCMonitor);
        DeleteUtil.removeDoc(tRCMonitor, bl2);
        if (bl) {
            ProfileEvent profileEvent = UIPlugin.getDefault().getProfileEvent();
            profileEvent.setSource(null);
            profileEvent.setType(128);
            UIPlugin.getDefault().notifyProfileEventListener(profileEvent);
        }
    }

    public static void deleteNode(TRCNode tRCNode, boolean bl, boolean bl2) {
        if (tRCNode == null) {
            return;
        }
        TRCMonitor tRCMonitor = tRCNode.getMonitor();
        if (tRCMonitor == null) {
            return;
        }
        if (tRCMonitor.getNodes().size() == 1) {
            DeleteUtil.deleteMonitor(tRCMonitor, bl, bl2);
        } else {
            DeleteUtil.removeDoc(tRCNode, bl2);
            tRCNode.setMonitor(null);
        }
        if (bl) {
            ProfileEvent profileEvent = UIPlugin.getDefault().getProfileEvent();
            profileEvent.setSource(null);
            profileEvent.setType(128);
            UIPlugin.getDefault().notifyProfileEventListener(profileEvent);
        }
    }

    public static void deleteProcess(TRCProcessProxy tRCProcessProxy, boolean bl, boolean bl2) {
        if (tRCProcessProxy == null) {
            return;
        }
        TRCNode tRCNode = tRCProcessProxy.getNode();
        if (tRCNode == null) {
            return;
        }
        if (tRCNode.getProcessProxies().size() == 1) {
            DeleteUtil.deleteNode(tRCNode, bl, bl2);
        } else {
            DeleteUtil.removeDoc(tRCProcessProxy, bl2);
            tRCProcessProxy.setNode(null);
        }
        if (bl) {
            ProfileEvent profileEvent = UIPlugin.getDefault().getProfileEvent();
            profileEvent.setSource(null);
            profileEvent.setType(128);
            UIPlugin.getDefault().notifyProfileEventListener(profileEvent);
        }
    }

    public static void deleteContainer(IContainer iContainer, boolean bl) throws CoreException {
        if (iContainer == null || !iContainer.exists()) {
            return;
        }
        IResource[] iResourceArray = iContainer.members();
        if (iResourceArray.length > 0) {
            int n = 0;
            while (n < iResourceArray.length) {
                if (iResourceArray[n] instanceof IFolder) {
                    IFolder iFolder = (IFolder)iResourceArray[n];
                    DeleteUtil.deleteContainer((IContainer)iFolder, bl);
                }
                ++n;
            }
        }
        ArrayList arrayList = PDContentProvider.getMonitors(iContainer);
        int n = 0;
        while (n < arrayList.size()) {
            TRCMonitor tRCMonitor;
            if (arrayList.get(n) instanceof TRCMonitor && (tRCMonitor = (TRCMonitor)arrayList.get(n)) != null) {
                DeleteUtil.deleteMonitor(tRCMonitor, true, bl);
            }
            ++n;
        }
        PDContentProvider.removeContainer(iContainer);
        iContainer.delete(true, null);
    }

    public static void deleteResource(IResource iResource, boolean bl) {
        if (iResource == null) {
            return;
        }
        try {
            IContainer iContainer = iResource.getParent();
            if (iResource == null || !iResource.exists()) {
                return;
            }
            if (iResource instanceof IProject || iResource instanceof IFolder) {
                DeleteUtil.deleteContainer((IContainer)iResource, bl);
            } else {
                iResource.delete(true, null);
            }
            ProfileEvent profileEvent = UIPlugin.getDefault().getProfileEvent();
            profileEvent.setSource(null);
            profileEvent.setType(128);
            UIPlugin.getDefault().notifyProfileEventListener(profileEvent);
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
    }

    public static void removeDoc(TRCAgentProxy tRCAgentProxy, boolean bl) {
        ArrayList arrayList;
        if (tRCAgentProxy == null || tRCAgentProxy.getAgent() == null || tRCAgentProxy.getAgent().eResource() == null) {
            return;
        }
        XMLLoader xMLLoader = LoadersUtils.locateDataProcessor((TRCAgentProxy)tRCAgentProxy);
        if (xMLLoader != null && xMLLoader instanceof XMLTraceDataProcessor) {
            ((XMLTraceDataProcessor)xMLLoader).dispose();
        }
        LoadersUtils.deregisterDataProcessor((TRCAgentProxy)tRCAgentProxy);
        Object object = LoadersUtils.locateAgentListener((TRCAgentProxy)tRCAgentProxy);
        if (object != null && object instanceof PIProcessListener) {
            ((PIProcessListener)object).dispose();
        }
        LoadersUtils.deregisterAgentListener((TRCAgentProxy)tRCAgentProxy);
        LoadersUtils.deregisterAgentInstance((TRCAgentProxy)tRCAgentProxy);
        LoadersUtils.deregisterAgentProxyContext((TRCAgentProxy)tRCAgentProxy);
        if (bl) {
            arrayList = new Path(TString.resourcePath(tRCAgentProxy.getAgent().eResource().getURI()));
            IResource iResource = UIPlugin.getPluginWorkbench().getRoot().findMember((IPath)arrayList);
            DeleteUtil.deleteResource(iResource, true);
        }
        UIPlugin.getDefault().getTraceManager().deregisterTrace(tRCAgentProxy);
        arrayList = UIPlugin.getDefault().getDeleteListeners();
        int n = 0;
        while (n < arrayList.size()) {
            ((IDeleteListener)arrayList.get(n)).deregister(tRCAgentProxy);
            ++n;
        }
        TRCProcessProxy tRCProcessProxy = tRCAgentProxy.getProcessProxy();
        TRCNode tRCNode = tRCProcessProxy.getNode();
        if (tRCProcessProxy == null || tRCNode == null) {
            return;
        }
        tRCProcessProxy.getAgentProxies().remove(tRCAgentProxy);
        try {
            Agent agent;
            Object object2;
            String string = tRCNode.getName();
            Node node = NodeFactory.createNode((String)string);
            if (node.isConnected() && (object2 = LoadersUtils.locateAgentInstance((TRCAgentProxy)tRCAgentProxy)) != null && object2 instanceof Agent && (agent = (Agent)object2).isAttached()) {
                agent.detach();
            }
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        DeleteUtil.unloadDoc((EObject)tRCAgentProxy.getAgent());
    }

    public static void removeDoc(TRCMonitor tRCMonitor, boolean bl) {
        Path path;
        if (tRCMonitor == null) {
            return;
        }
        ArrayList arrayList = UIPlugin.getDefault().getDeleteListeners();
        int n = 0;
        while (n < arrayList.size()) {
            ((IDeleteListener)arrayList.get(n)).deregister(tRCMonitor);
            ++n;
        }
        if (tRCMonitor.eResource() != null && bl) {
            path = new Path(TString.resourcePath(tRCMonitor.eResource().getURI()));
            IResource iResource = UIPlugin.getPluginWorkbench().getRoot().findMember((IPath)path);
            DeleteUtil.deleteResource(iResource, true);
        }
        path = tRCMonitor.getNodes().toArray();
        int n2 = 0;
        while (n2 < ((Path)path).length) {
            TRCNode tRCNode = (TRCNode)path[n2];
            if (!tRCNode.eIsProxy()) {
                DeleteUtil.removeDoc(tRCNode, bl);
            }
            ++n2;
        }
        DeleteUtil.unloadDoc((EObject)tRCMonitor);
    }

    public static void removeDoc(TRCNode tRCNode, boolean bl) {
        TRCMonitor tRCMonitor;
        Path path;
        if (tRCNode == null) {
            return;
        }
        ArrayList arrayList = UIPlugin.getDefault().getDeleteListeners();
        int n = 0;
        while (n < arrayList.size()) {
            ((IDeleteListener)arrayList.get(n)).deregister(tRCNode);
            ++n;
        }
        if (tRCNode.eResource() != null && bl) {
            path = new Path(TString.resourcePath(tRCNode.eResource().getURI()));
            IResource iResource = UIPlugin.getPluginWorkbench().getRoot().findMember((IPath)path);
            DeleteUtil.deleteResource(iResource, true);
        }
        path = tRCNode.getProcessProxies().toArray();
        int n2 = 0;
        while (n2 < ((Path)path).length) {
            tRCMonitor = (TRCProcessProxy)path[n2];
            if (!tRCMonitor.eIsProxy()) {
                DeleteUtil.removeDoc((TRCProcessProxy)tRCMonitor, bl);
            }
            ++n2;
        }
        tRCMonitor = tRCNode.getMonitor();
        if (tRCMonitor == null) {
            return;
        }
        tRCMonitor.getNodes().remove(tRCNode);
        if (bl) {
            Path path2 = new Path(TString.resourcePath(tRCMonitor.eResource().getURI()));
            IResource iResource = UIPlugin.getPluginWorkbench().getRoot().findMember((IPath)path2);
            if (iResource != null) {
                try {
                    SaveUtil.saveResource(null, (Resource)tRCMonitor.eResource());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        DeleteUtil.unloadDoc((EObject)tRCNode);
    }

    public static void removeDoc(TRCProcessProxy tRCProcessProxy, boolean bl) {
        ArrayList arrayList;
        TRCNode tRCNode;
        Path path;
        if (tRCProcessProxy == null) {
            return;
        }
        if (bl) {
            path = new Path(TString.resourcePath(tRCProcessProxy.eResource().getURI()));
            IResource iResource = UIPlugin.getPluginWorkbench().getRoot().findMember((IPath)path);
            DeleteUtil.deleteResource(iResource, true);
        }
        path = tRCProcessProxy.getAgentProxies().toArray();
        int n = 0;
        while (n < ((Path)path).length) {
            tRCNode = (TRCAgentProxy)path[n];
            if (!tRCNode.eIsProxy()) {
                DeleteUtil.removeDoc((TRCAgentProxy)tRCNode, bl);
            }
            ++n;
        }
        tRCNode = tRCProcessProxy.getNode();
        if (tRCNode != null) {
            tRCNode.getProcessProxies().remove(tRCProcessProxy);
            if (bl) {
                arrayList = new Path(TString.resourcePath(tRCNode.eResource().getURI()));
                IResource iResource = UIPlugin.getPluginWorkbench().getRoot().findMember((IPath)arrayList);
                if (iResource != null) {
                    try {
                        SaveUtil.saveResource(null, (Resource)tRCNode.eResource());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
        UIPlugin.getDefault().getTraceManager().deregisterTrace(tRCProcessProxy);
        UIPlugin.getDefault().deregisterLaunchProcess(tRCProcessProxy);
        arrayList = UIPlugin.getDefault().getDeleteListeners();
        int n2 = 0;
        while (n2 < arrayList.size()) {
            ((IDeleteListener)arrayList.get(n2)).deregister(tRCProcessProxy);
            ++n2;
        }
        DeleteUtil.unloadDoc((EObject)tRCProcessProxy);
    }

    public static void unloadDoc(EObject eObject) {
        if (eObject == null || eObject.eResource() == null) {
            return;
        }
        UIPlugin.getDefault().removeSelectionModel(eObject);
        ((HierarchyXMIResourceImpl)eObject.eResource()).doShallowDelete();
    }
}

