/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.wizard;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.models.hierarchy.TRCOption;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceProfileOptionsUI;
import org.eclipse.hyades.trace.ui.internal.util.DoubleCTree;
import org.eclipse.hyades.trace.ui.internal.wizard.AttachLocalWizard;
import org.eclipse.hyades.trace.ui.internal.wizard.AttachRemoteWizard;
import org.eclipse.hyades.trace.ui.internal.wizard.RelaunchWizard;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;

public class AgentOptionsPage
extends WizardPage {
    protected TraceProfileOptionsUI _optionsUI;
    protected String _type;

    public AgentOptionsPage(String string, String string2) {
        super(string);
        this._type = string2;
        this.setTitle(UIPlugin.getResourceString("AGENT_OPT_WIZARD_TITLE"));
        this.setDescription(UIPlugin.getResourceString("AGENT_WIZARD_DESCR"));
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 5;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = GridUtil.createFill();
        gridData.widthHint = 500;
        gridData.heightHint = 500;
        composite2.setLayoutData((Object)gridData);
        this._optionsUI = new TraceProfileOptionsUI();
        this._optionsUI.createControl(composite2);
        this._optionsUI.setWizardPage(this);
        this.setControl((Control)composite2);
        this.initializeValues();
        WorkbenchHelp.setHelp((Control)composite, (String)(UIPlugin.getPluginId() + ".powp0000"));
    }

    public boolean finish() {
        this._optionsUI.storeValues();
        return true;
    }

    public Vector getOptions() {
        return this._optionsUI.getOptions();
    }

    private void initializeValues() {
        this._optionsUI.enableButtons();
        if (this.getWizard() instanceof RelaunchWizard) {
            ((RelaunchWizard)this.getWizard()).setAgentOptions();
        }
    }

    public void initializeValues(EList eList) {
        this._optionsUI.setExecutionBoundary(false);
        IPreferenceStore iPreferenceStore = UIPlugin.getDefault().getPreferenceStore();
        this._optionsUI.setCollectionDepth(iPreferenceStore.getString("collect_depth"));
        if (eList != null) {
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                TRCOption tRCOption = (TRCOption)iterator.next();
                if (tRCOption.getKey().equals("STACK_INFORMATION")) {
                    if (tRCOption.getValue().equals("boundaryAndContiguous")) {
                        this._optionsUI.setExecutionBoundary(true);
                        this._optionsUI.setExecution(true);
                        continue;
                    }
                    if (tRCOption.getValue().equals("contiguous")) {
                        this._optionsUI.setExecution(true);
                        continue;
                    }
                    if (!tRCOption.getValue().equals("none")) continue;
                    this._optionsUI.setExecution(false);
                    continue;
                }
                if (tRCOption.getKey().equals("TRACE_MODE")) {
                    if (tRCOption.getValue().equals("noObjectCorrelation")) {
                        this._optionsUI.setHeap(false);
                    }
                    if (!tRCOption.getValue().equals("default")) continue;
                    this._optionsUI.setHeap(true);
                    continue;
                }
                if (!tRCOption.getKey().equals("BOUNDARY_DEPTH")) continue;
                this._optionsUI.setCollectionDepth(tRCOption.getValue());
                this._optionsUI.setExecutionBoundary(true);
                this._optionsUI.setExecution(true);
            }
        }
        this._optionsUI.enableBtnGroup();
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            Vector vector = this.getAgentsList();
            if (vector != null && !this.hasProfilingAgent(vector)) {
                this.getControl().setEnabled(false);
                this.getControl().setVisible(false);
                this.setDescription(UIPlugin.getResourceString("STR_OPTION_IGNORED"));
            } else {
                this.getControl().setEnabled(true);
                this.getControl().setVisible(true);
                this.setDescription(UIPlugin.getResourceString("AGENT_WIZARD_DESCR"));
            }
        }
    }

    private Vector getAgentsList() {
        DoubleCTree doubleCTree = null;
        Vector vector = null;
        if (this._type.equals("AttachLocalWizard")) {
            doubleCTree = ((AttachLocalWizard)this.getWizard()).getAgentList();
        } else if (this._type.equals("AttachRemoteWizard")) {
            doubleCTree = ((AttachRemoteWizard)this.getWizard()).getAgentList();
        }
        if (doubleCTree != null) {
            vector = doubleCTree.getSelectedAgents();
        }
        return vector;
    }

    private boolean hasProfilingAgent(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            Agent agent = (Agent)vector.elementAt(n);
            if (agent.getType() != null && agent.getType().equals("Profiler") && !agent.getName().equals("J2EE Request Profiler")) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

