/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.wizard;

import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ImportTraceRange
implements SelectionListener,
ModifyListener {
    Label _regionLabel;
    Button _wholeFileBtn;
    Button _inRangeBtn;
    Label _startLabel;
    Text _startText;
    Label _ofFileLabel1;
    Label _ofFileLabel2;
    Label _stopLabel;
    Text _stopText;
    double startValue = 0.0;
    double stopValue = 100.0;
    WizardPage _wizardPage;

    public ImportTraceRange(WizardPage wizardPage) {
        this._wizardPage = wizardPage;
    }

    public void createControl(Composite composite) {
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(272));
        group.setSize(group.computeSize(-1, -1));
        group.setText(UIPlugin.getResourceString("IMPORT_OPTION_STR"));
        Composite composite2 = new Composite((Composite)group, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 7;
        gridLayout.verticalSpacing = 5;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = GridUtil.createFill();
        composite2.setLayoutData((Object)gridData);
        this._wholeFileBtn = new Button(composite2, 16);
        gridData = new GridData();
        gridData.horizontalSpan = 7;
        this._wholeFileBtn.setLayoutData((Object)gridData);
        this._wholeFileBtn.setText(UIPlugin.getResourceString("IMPORT_COMPLETE_STR"));
        this._inRangeBtn = new Button(composite2, 16);
        this._inRangeBtn.setText(UIPlugin.getResourceString("IMPORT_PARTIAL_STR"));
        this._startLabel = new Label(composite2, 0);
        this._startLabel.setText(UIPlugin.getResourceString("FROM_STR"));
        this._startText = new Text(composite2, 2048);
        gridData = new GridData();
        gridData.widthHint = 30;
        this._startText.setLayoutData((Object)gridData);
        this._ofFileLabel1 = new Label(composite2, 0);
        this._ofFileLabel1.setText(UIPlugin.getResourceString("PERCENT_OF_FILE_STR"));
        this._stopLabel = new Label(composite2, 0);
        this._stopLabel.setText(UIPlugin.getResourceString("TO_STR"));
        this._stopText = new Text(composite2, 2048);
        gridData = new GridData();
        gridData.widthHint = 30;
        this._stopText.setLayoutData((Object)gridData);
        this._ofFileLabel2 = new Label(composite2, 0);
        this._ofFileLabel2.setText(UIPlugin.getResourceString("PERCENT_OF_FILE_STR"));
        this._wholeFileBtn.addSelectionListener((SelectionListener)this);
        this._inRangeBtn.addSelectionListener((SelectionListener)this);
        this._startText.addModifyListener((ModifyListener)this);
        this._stopText.addModifyListener((ModifyListener)this);
        this.initData();
    }

    private void initData() {
        this._wholeFileBtn.setSelection(true);
        this._startText.setText(String.valueOf(this.startValue));
        this._stopText.setText(String.valueOf(this.stopValue));
        this.setRangeInputEnable(false);
    }

    public Button getWholeFileBtn() {
        return this._wholeFileBtn;
    }

    public Button getInRangeBtn() {
        return this._inRangeBtn;
    }

    public boolean getWholeFileSelection() {
        return this._wholeFileBtn.getSelection();
    }

    public boolean getInRangeSelection() {
        return this._inRangeBtn.getSelection();
    }

    public double getStartRange() {
        return this.startValue;
    }

    public double getStopRange() {
        return this.stopValue;
    }

    public String checkRegionValue() {
        if (this._startText.getText().trim().equals("") || this._stopText.getText().trim().equals("")) {
            return UIPlugin.getResourceString("CANNOT_EMPTY_VALUE");
        }
        try {
            this.startValue = Double.parseDouble(this._startText.getText().trim());
            this.stopValue = Double.parseDouble(this._stopText.getText().trim());
            if (this.startValue > this.stopValue) {
                return UIPlugin.getResourceString("START_LARGER_STOP");
            }
            if (this.startValue == this.stopValue) {
                return UIPlugin.getResourceString("CANNOT_SAME");
            }
            if (this.startValue < 0.0 || this.startValue > 100.0 || this.stopValue < 0.0 || this.stopValue > 100.0) {
                return UIPlugin.getResourceString("INVALID_IMPORT_RANGE");
            }
            return null;
        }
        catch (NumberFormatException numberFormatException) {
            return UIPlugin.getResourceString("INVALID_IMPORT_STR");
        }
    }

    public void modifyText(ModifyEvent modifyEvent) {
        if (modifyEvent.widget == this._startText || modifyEvent.widget == this._stopText) {
            this._wizardPage.setErrorMessage(this.checkRegionValue());
        }
    }

    public void setRangeInputEnable(boolean bl) {
        this._startLabel.setEnabled(bl);
        this._startText.setEnabled(bl);
        this._ofFileLabel1.setEnabled(bl);
        this._stopLabel.setEnabled(bl);
        this._stopText.setEnabled(bl);
        this._ofFileLabel2.setEnabled(bl);
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this._wholeFileBtn) {
            this.setRangeInputEnable(false);
            this.startValue = 0.0;
            this.stopValue = 100.0;
            this._wizardPage.setErrorMessage(null);
        } else if (selectionEvent.widget == this._inRangeBtn) {
            this.setRangeInputEnable(true);
            this._wizardPage.setErrorMessage(this.checkRegionValue());
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }
}

