/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.wizard;

import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceLocationUI;
import org.eclipse.hyades.trace.ui.internal.core.TraceNodeUI;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.hyades.trace.ui.internal.wizard.NewNodeWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;

public class NewNodeWizardPage
extends WizardPage
implements ModifyListener {
    protected TRCMonitor fMonitor;
    protected Object fNodeFile;
    protected TRCNode fNode;
    protected TraceLocationUI _locationUI;
    protected TraceNodeUI _nodeUI;

    public NewNodeWizardPage(String string) {
        super(string);
    }

    public NewNodeWizardPage(String string, TRCMonitor tRCMonitor, PDProjectExplorer pDProjectExplorer) {
        super(string);
        this.setTitle(UIPlugin.getResourceString("CREATE_NEW_NODE"));
        this.setDescription(UIPlugin.getResourceString("CREATE_NEW_NODE_DESC"));
        this.fMonitor = tRCMonitor;
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 5;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = 500;
        composite2.setLayoutData((Object)gridData);
        this._locationUI = new TraceLocationUI();
        this._locationUI.createControl(composite2);
        this._locationUI.setEnabled(false);
        this._nodeUI = new TraceNodeUI();
        this._nodeUI.createControl(composite2);
        this._nodeUI.getNodeNameUI().addModifyListener((ModifyListener)this);
        this._nodeUI.getAddressUI().addModifyListener((ModifyListener)this);
        this._nodeUI.getPortNumberUI().addModifyListener((ModifyListener)this);
        this._nodeUI.getHourUI().addModifyListener((ModifyListener)this);
        this._nodeUI.getMinUI().addModifyListener((ModifyListener)this);
        this._nodeUI.getSecUI().addModifyListener((ModifyListener)this);
        this._nodeUI.getMicSecUI().addModifyListener((ModifyListener)this);
        this.setPageComplete(false);
        this.setControl((Control)composite2);
        IResource iResource = ((NewNodeWizard)this.getWizard()).getViewer().getSelectionFolder();
        if (iResource != null) {
            this._locationUI.setLocation(iResource.getFullPath().toOSString());
        }
        if (this.fMonitor != null) {
            this._locationUI.setMonitor(this.fMonitor.getName());
        }
        WorkbenchHelp.setHelp((Control)composite, (String)(UIPlugin.getPluginId() + ".nhwp0000"));
    }

    public boolean finish() {
        String string = this._nodeUI.getNodeNameUI().getText().trim();
        String string2 = this._nodeUI.getAddressUI().getText().trim();
        String string3 = this._nodeUI.getPortNumberUI().getText().trim();
        TRCNode tRCNode = null;
        tRCNode = !string.equals("") ? PDCoreUtil.createNode(this.fMonitor, string, string3) : PDCoreUtil.createNode(this.fMonitor, string2, string3);
        if (tRCNode != null) {
            tRCNode.setDeltaTime(this._nodeUI.getDeltaTime());
        }
        return true;
    }

    public Object getNode() {
        return this.fNode;
    }

    private boolean pageComplete() {
        String string = this._nodeUI.getNodeNameUI().getText().trim();
        String string2 = this._nodeUI.getAddressUI().getText().trim();
        String string3 = this._nodeUI.getPortNumberUI().getText().trim();
        String string4 = this._nodeUI.getHourUI().getText().trim();
        String string5 = this._nodeUI.getMinUI().getText().trim();
        String string6 = this._nodeUI.getSecUI().getText().trim();
        String string7 = this._nodeUI.getMicSecUI().getText().trim();
        return !(string.equals("") && string2.equals("") || Integer.parseInt(string3) < 0 || !string4.equals("") && Integer.parseInt(string4) < 0 || !string5.equals("") && (Integer.parseInt(string5) < 0 || Integer.parseInt(string5) >= 60) || !string6.equals("") && (Integer.parseInt(string6) < 0 || Integer.parseInt(string6) >= 60) || !string7.equals("") && (Integer.parseInt(string7) < 0 || Integer.parseInt(string7) >= 1000000));
    }

    public void modifyText(ModifyEvent modifyEvent) {
        String string = null;
        this.setPageComplete(true);
        String string2 = this._nodeUI.getNodeNameUI().getText().trim();
        String string3 = this._nodeUI.getAddressUI().getText().trim();
        String string4 = this._nodeUI.getPortNumberUI().getText().trim();
        if (modifyEvent.widget == this._nodeUI.getNodeNameUI()) {
            string = string2;
            this.setPageComplete(this.pageComplete());
        } else if (modifyEvent.widget == this._nodeUI.getAddressUI()) {
            string = string3;
            this.setPageComplete(this.pageComplete());
            string = "[" + string + "]";
        } else if (modifyEvent.widget == this._nodeUI.getPortNumberUI()) {
            try {
                int n = Integer.parseInt(string4);
                if (n < 0) {
                    this.setErrorMessage(UIPlugin.getResourceString("RAC_INVALID_PORT"));
                    this.setPageComplete(this.pageComplete());
                    return;
                }
                this.setErrorMessage(null);
                this.setPageComplete(this.pageComplete());
            }
            catch (NumberFormatException numberFormatException) {
                this.setErrorMessage(UIPlugin.getResourceString("RAC_INVALID_PORT"));
                this.setPageComplete(false);
            }
        } else if (modifyEvent.widget == this._nodeUI.getHourUI()) {
            try {
                int n = Integer.parseInt(this._nodeUI.getHourUI().getText().trim());
                if (n < 0) {
                    this.setErrorMessage(UIPlugin.getResourceString("INVALID_DELTA_FORMAT"));
                    this.setPageComplete(false);
                    return;
                }
                this.setErrorMessage(null);
                this.setPageComplete(this.pageComplete());
            }
            catch (NumberFormatException numberFormatException) {
                if (this._nodeUI.getHourUI().getText().trim().equals("")) {
                    this.setErrorMessage(null);
                    this.setPageComplete(true);
                    return;
                }
                this.setErrorMessage(UIPlugin.getResourceString("INVALID_DELTA_FORMAT"));
                this.setPageComplete(false);
            }
        } else if (modifyEvent.widget == this._nodeUI.getMinUI()) {
            try {
                int n = Integer.parseInt(this._nodeUI.getMinUI().getText().trim());
                if (n < 0 || n > 59) {
                    this.setErrorMessage(UIPlugin.getResourceString("INVALID_DELTA_FORMAT"));
                    this.setPageComplete(false);
                    return;
                }
                this.setErrorMessage(null);
                this.setPageComplete(this.pageComplete());
            }
            catch (NumberFormatException numberFormatException) {
                if (this._nodeUI.getMinUI().getText().trim().equals("")) {
                    this.setErrorMessage(null);
                    this.setPageComplete(true);
                    return;
                }
                this.setErrorMessage(UIPlugin.getResourceString("INVALID_DELTA_FORMAT"));
                this.setPageComplete(false);
            }
        } else if (modifyEvent.widget == this._nodeUI.getSecUI()) {
            try {
                int n = Integer.parseInt(this._nodeUI.getSecUI().getText().trim());
                if (n < 0 || n > 59) {
                    this.setErrorMessage(UIPlugin.getResourceString("INVALID_DELTA_FORMAT"));
                    this.setPageComplete(false);
                    return;
                }
                this.setErrorMessage(null);
                this.setPageComplete(this.pageComplete());
            }
            catch (NumberFormatException numberFormatException) {
                if (this._nodeUI.getSecUI().getText().trim().equals("")) {
                    this.setErrorMessage(null);
                    this.setPageComplete(true);
                    return;
                }
                this.setErrorMessage(UIPlugin.getResourceString("INVALID_DELTA_FORMAT"));
                this.setPageComplete(false);
            }
        } else if (modifyEvent.widget == this._nodeUI.getMicSecUI()) {
            try {
                int n = Integer.parseInt(this._nodeUI.getMicSecUI().getText().trim());
                if (n < 0 || n > 1000000) {
                    this.setErrorMessage(UIPlugin.getResourceString("INVALID_DELTA_FORMAT"));
                    this.setPageComplete(false);
                    return;
                }
                this.setErrorMessage(null);
                this.setPageComplete(this.pageComplete());
            }
            catch (NumberFormatException numberFormatException) {
                if (this._nodeUI.getMicSecUI().getText().trim().equals("")) {
                    this.setErrorMessage(null);
                    this.setPageComplete(true);
                    return;
                }
                this.setErrorMessage(UIPlugin.getResourceString("INVALID_DELTA_FORMAT"));
                this.setPageComplete(false);
            }
        }
        if (this.isPageComplete()) {
            this.setErrorMessage(null);
            EList eList = this.fMonitor.getNodes();
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                TRCNode tRCNode = (TRCNode)iterator.next();
                if (tRCNode.eIsProxy() || !tRCNode.getName().equals(string)) continue;
                String string5 = UIPlugin.getResourceString("NODE_ALD_EXIST");
                string5 = TString.change(string5, "%1", string);
                string5 = TString.change(string5, "%2", this.fMonitor.getName());
                this.setErrorMessage(string5);
                this.setPageComplete(false);
                return;
            }
        }
    }
}

