/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.wizard;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCConfiguration;
import org.eclipse.hyades.models.hierarchy.TRCFilter;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceProfileUI;
import org.eclipse.hyades.trace.ui.internal.util.FilterSetElement;
import org.eclipse.hyades.trace.ui.internal.util.FilterTableElement;
import org.eclipse.hyades.trace.ui.internal.wizard.OpenProfAgentWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;

public class OpenProfAgentPage
extends WizardPage {
    protected PDProjectExplorer fViewer;
    protected TraceProfileUI _profileUI;

    public OpenProfAgentPage(String string, PDProjectExplorer pDProjectExplorer) {
        super(string);
        this.setTitle(UIPlugin.getResourceString("PROF_AGENT_TITLE"));
        this.setDescription(UIPlugin.getResourceString("PROF_AGENT_DESC"));
        this.fViewer = pDProjectExplorer;
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 5;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = GridUtil.createFill();
        gridData.widthHint = 500;
        gridData.heightHint = 400;
        composite2.setLayoutData((Object)gridData);
        this._profileUI = new TraceProfileUI();
        this._profileUI.createControl(composite2);
        TRCAgentProxy tRCAgentProxy = ((OpenProfAgentWizard)this.getWizard()).getAgent();
        if (tRCAgentProxy == null || !tRCAgentProxy.isActive()) {
            this._profileUI.setAgentTerminated(true);
            this._profileUI.enable(false);
        }
        this.setControl((Control)composite2);
        this.populateData();
        WorkbenchHelp.setHelp((Control)composite, (String)(UIPlugin.getPluginId() + ".opap0000"));
    }

    public boolean finish() {
        TRCAgentProxy tRCAgentProxy = ((OpenProfAgentWizard)this.getWizard()).getAgent();
        if (tRCAgentProxy == null || !tRCAgentProxy.isActive()) {
            return true;
        }
        try {
            Object[] objectArray = tRCAgentProxy.getConfigurations().toArray();
            if (objectArray.length > 0) {
                this.setConfiguration((TRCConfiguration)objectArray[0]);
            } else {
                HierarchyFactory hierarchyFactory = UIPlugin.getDefault().getPerftraceFactory();
                TRCConfiguration tRCConfiguration = hierarchyFactory.createTRCConfiguration();
                tRCConfiguration.setActive(true);
                tRCConfiguration.setName(UIPlugin.getResourceString("STR_DEFAULT_SET_NAME"));
                tRCConfiguration.setAgentProxy(tRCAgentProxy);
                tRCAgentProxy.getConfigurations().add(tRCConfiguration);
                this.setConfiguration(tRCConfiguration);
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            concurrentModificationException.printStackTrace();
        }
        return true;
    }

    protected void populateData() {
        TRCAgentProxy tRCAgentProxy = ((OpenProfAgentWizard)this.getWizard()).getAgent();
        if (tRCAgentProxy == null) {
            return;
        }
        EList eList = null;
        EList eList2 = tRCAgentProxy.getConfigurations();
        Iterator iterator = eList2.iterator();
        if (iterator.hasNext()) {
            TRCConfiguration tRCConfiguration = (TRCConfiguration)iterator.next();
            eList = tRCConfiguration.getFilters();
            this.updateConfigData(tRCConfiguration.getName(), tRCConfiguration.isActive(), eList);
            return;
        }
        this.updateConfigData(UIPlugin.getResourceString("STR_DEFAULT_SET_NAME"), true, eList);
    }

    protected void setConfiguration(TRCConfiguration tRCConfiguration) {
        try {
            Object[] objectArray = tRCConfiguration.getFilters().toArray();
            int n = 0;
            while (n < objectArray.length) {
                ((TRCFilter)objectArray[n]).setConfiguration(null);
                ++n;
            }
            HierarchyFactory hierarchyFactory = UIPlugin.getDefault().getPerftraceFactory();
            ArrayList arrayList = this._profileUI.getFilterSet();
            int n2 = 0;
            while (n2 < arrayList.size()) {
                FilterSetElement filterSetElement = (FilterSetElement)arrayList.get(n2);
                if (filterSetElement.getEnabled()) {
                    tRCConfiguration.setActive(true);
                    tRCConfiguration.setName(filterSetElement.getName());
                    UIPlugin.getDefault().getPluginPreferences().setValue("filter_name", filterSetElement.getName());
                    ArrayList arrayList2 = filterSetElement.getChildren();
                    int n3 = 0;
                    while (n3 < arrayList2.size()) {
                        FilterTableElement filterTableElement = (FilterTableElement)arrayList2.get(n3);
                        TRCFilter tRCFilter = hierarchyFactory.createTRCFilter();
                        tRCFilter.setMode(filterTableElement.getVisibility());
                        tRCFilter.setPattern(filterTableElement.getText());
                        tRCFilter.setOperation(filterTableElement.getMethod());
                        tRCFilter.setType("CLASS");
                        tRCFilter.setActive(new Boolean(true));
                        tRCFilter.setConfiguration(tRCConfiguration);
                        ++n3;
                    }
                    break;
                }
                ++n2;
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            concurrentModificationException.printStackTrace();
        }
    }

    protected void updateConfigData(String string, boolean bl, EList eList) {
        Object object;
        ArrayList<FilterTableElement> arrayList = new ArrayList<FilterTableElement>();
        if (eList != null) {
            object = eList.iterator();
            while (object.hasNext()) {
                TRCFilter tRCFilter = (TRCFilter)object.next();
                String string2 = tRCFilter.getOperation();
                if (string2 != null) {
                    arrayList.add(new FilterTableElement(tRCFilter.getPattern(), string2, tRCFilter.getMode()));
                    continue;
                }
                arrayList.add(new FilterTableElement(tRCFilter.getPattern(), "*", tRCFilter.getMode()));
            }
        }
        object = new FilterSetElement(string, bl);
        ((FilterSetElement)object).setChildren(arrayList);
        this._profileUI.addFilterSet((FilterSetElement)object);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            if (!((OpenProfAgentWizard)this.getWizard()).isProfilingAgent()) {
                this.getControl().setEnabled(false);
                this.getControl().setVisible(false);
                this.setDescription(UIPlugin.getResourceString("STR_FILTER_IGNORED"));
            } else {
                this.getControl().setEnabled(true);
                this.getControl().setVisible(true);
                this.setDescription(UIPlugin.getResourceString("PROF_AGENT_DESC"));
            }
        }
    }
}

