/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.util;

import java.util.Iterator;
import java.util.Set;
import org.eclipse.hyades.loaders.util.HyadesConfigurationElement;
import org.eclipse.hyades.loaders.util.IHyadesPluginClassDescriptor;
import org.eclipse.hyades.loaders.util.LoaderExtensions;
import org.eclipse.hyades.loaders.util.RegistryReader;
import org.eclipse.hyades.loaders.util.XMLFragmentLoader;
import org.eclipse.hyades.loaders.util.XMLFragmentLoadersFactory;

class LoadersFactoryRegistryReader
extends RegistryReader {
    static final String TAG_LOADERS_FACTORY = "loadersFactory";
    static final String ATT_CLASS = "class";

    public LoadersFactoryRegistryReader() {
        super("fragment_loaders_factory");
    }

    protected boolean readElement(HyadesConfigurationElement hyadesConfigurationElement) {
        if (hyadesConfigurationElement.getName().equals(TAG_LOADERS_FACTORY)) {
            if (hyadesConfigurationElement.getAttribute(ATT_CLASS) == null) {
                this.logMissingAttribute(hyadesConfigurationElement, ATT_CLASS);
            } else {
                try {
                    IHyadesPluginClassDescriptor iHyadesPluginClassDescriptor = this.createPluginClassDescriptor(hyadesConfigurationElement, ATT_CLASS);
                    XMLFragmentLoadersFactory xMLFragmentLoadersFactory = (XMLFragmentLoadersFactory)iHyadesPluginClassDescriptor.createInstance();
                    Set set = xMLFragmentLoadersFactory.getSupportedElements();
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        if (LoaderExtensions.getInstance().containsKey(string)) {
                            this.logError(hyadesConfigurationElement, "A loader for this element already exists, this loader will be ignored.");
                            continue;
                        }
                        try {
                            XMLFragmentLoader xMLFragmentLoader = (XMLFragmentLoader)xMLFragmentLoadersFactory.getClass().getClassLoader().loadClass(xMLFragmentLoadersFactory.getLoaderClassName(string)).newInstance();
                            if (xMLFragmentLoader == null) continue;
                            LoaderExtensions.getInstance().put(string, xMLFragmentLoader);
                        }
                        catch (Exception exception) {
                            this.logError(hyadesConfigurationElement, exception.getLocalizedMessage());
                        }
                    }
                }
                catch (Exception exception) {
                    this.logError(hyadesConfigurationElement, exception.getLocalizedMessage());
                }
                return true;
            }
        }
        return false;
    }
}

