/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.loaders.util.AgentProxyContext;
import org.eclipse.hyades.loaders.util.AgentsContext;
import org.eclipse.hyades.loaders.util.GenericLookUpEntry;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.loaders.util.XMLLoader;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.models.hierarchy.util.SaveUtil;
import org.eclipse.hyades.models.hierarchy.util.StringUtil;

public class LoadersUtils {
    private static Map threads = new HashMap();
    private static SimpleDateFormat partialCIMDateFormatDashDelimiter = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH:mm:ss");
    private static SimpleDateFormat partialCIMDateFormatPlusDelimiter = new SimpleDateFormat("yyyy'+'MM'+'dd'T'HH:mm:ss");
    private static SimpleDateFormat partialCIMDateFormatNoDelimiter = new SimpleDateFormat("yyyyMMdd'T'HH:mm:ss");
    static /* synthetic */ Class class$org$eclipse$hyades$loaders$util$AgentProxyContext;
    static /* synthetic */ Class class$org$eclipse$hyades$loaders$util$HierarchyContext;
    static /* synthetic */ Class class$org$eclipse$hyades$loaders$util$AgentsContext;

    public static void setDefaultContext(HierarchyContext hierarchyContext) {
        String string;
        String string2;
        String string3;
        String string4;
        BasicEList basicEList;
        TRCMonitor tRCMonitor = hierarchyContext.getMonitor();
        TRCProcessProxy tRCProcessProxy = hierarchyContext.getProcessProxy();
        TRCNode tRCNode = hierarchyContext.getNode();
        if (tRCNode == null) {
            tRCNode = LoadersUtils.locateNodeFromMonitor(tRCMonitor, "Unknown", "0", "0");
            if (tRCNode == null) {
                basicEList = new BasicEList();
                string4 = new BasicEList();
                string3 = LoadersUtils.getMonitorFolder(tRCMonitor);
                string2 = null;
                if (string3 != null) {
                    string = StringUtil.change(tRCMonitor.getName().trim(), " ", "") + "_" + "Unknown";
                    String string5 = string3 + string;
                    string2 = Resource.Factory.Registry.INSTANCE.getFactory(SaveUtil.createURI(string5 + ".trcnxmi")).createResource(SaveUtil.createURI(string5 + ".trcnxmi"));
                    HierarchyResourceSetImpl.getInstance().getResources().add(string2);
                }
                tRCNode = HierarchyFactory.eINSTANCE.createTRCNode();
                tRCNode.setIpAddress("0");
                tRCNode.setRuntimeId("0");
                tRCNode.setName("Unknown");
                tRCMonitor.getNodes().add(tRCNode);
                tRCNode.setMonitor(tRCMonitor);
                hierarchyContext.setNode(tRCNode);
                if (string2 != null) {
                    string2.getContents().add(tRCNode);
                }
            }
            hierarchyContext.setNode(tRCNode);
        }
        if (tRCProcessProxy == null) {
            tRCProcessProxy = LoadersUtils.locateProcessFromNode(tRCNode, "0");
            if (tRCProcessProxy != null) {
                hierarchyContext.setProcessProxy(tRCProcessProxy);
                return;
            }
            basicEList = new BasicEList();
            string4 = LoadersUtils.getMonitorFolder(tRCMonitor);
            string3 = null;
            if (string4 != null) {
                string2 = StringUtil.change(tRCMonitor.getName().trim(), " ", "") + "_" + tRCNode.getName().trim() + "_" + "-1" + "_" + "0";
                string = string4 + string2;
                string3 = Resource.Factory.Registry.INSTANCE.getFactory(SaveUtil.createURI(string + ".trcpxmi")).createResource(SaveUtil.createURI(string + ".trcpxmi"));
                HierarchyResourceSetImpl.getInstance().getResources().add(string3);
            }
            tRCProcessProxy = HierarchyFactory.eINSTANCE.createTRCProcessProxy();
            tRCNode.getProcessProxies().add(tRCProcessProxy);
            tRCProcessProxy.setNode(tRCNode);
            tRCProcessProxy.setPid(-1);
            tRCProcessProxy.setRuntimeId("0");
            tRCProcessProxy.setName("Unknown");
            hierarchyContext.setProcessProxy(tRCProcessProxy);
            if (string3 != null) {
                string3.getContents().add(tRCProcessProxy);
            }
        }
    }

    public static short getDeltaTimeZoneInMinutesFromCIMFormat(String string) throws IllegalArgumentException {
        int n = string.length();
        short s = 0;
        if (string.charAt(n - 1) != 'Z') {
            try {
                s = Short.parseShort(string.substring(n - 5, n - 3));
                s = (short)(s * 60);
                s = (short)(s + Short.parseShort(string.substring(n - 2)));
                if (string.charAt(n - 6) == '-') {
                    s = (short)(s * -1);
                }
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Invalid parameter time stamp format.");
            }
        }
        return s;
    }

    public static double getMicrosecondsFromCIMFormat(String string) throws IllegalArgumentException {
        double d = 0.0;
        int n = string.indexOf(84);
        if (n != -1) {
            try {
                d = (double)partialCIMDateFormatDashDelimiter.parse(string.substring(0, n + 9)).getTime() * 1000.0;
            }
            catch (ParseException parseException) {
                try {
                    d = string.charAt(n - 3) == '+' ? (double)partialCIMDateFormatPlusDelimiter.parse(string.substring(0, n + 9)).getTime() * 1000.0 : (double)partialCIMDateFormatNoDelimiter.parse(string.substring(0, n + 9)).getTime() * 1000.0;
                }
                catch (ParseException parseException2) {
                    throw new IllegalArgumentException("Invalid parameter time stamp format.");
                }
            }
            d -= (double)LoadersUtils.getDeltaTimeZoneInMinutesFromCIMFormat(string) * 6.0E7;
            try {
                d += Double.parseDouble("0.".concat(string.substring(n + 10, string.endsWith("Z") ? string.length() - 1 : string.length() - 6))) * 1000000.0;
            }
            catch (Exception exception) {}
        } else {
            throw new IllegalArgumentException("Invalid parameter time stamp format.");
        }
        return d;
    }

    public static String getMonitorFolder(TRCMonitor tRCMonitor) {
        if (tRCMonitor == null) {
            return null;
        }
        Resource resource = tRCMonitor.eResource();
        if (resource == null) {
            return null;
        }
        String string = resource.getURI().toString();
        int n = (string = string.replace('\\', '/')).lastIndexOf("/");
        if (n >= 0) {
            string = string.substring(0, n);
        }
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        return string;
    }

    public static SimpleDateFormat getPartialCIMDateFormat() {
        return LoadersUtils.getPartialCIMDateFormatDashDelimiter();
    }

    public static SimpleDateFormat getPartialCIMDateFormatDashDelimiter() {
        return partialCIMDateFormatDashDelimiter;
    }

    public static SimpleDateFormat getPartialCIMDateFormatPlusDelimiter() {
        return partialCIMDateFormatPlusDelimiter;
    }

    public static SimpleDateFormat getPartialCIMDateFormatNoDelimiter() {
        return partialCIMDateFormatNoDelimiter;
    }

    public static double convertCreationTime(String string) {
        return LoadersUtils.getMicrosecondsFromCIMFormat(string);
    }

    public static TRCAgent createAgent(HierarchyContext hierarchyContext) {
        LoadersUtils.setDefaultContext(hierarchyContext);
        TRCAgent tRCAgent = hierarchyContext.getAgent();
        TRCAgentProxy tRCAgentProxy = hierarchyContext.getAgentProxy();
        TRCProcessProxy tRCProcessProxy = hierarchyContext.getProcessProxy();
        TRCNode tRCNode = hierarchyContext.getNode();
        TRCMonitor tRCMonitor = hierarchyContext.getMonitor();
        String string = "Unknown";
        String string2 = LoadersUtils.getMonitorFolder(tRCMonitor);
        Resource resource = null;
        double d = (double)new Date().getTime() / 1000.0;
        if (string2 != null) {
            String string3 = StringUtil.change(tRCMonitor.getName().trim(), " ", "") + "_" + tRCNode.getName().trim() + "_" + tRCProcessProxy.getPid() + "_" + tRCProcessProxy.getRuntimeId() + "_" + StringUtil.change(string.trim(), " ", "");
            String string4 = string2 + string3;
            resource = Resource.Factory.Registry.INSTANCE.getFactory(SaveUtil.createURI(string4 + ".trcaxmi")).createResource(SaveUtil.createURI(string4 + ".trcaxmi"));
            resource.setModified(true);
            HierarchyResourceSetImpl.getInstance().getResources().add(resource);
        }
        tRCAgent = HierarchyFactory.eINSTANCE.createTRCAgent();
        if (tRCAgentProxy == null) {
            tRCAgentProxy = HierarchyFactory.eINSTANCE.createTRCAgentProxy();
            tRCAgentProxy.setRuntimeId("" + d);
            tRCAgent.setRuntimeId("" + d);
            tRCAgent.setName(string);
            tRCAgentProxy.setName(string);
            tRCAgent.setStartTime(d);
            tRCAgentProxy.setStartTime(d);
            tRCAgent.setAgentProxy(tRCAgentProxy);
            tRCAgentProxy.setProcessProxy(tRCProcessProxy);
            tRCAgent.setCollectionMode(hierarchyContext.getCollectionMode());
            tRCAgentProxy.setCollectionMode(hierarchyContext.getCollectionMode());
            hierarchyContext.setAgent(tRCAgent);
            hierarchyContext.setAgentProxy(tRCAgentProxy);
        } else {
            tRCAgent.setRuntimeId(tRCAgentProxy.getRuntimeId());
            tRCAgent.setName(tRCAgentProxy.getName());
            tRCAgent.setStartTime(tRCAgentProxy.getStartTime());
            tRCAgent.setAgentProxy(tRCAgentProxy);
            tRCAgent.setCollectionMode(hierarchyContext.getCollectionMode());
            hierarchyContext.setAgent(tRCAgent);
        }
        if (hierarchyContext.getContextURI() == null) {
            hierarchyContext.setContextURI(resource.getURI().toString());
            LookupServiceExtensions.getInstance().register(null, hierarchyContext);
        }
        if (resource != null) {
            resource.getContents().add(tRCAgent);
        }
        return tRCAgent;
    }

    public static void deregisterAgentInstance(TRCAgentProxy tRCAgentProxy) {
        AgentProxyContext agentProxyContext = (AgentProxyContext)LookupServiceExtensions.getInstance().locate(null, class$org$eclipse$hyades$loaders$util$AgentProxyContext == null ? (class$org$eclipse$hyades$loaders$util$AgentProxyContext = LoadersUtils.class$("org.eclipse.hyades.loaders.util.AgentProxyContext")) : class$org$eclipse$hyades$loaders$util$AgentProxyContext, LoadersUtils.getLookUpKey(tRCAgentProxy.hashCode()));
        if (agentProxyContext != null) {
            agentProxyContext.setAgentInstance(null);
        }
    }

    public static void deregisterAgentListener(TRCAgentProxy tRCAgentProxy) {
        AgentProxyContext agentProxyContext = (AgentProxyContext)LookupServiceExtensions.getInstance().locate(null, class$org$eclipse$hyades$loaders$util$AgentProxyContext == null ? (class$org$eclipse$hyades$loaders$util$AgentProxyContext = LoadersUtils.class$("org.eclipse.hyades.loaders.util.AgentProxyContext")) : class$org$eclipse$hyades$loaders$util$AgentProxyContext, LoadersUtils.getLookUpKey(tRCAgentProxy.hashCode()));
        if (agentProxyContext != null) {
            agentProxyContext.setAgentListener(null);
        }
    }

    public static void deregisterAgentProxyContext(TRCAgentProxy tRCAgentProxy) {
        AgentProxyContext agentProxyContext = (AgentProxyContext)LookupServiceExtensions.getInstance().locate(null, class$org$eclipse$hyades$loaders$util$AgentProxyContext == null ? (class$org$eclipse$hyades$loaders$util$AgentProxyContext = LoadersUtils.class$("org.eclipse.hyades.loaders.util.AgentProxyContext")) : class$org$eclipse$hyades$loaders$util$AgentProxyContext, LoadersUtils.getLookUpKey(tRCAgentProxy.hashCode()));
        if (agentProxyContext != null) {
            LookupServiceExtensions.getInstance().deregister(null, agentProxyContext);
        }
    }

    public static void deregisterDataProcessor(TRCAgentProxy tRCAgentProxy) {
        AgentProxyContext agentProxyContext = (AgentProxyContext)LookupServiceExtensions.getInstance().locate(null, class$org$eclipse$hyades$loaders$util$AgentProxyContext == null ? (class$org$eclipse$hyades$loaders$util$AgentProxyContext = LoadersUtils.class$("org.eclipse.hyades.loaders.util.AgentProxyContext")) : class$org$eclipse$hyades$loaders$util$AgentProxyContext, LoadersUtils.getLookUpKey(tRCAgentProxy.hashCode()));
        if (agentProxyContext != null) {
            agentProxyContext.setDataProcessor(null);
        }
    }

    public static TRCAgent locateAgentFromMonitor(TRCMonitor tRCMonitor, String string) {
        EList eList = tRCMonitor.getNodes();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            TRCNode tRCNode = (TRCNode)iterator.next();
            if (tRCNode.eIsProxy()) continue;
            EList eList2 = tRCNode.getProcessProxies();
            Iterator iterator2 = eList2.iterator();
            while (iterator2.hasNext()) {
                TRCProcessProxy tRCProcessProxy = (TRCProcessProxy)iterator2.next();
                if (tRCProcessProxy.eIsProxy()) continue;
                EList eList3 = tRCProcessProxy.getAgentProxies();
                Iterator iterator3 = eList3.iterator();
                while (iterator3.hasNext()) {
                    TRCAgentProxy tRCAgentProxy = (TRCAgentProxy)iterator3.next();
                    if (tRCAgentProxy.eIsProxy() || tRCAgentProxy.getRuntimeId() == null || !tRCAgentProxy.getRuntimeId().equals(string)) continue;
                    return tRCAgentProxy.getAgent();
                }
            }
        }
        return null;
    }

    public static TRCAgent locateAgentFromProcess(TRCProcessProxy tRCProcessProxy, String string, String string2) {
        EList eList = tRCProcessProxy.getAgentProxies();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            TRCAgentProxy tRCAgentProxy = (TRCAgentProxy)iterator.next();
            if (tRCAgentProxy.eIsProxy() || tRCAgentProxy.getName() == null || !tRCAgentProxy.getName().equals(string) || tRCAgentProxy.getRuntimeId() != null && !tRCAgentProxy.getRuntimeId().equals("") && !tRCAgentProxy.getRuntimeId().equals(string2)) continue;
            return tRCAgentProxy.getAgent();
        }
        return null;
    }

    public static Object locateAgentInstance(TRCAgentProxy tRCAgentProxy) {
        AgentProxyContext agentProxyContext = (AgentProxyContext)LookupServiceExtensions.getInstance().locate(null, class$org$eclipse$hyades$loaders$util$AgentProxyContext == null ? (class$org$eclipse$hyades$loaders$util$AgentProxyContext = LoadersUtils.class$("org.eclipse.hyades.loaders.util.AgentProxyContext")) : class$org$eclipse$hyades$loaders$util$AgentProxyContext, LoadersUtils.getLookUpKey(tRCAgentProxy.hashCode()));
        if (agentProxyContext != null) {
            return agentProxyContext.getAgentInstance();
        }
        return null;
    }

    public static Object locateAgentListener(TRCAgentProxy tRCAgentProxy) {
        AgentProxyContext agentProxyContext = (AgentProxyContext)LookupServiceExtensions.getInstance().locate(null, class$org$eclipse$hyades$loaders$util$AgentProxyContext == null ? (class$org$eclipse$hyades$loaders$util$AgentProxyContext = LoadersUtils.class$("org.eclipse.hyades.loaders.util.AgentProxyContext")) : class$org$eclipse$hyades$loaders$util$AgentProxyContext, LoadersUtils.getLookUpKey(tRCAgentProxy.hashCode()));
        if (agentProxyContext != null) {
            return agentProxyContext.getAgentListener();
        }
        return null;
    }

    public static XMLLoader locateDataProcessor(TRCAgentProxy tRCAgentProxy) {
        AgentProxyContext agentProxyContext = (AgentProxyContext)LookupServiceExtensions.getInstance().locate(null, class$org$eclipse$hyades$loaders$util$AgentProxyContext == null ? (class$org$eclipse$hyades$loaders$util$AgentProxyContext = LoadersUtils.class$("org.eclipse.hyades.loaders.util.AgentProxyContext")) : class$org$eclipse$hyades$loaders$util$AgentProxyContext, LoadersUtils.getLookUpKey(tRCAgentProxy.hashCode()));
        if (agentProxyContext != null) {
            return agentProxyContext.getDataProcessor();
        }
        return null;
    }

    public static HierarchyContext locateHierarchyContext(TRCAgent tRCAgent) {
        HierarchyContext hierarchyContext = null;
        if (tRCAgent.eResource() != null) {
            hierarchyContext = (HierarchyContext)LookupServiceExtensions.getInstance().locate(null, class$org$eclipse$hyades$loaders$util$HierarchyContext == null ? (class$org$eclipse$hyades$loaders$util$HierarchyContext = LoadersUtils.class$("org.eclipse.hyades.loaders.util.HierarchyContext")) : class$org$eclipse$hyades$loaders$util$HierarchyContext, tRCAgent.eResource().getURI().toString());
        }
        if (hierarchyContext == null) {
            hierarchyContext = (HierarchyContext)LookupServiceExtensions.getInstance().locate(null, class$org$eclipse$hyades$loaders$util$HierarchyContext == null ? (class$org$eclipse$hyades$loaders$util$HierarchyContext = LoadersUtils.class$("org.eclipse.hyades.loaders.util.HierarchyContext")) : class$org$eclipse$hyades$loaders$util$HierarchyContext, tRCAgent.getRuntimeId());
        }
        return hierarchyContext;
    }

    /*
     * Unable to fully structure code
     */
    public static TRCNode locateNodeFromMonitor(TRCMonitor var0, String var1_1, String var2_2, String var3_3) {
        block6: {
            var4_4 = var0.getNodes();
            var5_5 = var4_4.iterator();
            try {
                var6_6 = InetAddress.getByName(var1_1);
                while (var5_5.hasNext()) {
                    var7_8 = (TRCNode)var5_5.next();
                    if (var7_8.eIsProxy()) continue;
                    var8_10 = var7_8.getName();
                    try {
                        var9_12 = InetAddress.getByName(var8_10);
                        if (!var6_6.equals(var9_12)) continue;
                        return var7_8;
                    }
                    catch (UnknownHostException var9_13) {
                        var10_15 = var7_8.getIpAddress();
                        if (!var8_10.equals(var1_1) && (var10_15 == null || !var10_15.equals(var2_2))) continue;
                        var7_8.setIpAddress(var2_2);
                        var7_8.setRuntimeId(var3_3);
                        return var7_8;
                    }
                }
                break block6;
            }
            catch (UnknownHostException var6_7) {
                ** while (var5_5.hasNext())
            }
lbl-1000:
            // 1 sources

            {
                var7_9 = (TRCNode)var5_5.next();
                var8_11 = var7_9.getName();
                var9_14 = var7_9.getIpAddress();
                if ((var8_11 == null || var1_1 == null || !var8_11.equals(var1_1)) && (var9_14 == null || !var9_14.equals(var2_2))) continue;
                var7_9.setIpAddress(var2_2);
                var7_9.setRuntimeId(var3_3);
                return var7_9;
            }
        }
        return null;
    }

    public static TRCProcessProxy locateProcessFromNode(TRCNode tRCNode, String string) {
        EList eList = tRCNode.getProcessProxies();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            TRCProcessProxy tRCProcessProxy = (TRCProcessProxy)iterator.next();
            if (tRCProcessProxy.eIsProxy() || tRCProcessProxy.getRuntimeId() == null || tRCProcessProxy.getRuntimeId().compareTo(string) != 0) continue;
            return tRCProcessProxy;
        }
        return null;
    }

    public static TRCProcessProxy locateProcessFromNode(TRCNode tRCNode, int n, String string) {
        EList eList = tRCNode.getProcessProxies();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            String string2;
            int n2;
            TRCProcessProxy tRCProcessProxy = (TRCProcessProxy)iterator.next();
            if (tRCProcessProxy.eIsProxy() || (n2 = tRCProcessProxy.getPid()) != n || (string2 = tRCProcessProxy.getRuntimeId()) != null && !string2.equals("") && !string2.equals(string)) continue;
            tRCProcessProxy.setRuntimeId(string);
            return tRCProcessProxy;
        }
        return null;
    }

    public static void log(Exception exception) {
        exception.printStackTrace();
    }

    public static String makeString(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            return null;
        }
        try {
            return new String(byArray, n, n2, "UTF8");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void registerAgentInstance(TRCAgentProxy tRCAgentProxy, Object object) {
        AgentProxyContext agentProxyContext = (AgentProxyContext)LookupServiceExtensions.getInstance().locate(null, class$org$eclipse$hyades$loaders$util$AgentProxyContext == null ? (class$org$eclipse$hyades$loaders$util$AgentProxyContext = LoadersUtils.class$("org.eclipse.hyades.loaders.util.AgentProxyContext")) : class$org$eclipse$hyades$loaders$util$AgentProxyContext, LoadersUtils.getLookUpKey(tRCAgentProxy.hashCode()));
        if (agentProxyContext != null) {
            agentProxyContext.setAgentInstance(object);
        } else {
            agentProxyContext = new AgentProxyContext();
            agentProxyContext.setAgentProxy(tRCAgentProxy);
            agentProxyContext.setAgentInstance(object);
            LookupServiceExtensions.getInstance().register(null, agentProxyContext);
        }
    }

    public static void registerAgentListener(TRCAgentProxy tRCAgentProxy, Object object) {
        AgentProxyContext agentProxyContext = (AgentProxyContext)LookupServiceExtensions.getInstance().locate(null, class$org$eclipse$hyades$loaders$util$AgentProxyContext == null ? (class$org$eclipse$hyades$loaders$util$AgentProxyContext = LoadersUtils.class$("org.eclipse.hyades.loaders.util.AgentProxyContext")) : class$org$eclipse$hyades$loaders$util$AgentProxyContext, LoadersUtils.getLookUpKey(tRCAgentProxy.hashCode()));
        if (agentProxyContext != null) {
            agentProxyContext.setAgentListener(object);
        } else {
            agentProxyContext = new AgentProxyContext();
            agentProxyContext.setAgentProxy(tRCAgentProxy);
            agentProxyContext.setAgentListener(object);
            LookupServiceExtensions.getInstance().register(null, agentProxyContext);
        }
    }

    public static void registerDataProcessor(TRCAgentProxy tRCAgentProxy, XMLLoader xMLLoader) {
        AgentProxyContext agentProxyContext = (AgentProxyContext)LookupServiceExtensions.getInstance().locate(null, class$org$eclipse$hyades$loaders$util$AgentProxyContext == null ? (class$org$eclipse$hyades$loaders$util$AgentProxyContext = LoadersUtils.class$("org.eclipse.hyades.loaders.util.AgentProxyContext")) : class$org$eclipse$hyades$loaders$util$AgentProxyContext, LoadersUtils.getLookUpKey(tRCAgentProxy.hashCode()));
        if (agentProxyContext != null) {
            agentProxyContext.setDataProcessor(xMLLoader);
        } else {
            agentProxyContext = new AgentProxyContext();
            agentProxyContext.setAgentProxy(tRCAgentProxy);
            agentProxyContext.setDataProcessor(xMLLoader);
            LookupServiceExtensions.getInstance().register(null, agentProxyContext);
        }
    }

    public static void loadRootEvent(XMLLoader xMLLoader) {
        xMLLoader.loadEvent("<TRACE>".getBytes(), "<TRACE>".getBytes().length);
    }

    public static TRCAgent locateAgent(String string, TRCAgent tRCAgent) {
        AgentsContext agentsContext = (AgentsContext)LookupServiceExtensions.getInstance().locate(null, class$org$eclipse$hyades$loaders$util$AgentsContext == null ? (class$org$eclipse$hyades$loaders$util$AgentsContext = LoadersUtils.class$("org.eclipse.hyades.loaders.util.AgentsContext")) : class$org$eclipse$hyades$loaders$util$AgentsContext, LoadersUtils.getLookUpKey(string));
        if (agentsContext != null) {
            return agentsContext.getActiveAgent(tRCAgent);
        }
        return null;
    }

    public static boolean registerAgent(String string, TRCAgent tRCAgent) {
        AgentsContext agentsContext = (AgentsContext)LookupServiceExtensions.getInstance().locate(null, class$org$eclipse$hyades$loaders$util$AgentsContext == null ? (class$org$eclipse$hyades$loaders$util$AgentsContext = LoadersUtils.class$("org.eclipse.hyades.loaders.util.AgentsContext")) : class$org$eclipse$hyades$loaders$util$AgentsContext, LoadersUtils.getLookUpKey(string));
        if (agentsContext == null) {
            agentsContext = new AgentsContext(string);
            LookupServiceExtensions.getInstance().register(null, agentsContext);
        }
        return agentsContext.registerAgent(tRCAgent);
    }

    public static Object getLookUpKey(int n) {
        return new Integer(n);
    }

    public static Object getLookUpKey(long l) {
        return new Integer(new Long(l).hashCode());
    }

    public static Object getLookUpKey(short s) {
        return new Short(s);
    }

    public static Object getLookUpKey(String string) {
        if (string == null) {
            return new Integer(0);
        }
        return new Integer(string.hashCode());
    }

    public static GenericLookUpEntry getGenericLookUpEntry(Thread thread) {
        Integer n = new Integer(thread.hashCode());
        GenericLookUpEntry genericLookUpEntry = (GenericLookUpEntry)threads.get(n);
        if (genericLookUpEntry == null) {
            genericLookUpEntry = new GenericLookUpEntry();
            threads.put(n, genericLookUpEntry);
        }
        return genericLookUpEntry;
    }

    public static void registerGenericLookUpEntry(HierarchyContext hierarchyContext, Object object, Object object2) {
        GenericLookUpEntry genericLookUpEntry = LoadersUtils.getGenericLookUpEntry(Thread.currentThread());
        genericLookUpEntry.setKey(object);
        genericLookUpEntry.setValue(object2);
        LookupServiceExtensions.getInstance().register(hierarchyContext, genericLookUpEntry);
        genericLookUpEntry.reset();
    }

    public static int getHashCode(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            n3 = 31 * n3 + byArray[n + n4];
            ++n4;
        }
        return n3;
    }

    public static int getHashCode(String string) {
        int n = 0;
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            n = 31 * n + string.charAt(n3);
            ++n3;
        }
        return n;
    }

    public static void setSessionStartTime(double d, TRCAgentProxy tRCAgentProxy) {
        TRCAgent tRCAgent;
        if (tRCAgentProxy == null) {
            return;
        }
        if (!tRCAgentProxy.eIsSet((EStructuralFeature)HierarchyPackage.eINSTANCE.getTRCAgentProxy_StartTime())) {
            tRCAgentProxy.setStartTime(d);
        }
        if ((tRCAgent = tRCAgentProxy.getAgent()) != null && !tRCAgent.eIsSet((EStructuralFeature)HierarchyPackage.eINSTANCE.getTRCAgent_StartTime())) {
            tRCAgent.setStartTime(d);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

