/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.loaders.util.HyadesConfigurationElement;
import org.eclipse.hyades.loaders.util.IHyadesPluginClassDescriptor;
import org.eclipse.hyades.loaders.util.PlatformPluginClassDescriptor;
import org.eclipse.hyades.loaders.util.StandalonePluginClassDescriptor;
import org.eclipse.hyades.models.hierarchy.util.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class RegistryReader {
    public static StandaloneConfiguration standaloneConfiguration;
    protected static int mode;
    protected static final String TAG_DESCRIPTION = "description";
    protected static final String LOADER_PPID = "fragment_loader";
    protected static final String HANDLER_PPID = "fragment_handler";
    protected static final String LOADERS_FACTORY_PPID = "fragment_loaders_factory";
    protected static final String RESOURCE_LOADER_PPID = "resource_loader";
    protected static final String LOOKUP_SERVICE_PPID = "lookup_service";
    protected static final String thisPluginId = "org.eclipse.hyades.models.hierarchy";
    private List alreadyProcessedEclipseFolders;
    private String extensionPointID;

    public RegistryReader(String string) {
        this.extensionPointID = string;
    }

    public static synchronized boolean isPlatformMode() {
        if (mode == 0) {
            RegistryReader.setMode();
        }
        return mode == 1;
    }

    public IHyadesPluginClassDescriptor createPluginClassDescriptor(HyadesConfigurationElement hyadesConfigurationElement, String string) {
        if (RegistryReader.isPlatformMode()) {
            return new PlatformPluginClassDescriptor((IConfigurationElement)hyadesConfigurationElement.getElement(), string);
        }
        return new StandalonePluginClassDescriptor((Node)hyadesConfigurationElement.getElement(), string);
    }

    public void readRegistry() {
        if (RegistryReader.isPlatformMode()) {
            this.platformReadRegistry();
        } else {
            this.standaloneReadRegistry();
        }
    }

    protected void logError(HyadesConfigurationElement hyadesConfigurationElement, String string) {
        System.err.println("Plugin " + hyadesConfigurationElement.getDeclaringExtensionName() + ", extension " + hyadesConfigurationElement.getAttribute("class"));
        System.err.println(string);
    }

    protected void logMissingAttribute(HyadesConfigurationElement hyadesConfigurationElement, String string) {
        this.logError(hyadesConfigurationElement, "The required attribute '" + string + "' not defined");
    }

    abstract boolean readElement(HyadesConfigurationElement var1);

    private static void setMode() {
        try {
            Class<?> clazz = Class.forName("org.eclipse.core.resources.ResourcesPlugin");
            Method method = clazz.getMethod("getWorkspace", null);
            Object object = method.invoke(null, null);
            Method method2 = object.getClass().getMethod("getRoot", null);
            Object object2 = method2.invoke(object, null);
            mode = object2 != null ? 1 : 2;
        }
        catch (ClassNotFoundException classNotFoundException) {
            mode = 2;
        }
        catch (SecurityException securityException) {
            mode = 2;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            mode = 2;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            mode = 2;
        }
        catch (IllegalAccessException illegalAccessException) {
            mode = 2;
        }
        catch (InvocationTargetException invocationTargetException) {
            mode = 2;
        }
    }

    private void addPackageExtensionPoints() {
        Iterator iterator = standaloneConfiguration.getExtensionsList().iterator();
        while (iterator.hasNext()) {
            HyadesConfigurationElement hyadesConfigurationElement = (HyadesConfigurationElement)iterator.next();
            if (!hyadesConfigurationElement.getDeclaringExtensionName().equals("org.eclipse.emf.ecore.generated_package")) continue;
            try {
                String string = hyadesConfigurationElement.getAttribute("class");
                if (standaloneConfiguration.getEmfPackageClassesList().contains(string)) continue;
                standaloneConfiguration.getEmfPackageClassesList().add(string);
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
            }
        }
    }

    private void internalReadElement(HyadesConfigurationElement hyadesConfigurationElement) {
        boolean bl = this.readElement(hyadesConfigurationElement);
        if (bl) {
            HyadesConfigurationElement[] hyadesConfigurationElementArray = hyadesConfigurationElement.getChildren();
            int n = 0;
            while (n < hyadesConfigurationElementArray.length) {
                this.internalReadElement(hyadesConfigurationElementArray[n]);
                ++n;
            }
        } else {
            this.logError(hyadesConfigurationElement, "Error processing extension: " + hyadesConfigurationElement.getDeclaringExtensionName());
        }
    }

    private void platformReadRegistry() {
        IExtensionPoint iExtensionPoint = Platform.getPluginRegistry().getExtensionPoint(thisPluginId, this.extensionPointID);
        if (iExtensionPoint != null) {
            IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                this.internalReadElement(new HyadesConfigurationElement(iConfigurationElementArray[n]));
                ++n;
            }
        }
    }

    private void processEMFpackages() {
        this.addPackageExtensionPoints();
        Iterator iterator = standaloneConfiguration.getEmfPackageClassesList().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            try {
                Class<?> clazz = Class.forName(string);
                try {
                    Field field = clazz.getField("eINSTANCE");
                    field.get(null);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    Method method = clazz.getMethod("init", null);
                    method.invoke(null, null);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
    }

    private void processEclipseFolder() {
        String string = standaloneConfiguration.getEclipseFolder();
        this.processEclipseFolder(string);
        File file = new File(string + "/links");
        if (file.exists()) {
            this.processLinksFolder(file);
        }
    }

    private void processEclipseFolder(String string) {
        if (string != null) {
            if (this.alreadyProcessedEclipseFolders.contains(string)) {
                return;
            }
            this.alreadyProcessedEclipseFolders.add(string);
            File file = new File(string + "/plugins");
            if (file.exists()) {
                File[] fileArray = file.listFiles();
                int n = fileArray.length - 1;
                while (n >= 0) {
                    File file2 = new File(fileArray[n].getAbsolutePath() + "/plugin.xml");
                    if (file2.exists()) {
                        String string2 = file2.getAbsolutePath();
                        if (!standaloneConfiguration.getPluginsXMLFiles().contains(string2)) {
                            standaloneConfiguration.getPluginsXMLFiles().add(string2);
                        }
                    }
                    --n;
                }
            }
        }
    }

    private void processExtensions() {
        Iterator iterator = standaloneConfiguration.getExtensionsList().iterator();
        while (iterator.hasNext()) {
            HyadesConfigurationElement hyadesConfigurationElement = (HyadesConfigurationElement)iterator.next();
            if (!hyadesConfigurationElement.getDeclaringExtensionName().endsWith("." + this.extensionPointID)) continue;
            this.internalReadElement(hyadesConfigurationElement);
        }
    }

    private void processLinksFolder(File file) {
        File[] fileArray = file.listFiles(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(".link");
            }
        });
        int n = fileArray.length - 1;
        while (n >= 0) {
            try {
                String string;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(fileArray[n]));
                while ((string = bufferedReader.readLine()) != null) {
                    if (!string.startsWith("path=")) continue;
                    string = string.substring("path=".length()).trim();
                    this.processEclipseFolder(string + "/eclipse");
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            --n;
        }
    }

    private void processPluginXMLFiles() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = standaloneConfiguration.getPluginsXMLFiles().iterator();
        while (iterator.hasNext()) {
            try {
                String string = (String)iterator.next();
                if (arrayList.contains(string)) continue;
                arrayList.add(string);
                Document document = XMLUtil.getXmlDom(string);
                NodeList nodeList = document.getElementsByTagName("extension");
                int n = nodeList.getLength() - 1;
                while (n >= 0) {
                    Node node = nodeList.item(n);
                    standaloneConfiguration.getExtensionsList().add(new HyadesConfigurationElement(node));
                    --n;
                }
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
            }
        }
    }

    private synchronized void standaloneReadRegistry() {
        if (standaloneConfiguration != null) {
            if (!standaloneConfiguration.isAlreadyProcessed()) {
                this.alreadyProcessedEclipseFolders = new ArrayList();
                this.processEclipseFolder();
                this.processPluginXMLFiles();
                this.processEMFpackages();
                standaloneConfiguration.alreadyProcessed = true;
            }
            this.processExtensions();
        }
    }

    static {
        mode = 0;
    }

    public static final class StandaloneConfiguration {
        protected List emfPackageClassesList = new ArrayList();
        protected List extensionsList = new ArrayList();
        protected List pluginsXMLFiles = new ArrayList();
        protected String eclipseFolder;
        private boolean alreadyProcessed = false;

        public boolean isAlreadyProcessed() {
            return this.alreadyProcessed;
        }

        public void setEclipseFolder(String string) {
            this.eclipseFolder = string;
        }

        public String getEclipseFolder() {
            return this.eclipseFolder;
        }

        public List getEmfPackageClassesList() {
            return this.emfPackageClassesList;
        }

        public List getExtensionsList() {
            return this.extensionsList;
        }

        public List getPluginsXMLFiles() {
            return this.pluginsXMLFiles;
        }
    }
}

