/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.util;

import org.eclipse.hyades.loaders.util.HyadesConfigurationElement;
import org.eclipse.hyades.loaders.util.IHyadesPluginClassDescriptor;
import org.eclipse.hyades.loaders.util.RegistryReader;
import org.eclipse.hyades.loaders.util.ResourceExtensions;
import org.eclipse.hyades.loaders.util.XMLResourceLoader;

class ResourceRegistryReader
extends RegistryReader {
    static final String TAG_RESOURCE_LOADER = "resourceLoader";
    static final String ATT_FILE_EXTENSION = "fileExtension";
    static final String ATT_CLASS = "class";

    public ResourceRegistryReader() {
        super("resource_loader");
    }

    protected boolean readElement(HyadesConfigurationElement hyadesConfigurationElement) {
        if (hyadesConfigurationElement.getName().equals(TAG_RESOURCE_LOADER)) {
            String string = hyadesConfigurationElement.getAttribute(ATT_FILE_EXTENSION);
            if (string == null) {
                this.logMissingAttribute(hyadesConfigurationElement, ATT_FILE_EXTENSION);
            } else if (hyadesConfigurationElement.getAttribute(ATT_CLASS) == null) {
                this.logMissingAttribute(hyadesConfigurationElement, ATT_CLASS);
            } else if (ResourceExtensions.getInstance().containsKey(string)) {
                this.logError(hyadesConfigurationElement, "A resource loader for this element already exists, this loader will be ignored.");
            } else {
                try {
                    IHyadesPluginClassDescriptor iHyadesPluginClassDescriptor = this.createPluginClassDescriptor(hyadesConfigurationElement, ATT_CLASS);
                    ResourceExtensions.getInstance().put(string, (XMLResourceLoader)iHyadesPluginClassDescriptor.createInstance());
                }
                catch (Exception exception) {
                    this.logError(hyadesConfigurationElement, exception.getLocalizedMessage());
                }
                return true;
            }
        }
        return false;
    }
}

